// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsDomain cifs domain
//
// swagger:model cifs_domain
type CifsDomain struct {

	// ad domain
	AdDomain *CifsDomainInlineAdDomain `json:"ad_domain,omitempty"`

	// Specifies the discovered servers records.
	//
	// Read Only: true
	CifsDomainInlineDiscoveredServers []*CifsDomainInlineDiscoveredServersInlineArrayItem `json:"discovered_servers,omitempty"`

	// Specifies the preferred DC records.
	//
	// Read Only: true
	CifsDomainInlinePreferredDcs []*CifsDomainInlinePreferredDcsInlineArrayItem `json:"preferred_dcs,omitempty"`

	// Specifies the trusted domain records.
	//
	// Read Only: true
	CifsDomainInlineTrustRelationships []*CifsDomainInlineTrustRelationshipsInlineArrayItem `json:"trust_relationships,omitempty"`

	// PKCS12 certificate used by the application to prove its identity to AKV.
	// Example: PEM Cert
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: e959d1b5-5a63-4284-9268-851e30e3eceb
	ClientID *string `json:"client_id,omitempty"`

	// name mapping
	NameMapping *CifsDomainInlineNameMapping `json:"name_mapping,omitempty"`

	// password schedule
	PasswordSchedule *CifsDomainInlinePasswordSchedule `json:"password_schedule,omitempty"`

	// Specifies the mode of server discovery.
	//
	// Enum: ["all","site","none"]
	ServerDiscoveryMode *string `json:"server_discovery_mode,omitempty"`

	// svm
	Svm *CifsDomainInlineSvm `json:"svm,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: c9f32fcb-4ab7-40fe-af1b-1850d46cfbbe
	TenantID *string `json:"tenant_id,omitempty"`
}

// Validate validates this cifs domain
func (m *CifsDomain) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifsDomainInlineDiscoveredServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifsDomainInlinePreferredDcs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifsDomainInlineTrustRelationships(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNameMapping(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePasswordSchedule(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerDiscoveryMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomain) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AdDomain) { // not required
		return nil
	}

	if m.AdDomain != nil {
		if err := m.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

func (m *CifsDomain) validateCifsDomainInlineDiscoveredServers(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsDomainInlineDiscoveredServers) { // not required
		return nil
	}

	for i := 0; i < len(m.CifsDomainInlineDiscoveredServers); i++ {
		if swag.IsZero(m.CifsDomainInlineDiscoveredServers[i]) { // not required
			continue
		}

		if m.CifsDomainInlineDiscoveredServers[i] != nil {
			if err := m.CifsDomainInlineDiscoveredServers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) validateCifsDomainInlinePreferredDcs(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsDomainInlinePreferredDcs) { // not required
		return nil
	}

	for i := 0; i < len(m.CifsDomainInlinePreferredDcs); i++ {
		if swag.IsZero(m.CifsDomainInlinePreferredDcs[i]) { // not required
			continue
		}

		if m.CifsDomainInlinePreferredDcs[i] != nil {
			if err := m.CifsDomainInlinePreferredDcs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) validateCifsDomainInlineTrustRelationships(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsDomainInlineTrustRelationships) { // not required
		return nil
	}

	for i := 0; i < len(m.CifsDomainInlineTrustRelationships); i++ {
		if swag.IsZero(m.CifsDomainInlineTrustRelationships[i]) { // not required
			continue
		}

		if m.CifsDomainInlineTrustRelationships[i] != nil {
			if err := m.CifsDomainInlineTrustRelationships[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("trust_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("client_certificate", "body", "password", m.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomain) validateNameMapping(formats strfmt.Registry) error {
	if swag.IsZero(m.NameMapping) { // not required
		return nil
	}

	if m.NameMapping != nil {
		if err := m.NameMapping.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("name_mapping")
			}
			return err
		}
	}

	return nil
}

func (m *CifsDomain) validatePasswordSchedule(formats strfmt.Registry) error {
	if swag.IsZero(m.PasswordSchedule) { // not required
		return nil
	}

	if m.PasswordSchedule != nil {
		if err := m.PasswordSchedule.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("password_schedule")
			}
			return err
		}
	}

	return nil
}

var cifsDomainTypeServerDiscoveryModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","site","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainTypeServerDiscoveryModePropEnum = append(cifsDomainTypeServerDiscoveryModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain
	// CifsDomain
	// server_discovery_mode
	// ServerDiscoveryMode
	// all
	// END DEBUGGING
	// CifsDomainServerDiscoveryModeAll captures enum value "all"
	CifsDomainServerDiscoveryModeAll string = "all"

	// BEGIN DEBUGGING
	// cifs_domain
	// CifsDomain
	// server_discovery_mode
	// ServerDiscoveryMode
	// site
	// END DEBUGGING
	// CifsDomainServerDiscoveryModeSite captures enum value "site"
	CifsDomainServerDiscoveryModeSite string = "site"

	// BEGIN DEBUGGING
	// cifs_domain
	// CifsDomain
	// server_discovery_mode
	// ServerDiscoveryMode
	// none
	// END DEBUGGING
	// CifsDomainServerDiscoveryModeNone captures enum value "none"
	CifsDomainServerDiscoveryModeNone string = "none"
)

// prop value enum
func (m *CifsDomain) validateServerDiscoveryModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainTypeServerDiscoveryModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsDomain) validateServerDiscoveryMode(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerDiscoveryMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateServerDiscoveryModeEnum("server_discovery_mode", "body", *m.ServerDiscoveryMode); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomain) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain based on the context it is used
func (m *CifsDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifsDomainInlineDiscoveredServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifsDomainInlinePreferredDcs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifsDomainInlineTrustRelationships(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNameMapping(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePasswordSchedule(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomain) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.AdDomain != nil {
		if err := m.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

func (m *CifsDomain) contextValidateCifsDomainInlineDiscoveredServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "discovered_servers", "body", []*CifsDomainInlineDiscoveredServersInlineArrayItem(m.CifsDomainInlineDiscoveredServers)); err != nil {
		return err
	}

	for i := 0; i < len(m.CifsDomainInlineDiscoveredServers); i++ {

		if m.CifsDomainInlineDiscoveredServers[i] != nil {
			if err := m.CifsDomainInlineDiscoveredServers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discovered_servers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) contextValidateCifsDomainInlinePreferredDcs(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "preferred_dcs", "body", []*CifsDomainInlinePreferredDcsInlineArrayItem(m.CifsDomainInlinePreferredDcs)); err != nil {
		return err
	}

	for i := 0; i < len(m.CifsDomainInlinePreferredDcs); i++ {

		if m.CifsDomainInlinePreferredDcs[i] != nil {
			if err := m.CifsDomainInlinePreferredDcs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("preferred_dcs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) contextValidateCifsDomainInlineTrustRelationships(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "trust_relationships", "body", []*CifsDomainInlineTrustRelationshipsInlineArrayItem(m.CifsDomainInlineTrustRelationships)); err != nil {
		return err
	}

	for i := 0; i < len(m.CifsDomainInlineTrustRelationships); i++ {

		if m.CifsDomainInlineTrustRelationships[i] != nil {
			if err := m.CifsDomainInlineTrustRelationships[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("trust_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsDomain) contextValidateNameMapping(ctx context.Context, formats strfmt.Registry) error {

	if m.NameMapping != nil {
		if err := m.NameMapping.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("name_mapping")
			}
			return err
		}
	}

	return nil
}

func (m *CifsDomain) contextValidatePasswordSchedule(ctx context.Context, formats strfmt.Registry) error {

	if m.PasswordSchedule != nil {
		if err := m.PasswordSchedule.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("password_schedule")
			}
			return err
		}
	}

	return nil
}

func (m *CifsDomain) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomain) UnmarshalBinary(b []byte) error {
	var res CifsDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineAdDomain Specifies the credentials of a user with permissions to reset the password in the organizational unit for the machine account.
//
// swagger:model cifs_domain_inline_ad_domain
type CifsDomainInlineAdDomain struct {

	// The account password of the user with permissions to reset the password in the organizational unit for the machine account.
	//
	Password *string `json:"password,omitempty"`

	// The username of a user with permissions to reset the password in the organizational unit for the machine account.
	//
	User *string `json:"user,omitempty"`
}

// Validate validates this cifs domain inline ad domain
func (m *CifsDomainInlineAdDomain) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cifs domain inline ad domain based on context it is used
func (m *CifsDomainInlineAdDomain) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineAdDomain) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineAdDomain) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineAdDomain
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineDiscoveredServersInlineArrayItem cifs domain inline discovered servers inline array item
//
// swagger:model cifs_domain_inline_discovered_servers_inline_array_item
type CifsDomainInlineDiscoveredServersInlineArrayItem struct {

	// Fully Qualified Domain Name.
	//
	// Example: test.com
	Domain *string `json:"domain,omitempty"`

	// node
	Node *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode `json:"node,omitempty"`

	// Server Preference
	//
	// Enum: ["unknown","preferred","favored","adequate"]
	Preference *string `json:"preference,omitempty"`

	// Server IP address
	//
	ServerIP *string `json:"server_ip,omitempty"`

	// Server Name
	//
	ServerName *string `json:"server_name,omitempty"`

	// Server Type
	//
	// Enum: ["unknown","kerberos","ms_ldap","ms_dc","ldap"]
	ServerType *string `json:"server_type,omitempty"`

	// Server status
	//
	// Enum: ["ok","unavailable","slow","expired","undetermined","unreachable"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePreference(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","preferred","favored","adequate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// unknown
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceUnknown captures enum value "unknown"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// preferred
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferencePreferred captures enum value "preferred"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferencePreferred string = "preferred"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// favored
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceFavored captures enum value "favored"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceFavored string = "favored"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// preference
	// Preference
	// adequate
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceAdequate captures enum value "adequate"
	CifsDomainInlineDiscoveredServersInlineArrayItemPreferenceAdequate string = "adequate"
)

// prop value enum
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validatePreferenceEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypePreferencePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validatePreference(formats strfmt.Registry) error {
	if swag.IsZero(m.Preference) { // not required
		return nil
	}

	// value enum
	if err := m.validatePreferenceEnum("preference", "body", *m.Preference); err != nil {
		return err
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","kerberos","ms_ldap","ms_dc","ldap"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// unknown
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeUnknown captures enum value "unknown"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// kerberos
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeKerberos captures enum value "kerberos"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeKerberos string = "kerberos"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ms_ldap
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsLdap captures enum value "ms_ldap"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsLdap string = "ms_ldap"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ms_dc
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsDc captures enum value "ms_dc"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeMsDc string = "ms_dc"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// server_type
	// ServerType
	// ldap
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeLdap captures enum value "ldap"
	CifsDomainInlineDiscoveredServersInlineArrayItemServerTypeLdap string = "ldap"
)

// prop value enum
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validateServerTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypeServerTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validateServerType(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerType) { // not required
		return nil
	}

	// value enum
	if err := m.validateServerTypeEnum("server_type", "body", *m.ServerType); err != nil {
		return err
	}

	return nil
}

var cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","unavailable","slow","expired","undetermined","unreachable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum = append(cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// ok
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateOk captures enum value "ok"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unavailable
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUnavailable captures enum value "unavailable"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// slow
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateSlow captures enum value "slow"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateSlow string = "slow"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// expired
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateExpired captures enum value "expired"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateExpired string = "expired"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// undetermined
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUndetermined captures enum value "undetermined"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUndetermined string = "undetermined"

	// BEGIN DEBUGGING
	// cifs_domain_inline_discovered_servers_inline_array_item
	// CifsDomainInlineDiscoveredServersInlineArrayItem
	// state
	// State
	// unreachable
	// END DEBUGGING
	// CifsDomainInlineDiscoveredServersInlineArrayItemStateUnreachable captures enum value "unreachable"
	CifsDomainInlineDiscoveredServersInlineArrayItemStateUnreachable string = "unreachable"
)

// prop value enum
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsDomainInlineDiscoveredServersInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item based on the context it is used
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode cifs domain inline discovered servers inline array item inline node
//
// swagger:model cifs_domain_inline_discovered_servers_inline_array_item_inline_node
type CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode struct {

	// links
	Links *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item inline node
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item inline node based on the context it is used
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks cifs domain inline discovered servers inline array item inline node inline links
//
// swagger:model cifs_domain_inline_discovered_servers_inline_array_item_inline_node_inline__links
type CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline discovered servers inline array item inline node inline links
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline discovered servers inline array item inline node inline links based on the context it is used
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineDiscoveredServersInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineNameMapping Specifies the name mapping search records.
//
// swagger:model cifs_domain_inline_name_mapping
type CifsDomainInlineNameMapping struct {

	// trusted domains
	TrustedDomains []*string `json:"trusted_domains,omitempty"`
}

// Validate validates this cifs domain inline name mapping
func (m *CifsDomainInlineNameMapping) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs domain inline name mapping based on the context it is used
func (m *CifsDomainInlineNameMapping) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineNameMapping) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineNameMapping) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineNameMapping
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlinePasswordSchedule Specifies the password schedule records.
//
// swagger:model cifs_domain_inline_password_schedule
type CifsDomainInlinePasswordSchedule struct {

	// Day of the week for password change schedule.
	// Example: Sunday
	ScheduleDayOfWeek *string `json:"schedule_day_of_week,omitempty"`

	// Schedule description.
	// Read Only: true
	ScheduleDescription *string `json:"schedule_description,omitempty"`

	// Is password schedule enabled.
	ScheduleEnabled *bool `json:"schedule_enabled,omitempty"`

	// Last successful password change time.
	// Read Only: true
	// Format: date-time
	ScheduleLastChangedTime *strfmt.DateTime `json:"schedule_last_changed_time,omitempty"`

	// Minutes within which schedule start can be randomized.
	// Maximum: 180
	// Minimum: 1
	ScheduleRandomizedMinute *int64 `json:"schedule_randomized_minute,omitempty"`

	// Start time for password change schedule.
	// Example: 36900
	ScheduleTimeOfDay *string `json:"schedule_time_of_day,omitempty"`

	// Warning message in case job is deleted.
	// Read Only: true
	ScheduleWarnMessage *string `json:"schedule_warn_message,omitempty"`

	// Interval in weeks for password change schedule.
	// Maximum: 52
	// Minimum: 1
	ScheduleWeeklyInterval *int64 `json:"schedule_weekly_interval,omitempty"`
}

// Validate validates this cifs domain inline password schedule
func (m *CifsDomainInlinePasswordSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateScheduleLastChangedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduleRandomizedMinute(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduleWeeklyInterval(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlinePasswordSchedule) validateScheduleLastChangedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleLastChangedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("password_schedule"+"."+"schedule_last_changed_time", "body", "date-time", m.ScheduleLastChangedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainInlinePasswordSchedule) validateScheduleRandomizedMinute(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleRandomizedMinute) { // not required
		return nil
	}

	if err := validate.MinimumInt("password_schedule"+"."+"schedule_randomized_minute", "body", *m.ScheduleRandomizedMinute, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("password_schedule"+"."+"schedule_randomized_minute", "body", *m.ScheduleRandomizedMinute, 180, false); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainInlinePasswordSchedule) validateScheduleWeeklyInterval(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleWeeklyInterval) { // not required
		return nil
	}

	if err := validate.MinimumInt("password_schedule"+"."+"schedule_weekly_interval", "body", *m.ScheduleWeeklyInterval, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("password_schedule"+"."+"schedule_weekly_interval", "body", *m.ScheduleWeeklyInterval, 52, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs domain inline password schedule based on the context it is used
func (m *CifsDomainInlinePasswordSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateScheduleDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScheduleLastChangedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScheduleWarnMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlinePasswordSchedule) contextValidateScheduleDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "password_schedule"+"."+"schedule_description", "body", m.ScheduleDescription); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainInlinePasswordSchedule) contextValidateScheduleLastChangedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "password_schedule"+"."+"schedule_last_changed_time", "body", m.ScheduleLastChangedTime); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainInlinePasswordSchedule) contextValidateScheduleWarnMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "password_schedule"+"."+"schedule_warn_message", "body", m.ScheduleWarnMessage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlinePasswordSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlinePasswordSchedule) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlinePasswordSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlinePreferredDcsInlineArrayItem cifs domain inline preferred dcs inline array item
//
// swagger:model cifs_domain_inline_preferred_dcs_inline_array_item
type CifsDomainInlinePreferredDcsInlineArrayItem struct {

	// Fully Qualified Domain Name.
	//
	// Example: test.com
	// Read Only: true
	Fqdn *string `json:"fqdn,omitempty"`

	// IP address of the preferred domain controller (DC). The address can be either an IPv4 or an IPv6 address.
	//
	// Example: 4.4.4.4
	// Read Only: true
	ServerIP *string `json:"server_ip,omitempty"`
}

// Validate validates this cifs domain inline preferred dcs inline array item
func (m *CifsDomainInlinePreferredDcsInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs domain inline preferred dcs inline array item based on the context it is used
func (m *CifsDomainInlinePreferredDcsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFqdn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServerIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlinePreferredDcsInlineArrayItem) contextValidateFqdn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "fqdn", "body", m.Fqdn); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainInlinePreferredDcsInlineArrayItem) contextValidateServerIP(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "server_ip", "body", m.ServerIP); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlinePreferredDcsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlinePreferredDcsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlinePreferredDcsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model cifs_domain_inline_svm
type CifsDomainInlineSvm struct {

	// links
	Links *CifsDomainInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline svm
func (m *CifsDomainInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline svm based on the context it is used
func (m *CifsDomainInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineSvmInlineLinks cifs domain inline svm inline links
//
// swagger:model cifs_domain_inline_svm_inline__links
type CifsDomainInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline svm inline links
func (m *CifsDomainInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline svm inline links based on the context it is used
func (m *CifsDomainInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineTrustRelationshipsInlineArrayItem cifs domain inline trust relationships inline array item
//
// swagger:model cifs_domain_inline_trust_relationships_inline_array_item
type CifsDomainInlineTrustRelationshipsInlineArrayItem struct {

	// Home Domain Name
	//
	HomeDomain *string `json:"home_domain,omitempty"`

	// node
	Node *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode `json:"node,omitempty"`

	// Trusted Domain Name
	//
	TrustedDomains []*string `json:"trusted_domains"`
}

// Validate validates this cifs domain inline trust relationships inline array item
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item based on the context it is used
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode cifs domain inline trust relationships inline array item inline node
//
// swagger:model cifs_domain_inline_trust_relationships_inline_array_item_inline_node
type CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode struct {

	// links
	Links *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs domain inline trust relationships inline array item inline node
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item inline node based on the context it is used
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks cifs domain inline trust relationships inline array item inline node inline links
//
// swagger:model cifs_domain_inline_trust_relationships_inline_array_item_inline_node_inline__links
type CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs domain inline trust relationships inline array item inline node inline links
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs domain inline trust relationships inline array item inline node inline links based on the context it is used
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsDomainInlineTrustRelationshipsInlineArrayItemInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
