// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsDomainPasswordSchedule cifs domain password schedule
//
// swagger:model cifs_domain_password_schedule
type CifsDomainPasswordSchedule struct {

	// Day of the week for password change schedule.
	// Example: Sunday
	ScheduleDayOfWeek *string `json:"schedule_day_of_week,omitempty"`

	// Schedule description.
	// Read Only: true
	ScheduleDescription *string `json:"schedule_description,omitempty"`

	// Is password schedule enabled.
	ScheduleEnabled *bool `json:"schedule_enabled,omitempty"`

	// Last successful password change time.
	// Read Only: true
	// Format: date-time
	ScheduleLastChangedTime *strfmt.DateTime `json:"schedule_last_changed_time,omitempty"`

	// Minutes within which schedule start can be randomized.
	// Maximum: 180
	// Minimum: 1
	ScheduleRandomizedMinute *int64 `json:"schedule_randomized_minute,omitempty"`

	// Start time for password change schedule.
	// Example: 36900
	ScheduleTimeOfDay *string `json:"schedule_time_of_day,omitempty"`

	// Warning message in case job is deleted.
	// Read Only: true
	ScheduleWarnMessage *string `json:"schedule_warn_message,omitempty"`

	// Interval in weeks for password change schedule.
	// Maximum: 52
	// Minimum: 1
	ScheduleWeeklyInterval *int64 `json:"schedule_weekly_interval,omitempty"`
}

// Validate validates this cifs domain password schedule
func (m *CifsDomainPasswordSchedule) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateScheduleLastChangedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduleRandomizedMinute(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScheduleWeeklyInterval(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainPasswordSchedule) validateScheduleLastChangedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleLastChangedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("schedule_last_changed_time", "body", "date-time", m.ScheduleLastChangedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainPasswordSchedule) validateScheduleRandomizedMinute(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleRandomizedMinute) { // not required
		return nil
	}

	if err := validate.MinimumInt("schedule_randomized_minute", "body", *m.ScheduleRandomizedMinute, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("schedule_randomized_minute", "body", *m.ScheduleRandomizedMinute, 180, false); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainPasswordSchedule) validateScheduleWeeklyInterval(formats strfmt.Registry) error {
	if swag.IsZero(m.ScheduleWeeklyInterval) { // not required
		return nil
	}

	if err := validate.MinimumInt("schedule_weekly_interval", "body", *m.ScheduleWeeklyInterval, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("schedule_weekly_interval", "body", *m.ScheduleWeeklyInterval, 52, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs domain password schedule based on the context it is used
func (m *CifsDomainPasswordSchedule) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateScheduleDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScheduleLastChangedTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScheduleWarnMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsDomainPasswordSchedule) contextValidateScheduleDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "schedule_description", "body", m.ScheduleDescription); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainPasswordSchedule) contextValidateScheduleLastChangedTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "schedule_last_changed_time", "body", m.ScheduleLastChangedTime); err != nil {
		return err
	}

	return nil
}

func (m *CifsDomainPasswordSchedule) contextValidateScheduleWarnMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "schedule_warn_message", "body", m.ScheduleWarnMessage); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsDomainPasswordSchedule) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsDomainPasswordSchedule) UnmarshalBinary(b []byte) error {
	var res CifsDomainPasswordSchedule
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
