// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsOpenFile Manage opened files over CIFS.
//
// swagger:model cifs_open_file
type CifsOpenFile struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// connection
	Connection *CifsOpenFileInlineConnection `json:"connection,omitempty"`

	// The type of continuous availability protection provided to the file.
	// Opened files are continuously available if there are opened through a SMB3 client through a share with "continuously_available" set to yes.
	// These open files are capable of non-disruptively recovering from take over and giveback as well as general aggregate relocation.
	// - no: the open file is not continuously available.
	// - yes: the open file is continuously available.
	//
	// Example: no
	// Read Only: true
	// Enum: ["no","yes"]
	ContinuouslyAvailable *string `json:"continuously_available,omitempty"`

	// The unique identifier for the opened file.
	// Example: 17
	Identifier *int64 `json:"identifier,omitempty"`

	// node
	// Required: true
	Node *CifsOpenFileInlineNode `json:"node"`

	// Open mode corresponding to the opened file
	// - r: Opened for read
	// - w: Opened for write
	// - d: Opened for delete
	// - rw: Opened for read and write
	//
	// Example: r
	// Read Only: true
	// Enum: ["r","w","d","rw"]
	OpenMode *string `json:"open_mode,omitempty"`

	// Path from CIFS share.
	// Example: sub1\\sub2\\f4
	// Read Only: true
	Path *string `json:"path,omitempty"`

	// The number of range locks granted on the file.
	// Example: 4
	// Read Only: true
	RangeLocksCount *int64 `json:"range_locks_count,omitempty"`

	// session
	Session *CifsOpenFileInlineSession `json:"session,omitempty"`

	// share
	Share *CifsOpenFileInlineShare `json:"share,omitempty"`

	// svm
	// Required: true
	Svm *CifsOpenFileInlineSvm `json:"svm"`

	// The type of opened file.
	// The file can be a regular file, directory, a symbolic link to an existing file/directory, or an alternate data stream.
	//
	// Example: regular
	// Read Only: true
	// Enum: ["directory","regular","stream","symlink"]
	Type *string `json:"type,omitempty"`

	// volume
	Volume *CifsOpenFileInlineVolume `json:"volume,omitempty"`
}

// Validate validates this cifs open file
func (m *CifsOpenFile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContinuouslyAvailable(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOpenMode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSession(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFile) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) validateConnection(formats strfmt.Registry) error {
	if swag.IsZero(m.Connection) { // not required
		return nil
	}

	if m.Connection != nil {
		if err := m.Connection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

var cifsOpenFileTypeContinuouslyAvailablePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no","yes"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsOpenFileTypeContinuouslyAvailablePropEnum = append(cifsOpenFileTypeContinuouslyAvailablePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// continuously_available
	// ContinuouslyAvailable
	// no
	// END DEBUGGING
	// CifsOpenFileContinuouslyAvailableNo captures enum value "no"
	CifsOpenFileContinuouslyAvailableNo string = "no"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// continuously_available
	// ContinuouslyAvailable
	// yes
	// END DEBUGGING
	// CifsOpenFileContinuouslyAvailableYes captures enum value "yes"
	CifsOpenFileContinuouslyAvailableYes string = "yes"
)

// prop value enum
func (m *CifsOpenFile) validateContinuouslyAvailableEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsOpenFileTypeContinuouslyAvailablePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsOpenFile) validateContinuouslyAvailable(formats strfmt.Registry) error {
	if swag.IsZero(m.ContinuouslyAvailable) { // not required
		return nil
	}

	// value enum
	if err := m.validateContinuouslyAvailableEnum("continuously_available", "body", *m.ContinuouslyAvailable); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) validateNode(formats strfmt.Registry) error {

	if err := validate.Required("node", "body", m.Node); err != nil {
		return err
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var cifsOpenFileTypeOpenModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["r","w","d","rw"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsOpenFileTypeOpenModePropEnum = append(cifsOpenFileTypeOpenModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// open_mode
	// OpenMode
	// r
	// END DEBUGGING
	// CifsOpenFileOpenModeR captures enum value "r"
	CifsOpenFileOpenModeR string = "r"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// open_mode
	// OpenMode
	// w
	// END DEBUGGING
	// CifsOpenFileOpenModeW captures enum value "w"
	CifsOpenFileOpenModeW string = "w"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// open_mode
	// OpenMode
	// d
	// END DEBUGGING
	// CifsOpenFileOpenModeD captures enum value "d"
	CifsOpenFileOpenModeD string = "d"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// open_mode
	// OpenMode
	// rw
	// END DEBUGGING
	// CifsOpenFileOpenModeRw captures enum value "rw"
	CifsOpenFileOpenModeRw string = "rw"
)

// prop value enum
func (m *CifsOpenFile) validateOpenModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsOpenFileTypeOpenModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsOpenFile) validateOpenMode(formats strfmt.Registry) error {
	if swag.IsZero(m.OpenMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateOpenModeEnum("open_mode", "body", *m.OpenMode); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) validateSession(formats strfmt.Registry) error {
	if swag.IsZero(m.Session) { // not required
		return nil
	}

	if m.Session != nil {
		if err := m.Session.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("session")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if m.Share != nil {
		if err := m.Share.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) validateSvm(formats strfmt.Registry) error {

	if err := validate.Required("svm", "body", m.Svm); err != nil {
		return err
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var cifsOpenFileTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["directory","regular","stream","symlink"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsOpenFileTypeTypePropEnum = append(cifsOpenFileTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// type
	// Type
	// directory
	// END DEBUGGING
	// CifsOpenFileTypeDirectory captures enum value "directory"
	CifsOpenFileTypeDirectory string = "directory"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// type
	// Type
	// regular
	// END DEBUGGING
	// CifsOpenFileTypeRegular captures enum value "regular"
	CifsOpenFileTypeRegular string = "regular"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// type
	// Type
	// stream
	// END DEBUGGING
	// CifsOpenFileTypeStream captures enum value "stream"
	CifsOpenFileTypeStream string = "stream"

	// BEGIN DEBUGGING
	// cifs_open_file
	// CifsOpenFile
	// type
	// Type
	// symlink
	// END DEBUGGING
	// CifsOpenFileTypeSymlink captures enum value "symlink"
	CifsOpenFileTypeSymlink string = "symlink"
)

// prop value enum
func (m *CifsOpenFile) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsOpenFileTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsOpenFile) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file based on the context it is used
func (m *CifsOpenFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContinuouslyAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOpenMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePath(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRangeLocksCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSession(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShare(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFile) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateConnection(ctx context.Context, formats strfmt.Registry) error {

	if m.Connection != nil {
		if err := m.Connection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connection")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateContinuouslyAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "continuously_available", "body", m.ContinuouslyAvailable); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateOpenMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "open_mode", "body", m.OpenMode); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) contextValidatePath(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "path", "body", m.Path); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) contextValidateRangeLocksCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "range_locks_count", "body", m.RangeLocksCount); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) contextValidateSession(ctx context.Context, formats strfmt.Registry) error {

	if m.Session != nil {
		if err := m.Session.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("session")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateShare(ctx context.Context, formats strfmt.Registry) error {

	if m.Share != nil {
		if err := m.Share.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *CifsOpenFile) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFile) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFile) UnmarshalBinary(b []byte) error {
	var res CifsOpenFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineConnection cifs open file inline connection
//
// swagger:model cifs_open_file_inline_connection
type CifsOpenFileInlineConnection struct {

	// The number of CIFS connections associated with the CIFS session.
	// Example: 3
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// The connection that is used to open the file.
	// Example: 356756
	Identifier *int64 `json:"identifier,omitempty"`
}

// Validate validates this cifs open file inline connection
func (m *CifsOpenFileInlineConnection) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs open file inline connection based on the context it is used
func (m *CifsOpenFileInlineConnection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineConnection) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connection"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineConnection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineConnection) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineConnection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineNode cifs open file inline node
//
// swagger:model cifs_open_file_inline_node
type CifsOpenFileInlineNode struct {

	// links
	Links *CifsOpenFileInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs open file inline node
func (m *CifsOpenFileInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline node based on the context it is used
func (m *CifsOpenFileInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineNode) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineNodeInlineLinks cifs open file inline node inline links
//
// swagger:model cifs_open_file_inline_node_inline__links
type CifsOpenFileInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs open file inline node inline links
func (m *CifsOpenFileInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline node inline links based on the context it is used
func (m *CifsOpenFileInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineSession cifs open file inline session
//
// swagger:model cifs_open_file_inline_session
type CifsOpenFileInlineSession struct {

	// Session under which file is opened.
	// Example: 8966666858094658000
	Identifier *int64 `json:"identifier,omitempty"`
}

// Validate validates this cifs open file inline session
func (m *CifsOpenFileInlineSession) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs open file inline session based on the context it is used
func (m *CifsOpenFileInlineSession) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineSession) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineSession) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineSession
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineShare cifs open file inline share
//
// swagger:model cifs_open_file_inline_share
type CifsOpenFileInlineShare struct {

	// The share mode used to open the file.
	// The share mode can be a combination of:
	//   - r: read mode
	//   - w: write mode
	//   - d: delete
	//   - rw: read and write modes
	//   - rwd: read, write, and delete modes
	//
	// Example: r
	// Read Only: true
	// Enum: ["r","w","d","rw","rwd"]
	Mode *string `json:"mode,omitempty"`

	// CIFS share name where the file resides.
	// Example: share1
	// Read Only: true
	Name *string `json:"name,omitempty"`
}

// Validate validates this cifs open file inline share
func (m *CifsOpenFileInlineShare) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var cifsOpenFileInlineShareTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["r","w","d","rw","rwd"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsOpenFileInlineShareTypeModePropEnum = append(cifsOpenFileInlineShareTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_open_file_inline_share
	// CifsOpenFileInlineShare
	// mode
	// Mode
	// r
	// END DEBUGGING
	// CifsOpenFileInlineShareModeR captures enum value "r"
	CifsOpenFileInlineShareModeR string = "r"

	// BEGIN DEBUGGING
	// cifs_open_file_inline_share
	// CifsOpenFileInlineShare
	// mode
	// Mode
	// w
	// END DEBUGGING
	// CifsOpenFileInlineShareModeW captures enum value "w"
	CifsOpenFileInlineShareModeW string = "w"

	// BEGIN DEBUGGING
	// cifs_open_file_inline_share
	// CifsOpenFileInlineShare
	// mode
	// Mode
	// d
	// END DEBUGGING
	// CifsOpenFileInlineShareModeD captures enum value "d"
	CifsOpenFileInlineShareModeD string = "d"

	// BEGIN DEBUGGING
	// cifs_open_file_inline_share
	// CifsOpenFileInlineShare
	// mode
	// Mode
	// rw
	// END DEBUGGING
	// CifsOpenFileInlineShareModeRw captures enum value "rw"
	CifsOpenFileInlineShareModeRw string = "rw"

	// BEGIN DEBUGGING
	// cifs_open_file_inline_share
	// CifsOpenFileInlineShare
	// mode
	// Mode
	// rwd
	// END DEBUGGING
	// CifsOpenFileInlineShareModeRwd captures enum value "rwd"
	CifsOpenFileInlineShareModeRwd string = "rwd"
)

// prop value enum
func (m *CifsOpenFileInlineShare) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsOpenFileInlineShareTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsOpenFileInlineShare) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("share"+"."+"mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs open file inline share based on the context it is used
func (m *CifsOpenFileInlineShare) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineShare) contextValidateMode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "share"+"."+"mode", "body", m.Mode); err != nil {
		return err
	}

	return nil
}

func (m *CifsOpenFileInlineShare) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "share"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineShare) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineShare) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineShare
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model cifs_open_file_inline_svm
type CifsOpenFileInlineSvm struct {

	// links
	Links *CifsOpenFileInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs open file inline svm
func (m *CifsOpenFileInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline svm based on the context it is used
func (m *CifsOpenFileInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineSvmInlineLinks cifs open file inline svm inline links
//
// swagger:model cifs_open_file_inline_svm_inline__links
type CifsOpenFileInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs open file inline svm inline links
func (m *CifsOpenFileInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline svm inline links based on the context it is used
func (m *CifsOpenFileInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineVolume cifs open file inline volume
//
// swagger:model cifs_open_file_inline_volume
type CifsOpenFileInlineVolume struct {

	// links
	Links *CifsOpenFileInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs open file inline volume
func (m *CifsOpenFileInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline volume based on the context it is used
func (m *CifsOpenFileInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineVolume) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsOpenFileInlineVolumeInlineLinks cifs open file inline volume inline links
//
// swagger:model cifs_open_file_inline_volume_inline__links
type CifsOpenFileInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs open file inline volume inline links
func (m *CifsOpenFileInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs open file inline volume inline links based on the context it is used
func (m *CifsOpenFileInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsOpenFileInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsOpenFileInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsOpenFileInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsOpenFileInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
