// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsService cifs service
//
// swagger:model cifs_service
type CifsService struct {

	// links
	Links *CifsServiceInlineLinks `json:"_links,omitempty"`

	// ad domain
	AdDomain *AdDomain `json:"ad_domain,omitempty"`

	// Authentication type.
	// Example: domain
	// Read Only: true
	// Enum: ["domain","workgroup"]
	AuthStyle *string `json:"auth-style,omitempty"`

	// Specifies the type of user who can access the SMB Volume. The default is domain_user. In the case of a hybrid-user, ONTAP won't contact on-premise ADDS.
	//
	// Enum: ["domain_user","hybrid_user"]
	AuthUserType *string `json:"auth_user_type,omitempty"`

	// Specifies the authentication method.
	// The available values are:
	//   * client_secret
	//   * certificate
	//
	// Enum: ["client_secret","certificate"]
	AuthenticationMethod *string `json:"authentication_method,omitempty"`

	// PKCS12 certificate used by the application to prove its identity to AKV.
	// Example: PEM Cert
	// Format: password
	ClientCertificate *strfmt.Password `json:"client_certificate,omitempty"`

	// Application client ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: e959d1b5-5a63-4284-9268-851e30e3eceb
	ClientID *string `json:"client_id,omitempty"`

	// Secret used by the application to prove its identity to AKV.
	// Example: _8E8Q~Qu866jtihUE3ia4Q5Y5IDEVC6UfskbZa6X
	// Format: password
	ClientSecret *strfmt.Password `json:"client_secret,omitempty"`

	// A descriptive text comment for the CIFS server. SMB clients can see the CIFS server comment when browsing servers on the network. If there is a space in the comment, you must enclose the entire string in quotation marks.
	// Example: This CIFS Server Belongs to CS Department
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the UNIX user to which any authenticated CIFS user is mapped to, if the normal user mapping rules fails.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies if the CIFS service is administratively enabled.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// If set to true, group policies will be applied to the SVM.
	GroupPolicyObjectEnabled *bool `json:"group_policy_object_enabled,omitempty"`

	// URI of the deployed AKV that is used by ONTAP for storing keys.
	// Example: https://kmip-akv-keyvault.vault.azure.net/
	// Format: uri
	KeyVaultURI *strfmt.URI `json:"key_vault_uri,omitempty"`

	// metric
	Metric *CifsServiceInlineMetric `json:"metric,omitempty"`

	// The name of the CIFS server.
	// Example: CIFS1
	// Max Length: 15
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// netbios
	Netbios *CifsNetbios `json:"netbios,omitempty"`

	// Open authorization server host name.
	// Example: login.microsoftonline.com
	OauthHost *string `json:"oauth_host,omitempty"`

	// options
	Options *CifsServiceOptions `json:"options,omitempty"`

	// Proxy host.
	// Example: proxy.eng.com
	ProxyHost *string `json:"proxy_host,omitempty"`

	// Proxy password. Password is not audited.
	// Example: proxypassword
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy port.
	// Example: 1234
	ProxyPort *int64 `json:"proxy_port,omitempty"`

	// Proxy type.
	// Enum: ["http","https"]
	ProxyType *string `json:"proxy_type,omitempty"`

	// Proxy username.
	// Example: proxyuser
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// security
	Security *CifsServiceSecurity `json:"security,omitempty"`

	// statistics
	Statistics *CifsServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *CifsServiceInlineSvm `json:"svm,omitempty"`

	// Directory (tenant) ID of the deployed Azure application with appropriate access to an AKV or EntraId.
	// Example: c9f32fcb-4ab7-40fe-af1b-1850d46cfbbe
	TenantID *string `json:"tenant_id,omitempty"`

	// AKV connection timeout, in seconds. The allowed range is between 0 to 30 seconds.
	// Example: 25
	Timeout *int64 `json:"timeout,omitempty"`

	// Verify the identity of the AKV host name. By default, verify_host is set to true.
	VerifyHost *bool `json:"verify_host,omitempty"`

	// The workgroup name.
	// Example: workgrp1
	// Max Length: 15
	// Min Length: 1
	Workgroup *string `json:"workgroup,omitempty"`
}

// Validate validates this cifs service
func (m *CifsService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAdDomain(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthUserType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationMethod(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClientSecret(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateKeyVaultURI(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetbios(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProxyType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateAdDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.AdDomain) { // not required
		return nil
	}

	if m.AdDomain != nil {
		if err := m.AdDomain.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

var cifsServiceTypeAuthStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain","workgroup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceTypeAuthStylePropEnum = append(cifsServiceTypeAuthStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// auth-style
	// AuthStyle
	// domain
	// END DEBUGGING
	// CifsServiceAuthStyleDomain captures enum value "domain"
	CifsServiceAuthStyleDomain string = "domain"

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// auth-style
	// AuthStyle
	// workgroup
	// END DEBUGGING
	// CifsServiceAuthStyleWorkgroup captures enum value "workgroup"
	CifsServiceAuthStyleWorkgroup string = "workgroup"
)

// prop value enum
func (m *CifsService) validateAuthStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceTypeAuthStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsService) validateAuthStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthStyleEnum("auth-style", "body", *m.AuthStyle); err != nil {
		return err
	}

	return nil
}

var cifsServiceTypeAuthUserTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["domain_user","hybrid_user"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceTypeAuthUserTypePropEnum = append(cifsServiceTypeAuthUserTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// auth_user_type
	// AuthUserType
	// domain_user
	// END DEBUGGING
	// CifsServiceAuthUserTypeDomainUser captures enum value "domain_user"
	CifsServiceAuthUserTypeDomainUser string = "domain_user"

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// auth_user_type
	// AuthUserType
	// hybrid_user
	// END DEBUGGING
	// CifsServiceAuthUserTypeHybridUser captures enum value "hybrid_user"
	CifsServiceAuthUserTypeHybridUser string = "hybrid_user"
)

// prop value enum
func (m *CifsService) validateAuthUserTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceTypeAuthUserTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsService) validateAuthUserType(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthUserType) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthUserTypeEnum("auth_user_type", "body", *m.AuthUserType); err != nil {
		return err
	}

	return nil
}

var cifsServiceTypeAuthenticationMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["client_secret","certificate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceTypeAuthenticationMethodPropEnum = append(cifsServiceTypeAuthenticationMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// authentication_method
	// AuthenticationMethod
	// client_secret
	// END DEBUGGING
	// CifsServiceAuthenticationMethodClientSecret captures enum value "client_secret"
	CifsServiceAuthenticationMethodClientSecret string = "client_secret"

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// authentication_method
	// AuthenticationMethod
	// certificate
	// END DEBUGGING
	// CifsServiceAuthenticationMethodCertificate captures enum value "certificate"
	CifsServiceAuthenticationMethodCertificate string = "certificate"
)

// prop value enum
func (m *CifsService) validateAuthenticationMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceTypeAuthenticationMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsService) validateAuthenticationMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationMethodEnum("authentication_method", "body", *m.AuthenticationMethod); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateClientCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientCertificate) { // not required
		return nil
	}

	if err := validate.FormatOf("client_certificate", "body", "password", m.ClientCertificate.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateClientSecret(formats strfmt.Registry) error {
	if swag.IsZero(m.ClientSecret) { // not required
		return nil
	}

	if err := validate.FormatOf("client_secret", "body", "password", m.ClientSecret.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateKeyVaultURI(formats strfmt.Registry) error {
	if swag.IsZero(m.KeyVaultURI) { // not required
		return nil
	}

	if err := validate.FormatOf("key_vault_uri", "body", "uri", m.KeyVaultURI.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 15); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateNetbios(formats strfmt.Registry) error {
	if swag.IsZero(m.Netbios) { // not required
		return nil
	}

	if m.Netbios != nil {
		if err := m.Netbios.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netbios")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.Options) { // not required
		return nil
	}

	if m.Options != nil {
		if err := m.Options.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

var cifsServiceTypeProxyTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["http","https"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceTypeProxyTypePropEnum = append(cifsServiceTypeProxyTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// proxy_type
	// ProxyType
	// http
	// END DEBUGGING
	// CifsServiceProxyTypeHTTP captures enum value "http"
	CifsServiceProxyTypeHTTP string = "http"

	// BEGIN DEBUGGING
	// cifs_service
	// CifsService
	// proxy_type
	// ProxyType
	// https
	// END DEBUGGING
	// CifsServiceProxyTypeHTTPS captures enum value "https"
	CifsServiceProxyTypeHTTPS string = "https"
)

// prop value enum
func (m *CifsService) validateProxyTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceTypeProxyTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsService) validateProxyType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProxyType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProxyTypeEnum("proxy_type", "body", *m.ProxyType); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.Security) { // not required
		return nil
	}

	if m.Security != nil {
		if err := m.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) validateWorkgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Workgroup) { // not required
		return nil
	}

	if err := validate.MinLength("workgroup", "body", *m.Workgroup, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("workgroup", "body", *m.Workgroup, 15); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service based on the context it is used
func (m *CifsService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAdDomain(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuthStyle(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNetbios(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateAdDomain(ctx context.Context, formats strfmt.Registry) error {

	if m.AdDomain != nil {
		if err := m.AdDomain.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ad_domain")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateAuthStyle(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "auth-style", "body", m.AuthStyle); err != nil {
		return err
	}

	return nil
}

func (m *CifsService) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateNetbios(ctx context.Context, formats strfmt.Registry) error {

	if m.Netbios != nil {
		if err := m.Netbios.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("netbios")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.Options != nil {
		if err := m.Options.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("options")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if m.Security != nil {
		if err := m.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *CifsService) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsService) UnmarshalBinary(b []byte) error {
	var res CifsService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineLinks cifs service inline links
//
// swagger:model cifs_service_inline__links
type CifsServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline links
func (m *CifsServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline links based on the context it is used
func (m *CifsServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
//
// swagger:model cifs_service_inline_metric
type CifsServiceInlineMetric struct {

	// links
	Links *CifsServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *CifsServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *CifsServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *CifsServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cifs service inline metric
func (m *CifsServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineMetricTypeDurationPropEnum = append(cifsServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT15S captures enum value "PT15S"
	CifsServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT4M captures enum value "PT4M"
	CifsServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT30M captures enum value "PT30M"
	CifsServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT2H captures enum value "PT2H"
	CifsServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// CifsServiceInlineMetricDurationP1D captures enum value "P1D"
	CifsServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// CifsServiceInlineMetricDurationPT5M captures enum value "PT5M"
	CifsServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *CifsServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineMetricTypeStatusPropEnum = append(cifsServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// CifsServiceInlineMetricStatusOk captures enum value "ok"
	CifsServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// CifsServiceInlineMetricStatusError captures enum value "error"
	CifsServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	CifsServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	CifsServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	CifsServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// CifsServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	CifsServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// CifsServiceInlineMetricStatusNotFound captures enum value "not_found"
	CifsServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	CifsServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// CifsServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	CifsServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// CifsServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	CifsServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_metric
	// CifsServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// CifsServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	CifsServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *CifsServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service inline metric based on the context it is used
func (m *CifsServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model cifs_service_inline_metric_inline_iops
type CifsServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline iops
func (m *CifsServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline iops based on the context it is used
func (m *CifsServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model cifs_service_inline_metric_inline_latency
type CifsServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline latency
func (m *CifsServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline latency based on the context it is used
func (m *CifsServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineMetricInlineLinks cifs service inline metric inline links
//
// swagger:model cifs_service_inline_metric_inline__links
type CifsServiceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline metric inline links
func (m *CifsServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline metric inline links based on the context it is used
func (m *CifsServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model cifs_service_inline_metric_inline_throughput
type CifsServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline metric inline throughput
func (m *CifsServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline metric inline throughput based on the context it is used
func (m *CifsServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model cifs_service_inline_statistics
type CifsServiceInlineStatistics struct {

	// iops raw
	IopsRaw *CifsServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *CifsServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *CifsServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cifs service inline statistics
func (m *CifsServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var cifsServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceInlineStatisticsTypeStatusPropEnum = append(cifsServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusOk captures enum value "ok"
	CifsServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusError captures enum value "error"
	CifsServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	CifsServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	CifsServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	CifsServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	CifsServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	CifsServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	CifsServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	CifsServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	CifsServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cifs_service_inline_statistics
	// CifsServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// CifsServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	CifsServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *CifsServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs service inline statistics based on the context it is used
func (m *CifsServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *CifsServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *CifsServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model cifs_service_inline_statistics_inline_iops_raw
type CifsServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline iops raw
func (m *CifsServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline iops raw based on the context it is used
func (m *CifsServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model cifs_service_inline_statistics_inline_latency_raw
type CifsServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline latency raw
func (m *CifsServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline latency raw based on the context it is used
func (m *CifsServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model cifs_service_inline_statistics_inline_throughput_raw
type CifsServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cifs service inline statistics inline throughput raw
func (m *CifsServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cifs service inline statistics inline throughput raw based on the context it is used
func (m *CifsServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model cifs_service_inline_svm
type CifsServiceInlineSvm struct {

	// links
	Links *CifsServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs service inline svm
func (m *CifsServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline svm based on the context it is used
func (m *CifsServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsServiceInlineSvmInlineLinks cifs service inline svm inline links
//
// swagger:model cifs_service_inline_svm_inline__links
type CifsServiceInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs service inline svm inline links
func (m *CifsServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs service inline svm inline links based on the context it is used
func (m *CifsServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
