// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsServiceSecurity cifs service security
//
// swagger:model cifs_service_security
type CifsServiceSecurity struct {

	// advertised kdc encryptions
	AdvertisedKdcEncryptions []*string `json:"advertised_kdc_encryptions,omitempty"`

	// Specifies whether or not an AES session key is enabled for the Netlogon channel.
	//
	AesNetlogonEnabled *bool `json:"aes_netlogon_enabled,omitempty"`

	// Specifies whether encryption is required for domain controller connections.
	EncryptDcConnection *bool `json:"encrypt_dc_connection,omitempty"`

	// Important: This attribute has been deprecated. Use "security.advertised_kdc_encryptions" to specify the encryption type to use.
	// Specifies whether AES-128 and AES-256 encryption is enabled for all Kerberos-based communication with the Active Directory KDC.
	// To take advantage of the strongest security with Kerberos-based communication, AES-256 and AES-128 encryption can be enabled on the CIFS server.
	// Kerberos-related communication for CIFS is used during CIFS server creation on the SVM, as well
	// as during the SMB session setup phase.
	// The CIFS server supports the following encryption types for Kerberos communication:
	//     * RC4-HMAC
	//     * DES
	//     * AES
	// When the CIFS server is created, the domain controller creates a computer machine account in
	// Active Directory. After a newly created machine account authenticates, the KDC and the CIFS server
	// negotiates encryption types. At this time, the KDC becomes aware of the encryption capabilities of
	// the particular machine account and uses those capabilities in subsequent communication with the
	// CIFS server.
	// In addition to negotiating encryption types during CIFS server creation, the encryption types are
	// renegotiated when a machine account password is reset.
	//
	KdcEncryption *bool `json:"kdc_encryption,omitempty"`

	// Specifies whether or not LDAP referral chasing is enabled for AD LDAP connections.
	//
	LdapReferralEnabled *bool `json:"ldap_referral_enabled,omitempty"`

	// It is CIFS server minimum security level, also known as the LMCompatibilityLevel. The minimum security level is the minimum level of the security tokens that        the CIFS server accepts from SMB clients.
	// The available values are:
	// * lm_ntlm_ntlmv2_krb          Accepts LM, NTLM, NTLMv2 and Kerberos
	// * ntlm_ntlmv2_krb             Accepts NTLM, NTLMv2 and Kerberos
	// * ntlmv2_krb                  Accepts NTLMv2 and Kerberos
	// * krb                         Accepts Kerberos only
	//
	// Enum: ["lm_ntlm_ntlmv2_krb","ntlm_ntlmv2_krb","ntlmv2_krb","krb"]
	LmCompatibilityLevel *string `json:"lm_compatibility_level,omitempty"`

	// Specifies what level of access an anonymous user is granted. An anonymous user (also known as a "null user") can list or enumerate certain types of system information from Windows hosts on the network, including user names and details, account policies, and share names. Access for the anonymous user can be controlled by specifying one of three access restriction settings.
	//  The available values are:
	//  * no_restriction   - No access restriction for an anonymous user.
	//  * no_enumeration   - Enumeration is restricted for an anonymous user.
	//  * no_access        - All access is restricted for an anonymous user.
	//
	// Enum: ["no_restriction","no_enumeration","no_access"]
	RestrictAnonymous *string `json:"restrict_anonymous,omitempty"`

	// Specifies client session security for AD LDAP connections.
	// The available values are:
	//   * none - No Signing or Sealing.
	//   * sign - Sign LDAP traffic.
	//   * seal - Seal and Sign LDAP traffic
	//
	// Enum: ["none","sign","seal"]
	SessionSecurity *string `json:"session_security,omitempty"`

	// Specifies whether encryption is required for incoming CIFS traffic.
	SmbEncryption *bool `json:"smb_encryption,omitempty"`

	// Specifies whether signing is required for incoming CIFS traffic. SMB signing helps to ensure that network traffic between the CIFS server and the client is not compromised.
	//
	SmbSigning *bool `json:"smb_signing,omitempty"`

	// Specifies whether or not channel binding is attempted in the case of TLS/LDAPS.
	//
	TryLdapChannelBinding *bool `json:"try_ldap_channel_binding,omitempty"`

	// Specifies whether or not to use use LDAPS for secure Active Directory LDAP connections
	// by using the TLS/SSL protocols.
	//
	UseLdaps *bool `json:"use_ldaps,omitempty"`

	// Specifies whether or not to use SSL/TLS for allowing secure LDAP communication with
	// Active Directory LDAP servers.
	//
	UseStartTLS *bool `json:"use_start_tls,omitempty"`
}

// Validate validates this cifs service security
func (m *CifsServiceSecurity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAdvertisedKdcEncryptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLmCompatibilityLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestrictAnonymous(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionSecurity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var cifsServiceSecurityAdvertisedKdcEncryptionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["des","rc4","aes_128","aes_256"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceSecurityAdvertisedKdcEncryptionsItemsEnum = append(cifsServiceSecurityAdvertisedKdcEncryptionsItemsEnum, v)
	}
}

func (m *CifsServiceSecurity) validateAdvertisedKdcEncryptionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceSecurityAdvertisedKdcEncryptionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceSecurity) validateAdvertisedKdcEncryptions(formats strfmt.Registry) error {
	if swag.IsZero(m.AdvertisedKdcEncryptions) { // not required
		return nil
	}

	for i := 0; i < len(m.AdvertisedKdcEncryptions); i++ {
		if swag.IsZero(m.AdvertisedKdcEncryptions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateAdvertisedKdcEncryptionsItemsEnum("advertised_kdc_encryptions"+"."+strconv.Itoa(i), "body", *m.AdvertisedKdcEncryptions[i]); err != nil {
			return err
		}

	}

	return nil
}

var cifsServiceSecurityTypeLmCompatibilityLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["lm_ntlm_ntlmv2_krb","ntlm_ntlmv2_krb","ntlmv2_krb","krb"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceSecurityTypeLmCompatibilityLevelPropEnum = append(cifsServiceSecurityTypeLmCompatibilityLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// lm_compatibility_level
	// LmCompatibilityLevel
	// lm_ntlm_ntlmv2_krb
	// END DEBUGGING
	// CifsServiceSecurityLmCompatibilityLevelLmNtlmNtlmv2Krb captures enum value "lm_ntlm_ntlmv2_krb"
	CifsServiceSecurityLmCompatibilityLevelLmNtlmNtlmv2Krb string = "lm_ntlm_ntlmv2_krb"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// lm_compatibility_level
	// LmCompatibilityLevel
	// ntlm_ntlmv2_krb
	// END DEBUGGING
	// CifsServiceSecurityLmCompatibilityLevelNtlmNtlmv2Krb captures enum value "ntlm_ntlmv2_krb"
	CifsServiceSecurityLmCompatibilityLevelNtlmNtlmv2Krb string = "ntlm_ntlmv2_krb"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// lm_compatibility_level
	// LmCompatibilityLevel
	// ntlmv2_krb
	// END DEBUGGING
	// CifsServiceSecurityLmCompatibilityLevelNtlmv2Krb captures enum value "ntlmv2_krb"
	CifsServiceSecurityLmCompatibilityLevelNtlmv2Krb string = "ntlmv2_krb"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// lm_compatibility_level
	// LmCompatibilityLevel
	// krb
	// END DEBUGGING
	// CifsServiceSecurityLmCompatibilityLevelKrb captures enum value "krb"
	CifsServiceSecurityLmCompatibilityLevelKrb string = "krb"
)

// prop value enum
func (m *CifsServiceSecurity) validateLmCompatibilityLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceSecurityTypeLmCompatibilityLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceSecurity) validateLmCompatibilityLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.LmCompatibilityLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateLmCompatibilityLevelEnum("lm_compatibility_level", "body", *m.LmCompatibilityLevel); err != nil {
		return err
	}

	return nil
}

var cifsServiceSecurityTypeRestrictAnonymousPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_restriction","no_enumeration","no_access"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceSecurityTypeRestrictAnonymousPropEnum = append(cifsServiceSecurityTypeRestrictAnonymousPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// restrict_anonymous
	// RestrictAnonymous
	// no_restriction
	// END DEBUGGING
	// CifsServiceSecurityRestrictAnonymousNoRestriction captures enum value "no_restriction"
	CifsServiceSecurityRestrictAnonymousNoRestriction string = "no_restriction"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// restrict_anonymous
	// RestrictAnonymous
	// no_enumeration
	// END DEBUGGING
	// CifsServiceSecurityRestrictAnonymousNoEnumeration captures enum value "no_enumeration"
	CifsServiceSecurityRestrictAnonymousNoEnumeration string = "no_enumeration"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// restrict_anonymous
	// RestrictAnonymous
	// no_access
	// END DEBUGGING
	// CifsServiceSecurityRestrictAnonymousNoAccess captures enum value "no_access"
	CifsServiceSecurityRestrictAnonymousNoAccess string = "no_access"
)

// prop value enum
func (m *CifsServiceSecurity) validateRestrictAnonymousEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceSecurityTypeRestrictAnonymousPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceSecurity) validateRestrictAnonymous(formats strfmt.Registry) error {
	if swag.IsZero(m.RestrictAnonymous) { // not required
		return nil
	}

	// value enum
	if err := m.validateRestrictAnonymousEnum("restrict_anonymous", "body", *m.RestrictAnonymous); err != nil {
		return err
	}

	return nil
}

var cifsServiceSecurityTypeSessionSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sign","seal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsServiceSecurityTypeSessionSecurityPropEnum = append(cifsServiceSecurityTypeSessionSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// session_security
	// SessionSecurity
	// none
	// END DEBUGGING
	// CifsServiceSecuritySessionSecurityNone captures enum value "none"
	CifsServiceSecuritySessionSecurityNone string = "none"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// session_security
	// SessionSecurity
	// sign
	// END DEBUGGING
	// CifsServiceSecuritySessionSecuritySign captures enum value "sign"
	CifsServiceSecuritySessionSecuritySign string = "sign"

	// BEGIN DEBUGGING
	// cifs_service_security
	// CifsServiceSecurity
	// session_security
	// SessionSecurity
	// seal
	// END DEBUGGING
	// CifsServiceSecuritySessionSecuritySeal captures enum value "seal"
	CifsServiceSecuritySessionSecuritySeal string = "seal"
)

// prop value enum
func (m *CifsServiceSecurity) validateSessionSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsServiceSecurityTypeSessionSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsServiceSecurity) validateSessionSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.SessionSecurity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSessionSecurityEnum("session_security", "body", *m.SessionSecurity); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cifs service security based on context it is used
func (m *CifsServiceSecurity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CifsServiceSecurity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsServiceSecurity) UnmarshalBinary(b []byte) error {
	var res CifsServiceSecurity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
