// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsShare CIFS share is a named access point in a volume. Before users and applications can access data on the CIFS server over SMB,
// a CIFS share must be created with sufficient share permission. CIFS shares are tied to the CIFS server on the SVM.
// When a CIFS share is created, ONTAP creates a default ACL for the share with Full Control permissions for Everyone.
//
// swagger:model cifs_share
type CifsShare struct {

	// links
	Links *CifsShareInlineLinks `json:"_links,omitempty"`

	// If enabled, all folders inside this share are visible to a user based on that individual user access right; prevents
	// the display of folders or other shared resources that the user does not have access to.
	//
	AccessBasedEnumeration *bool `json:"access_based_enumeration,omitempty"`

	// Specifies whether or not the SMB2 clients are allowed to access the encrypted share.
	//
	AllowUnencryptedAccess *bool `json:"allow_unencrypted_access,omitempty"`

	// Specifies that connections through this share cache attributes for a short time to improve performance.
	//
	AttributeCache *bool `json:"attribute_cache,omitempty"`

	// Specifies whether or not the Windows clients can browse the share.
	//
	Browsable *bool `json:"browsable,omitempty"`

	// Specifies whether CIFS clients can request for change notifications for directories on this share.
	ChangeNotify *bool `json:"change_notify,omitempty"`

	// cifs share inline acls
	CifsShareInlineAcls []*CifsShareInlineAclsInlineArrayItem `json:"acls,omitempty"`

	// Specify the CIFS share descriptions.
	// Example: HR Department Share
	// Max Length: 256
	// Min Length: 1
	Comment *string `json:"comment,omitempty"`

	// Specifies whether or not the clients connecting to this share can open files in a persistent manner.
	// Files opened in this way are protected from disruptive events, such as, failover and giveback.
	// If the Vscan ONTAP feature is used, it is not supported in continuous availability (CA) shares.
	//
	ContinuouslyAvailable *bool `json:"continuously_available,omitempty"`

	// Directory Mode Creation Mask to be viewed as an octal number.
	// Example: 21
	DirUmask *string `json:"dir_umask,omitempty"`

	// Specifies that SMB encryption must be used when accessing this share. Clients that do not support encryption are not
	// able to access this share.
	//
	Encryption *bool `json:"encryption,omitempty"`

	// File Mode Creation Mask to be viewed as an octal number.
	// Example: 21
	FileUmask *string `json:"file_umask,omitempty"`

	// Specifies that all files that CIFS users create in a specific share belong to the same group
	// (also called the "force-group"). The "force-group" must be a predefined group in the UNIX group
	// database. This setting has no effect unless the security style of the volume is UNIX or mixed
	// security style.
	//
	ForceGroupForCreate *string `json:"force_group_for_create,omitempty"`

	// Specifies whether or not the share is a home directory share, where the share and path names are dynamic.
	// ONTAP home directory functionality automatically offer each user a dynamic share to their home directory without creating an
	// individual SMB share for each user.
	// The ONTAP CIFS home directory feature enable us to configure a share that maps to
	// different directories based on the user that connects to it. Instead of creating a separate shares for each user,
	// a single share with a home directory parameters can be created.
	// In a home directory share, ONTAP dynamically generates the share-name and share-path by substituting
	// %w, %u, and %d variables with the corresponding Windows user name, UNIX user name, and domain name, respectively.
	//
	HomeDirectory *bool `json:"home_directory,omitempty"`

	// Maximum number of tree connections on share.
	//
	MaxConnectionsPerShare *int64 `json:"max_connections_per_share,omitempty"`

	// Specifies the name of the CIFS share that you want to create. If this
	// is a home directory share then the share name includes the pattern as
	// %w (Windows user name), %u (UNIX user name) and %d (Windows domain name)
	// variables in any combination with this parameter to generate shares dynamically.
	//
	// Example: HR_SHARE
	// Max Length: 80
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// Specifies whether or not the SMB clients connecting to this share can cache the directory enumeration
	// results returned by the CIFS servers.
	//
	NamespaceCaching *bool `json:"namespace_caching,omitempty"`

	// Specifies whether or not CIFS clients can follow a unix symlinks outside the share boundaries.
	//
	NoStrictSecurity *bool `json:"no_strict_security,omitempty"`

	// Offline Files
	// The supported values are:
	//   * none - Clients are not permitted to cache files for offline access.
	//   * manual - Clients may cache files that are explicitly selected by the user for offline access.
	//   * documents - Clients may automatically cache files that are used by the user for offline access.
	//   * programs - Clients may automatically cache files that are used by the user for offline access
	//                and may use those files in an offline mode even if the share is available.
	//
	// Enum: ["none","manual","documents","programs"]
	OfflineFiles *string `json:"offline_files,omitempty"`

	// Specify whether opportunistic locks are enabled on this share. "Oplocks" allow clients to lock files and cache content locally,
	// which can increase performance for file operations.
	//
	Oplocks *bool `json:"oplocks,omitempty"`

	// The fully-qualified pathname in the owning SVM namespace that is shared through this share.
	// If this is a home directory share then the path should be dynamic by specifying the pattern
	// %w (Windows user name), %u (UNIX user name), or %d (domain name) variables in any combination.
	// ONTAP generates the path dynamically for the connected user and this path is appended to each
	// search path to find the full Home Directory path.
	//
	// Example: /volume_1/eng_vol/
	// Max Length: 256
	// Min Length: 1
	Path *string `json:"path,omitempty"`

	// Specifies that the previous version can be viewed and restored from the client.
	ShowPreviousVersions *bool `json:"show_previous_versions,omitempty"`

	// Specifies whether or not the snapshots can be viewed and traversed by clients.
	//
	ShowSnapshot *bool `json:"show_snapshot,omitempty"`

	// svm
	Svm *CifsShareInlineSvm `json:"svm,omitempty"`

	// Controls the access of UNIX symbolic links to CIFS clients.
	// The supported values are:
	//     * local - Enables only local symbolic links which is within the same CIFS share.
	//     * widelink - Enables both local symlinks and widelinks.
	//     * disable - Disables local symlinks and widelinks.
	//
	// Enum: ["local","widelink","disable"]
	UnixSymlink *string `json:"unix_symlink,omitempty"`

	// volume
	Volume *CifsShareInlineVolume `json:"volume,omitempty"`

	// Vscan File-Operations Profile
	// The supported values are:
	//   * no_scan - Virus scans are never triggered for accesses to this share.
	//   * standard - Virus scans can be triggered by open, close, and rename operations.
	//   * strict - Virus scans can be triggered by open, read, close, and rename operations.
	//   * writes_only - Virus scans can be triggered only when a file that has been modified is closed.
	//
	// Enum: ["no_scan","standard","strict","writes_only"]
	VscanProfile *string `json:"vscan_profile,omitempty"`
}

// Validate validates this cifs share
func (m *CifsShare) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCifsShareInlineAcls(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOfflineFiles(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnixSymlink(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVscanProfile(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShare) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsShare) validateCifsShareInlineAcls(formats strfmt.Registry) error {
	if swag.IsZero(m.CifsShareInlineAcls) { // not required
		return nil
	}

	for i := 0; i < len(m.CifsShareInlineAcls); i++ {
		if swag.IsZero(m.CifsShareInlineAcls[i]) { // not required
			continue
		}

		if m.CifsShareInlineAcls[i] != nil {
			if err := m.CifsShareInlineAcls[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsShare) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (m *CifsShare) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 80); err != nil {
		return err
	}

	return nil
}

var cifsShareTypeOfflineFilesPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","manual","documents","programs"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareTypeOfflineFilesPropEnum = append(cifsShareTypeOfflineFilesPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// offline_files
	// OfflineFiles
	// none
	// END DEBUGGING
	// CifsShareOfflineFilesNone captures enum value "none"
	CifsShareOfflineFilesNone string = "none"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// offline_files
	// OfflineFiles
	// manual
	// END DEBUGGING
	// CifsShareOfflineFilesManual captures enum value "manual"
	CifsShareOfflineFilesManual string = "manual"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// offline_files
	// OfflineFiles
	// documents
	// END DEBUGGING
	// CifsShareOfflineFilesDocuments captures enum value "documents"
	CifsShareOfflineFilesDocuments string = "documents"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// offline_files
	// OfflineFiles
	// programs
	// END DEBUGGING
	// CifsShareOfflineFilesPrograms captures enum value "programs"
	CifsShareOfflineFilesPrograms string = "programs"
)

// prop value enum
func (m *CifsShare) validateOfflineFilesEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareTypeOfflineFilesPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsShare) validateOfflineFiles(formats strfmt.Registry) error {
	if swag.IsZero(m.OfflineFiles) { // not required
		return nil
	}

	// value enum
	if err := m.validateOfflineFilesEnum("offline_files", "body", *m.OfflineFiles); err != nil {
		return err
	}

	return nil
}

func (m *CifsShare) validatePath(formats strfmt.Registry) error {
	if swag.IsZero(m.Path) { // not required
		return nil
	}

	if err := validate.MinLength("path", "body", *m.Path, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("path", "body", *m.Path, 256); err != nil {
		return err
	}

	return nil
}

func (m *CifsShare) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var cifsShareTypeUnixSymlinkPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["local","widelink","disable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareTypeUnixSymlinkPropEnum = append(cifsShareTypeUnixSymlinkPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// unix_symlink
	// UnixSymlink
	// local
	// END DEBUGGING
	// CifsShareUnixSymlinkLocal captures enum value "local"
	CifsShareUnixSymlinkLocal string = "local"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// unix_symlink
	// UnixSymlink
	// widelink
	// END DEBUGGING
	// CifsShareUnixSymlinkWidelink captures enum value "widelink"
	CifsShareUnixSymlinkWidelink string = "widelink"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// unix_symlink
	// UnixSymlink
	// disable
	// END DEBUGGING
	// CifsShareUnixSymlinkDisable captures enum value "disable"
	CifsShareUnixSymlinkDisable string = "disable"
)

// prop value enum
func (m *CifsShare) validateUnixSymlinkEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareTypeUnixSymlinkPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsShare) validateUnixSymlink(formats strfmt.Registry) error {
	if swag.IsZero(m.UnixSymlink) { // not required
		return nil
	}

	// value enum
	if err := m.validateUnixSymlinkEnum("unix_symlink", "body", *m.UnixSymlink); err != nil {
		return err
	}

	return nil
}

func (m *CifsShare) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

var cifsShareTypeVscanProfilePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_scan","standard","strict","writes_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareTypeVscanProfilePropEnum = append(cifsShareTypeVscanProfilePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// vscan_profile
	// VscanProfile
	// no_scan
	// END DEBUGGING
	// CifsShareVscanProfileNoScan captures enum value "no_scan"
	CifsShareVscanProfileNoScan string = "no_scan"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// vscan_profile
	// VscanProfile
	// standard
	// END DEBUGGING
	// CifsShareVscanProfileStandard captures enum value "standard"
	CifsShareVscanProfileStandard string = "standard"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// vscan_profile
	// VscanProfile
	// strict
	// END DEBUGGING
	// CifsShareVscanProfileStrict captures enum value "strict"
	CifsShareVscanProfileStrict string = "strict"

	// BEGIN DEBUGGING
	// cifs_share
	// CifsShare
	// vscan_profile
	// VscanProfile
	// writes_only
	// END DEBUGGING
	// CifsShareVscanProfileWritesOnly captures enum value "writes_only"
	CifsShareVscanProfileWritesOnly string = "writes_only"
)

// prop value enum
func (m *CifsShare) validateVscanProfileEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareTypeVscanProfilePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsShare) validateVscanProfile(formats strfmt.Registry) error {
	if swag.IsZero(m.VscanProfile) { // not required
		return nil
	}

	// value enum
	if err := m.validateVscanProfileEnum("vscan_profile", "body", *m.VscanProfile); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs share based on the context it is used
func (m *CifsShare) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCifsShareInlineAcls(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShare) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CifsShare) contextValidateCifsShareInlineAcls(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CifsShareInlineAcls); i++ {

		if m.CifsShareInlineAcls[i] != nil {
			if err := m.CifsShareInlineAcls[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("acls" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *CifsShare) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *CifsShare) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShare) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShare) UnmarshalBinary(b []byte) error {
	var res CifsShare
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineAclsInlineArrayItem The permissions that users and groups have on a CIFS share.
//
// swagger:model cifs_share_inline_acls_inline_array_item
type CifsShareInlineAclsInlineArrayItem struct {

	// links
	Links *CifsShareInlineAclsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Specifies the access rights that a user or group has on the defined CIFS Share.
	// The following values are allowed:
	// * no_access    - User does not have CIFS share access
	// * read         - User has only read access
	// * change       - User has change access
	// * full_control - User has full_control access
	//
	// Enum: ["no_access","read","change","full_control"]
	Permission *string `json:"permission,omitempty"`

	// Specifies the type of the user or group to add to the access control
	// list of a CIFS share. The following values are allowed:
	// * windows    - Windows user or group
	// * unix_user  - UNIX user
	// * unix_group - UNIX group
	//
	// Enum: ["windows","unix_user","unix_group"]
	Type *string `json:"type,omitempty"`

	// Specifies the user or group name to add to the access control list of a CIFS share.
	// Example: ENGDOMAIN\\ad_user
	UserOrGroup *string `json:"user_or_group,omitempty"`

	// Windows SID/UNIX ID depending on access-control type.
	WinSidUnixID *string `json:"win_sid_unix_id,omitempty"`
}

// Validate validates this cifs share inline acls inline array item
func (m *CifsShareInlineAclsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_access","read","change","full_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum = append(cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// no_access
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionNoAccess captures enum value "no_access"
	CifsShareInlineAclsInlineArrayItemPermissionNoAccess string = "no_access"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// read
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionRead captures enum value "read"
	CifsShareInlineAclsInlineArrayItemPermissionRead string = "read"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// change
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionChange captures enum value "change"
	CifsShareInlineAclsInlineArrayItemPermissionChange string = "change"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// permission
	// Permission
	// full_control
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemPermissionFullControl captures enum value "full_control"
	CifsShareInlineAclsInlineArrayItemPermissionFullControl string = "full_control"
)

// prop value enum
func (m *CifsShareInlineAclsInlineArrayItem) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareInlineAclsInlineArrayItemTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItem) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(m.Permission) { // not required
		return nil
	}

	// value enum
	if err := m.validatePermissionEnum("permission", "body", *m.Permission); err != nil {
		return err
	}

	return nil
}

var cifsShareInlineAclsInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["windows","unix_user","unix_group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsShareInlineAclsInlineArrayItemTypeTypePropEnum = append(cifsShareInlineAclsInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// windows
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeWindows captures enum value "windows"
	CifsShareInlineAclsInlineArrayItemTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// unix_user
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeUnixUser captures enum value "unix_user"
	CifsShareInlineAclsInlineArrayItemTypeUnixUser string = "unix_user"

	// BEGIN DEBUGGING
	// cifs_share_inline_acls_inline_array_item
	// CifsShareInlineAclsInlineArrayItem
	// type
	// Type
	// unix_group
	// END DEBUGGING
	// CifsShareInlineAclsInlineArrayItemTypeUnixGroup captures enum value "unix_group"
	CifsShareInlineAclsInlineArrayItemTypeUnixGroup string = "unix_group"
)

// prop value enum
func (m *CifsShareInlineAclsInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsShareInlineAclsInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cifs share inline acls inline array item based on the context it is used
func (m *CifsShareInlineAclsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineAclsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineAclsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineAclsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineAclsInlineArrayItemInlineLinks cifs share inline acls inline array item inline links
//
// swagger:model cifs_share_inline_acls_inline_array_item_inline__links
type CifsShareInlineAclsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline acls inline array item inline links
func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline acls inline array item inline links based on the context it is used
func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineAclsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineAclsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineLinks cifs share inline links
//
// swagger:model cifs_share_inline__links
type CifsShareInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline links
func (m *CifsShareInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline links based on the context it is used
func (m *CifsShareInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model cifs_share_inline_svm
type CifsShareInlineSvm struct {

	// links
	Links *CifsShareInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs share inline svm
func (m *CifsShareInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline svm based on the context it is used
func (m *CifsShareInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineSvm) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineSvmInlineLinks cifs share inline svm inline links
//
// swagger:model cifs_share_inline_svm_inline__links
type CifsShareInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline svm inline links
func (m *CifsShareInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline svm inline links based on the context it is used
func (m *CifsShareInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineVolume cifs share inline volume
//
// swagger:model cifs_share_inline_volume
type CifsShareInlineVolume struct {

	// links
	Links *CifsShareInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cifs share inline volume
func (m *CifsShareInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline volume based on the context it is used
func (m *CifsShareInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineVolume) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CifsShareInlineVolumeInlineLinks cifs share inline volume inline links
//
// swagger:model cifs_share_inline_volume_inline__links
type CifsShareInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cifs share inline volume inline links
func (m *CifsShareInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cifs share inline volume inline links based on the context it is used
func (m *CifsShareInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CifsShareInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CifsShareInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsShareInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CifsShareInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
