// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CifsTarget cifs target
//
// swagger:model cifs_target
type CifsTarget struct {

	// Specify if the destination share is a home directory.
	HomeDirectory *bool `json:"home_directory,omitempty"`

	// Specifies whether the CIFS symbolic link is a local link or wide link.
	// The following values are supported:
	// * local - Local symbolic link maps only to the same CIFS share.
	// * widelink - Wide symbolic link maps to any CIFS share on the network.
	//
	// Enum: ["local","widelink"]
	Locality *string `json:"locality,omitempty"`

	// Specifies the CIFS path on the destination to which the symbolic link maps. The final path is generated by concatenating the CIFS server name, the share name, the cifs-path and the remaining path in the symbolic link left after the prefix match. This value is specified by using a UNIX-style path name. The trailing forward slash is required for the full path name to be properly interpreted.
	// Example: /dir1/dir2/
	// Max Length: 256
	Path *string `json:"path,omitempty"`

	// Specifies the destination CIFS server where the
	// UNIX symbolic link is pointing. This field is mandatory if the
	// locality of the symbolic link is 'widelink'.
	// You can specify the value in any of the following formats:
	//   * DNS name of the CIFS server.
	//   * IP address of the CIFS server.
	//   * NetBIOS name of the CIFS server.
	//
	// Example: ENGCIFS
	// Max Length: 45
	Server *string `json:"server,omitempty"`

	// Specifies the CIFS share name on the destination CIFS server to which the UNIX symbolic link is pointing.
	// Example: ENG_SHARE
	// Max Length: 80
	Share *string `json:"share,omitempty"`
}

// Validate validates this cifs target
func (m *CifsTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocality(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePath(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShare(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var cifsTargetTypeLocalityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["local","widelink"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cifsTargetTypeLocalityPropEnum = append(cifsTargetTypeLocalityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cifs_target
	// CifsTarget
	// locality
	// Locality
	// local
	// END DEBUGGING
	// CifsTargetLocalityLocal captures enum value "local"
	CifsTargetLocalityLocal string = "local"

	// BEGIN DEBUGGING
	// cifs_target
	// CifsTarget
	// locality
	// Locality
	// widelink
	// END DEBUGGING
	// CifsTargetLocalityWidelink captures enum value "widelink"
	CifsTargetLocalityWidelink string = "widelink"
)

// prop value enum
func (m *CifsTarget) validateLocalityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cifsTargetTypeLocalityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CifsTarget) validateLocality(formats strfmt.Registry) error {
	if swag.IsZero(m.Locality) { // not required
		return nil
	}

	// value enum
	if err := m.validateLocalityEnum("locality", "body", *m.Locality); err != nil {
		return err
	}

	return nil
}

func (m *CifsTarget) validatePath(formats strfmt.Registry) error {
	if swag.IsZero(m.Path) { // not required
		return nil
	}

	if err := validate.MaxLength("path", "body", *m.Path, 256); err != nil {
		return err
	}

	return nil
}

func (m *CifsTarget) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	if err := validate.MaxLength("server", "body", *m.Server, 45); err != nil {
		return err
	}

	return nil
}

func (m *CifsTarget) validateShare(formats strfmt.Registry) error {
	if swag.IsZero(m.Share) { // not required
		return nil
	}

	if err := validate.MaxLength("share", "body", *m.Share, 80); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cifs target based on context it is used
func (m *CifsTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CifsTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CifsTarget) UnmarshalBinary(b []byte) error {
	var res CifsTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
