// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClientLock This object represents locks on a volume.
//
// swagger:model client_lock
type ClientLock struct {

	// byte lock
	ByteLock *ByteLock `json:"byte_lock,omitempty"`

	// IP address of the client holding the lock.
	// Example: 0.0.0.0
	ClientAddress *string `json:"client_address,omitempty"`

	// Indicate if volume is constituent or not.
	// Read Only: true
	Constituent *bool `json:"constituent,omitempty"`

	// Type of delegation.
	// Read Only: true
	// Enum: ["read","write"]
	Delegation *string `json:"delegation,omitempty"`

	// interface
	Interface *ClientLockInlineInterface `json:"interface,omitempty"`

	// node
	Node *ClientLockInlineNode `json:"node,omitempty"`

	// The oplock level determines which operations the client may cache locally.
	// Read Only: true
	// Enum: ["exclusive","level2","batch","null","read_batch"]
	OplockLevel *string `json:"oplock_level,omitempty"`

	// Owner ID.
	// Read Only: true
	OwnerID *string `json:"owner_id,omitempty"`

	// Object path
	Path *string `json:"path,omitempty"`

	// Type of lock protocol.
	// Enum: ["cifs","fcache","nfsv4","http","nlm","nfsv4.1","crposix"]
	Protocol *string `json:"protocol,omitempty"`

	// share lock
	ShareLock *ShareLock `json:"share_lock,omitempty"`

	// smb
	Smb *Smb `json:"smb,omitempty"`

	// State of lock.
	// Read Only: true
	// Enum: ["granted","revoking","adjusted","denied","subsumed","gone","unused","waiting","timeout"]
	State *string `json:"state,omitempty"`

	// svm
	Svm *ClientLockInlineSvm `json:"svm,omitempty"`

	// Type of lock.
	// Read Only: true
	// Enum: ["byte_range","share_level","op_lock","delegation"]
	Type *string `json:"type,omitempty"`

	// Lock UUID
	// Example: ceeac1b4-8646-4c76-a054-1c96e87594aa
	UUID *string `json:"uuid,omitempty"`

	// volume
	Volume *ClientLockInlineVolume `json:"volume,omitempty"`
}

// Validate validates this client lock
func (m *ClientLock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateByteLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDelegation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOplockLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateShareLock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSmb(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLock) validateByteLock(formats strfmt.Registry) error {
	if swag.IsZero(m.ByteLock) { // not required
		return nil
	}

	if m.ByteLock != nil {
		if err := m.ByteLock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("byte_lock")
			}
			return err
		}
	}

	return nil
}

var clientLockTypeDelegationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","write"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clientLockTypeDelegationPropEnum = append(clientLockTypeDelegationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// delegation
	// Delegation
	// read
	// END DEBUGGING
	// ClientLockDelegationRead captures enum value "read"
	ClientLockDelegationRead string = "read"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// delegation
	// Delegation
	// write
	// END DEBUGGING
	// ClientLockDelegationWrite captures enum value "write"
	ClientLockDelegationWrite string = "write"
)

// prop value enum
func (m *ClientLock) validateDelegationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clientLockTypeDelegationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClientLock) validateDelegation(formats strfmt.Registry) error {
	if swag.IsZero(m.Delegation) { // not required
		return nil
	}

	// value enum
	if err := m.validateDelegationEnum("delegation", "body", *m.Delegation); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.Interface) { // not required
		return nil
	}

	if m.Interface != nil {
		if err := m.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

var clientLockTypeOplockLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["exclusive","level2","batch","null","read_batch"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clientLockTypeOplockLevelPropEnum = append(clientLockTypeOplockLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// oplock_level
	// OplockLevel
	// exclusive
	// END DEBUGGING
	// ClientLockOplockLevelExclusive captures enum value "exclusive"
	ClientLockOplockLevelExclusive string = "exclusive"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// oplock_level
	// OplockLevel
	// level2
	// END DEBUGGING
	// ClientLockOplockLevelLevel2 captures enum value "level2"
	ClientLockOplockLevelLevel2 string = "level2"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// oplock_level
	// OplockLevel
	// batch
	// END DEBUGGING
	// ClientLockOplockLevelBatch captures enum value "batch"
	ClientLockOplockLevelBatch string = "batch"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// oplock_level
	// OplockLevel
	// null
	// END DEBUGGING
	// ClientLockOplockLevelNull captures enum value "null"
	ClientLockOplockLevelNull string = "null"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// oplock_level
	// OplockLevel
	// read_batch
	// END DEBUGGING
	// ClientLockOplockLevelReadBatch captures enum value "read_batch"
	ClientLockOplockLevelReadBatch string = "read_batch"
)

// prop value enum
func (m *ClientLock) validateOplockLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clientLockTypeOplockLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClientLock) validateOplockLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.OplockLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateOplockLevelEnum("oplock_level", "body", *m.OplockLevel); err != nil {
		return err
	}

	return nil
}

var clientLockTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cifs","fcache","nfsv4","http","nlm","nfsv4.1","crposix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clientLockTypeProtocolPropEnum = append(clientLockTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// cifs
	// END DEBUGGING
	// ClientLockProtocolCifs captures enum value "cifs"
	ClientLockProtocolCifs string = "cifs"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// fcache
	// END DEBUGGING
	// ClientLockProtocolFcache captures enum value "fcache"
	ClientLockProtocolFcache string = "fcache"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// nfsv4
	// END DEBUGGING
	// ClientLockProtocolNfsv4 captures enum value "nfsv4"
	ClientLockProtocolNfsv4 string = "nfsv4"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// http
	// END DEBUGGING
	// ClientLockProtocolHTTP captures enum value "http"
	ClientLockProtocolHTTP string = "http"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// nlm
	// END DEBUGGING
	// ClientLockProtocolNlm captures enum value "nlm"
	ClientLockProtocolNlm string = "nlm"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// nfsv4.1
	// END DEBUGGING
	// ClientLockProtocolNfsv4Dot1 captures enum value "nfsv4.1"
	ClientLockProtocolNfsv4Dot1 string = "nfsv4.1"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// protocol
	// Protocol
	// crposix
	// END DEBUGGING
	// ClientLockProtocolCrposix captures enum value "crposix"
	ClientLockProtocolCrposix string = "crposix"
)

// prop value enum
func (m *ClientLock) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clientLockTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClientLock) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) validateShareLock(formats strfmt.Registry) error {
	if swag.IsZero(m.ShareLock) { // not required
		return nil
	}

	if m.ShareLock != nil {
		if err := m.ShareLock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share_lock")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) validateSmb(formats strfmt.Registry) error {
	if swag.IsZero(m.Smb) { // not required
		return nil
	}

	if m.Smb != nil {
		if err := m.Smb.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smb")
			}
			return err
		}
	}

	return nil
}

var clientLockTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["granted","revoking","adjusted","denied","subsumed","gone","unused","waiting","timeout"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clientLockTypeStatePropEnum = append(clientLockTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// granted
	// END DEBUGGING
	// ClientLockStateGranted captures enum value "granted"
	ClientLockStateGranted string = "granted"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// revoking
	// END DEBUGGING
	// ClientLockStateRevoking captures enum value "revoking"
	ClientLockStateRevoking string = "revoking"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// adjusted
	// END DEBUGGING
	// ClientLockStateAdjusted captures enum value "adjusted"
	ClientLockStateAdjusted string = "adjusted"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// denied
	// END DEBUGGING
	// ClientLockStateDenied captures enum value "denied"
	ClientLockStateDenied string = "denied"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// subsumed
	// END DEBUGGING
	// ClientLockStateSubsumed captures enum value "subsumed"
	ClientLockStateSubsumed string = "subsumed"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// gone
	// END DEBUGGING
	// ClientLockStateGone captures enum value "gone"
	ClientLockStateGone string = "gone"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// unused
	// END DEBUGGING
	// ClientLockStateUnused captures enum value "unused"
	ClientLockStateUnused string = "unused"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// waiting
	// END DEBUGGING
	// ClientLockStateWaiting captures enum value "waiting"
	ClientLockStateWaiting string = "waiting"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// state
	// State
	// timeout
	// END DEBUGGING
	// ClientLockStateTimeout captures enum value "timeout"
	ClientLockStateTimeout string = "timeout"
)

// prop value enum
func (m *ClientLock) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clientLockTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClientLock) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var clientLockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["byte_range","share_level","op_lock","delegation"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clientLockTypeTypePropEnum = append(clientLockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// type
	// Type
	// byte_range
	// END DEBUGGING
	// ClientLockTypeByteRange captures enum value "byte_range"
	ClientLockTypeByteRange string = "byte_range"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// type
	// Type
	// share_level
	// END DEBUGGING
	// ClientLockTypeShareLevel captures enum value "share_level"
	ClientLockTypeShareLevel string = "share_level"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// type
	// Type
	// op_lock
	// END DEBUGGING
	// ClientLockTypeOpLock captures enum value "op_lock"
	ClientLockTypeOpLock string = "op_lock"

	// BEGIN DEBUGGING
	// client_lock
	// ClientLock
	// type
	// Type
	// delegation
	// END DEBUGGING
	// ClientLockTypeDelegation captures enum value "delegation"
	ClientLockTypeDelegation string = "delegation"
)

// prop value enum
func (m *ClientLock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clientLockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClientLock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock based on the context it is used
func (m *ClientLock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateByteLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConstituent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelegation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOplockLevel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwnerID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateShareLock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSmb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLock) contextValidateByteLock(ctx context.Context, formats strfmt.Registry) error {

	if m.ByteLock != nil {
		if err := m.ByteLock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("byte_lock")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateConstituent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "constituent", "body", m.Constituent); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateDelegation(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "delegation", "body", m.Delegation); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.Interface != nil {
		if err := m.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateOplockLevel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "oplock_level", "body", m.OplockLevel); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateOwnerID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "owner_id", "body", m.OwnerID); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateShareLock(ctx context.Context, formats strfmt.Registry) error {

	if m.ShareLock != nil {
		if err := m.ShareLock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("share_lock")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateSmb(ctx context.Context, formats strfmt.Registry) error {

	if m.Smb != nil {
		if err := m.Smb.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("smb")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLock) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ClientLock) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLock) UnmarshalBinary(b []byte) error {
	var res ClientLock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineInterface A network interface. Either UUID or name may be supplied on input.
//
// swagger:model client_lock_inline_interface
type ClientLockInlineInterface struct {

	// links
	Links *ClientLockInlineInterfaceInlineLinks `json:"_links,omitempty"`

	// ip
	IP *ClientLockInlineInterfaceInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this client lock inline interface
func (m *ClientLockInlineInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterface) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLockInlineInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline interface based on the context it is used
func (m *ClientLockInlineInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterface) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClientLockInlineInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineInterface) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineInterfaceInlineIP IP information
//
// swagger:model client_lock_inline_interface_inline_ip
type ClientLockInlineInterfaceInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this client lock inline interface inline ip
func (m *ClientLockInlineInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterfaceInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline interface inline ip based on the context it is used
func (m *ClientLockInlineInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterfaceInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineInterfaceInlineLinks client lock inline interface inline links
//
// swagger:model client_lock_inline_interface_inline__links
type ClientLockInlineInterfaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this client lock inline interface inline links
func (m *ClientLockInlineInterfaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterfaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline interface inline links based on the context it is used
func (m *ClientLockInlineInterfaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineInterfaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineInterfaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineInterfaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineInterfaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineNode client lock inline node
//
// swagger:model client_lock_inline_node
type ClientLockInlineNode struct {

	// links
	Links *ClientLockInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this client lock inline node
func (m *ClientLockInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline node based on the context it is used
func (m *ClientLockInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineNode) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineNodeInlineLinks client lock inline node inline links
//
// swagger:model client_lock_inline_node_inline__links
type ClientLockInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this client lock inline node inline links
func (m *ClientLockInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline node inline links based on the context it is used
func (m *ClientLockInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model client_lock_inline_svm
type ClientLockInlineSvm struct {

	// links
	Links *ClientLockInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this client lock inline svm
func (m *ClientLockInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline svm based on the context it is used
func (m *ClientLockInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineSvm) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineSvmInlineLinks client lock inline svm inline links
//
// swagger:model client_lock_inline_svm_inline__links
type ClientLockInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this client lock inline svm inline links
func (m *ClientLockInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline svm inline links based on the context it is used
func (m *ClientLockInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineVolume client lock inline volume
//
// swagger:model client_lock_inline_volume
type ClientLockInlineVolume struct {

	// links
	Links *ClientLockInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this client lock inline volume
func (m *ClientLockInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline volume based on the context it is used
func (m *ClientLockInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineVolume) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClientLockInlineVolumeInlineLinks client lock inline volume inline links
//
// swagger:model client_lock_inline_volume_inline__links
type ClientLockInlineVolumeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this client lock inline volume inline links
func (m *ClientLockInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this client lock inline volume inline links based on the context it is used
func (m *ClientLockInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClientLockInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClientLockInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClientLockInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClientLockInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
