// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudStorageTier cloud storage tier
//
// swagger:model cloud_storage_tier
type CloudStorageTier struct {

	// cloud store
	CloudStore *CloudStorageTierInlineCloudStore `json:"cloud_store,omitempty"`

	// Capacity used in bytes in the cloud store by this aggregate. This is a cached value calculated every 5 minutes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this cloud storage tier
func (m *CloudStorageTier) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudStore(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTier) validateCloudStore(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudStore) { // not required
		return nil
	}

	if m.CloudStore != nil {
		if err := m.CloudStore.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud storage tier based on the context it is used
func (m *CloudStorageTier) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudStore(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTier) contextValidateCloudStore(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudStore != nil {
		if err := m.CloudStore.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store")
			}
			return err
		}
	}

	return nil
}

func (m *CloudStorageTier) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudStorageTier) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudStorageTier) UnmarshalBinary(b []byte) error {
	var res CloudStorageTier
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudStorageTierInlineCloudStore Cloud store
//
// swagger:model cloud_storage_tier_inline_cloud_store
type CloudStorageTierInlineCloudStore struct {

	// links
	Links *CloudStorageTierInlineCloudStoreInlineLinks `json:"_links,omitempty"`

	// name
	// Example: store1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud storage tier inline cloud store
func (m *CloudStorageTierInlineCloudStore) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTierInlineCloudStore) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud storage tier inline cloud store based on the context it is used
func (m *CloudStorageTierInlineCloudStore) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTierInlineCloudStore) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudStorageTierInlineCloudStore) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudStorageTierInlineCloudStore) UnmarshalBinary(b []byte) error {
	var res CloudStorageTierInlineCloudStore
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudStorageTierInlineCloudStoreInlineLinks cloud storage tier inline cloud store inline links
//
// swagger:model cloud_storage_tier_inline_cloud_store_inline__links
type CloudStorageTierInlineCloudStoreInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cloud storage tier inline cloud store inline links
func (m *CloudStorageTierInlineCloudStoreInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTierInlineCloudStoreInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud storage tier inline cloud store inline links based on the context it is used
func (m *CloudStorageTierInlineCloudStoreInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudStorageTierInlineCloudStoreInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_store" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudStorageTierInlineCloudStoreInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudStorageTierInlineCloudStoreInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudStorageTierInlineCloudStoreInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
