// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CloudTarget cloud target
//
// swagger:model cloud_target
type CloudTarget struct {

	// links
	Links *CloudTargetInlineLinks `json:"_links,omitempty"`

	// Access key ID for AWS_S3 and other S3 compatible provider types.
	AccessKey *string `json:"access_key,omitempty"`

	// Authentication used to access the target. SnapMirror does not yet support CAP. Required in POST.
	// Enum: ["key","cap","ec2_iam","gcp_sa","azure_msi"]
	AuthenticationType *string `json:"authentication_type,omitempty"`

	// Azure account
	AzureAccount *string `json:"azure_account,omitempty"`

	// Managed Service Identity (MSI) token required to authenticate to the Azure object store. This form of authentication is only supported on Azure NetApp Files.
	// Format: password
	AzureMsiToken *strfmt.Password `json:"azure_msi_token,omitempty"`

	// Azure access key
	// Format: password
	AzurePrivateKey *strfmt.Password `json:"azure_private_key,omitempty"`

	// Shared access signature token to access Azure containers and blobs.
	// Format: password
	AzureSasToken *strfmt.Password `json:"azure_sas_token,omitempty"`

	// This parameter is available only when auth-type is CAP. It specifies a full URL of the request to a CAP server for retrieving temporary credentials (access-key, secret-password, and session token) for accessing the object store.
	// Example: https://123.45.67.89:1234/CAP/api/v1/credentials?agency=myagency\u0026mission=mymission\u0026role=myrole
	CapURL *string `json:"cap_url,omitempty"`

	// Is SSL/TLS certificate validation enabled? The default value is true. This can only be modified for SGWS, IBM_COS, and ONTAP_S3 provider types.
	CertificateValidationEnabled *bool `json:"certificate_validation_enabled,omitempty"`

	// cluster
	Cluster *CloudTargetInlineCluster `json:"cluster,omitempty"`

	// Data bucket/container name. For FabricLink, a wildcard character "*" can also be specified to indicate that all the buckets in an SVM can use the same target information. However, for containers other than ONTAP, an exact name should be specified.
	// Example: bucket1
	Container *string `json:"container,omitempty"`

	// ipspace
	Ipspace *CloudTargetInlineIpspace `json:"ipspace,omitempty"`

	// Cloud target name
	Name *string `json:"name,omitempty"`

	// Owner of the target. Allowed values are <personalities supports=unified> FabricPool, </personalities> SnapMirror or S3_SnapMirror. A target can be used by only one feature.
	// Enum: ["fabricpool","snapmirror","s3_snapmirror"]
	Owner *string `json:"owner,omitempty"`

	// Port number of the object store that ONTAP uses when establishing a connection. Required in POST.
	Port *int64 `json:"port,omitempty"`

	// Type of cloud provider. Allowed values depend on owner type. <personalities supports=unified> For FabricPool, AliCloud, AWS_S3, Azure_Cloud, GoogleCloud, IBM_COS, SGWS, and ONTAP_S3 are allowed. </personalities> For SnapMirror, the valid values are AWS_S3 or SGWS. For FabricLink, AWS_S3, SGWS, S3_Compatible, S3EMU, LOOPBACK and ONTAP_S3 are allowed.
	ProviderType *string `json:"provider_type,omitempty"`

	// The warning threshold for read latency that is used to determine when an alert ems for a read operation from an object store should be issued.
	ReadLatencyWarningThreshold *int64 `json:"read_latency_warning_threshold,omitempty"`

	// If the cloud target is owned by a data SVM, then the scope is set to svm. Otherwise it will be set to cluster.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// Secret access key for AWS_S3 and other S3 compatible provider types.
	// Format: password
	SecretPassword *strfmt.Password `json:"secret_password,omitempty"`

	// Fully qualified domain name of the object store server. Required on POST.  For Amazon S3, server name must be an AWS regional endpoint in the format s3.amazonaws.com or s3-<region>.amazonaws.com, for example, s3-us-west-2.amazonaws.com. The region of the server and the bucket must match. For Azure, if the server is a "blob.core.windows.net" or a "blob.core.usgovcloudapi.net", then a value of azure-account followed by a period is added in front of the server.
	Server *string `json:"server,omitempty"`

	// Encryption of data at rest by the object store server for AWS_S3 and other S3 compatible provider types. In most cases it is best not to change default value of "sse_s3" for object store servers which support SSE-S3 encryption. The encryption is in addition to any encryption done by ONTAP at a volume or at an aggregate level. Note that changing this option does not change encryption of data which already exist in the object store.
	// Enum: ["none","sse_s3","sse_kms","dsse_kms"]
	ServerSideEncryption *string `json:"server_side_encryption,omitempty"`

	// Use of the cloud target by SnapMirror.
	// Enum: ["data","metadata"]
	SnapmirrorUse *string `json:"snapmirror_use,omitempty"`

	// SSL/HTTPS enabled or not
	SslEnabled *bool `json:"ssl_enabled,omitempty"`

	// svm
	Svm *CloudTargetInlineSvm `json:"svm,omitempty"`

	// URL style used to access S3 bucket.
	// Enum: ["path_style","virtual_hosted_style"]
	URLStyle *string `json:"url_style,omitempty"`

	// Use HTTP proxy when connecting to the object store.
	UseHTTPProxy *bool `json:"use_http_proxy,omitempty"`

	// The amount of cloud space used by all the aggregates attached to the target, in bytes. This field is only populated for FabricPool targets. The value is recalculated once every 5 minutes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Cloud target UUID
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target
func (m *CloudTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthenticationType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzureMsiToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzurePrivateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAzureSasToken(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecretPassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServerSideEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapmirrorUse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateURLStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTarget) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var cloudTargetTypeAuthenticationTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["key","cap","ec2_iam","gcp_sa","azure_msi"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeAuthenticationTypePropEnum = append(cloudTargetTypeAuthenticationTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// authentication_type
	// AuthenticationType
	// key
	// END DEBUGGING
	// CloudTargetAuthenticationTypeKey captures enum value "key"
	CloudTargetAuthenticationTypeKey string = "key"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// authentication_type
	// AuthenticationType
	// cap
	// END DEBUGGING
	// CloudTargetAuthenticationTypeCap captures enum value "cap"
	CloudTargetAuthenticationTypeCap string = "cap"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// authentication_type
	// AuthenticationType
	// ec2_iam
	// END DEBUGGING
	// CloudTargetAuthenticationTypeEc2Iam captures enum value "ec2_iam"
	CloudTargetAuthenticationTypeEc2Iam string = "ec2_iam"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// authentication_type
	// AuthenticationType
	// gcp_sa
	// END DEBUGGING
	// CloudTargetAuthenticationTypeGcpSa captures enum value "gcp_sa"
	CloudTargetAuthenticationTypeGcpSa string = "gcp_sa"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// authentication_type
	// AuthenticationType
	// azure_msi
	// END DEBUGGING
	// CloudTargetAuthenticationTypeAzureMsi captures enum value "azure_msi"
	CloudTargetAuthenticationTypeAzureMsi string = "azure_msi"
)

// prop value enum
func (m *CloudTarget) validateAuthenticationTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeAuthenticationTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateAuthenticationType(formats strfmt.Registry) error {
	if swag.IsZero(m.AuthenticationType) { // not required
		return nil
	}

	// value enum
	if err := m.validateAuthenticationTypeEnum("authentication_type", "body", *m.AuthenticationType); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateAzureMsiToken(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureMsiToken) { // not required
		return nil
	}

	if err := validate.FormatOf("azure_msi_token", "body", "password", m.AzureMsiToken.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateAzurePrivateKey(formats strfmt.Registry) error {
	if swag.IsZero(m.AzurePrivateKey) { // not required
		return nil
	}

	if err := validate.FormatOf("azure_private_key", "body", "password", m.AzurePrivateKey.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateAzureSasToken(formats strfmt.Registry) error {
	if swag.IsZero(m.AzureSasToken) { // not required
		return nil
	}

	if err := validate.FormatOf("azure_sas_token", "body", "password", m.AzureSasToken.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateCluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Cluster) { // not required
		return nil
	}

	if m.Cluster != nil {
		if err := m.Cluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *CloudTarget) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

var cloudTargetTypeOwnerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fabricpool","snapmirror","s3_snapmirror"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeOwnerPropEnum = append(cloudTargetTypeOwnerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// owner
	// Owner
	// fabricpool
	// END DEBUGGING
	// CloudTargetOwnerFabricpool captures enum value "fabricpool"
	CloudTargetOwnerFabricpool string = "fabricpool"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// owner
	// Owner
	// snapmirror
	// END DEBUGGING
	// CloudTargetOwnerSnapmirror captures enum value "snapmirror"
	CloudTargetOwnerSnapmirror string = "snapmirror"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// owner
	// Owner
	// s3_snapmirror
	// END DEBUGGING
	// CloudTargetOwnerS3Snapmirror captures enum value "s3_snapmirror"
	CloudTargetOwnerS3Snapmirror string = "s3_snapmirror"
)

// prop value enum
func (m *CloudTarget) validateOwnerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeOwnerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	// value enum
	if err := m.validateOwnerEnum("owner", "body", *m.Owner); err != nil {
		return err
	}

	return nil
}

var cloudTargetTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeScopePropEnum = append(cloudTargetTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// CloudTargetScopeCluster captures enum value "cluster"
	CloudTargetScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// CloudTargetScopeSvm captures enum value "svm"
	CloudTargetScopeSvm string = "svm"
)

// prop value enum
func (m *CloudTarget) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(m.Scope) { // not required
		return nil
	}

	// value enum
	if err := m.validateScopeEnum("scope", "body", *m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateSecretPassword(formats strfmt.Registry) error {
	if swag.IsZero(m.SecretPassword) { // not required
		return nil
	}

	if err := validate.FormatOf("secret_password", "body", "password", m.SecretPassword.String(), formats); err != nil {
		return err
	}

	return nil
}

var cloudTargetTypeServerSideEncryptionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sse_s3","sse_kms","dsse_kms"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeServerSideEncryptionPropEnum = append(cloudTargetTypeServerSideEncryptionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// server_side_encryption
	// ServerSideEncryption
	// none
	// END DEBUGGING
	// CloudTargetServerSideEncryptionNone captures enum value "none"
	CloudTargetServerSideEncryptionNone string = "none"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// server_side_encryption
	// ServerSideEncryption
	// sse_s3
	// END DEBUGGING
	// CloudTargetServerSideEncryptionSseS3 captures enum value "sse_s3"
	CloudTargetServerSideEncryptionSseS3 string = "sse_s3"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// server_side_encryption
	// ServerSideEncryption
	// sse_kms
	// END DEBUGGING
	// CloudTargetServerSideEncryptionSseKms captures enum value "sse_kms"
	CloudTargetServerSideEncryptionSseKms string = "sse_kms"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// server_side_encryption
	// ServerSideEncryption
	// dsse_kms
	// END DEBUGGING
	// CloudTargetServerSideEncryptionDsseKms captures enum value "dsse_kms"
	CloudTargetServerSideEncryptionDsseKms string = "dsse_kms"
)

// prop value enum
func (m *CloudTarget) validateServerSideEncryptionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeServerSideEncryptionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateServerSideEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.ServerSideEncryption) { // not required
		return nil
	}

	// value enum
	if err := m.validateServerSideEncryptionEnum("server_side_encryption", "body", *m.ServerSideEncryption); err != nil {
		return err
	}

	return nil
}

var cloudTargetTypeSnapmirrorUsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","metadata"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeSnapmirrorUsePropEnum = append(cloudTargetTypeSnapmirrorUsePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// snapmirror_use
	// SnapmirrorUse
	// data
	// END DEBUGGING
	// CloudTargetSnapmirrorUseData captures enum value "data"
	CloudTargetSnapmirrorUseData string = "data"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// snapmirror_use
	// SnapmirrorUse
	// metadata
	// END DEBUGGING
	// CloudTargetSnapmirrorUseMetadata captures enum value "metadata"
	CloudTargetSnapmirrorUseMetadata string = "metadata"
)

// prop value enum
func (m *CloudTarget) validateSnapmirrorUseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeSnapmirrorUsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateSnapmirrorUse(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapmirrorUse) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnapmirrorUseEnum("snapmirror_use", "body", *m.SnapmirrorUse); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

var cloudTargetTypeURLStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["path_style","virtual_hosted_style"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudTargetTypeURLStylePropEnum = append(cloudTargetTypeURLStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// url_style
	// URLStyle
	// path_style
	// END DEBUGGING
	// CloudTargetURLStylePathStyle captures enum value "path_style"
	CloudTargetURLStylePathStyle string = "path_style"

	// BEGIN DEBUGGING
	// cloud_target
	// CloudTarget
	// url_style
	// URLStyle
	// virtual_hosted_style
	// END DEBUGGING
	// CloudTargetURLStyleVirtualHostedStyle captures enum value "virtual_hosted_style"
	CloudTargetURLStyleVirtualHostedStyle string = "virtual_hosted_style"
)

// prop value enum
func (m *CloudTarget) validateURLStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudTargetTypeURLStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CloudTarget) validateURLStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.URLStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateURLStyleEnum("url_style", "body", *m.URLStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cloud target based on the context it is used
func (m *CloudTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTarget) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CloudTarget) contextValidateCluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Cluster != nil {
		if err := m.Cluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster")
			}
			return err
		}
	}

	return nil
}

func (m *CloudTarget) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *CloudTarget) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "scope", "body", m.Scope); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *CloudTarget) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

func (m *CloudTarget) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTarget) UnmarshalBinary(b []byte) error {
	var res CloudTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineCluster cloud target inline cluster
//
// swagger:model cloud_target_inline_cluster
type CloudTargetInlineCluster struct {

	// The name of the cluster that owns the cloud target. For POST, this accepts the name of the peer cluster only if the cluster is in switchover state.
	Name *string `json:"name,omitempty"`

	// The UUID of the cluster that owns the cloud target. For POST, this accepts the UUID of the peer cluster only if the cluster is in switchover state.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline cluster
func (m *CloudTargetInlineCluster) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cloud target inline cluster based on context it is used
func (m *CloudTargetInlineCluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineCluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineCluster) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineCluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineIpspace IPspace to use in order to reach the cloud target.
//
// swagger:model cloud_target_inline_ipspace
type CloudTargetInlineIpspace struct {

	// links
	Links *CloudTargetInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline ipspace
func (m *CloudTargetInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline ipspace based on the context it is used
func (m *CloudTargetInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineIpspace) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineIpspaceInlineLinks cloud target inline ipspace inline links
//
// swagger:model cloud_target_inline_ipspace_inline__links
type CloudTargetInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline ipspace inline links
func (m *CloudTargetInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline ipspace inline links based on the context it is used
func (m *CloudTargetInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineLinks cloud target inline links
//
// swagger:model cloud_target_inline__links
type CloudTargetInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline links
func (m *CloudTargetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline links based on the context it is used
func (m *CloudTargetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineSvm This field is only applicable when used for SnapMirror and FabricLink. For POST and PATCH, SVM information is required for SnapMirror and FabricLink targets when the scope is svm and is not allowed for FabricPool targets. For GET, this field is not set if the scope of the cloud target is "cluster".
//
// swagger:model cloud_target_inline_svm
type CloudTargetInlineSvm struct {

	// links
	Links *CloudTargetInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud target inline svm
func (m *CloudTargetInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline svm based on the context it is used
func (m *CloudTargetInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineSvm) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CloudTargetInlineSvmInlineLinks cloud target inline svm inline links
//
// swagger:model cloud_target_inline_svm_inline__links
type CloudTargetInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cloud target inline svm inline links
func (m *CloudTargetInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud target inline svm inline links based on the context it is used
func (m *CloudTargetInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CloudTargetInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CloudTargetInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CloudTargetInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudTargetInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
