// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Cluster Complete cluster information
//
// swagger:model cluster
type Cluster struct {

	// links
	Links *ClusterInlineLinks `json:"_links,omitempty"`

	// active directory
	ActiveDirectory *ClusterInlineActiveDirectory `json:"active_directory,omitempty"`

	// Indicates how new SVMs will default "auto_enable_activity_tracking" for new volumes.
	AutoEnableActivityTracking *bool `json:"auto_enable_activity_tracking,omitempty"`

	// Indicates how new SVMs will default "auto_enable_analytics" for new volumes.
	AutoEnableAnalytics *bool `json:"auto_enable_analytics,omitempty"`

	// certificate
	Certificate *ClusterInlineCertificate `json:"certificate,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	ClusterInlineTags []*string `json:"_tags,omitempty"`

	// A list of DNS domains.
	// Domain names have the following requirements:
	// * The name must contain only the following characters: A through Z,
	//   a through z, 0 through 9, ".", "-" or "_".
	// * The first character of each label, delimited by ".", must be one
	//   of the following characters: A through Z or a through z or 0
	//   through 9.
	// * The last character of each label, delimited by ".", must be one of
	//   the following characters: A through Z, a through z, or 0 through 9.
	// * The top level domain must contain only the following characters: A
	//   through Z, a through z.
	// * The system reserves the following names:"all", "local", and "localhost".
	//
	// Example: ["example.com","example2.example3.com"]
	// Max Items: 6
	ClusterInlineDNSDomains []*string `json:"dns_domains,omitempty"`

	// cluster inline management interfaces
	// Read Only: true
	ClusterInlineManagementInterfaces []*ClusterInlineManagementInterfacesInlineArrayItem `json:"management_interfaces,omitempty"`

	// The list of IP addresses of the DNS servers. Addresses can be either
	// IPv4 or IPv6 addresses.
	//
	// Example: ["10.224.65.20","2001:db08:a0b:12f0::1"]
	// Max Items: 3
	ClusterInlineNameServers []*string `json:"name_servers,omitempty"`

	// cluster inline nodes
	ClusterInlineNodes []*ClusterInlineNodesInlineArrayItem `json:"nodes,omitempty"`

	// Host name, IPv4 address, or IPv6 address for the external NTP time servers.
	// Example: ["time.nist.gov","10.98.19.20","2610:20:6F15:15::27"]
	ClusterInlineNtpServers []*string `json:"ntp_servers,omitempty"`

	// Indicates whether the cluster network overlay is enabled.
	ClusterNetworkOverlayEnabled *bool `json:"cluster_network_overlay_enabled,omitempty"`

	// configuration backup
	ConfigurationBackup *ClusterInlineConfigurationBackup `json:"configuration_backup,omitempty"`

	// contact
	// Example: support@company.com
	Contact *string `json:"contact,omitempty"`

	// Specifies whether the cluster is designed for disaggregated storage.
	// Read Only: true
	Disaggregated *bool `json:"disaggregated,omitempty"`

	// license
	License *ClusterInlineLicense `json:"license,omitempty"`

	// location
	// Example: building 1
	Location *string `json:"location,omitempty"`

	// management interface
	ManagementInterface *ClusterInlineManagementInterface `json:"management_interface,omitempty"`

	// metric
	Metric *ClusterInlineMetric `json:"metric,omitempty"`

	// name
	// Example: cluster1
	Name *string `json:"name,omitempty"`

	// Initial admin password used to create the cluster.
	// Example: mypassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// peering policy
	PeeringPolicy *ClusterInlinePeeringPolicy `json:"peering_policy,omitempty"`

	// Specifies if this cluster is an All SAN Array.
	// Read Only: true
	SanOptimized *bool `json:"san_optimized,omitempty"`

	// statistics
	Statistics *ClusterInlineStatistics `json:"statistics,omitempty"`

	// timezone
	Timezone *ClusterInlineTimezone `json:"timezone,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// version
	Version *ClusterInlineVersion `json:"version,omitempty"`
}

// Validate validates this cluster
func (m *Cluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActiveDirectory(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInlineDNSDomains(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInlineManagementInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInlineNameServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInlineNodes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigurationBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLicense(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePeeringPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimezone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Cluster) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateActiveDirectory(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveDirectory) { // not required
		return nil
	}

	if m.ActiveDirectory != nil {
		if err := m.ActiveDirectory.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("active_directory")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(m.Certificate) { // not required
		return nil
	}

	if m.Certificate != nil {
		if err := m.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateClusterInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInlineTags) { // not required
		return nil
	}

	iClusterInlineTagsSize := int64(len(m.ClusterInlineTags))

	if err := validate.MaxItems("_tags", "body", iClusterInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) validateClusterInlineDNSDomains(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInlineDNSDomains) { // not required
		return nil
	}

	iClusterInlineDNSDomainsSize := int64(len(m.ClusterInlineDNSDomains))

	if err := validate.MaxItems("dns_domains", "body", iClusterInlineDNSDomainsSize, 6); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterInlineDNSDomains); i++ {
		if swag.IsZero(m.ClusterInlineDNSDomains[i]) { // not required
			continue
		}

		if err := validate.MinLength("dns_domains"+"."+strconv.Itoa(i), "body", *m.ClusterInlineDNSDomains[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("dns_domains"+"."+strconv.Itoa(i), "body", *m.ClusterInlineDNSDomains[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (m *Cluster) validateClusterInlineManagementInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInlineManagementInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterInlineManagementInterfaces); i++ {
		if swag.IsZero(m.ClusterInlineManagementInterfaces[i]) { // not required
			continue
		}

		if m.ClusterInlineManagementInterfaces[i] != nil {
			if err := m.ClusterInlineManagementInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Cluster) validateClusterInlineNameServers(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInlineNameServers) { // not required
		return nil
	}

	iClusterInlineNameServersSize := int64(len(m.ClusterInlineNameServers))

	if err := validate.MaxItems("name_servers", "body", iClusterInlineNameServersSize, 3); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) validateClusterInlineNodes(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInlineNodes) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterInlineNodes); i++ {
		if swag.IsZero(m.ClusterInlineNodes[i]) { // not required
			continue
		}

		if m.ClusterInlineNodes[i] != nil {
			if err := m.ClusterInlineNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Cluster) validateConfigurationBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigurationBackup) { // not required
		return nil
	}

	if m.ConfigurationBackup != nil {
		if err := m.ConfigurationBackup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration_backup")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateLicense(formats strfmt.Registry) error {
	if swag.IsZero(m.License) { // not required
		return nil
	}

	if m.License != nil {
		if err := m.License.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateManagementInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterface) { // not required
		return nil
	}

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) validatePeeringPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.PeeringPolicy) { // not required
		return nil
	}

	if m.PeeringPolicy != nil {
		if err := m.PeeringPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peering_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateTimezone(formats strfmt.Registry) error {
	if swag.IsZero(m.Timezone) { // not required
		return nil
	}

	if m.Timezone != nil {
		if err := m.Timezone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("timezone")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster based on the context it is used
func (m *Cluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateActiveDirectory(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInlineManagementInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInlineNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConfigurationBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDisaggregated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLicense(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePeeringPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSanOptimized(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimezone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Cluster) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateActiveDirectory(ctx context.Context, formats strfmt.Registry) error {

	if m.ActiveDirectory != nil {
		if err := m.ActiveDirectory.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("active_directory")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if m.Certificate != nil {
		if err := m.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateClusterInlineManagementInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "management_interfaces", "body", []*ClusterInlineManagementInterfacesInlineArrayItem(m.ClusterInlineManagementInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterInlineManagementInterfaces); i++ {

		if m.ClusterInlineManagementInterfaces[i] != nil {
			if err := m.ClusterInlineManagementInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Cluster) contextValidateClusterInlineNodes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ClusterInlineNodes); i++ {

		if m.ClusterInlineNodes[i] != nil {
			if err := m.ClusterInlineNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Cluster) contextValidateConfigurationBackup(ctx context.Context, formats strfmt.Registry) error {

	if m.ConfigurationBackup != nil {
		if err := m.ConfigurationBackup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("configuration_backup")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateDisaggregated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "disaggregated", "body", m.Disaggregated); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) contextValidateLicense(ctx context.Context, formats strfmt.Registry) error {

	if m.License != nil {
		if err := m.License.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("license")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateManagementInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidatePeeringPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.PeeringPolicy != nil {
		if err := m.PeeringPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("peering_policy")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateSanOptimized(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "san_optimized", "body", m.SanOptimized); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateTimezone(ctx context.Context, formats strfmt.Registry) error {

	if m.Timezone != nil {
		if err := m.Timezone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("timezone")
			}
			return err
		}
	}

	return nil
}

func (m *Cluster) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *Cluster) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Cluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Cluster) UnmarshalBinary(b []byte) error {
	var res Cluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineActiveDirectory cluster inline active directory
//
// swagger:model cluster_inline_active_directory
type ClusterInlineActiveDirectory struct {

	// If set to true and a machine account exists with the same name as specified in "name" in Active Directory, it is overwritten and reused.
	// Example: false
	ForceAccountOverwrite *bool `json:"force_account_overwrite,omitempty"`

	// Fully qualified domain name.
	// Example: server1.com
	// Max Length: 254
	Fqdn *string `json:"fqdn,omitempty"`

	// Active Directory account NetBIOS name.
	// Example: account1
	// Max Length: 15
	Name *string `json:"name,omitempty"`

	// Organizational unit under which the Active Directory account is created.
	// Example: CN=Test
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// Administrator password required for Active Directory account creation, modification, and deletion.
	// Example: testpwd
	// Min Length: 1
	Password *string `json:"password,omitempty"`

	// security
	Security *ActiveDirectorySecurity `json:"security,omitempty"`

	// Administrator username required for Active Directory account creation, modification, and deletion.
	// Example: admin
	// Min Length: 1
	Username *string `json:"username,omitempty"`
}

// Validate validates this cluster inline active directory
func (m *ClusterInlineActiveDirectory) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFqdn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineActiveDirectory) validateFqdn(formats strfmt.Registry) error {
	if swag.IsZero(m.Fqdn) { // not required
		return nil
	}

	if err := validate.MaxLength("active_directory"+"."+"fqdn", "body", *m.Fqdn, 254); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineActiveDirectory) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MaxLength("active_directory"+"."+"name", "body", *m.Name, 15); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineActiveDirectory) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MinLength("active_directory"+"."+"password", "body", *m.Password, 1); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineActiveDirectory) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.Security) { // not required
		return nil
	}

	if m.Security != nil {
		if err := m.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("active_directory" + "." + "security")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineActiveDirectory) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(m.Username) { // not required
		return nil
	}

	if err := validate.MinLength("active_directory"+"."+"username", "body", *m.Username, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline active directory based on the context it is used
func (m *ClusterInlineActiveDirectory) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineActiveDirectory) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if m.Security != nil {
		if err := m.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("active_directory" + "." + "security")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineActiveDirectory) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineActiveDirectory) UnmarshalBinary(b []byte) error {
	var res ClusterInlineActiveDirectory
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineCertificate Support for this field will be removed in a future release. Please use /api/cluster/web for this field. Certificate used by cluster and node management interfaces for TLS connection requests.
//
// swagger:model cluster_inline_certificate
type ClusterInlineCertificate struct {

	// links
	Links *ClusterInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster inline certificate
func (m *ClusterInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline certificate based on the context it is used
func (m *ClusterInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineCertificate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineCertificate) UnmarshalBinary(b []byte) error {
	var res ClusterInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineCertificateInlineLinks cluster inline certificate inline links
//
// swagger:model cluster_inline_certificate_inline__links
type ClusterInlineCertificateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline certificate inline links
func (m *ClusterInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline certificate inline links based on the context it is used
func (m *ClusterInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineConfigurationBackup cluster inline configuration backup
//
// swagger:model cluster_inline_configuration_backup
type ClusterInlineConfigurationBackup struct {

	// password
	// Example: yourpassword
	// Format: password
	Password *strfmt.Password `json:"password,omitempty"`

	// The REST API HTTP method (POST/PUT).
	// Example: post
	// Enum: ["post","put"]
	RestMethod *string `json:"rest_method,omitempty"`

	// An external backup location for the cluster configuration. This is mostly required for single node clusters where node and cluster configuration backups cannot be copied to other nodes in the cluster.
	// Example: http://10.224.65.198/backups
	URL *string `json:"url,omitempty"`

	// username
	// Example: me
	Username *string `json:"username,omitempty"`

	// Use this parameter with the value "true" to validate the digital certificate of the remote server. Digital certificate validation is available only when the HTTPS protocol is used in the URL; it is disabled by default.
	ValidateCertificate *bool `json:"validate_certificate,omitempty"`
}

// Validate validates this cluster inline configuration backup
func (m *ClusterInlineConfigurationBackup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestMethod(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineConfigurationBackup) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.FormatOf("configuration_backup"+"."+"password", "body", "password", m.Password.String(), formats); err != nil {
		return err
	}

	return nil
}

var clusterInlineConfigurationBackupTypeRestMethodPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["post","put"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineConfigurationBackupTypeRestMethodPropEnum = append(clusterInlineConfigurationBackupTypeRestMethodPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_configuration_backup
	// ClusterInlineConfigurationBackup
	// rest_method
	// RestMethod
	// post
	// END DEBUGGING
	// ClusterInlineConfigurationBackupRestMethodPost captures enum value "post"
	ClusterInlineConfigurationBackupRestMethodPost string = "post"

	// BEGIN DEBUGGING
	// cluster_inline_configuration_backup
	// ClusterInlineConfigurationBackup
	// rest_method
	// RestMethod
	// put
	// END DEBUGGING
	// ClusterInlineConfigurationBackupRestMethodPut captures enum value "put"
	ClusterInlineConfigurationBackupRestMethodPut string = "put"
)

// prop value enum
func (m *ClusterInlineConfigurationBackup) validateRestMethodEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineConfigurationBackupTypeRestMethodPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineConfigurationBackup) validateRestMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.RestMethod) { // not required
		return nil
	}

	// value enum
	if err := m.validateRestMethodEnum("configuration_backup"+"."+"rest_method", "body", *m.RestMethod); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster inline configuration backup based on context it is used
func (m *ClusterInlineConfigurationBackup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineConfigurationBackup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineConfigurationBackup) UnmarshalBinary(b []byte) error {
	var res ClusterInlineConfigurationBackup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineLicense License keys or NLF contents.
//
// swagger:model cluster_inline_license
type ClusterInlineLicense struct {

	// keys
	Keys []*string `json:"keys,omitempty"`
}

// Validate validates this cluster inline license
func (m *ClusterInlineLicense) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cluster inline license based on context it is used
func (m *ClusterInlineLicense) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineLicense) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineLicense) UnmarshalBinary(b []byte) error {
	var res ClusterInlineLicense
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineLinks cluster inline links
//
// swagger:model cluster_inline__links
type ClusterInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline links
func (m *ClusterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline links based on the context it is used
func (m *ClusterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineManagementInterface The management interface of the cluster. The subnet mask and gateway for this interface are used for the node management interfaces provided in the node configuration.
//
// swagger:model cluster_inline_management_interface
type ClusterInlineManagementInterface struct {

	// ip
	IP *ClusterInlineManagementInterfaceInlineIP `json:"ip,omitempty"`
}

// Validate validates this cluster inline management interface
func (m *ClusterInlineManagementInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline management interface based on the context it is used
func (m *ClusterInlineManagementInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineManagementInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineManagementInterface) UnmarshalBinary(b []byte) error {
	var res ClusterInlineManagementInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineManagementInterfaceInlineIP Object to setup an interface along with its default router.
//
// swagger:model cluster_inline_management_interface_inline_ip
type ClusterInlineManagementInterfaceInlineIP struct {

	// IPv4 or IPv6 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// netmask
	Netmask *IPNetmask `json:"netmask,omitempty"`
}

// Validate validates this cluster inline management interface inline ip
func (m *ClusterInlineManagementInterfaceInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNetmask(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfaceInlineIP) validateNetmask(formats strfmt.Registry) error {
	if swag.IsZero(m.Netmask) { // not required
		return nil
	}

	if m.Netmask != nil {
		if err := m.Netmask.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline management interface inline ip based on the context it is used
func (m *ClusterInlineManagementInterfaceInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNetmask(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfaceInlineIP) contextValidateNetmask(ctx context.Context, formats strfmt.Registry) error {

	if m.Netmask != nil {
		if err := m.Netmask.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip" + "." + "netmask")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineManagementInterfaceInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineManagementInterfaceInlineIP) UnmarshalBinary(b []byte) error {
	var res ClusterInlineManagementInterfaceInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineManagementInterfacesInlineArrayItem A network interface. Either UUID or name may be supplied on input.
//
// swagger:model cluster_inline_management_interfaces_inline_array_item
type ClusterInlineManagementInterfacesInlineArrayItem struct {

	// links
	Links *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// ip
	IP *ClusterInlineManagementInterfacesInlineArrayItemInlineIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster inline management interfaces inline array item
func (m *ClusterInlineManagementInterfacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItem) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline management interfaces inline array item based on the context it is used
func (m *ClusterInlineManagementInterfacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItem) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ClusterInlineManagementInterfacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineManagementInterfacesInlineArrayItemInlineIP IP information
//
// swagger:model cluster_inline_management_interfaces_inline_array_item_inline_ip
type ClusterInlineManagementInterfacesInlineArrayItemInlineIP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this cluster inline management interfaces inline array item inline ip
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline management interfaces inline array item inline ip based on the context it is used
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineIP) UnmarshalBinary(b []byte) error {
	var res ClusterInlineManagementInterfacesInlineArrayItemInlineIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineManagementInterfacesInlineArrayItemInlineLinks cluster inline management interfaces inline array item inline links
//
// swagger:model cluster_inline_management_interfaces_inline_array_item_inline__links
type ClusterInlineManagementInterfacesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline management interfaces inline array item inline links
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline management interfaces inline array item inline links based on the context it is used
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineManagementInterfacesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineManagementInterfacesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineMetric Performance numbers, such as IOPS latency and throughput.
//
// swagger:model cluster_inline_metric
type ClusterInlineMetric struct {

	// links
	Links *ClusterInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *ClusterInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *ClusterInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *ClusterInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cluster inline metric
func (m *ClusterInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var clusterInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineMetricTypeDurationPropEnum = append(clusterInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ClusterInlineMetricDurationPT15S captures enum value "PT15S"
	ClusterInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ClusterInlineMetricDurationPT4M captures enum value "PT4M"
	ClusterInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ClusterInlineMetricDurationPT30M captures enum value "PT30M"
	ClusterInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ClusterInlineMetricDurationPT2H captures enum value "PT2H"
	ClusterInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ClusterInlineMetricDurationP1D captures enum value "P1D"
	ClusterInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ClusterInlineMetricDurationPT5M captures enum value "PT5M"
	ClusterInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ClusterInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var clusterInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineMetricTypeStatusPropEnum = append(clusterInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterInlineMetricStatusOk captures enum value "ok"
	ClusterInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterInlineMetricStatusError captures enum value "error"
	ClusterInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	ClusterInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	ClusterInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	ClusterInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// ClusterInlineMetricStatusNotFound captures enum value "not_found"
	ClusterInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	ClusterInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cluster_inline_metric
	// ClusterInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *ClusterInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline metric based on the context it is used
func (m *ClusterInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineMetric) UnmarshalBinary(b []byte) error {
	var res ClusterInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model cluster_inline_metric_inline_iops
type ClusterInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline metric inline iops
func (m *ClusterInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline metric inline iops based on the context it is used
func (m *ClusterInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res ClusterInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model cluster_inline_metric_inline_latency
type ClusterInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline metric inline latency
func (m *ClusterInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline metric inline latency based on the context it is used
func (m *ClusterInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res ClusterInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineMetricInlineLinks cluster inline metric inline links
//
// swagger:model cluster_inline_metric_inline__links
type ClusterInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline metric inline links
func (m *ClusterInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline metric inline links based on the context it is used
func (m *ClusterInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model cluster_inline_metric_inline_throughput
type ClusterInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline metric inline throughput
func (m *ClusterInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline metric inline throughput based on the context it is used
func (m *ClusterInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res ClusterInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItem Complete node information
//
// swagger:model cluster_inline_nodes_inline_array_item
type ClusterInlineNodesInlineArrayItem struct {

	// links
	Links *ClusterInlineNodesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Anti ransomware version.
	// Example: 1.0
	// Read Only: true
	AntiRansomwareVersion *string `json:"anti_ransomware_version,omitempty"`

	// cluster interface
	ClusterInterface *ClusterInlineNodesInlineArrayItemInlineClusterInterface `json:"cluster_interface,omitempty"`

	// cluster interfaces
	// Read Only: true
	ClusterInterfaces []*ClusterNodesItems0ClusterInterfacesItems0 `json:"cluster_interfaces"`

	// controller
	Controller *ClusterInlineNodesInlineArrayItemInlineController `json:"controller,omitempty"`

	// The current or "wall clock" time of the node in ISO-8601 date, time, and time zone format.
	// The ISO-8601 date and time are localized based on the ONTAP cluster's timezone setting.
	//
	// Example: 2019-04-17 11:49:26-04:00
	// Read Only: true
	// Format: date-time
	Date *strfmt.DateTime `json:"date,omitempty"`

	// external cache
	ExternalCache *ClusterInlineNodesInlineArrayItemInlineExternalCache `json:"external_cache,omitempty"`

	// external cache bypass
	ExternalCacheBypass *ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass `json:"external_cache_bypass,omitempty"`

	// ha
	Ha *ClusterInlineNodesInlineArrayItemInlineHa `json:"ha,omitempty"`

	// hw assist
	HwAssist *ClusterInlineNodesInlineArrayItemInlineHwAssist `json:"hw_assist,omitempty"`

	// Specifies whether or not the node is in spares low condition.
	// Read Only: true
	IsSparesLow *bool `json:"is_spares_low,omitempty"`

	// location
	// Example: rack 2 row 5
	Location *string `json:"location,omitempty"`

	// management interface
	ManagementInterface *ClusterInlineNodesInlineArrayItemInlineManagementInterface `json:"management_interface,omitempty"`

	// management interfaces
	// Read Only: true
	ManagementInterfaces []*ClusterNodesItems0ManagementInterfacesItems0 `json:"management_interfaces"`

	// Possible values:
	// * <i>available</i> - A node is detected on the internal cluster network and can be added to the cluster.  Nodes that have a membership of "available" are not returned when a GET request is called when the cluster exists. Provide a query on the "membership" property for <i>available</i> to scan for nodes on the cluster network. Nodes that have a membership of "available" are returned automatically before a cluster is created.
	// * <i>joining</i> - Joining nodes are in the process of being added to the cluster. The node might be progressing through the steps to become a member or might have failed. The job to add the node or create the cluster provides details on the current progress of the node.
	// * <i>member</i> - Nodes that are members have successfully joined the cluster.
	//
	// Read Only: true
	// Enum: ["available","joining","member"]
	Membership *string `json:"membership,omitempty"`

	// metric
	Metric *ClusterInlineNodesInlineArrayItemInlineMetric `json:"metric,omitempty"`

	// metrocluster
	Metrocluster *ClusterInlineNodesInlineArrayItemInlineMetrocluster `json:"metrocluster,omitempty"`

	// model
	// Example: FAS3070
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// name
	// Example: node-01
	Name *string `json:"name,omitempty"`

	// nvlog
	Nvlog *ClusterInlineNodesInlineArrayItemInlineNvlog `json:"nvlog,omitempty"`

	// nvram
	Nvram *ClusterInlineNodesInlineArrayItemInlineNvram `json:"nvram,omitempty"`

	// Owner of the node.
	// Example: Example Corp
	Owner *string `json:"owner,omitempty"`

	// serial number
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// service processor
	ServiceProcessor *ClusterInlineNodesInlineArrayItemInlineServiceProcessor `json:"service_processor,omitempty"`

	// snaplock
	Snaplock *ClusterInlineNodesInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// State of the node:
	// * <i>up</i> - Node is up and operational.
	// * <i>booting</i> - Node is booting up.
	// * <i>down</i> - Node has stopped or is dumping core.
	// * <i>taken_over</i> - Node has been taken over by its HA partner and is not yet waiting for giveback.
	// * <i>waiting_for_giveback</i> - Node has been taken over by its HA partner and is waiting for the HA partner to giveback disks.
	// * <i>degraded</i> - Node has one or more critical services offline.
	// * <i>unknown</i> - Node or its HA partner cannot be contacted and there is no information on the node's state.
	//
	// Read Only: true
	// Enum: ["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *ClusterInlineNodesInlineArrayItemInlineStatistics `json:"statistics,omitempty"`

	// Storage availability zones associated with the node.
	// Read Only: true
	StorageAvailabilityZones []*StorageAvailabilityZoneReference `json:"storage_availability_zones"`

	// The storage configuration in the system. Possible values:
	// * <i>mixed_path</i>
	// * <i>single_path</i>
	// * <i>multi_path</i>
	// * <i>tri_path</i>
	// * <i>quad_path</i>
	// * <i>mixed_path_ha</i>
	// * <i>single_path_ha</i>
	// * <i>multi_path_ha</i>
	// * <i>tri_path_ha</i>
	// * <i>quad_path_ha</i>
	// * <i>unknown</i>
	// * <i>virtual</i>
	//
	// Read Only: true
	// Enum: ["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]
	StorageConfiguration *string `json:"storage_configuration,omitempty"`

	// system aggregate
	SystemAggregate *ClusterInlineNodesInlineArrayItemInlineSystemAggregate `json:"system_aggregate,omitempty"`

	// system id
	// Example: 92027651
	// Read Only: true
	SystemID *string `json:"system_id,omitempty"`

	// OEM system machine type.
	// Example: 7Y56-CTOWW1
	// Read Only: true
	SystemMachineType *string `json:"system_machine_type,omitempty"`

	// The total time, in seconds, that the node has been up.
	// Example: 300536
	// Read Only: true
	Uptime *int64 `json:"uptime,omitempty"`

	// uuid
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// OEM vendor serial number.
	// Example: 791603000068
	// Read Only: true
	VendorSerialNumber *string `json:"vendor_serial_number,omitempty"`

	// version
	Version *ClusterInlineNodesInlineArrayItemInlineVersion `json:"version,omitempty"`

	// vm
	VM *ClusterInlineNodesInlineArrayItemInlineVM `json:"vm,omitempty"`
}

// Validate validates this cluster inline nodes inline array item
func (m *ClusterInlineNodesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateController(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExternalCacheBypass(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHa(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHwAssist(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateManagementInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMembership(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetrocluster(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvlog(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNvram(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateServiceProcessor(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageAvailabilityZones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageConfiguration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystemAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVM(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateClusterInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInterface) { // not required
		return nil
	}

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateClusterInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterInterfaces); i++ {
		if swag.IsZero(m.ClusterInterfaces[i]) { // not required
			continue
		}

		if m.ClusterInterfaces[i] != nil {
			if err := m.ClusterInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateController(formats strfmt.Registry) error {
	if swag.IsZero(m.Controller) { // not required
		return nil
	}

	if m.Controller != nil {
		if err := m.Controller.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateDate(formats strfmt.Registry) error {
	if swag.IsZero(m.Date) { // not required
		return nil
	}

	if err := validate.FormatOf("date", "body", "date-time", m.Date.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateExternalCache(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCache) { // not required
		return nil
	}

	if m.ExternalCache != nil {
		if err := m.ExternalCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateExternalCacheBypass(formats strfmt.Registry) error {
	if swag.IsZero(m.ExternalCacheBypass) { // not required
		return nil
	}

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateHa(formats strfmt.Registry) error {
	if swag.IsZero(m.Ha) { // not required
		return nil
	}

	if m.Ha != nil {
		if err := m.Ha.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateHwAssist(formats strfmt.Registry) error {
	if swag.IsZero(m.HwAssist) { // not required
		return nil
	}

	if m.HwAssist != nil {
		if err := m.HwAssist.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateManagementInterface(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterface) { // not required
		return nil
	}

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateManagementInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ManagementInterfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.ManagementInterfaces); i++ {
		if swag.IsZero(m.ManagementInterfaces[i]) { // not required
			continue
		}

		if m.ManagementInterfaces[i] != nil {
			if err := m.ManagementInterfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var clusterInlineNodesInlineArrayItemTypeMembershipPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","joining","member"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemTypeMembershipPropEnum = append(clusterInlineNodesInlineArrayItemTypeMembershipPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// membership
	// Membership
	// available
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemMembershipAvailable captures enum value "available"
	ClusterInlineNodesInlineArrayItemMembershipAvailable string = "available"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// membership
	// Membership
	// joining
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemMembershipJoining captures enum value "joining"
	ClusterInlineNodesInlineArrayItemMembershipJoining string = "joining"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// membership
	// Membership
	// member
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemMembershipMember captures enum value "member"
	ClusterInlineNodesInlineArrayItemMembershipMember string = "member"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItem) validateMembershipEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemTypeMembershipPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateMembership(formats strfmt.Registry) error {
	if swag.IsZero(m.Membership) { // not required
		return nil
	}

	// value enum
	if err := m.validateMembershipEnum("membership", "body", *m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateMetrocluster(formats strfmt.Registry) error {
	if swag.IsZero(m.Metrocluster) { // not required
		return nil
	}

	if m.Metrocluster != nil {
		if err := m.Metrocluster.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateNvlog(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvlog) { // not required
		return nil
	}

	if m.Nvlog != nil {
		if err := m.Nvlog.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateNvram(formats strfmt.Registry) error {
	if swag.IsZero(m.Nvram) { // not required
		return nil
	}

	if m.Nvram != nil {
		if err := m.Nvram.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateServiceProcessor(formats strfmt.Registry) error {
	if swag.IsZero(m.ServiceProcessor) { // not required
		return nil
	}

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","booting","down","taken_over","waiting_for_giveback","degraded","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// up
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateUp captures enum value "up"
	ClusterInlineNodesInlineArrayItemStateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// booting
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateBooting captures enum value "booting"
	ClusterInlineNodesInlineArrayItemStateBooting string = "booting"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateDown captures enum value "down"
	ClusterInlineNodesInlineArrayItemStateDown string = "down"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// taken_over
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateTakenOver captures enum value "taken_over"
	ClusterInlineNodesInlineArrayItemStateTakenOver string = "taken_over"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// waiting_for_giveback
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateWaitingForGiveback captures enum value "waiting_for_giveback"
	ClusterInlineNodesInlineArrayItemStateWaitingForGiveback string = "waiting_for_giveback"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// degraded
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateDegraded captures enum value "degraded"
	ClusterInlineNodesInlineArrayItemStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// state
	// State
	// unknown
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStateUnknown captures enum value "unknown"
	ClusterInlineNodesInlineArrayItemStateUnknown string = "unknown"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateStorageAvailabilityZones(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageAvailabilityZones) { // not required
		return nil
	}

	for i := 0; i < len(m.StorageAvailabilityZones); i++ {
		if swag.IsZero(m.StorageAvailabilityZones[i]) { // not required
			continue
		}

		if m.StorageAvailabilityZones[i] != nil {
			if err := m.StorageAvailabilityZones[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var clusterInlineNodesInlineArrayItemTypeStorageConfigurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unknown","single_path","multi_path","mixed_path","quad_path","single_path_ha","multi_path_ha","mixed_path_ha","quad_path_ha","tri_path","tri_path_ha","virtual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemTypeStorageConfigurationPropEnum = append(clusterInlineNodesInlineArrayItemTypeStorageConfigurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// unknown
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationUnknown captures enum value "unknown"
	ClusterInlineNodesInlineArrayItemStorageConfigurationUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// single_path
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationSinglePath captures enum value "single_path"
	ClusterInlineNodesInlineArrayItemStorageConfigurationSinglePath string = "single_path"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// multi_path
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationMultiPath captures enum value "multi_path"
	ClusterInlineNodesInlineArrayItemStorageConfigurationMultiPath string = "multi_path"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// mixed_path
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationMixedPath captures enum value "mixed_path"
	ClusterInlineNodesInlineArrayItemStorageConfigurationMixedPath string = "mixed_path"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// quad_path
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationQuadPath captures enum value "quad_path"
	ClusterInlineNodesInlineArrayItemStorageConfigurationQuadPath string = "quad_path"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// single_path_ha
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationSinglePathHa captures enum value "single_path_ha"
	ClusterInlineNodesInlineArrayItemStorageConfigurationSinglePathHa string = "single_path_ha"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// multi_path_ha
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationMultiPathHa captures enum value "multi_path_ha"
	ClusterInlineNodesInlineArrayItemStorageConfigurationMultiPathHa string = "multi_path_ha"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// mixed_path_ha
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationMixedPathHa captures enum value "mixed_path_ha"
	ClusterInlineNodesInlineArrayItemStorageConfigurationMixedPathHa string = "mixed_path_ha"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// quad_path_ha
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationQuadPathHa captures enum value "quad_path_ha"
	ClusterInlineNodesInlineArrayItemStorageConfigurationQuadPathHa string = "quad_path_ha"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// tri_path
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationTriPath captures enum value "tri_path"
	ClusterInlineNodesInlineArrayItemStorageConfigurationTriPath string = "tri_path"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// tri_path_ha
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationTriPathHa captures enum value "tri_path_ha"
	ClusterInlineNodesInlineArrayItemStorageConfigurationTriPathHa string = "tri_path_ha"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item
	// ClusterInlineNodesInlineArrayItem
	// storage_configuration
	// StorageConfiguration
	// virtual
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemStorageConfigurationVirtual captures enum value "virtual"
	ClusterInlineNodesInlineArrayItemStorageConfigurationVirtual string = "virtual"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItem) validateStorageConfigurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemTypeStorageConfigurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateStorageConfiguration(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageConfiguration) { // not required
		return nil
	}

	// value enum
	if err := m.validateStorageConfigurationEnum("storage_configuration", "body", *m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateSystemAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.SystemAggregate) { // not required
		return nil
	}

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) validateVM(formats strfmt.Registry) error {
	if swag.IsZero(m.VM) { // not required
		return nil
	}

	if m.VM != nil {
		if err := m.VM.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item based on the context it is used
func (m *ClusterInlineNodesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAntiRansomwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateController(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExternalCacheBypass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHa(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHwAssist(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSparesLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateManagementInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMembership(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetrocluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvlog(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNvram(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateServiceProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageAvailabilityZones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageConfiguration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystemMachineType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUptime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVendorSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVM(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateAntiRansomwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anti_ransomware_version", "body", m.AntiRansomwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateClusterInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ClusterInterface != nil {
		if err := m.ClusterInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateClusterInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "cluster_interfaces", "body", []*ClusterNodesItems0ClusterInterfacesItems0(m.ClusterInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterInterfaces); i++ {

		if m.ClusterInterfaces[i] != nil {
			if err := m.ClusterInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("cluster_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateController(ctx context.Context, formats strfmt.Registry) error {

	if m.Controller != nil {
		if err := m.Controller.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateDate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "date", "body", m.Date); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateExternalCache(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCache != nil {
		if err := m.ExternalCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateExternalCacheBypass(ctx context.Context, formats strfmt.Registry) error {

	if m.ExternalCacheBypass != nil {
		if err := m.ExternalCacheBypass.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("external_cache_bypass")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateHa(ctx context.Context, formats strfmt.Registry) error {

	if m.Ha != nil {
		if err := m.Ha.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateHwAssist(ctx context.Context, formats strfmt.Registry) error {

	if m.HwAssist != nil {
		if err := m.HwAssist.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateIsSparesLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_spares_low", "body", m.IsSparesLow); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateManagementInterface(ctx context.Context, formats strfmt.Registry) error {

	if m.ManagementInterface != nil {
		if err := m.ManagementInterface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateManagementInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "management_interfaces", "body", []*ClusterNodesItems0ManagementInterfacesItems0(m.ManagementInterfaces)); err != nil {
		return err
	}

	for i := 0; i < len(m.ManagementInterfaces); i++ {

		if m.ManagementInterfaces[i] != nil {
			if err := m.ManagementInterfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("management_interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateMembership(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "membership", "body", m.Membership); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateMetrocluster(ctx context.Context, formats strfmt.Registry) error {

	if m.Metrocluster != nil {
		if err := m.Metrocluster.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metrocluster")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateNvlog(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvlog != nil {
		if err := m.Nvlog.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvlog")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateNvram(ctx context.Context, formats strfmt.Registry) error {

	if m.Nvram != nil {
		if err := m.Nvram.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nvram")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateServiceProcessor(ctx context.Context, formats strfmt.Registry) error {

	if m.ServiceProcessor != nil {
		if err := m.ServiceProcessor.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateStorageAvailabilityZones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_availability_zones", "body", []*StorageAvailabilityZoneReference(m.StorageAvailabilityZones)); err != nil {
		return err
	}

	for i := 0; i < len(m.StorageAvailabilityZones); i++ {

		if m.StorageAvailabilityZones[i] != nil {
			if err := m.StorageAvailabilityZones[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("storage_availability_zones" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateStorageConfiguration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_configuration", "body", m.StorageConfiguration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateSystemAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.SystemAggregate != nil {
		if err := m.SystemAggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateSystemID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_id", "body", m.SystemID); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateSystemMachineType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "system_machine_type", "body", m.SystemMachineType); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateUptime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uptime", "body", m.Uptime); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateVendorSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vendor_serial_number", "body", m.VendorSerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItem) contextValidateVM(ctx context.Context, formats strfmt.Registry) error {

	if m.VM != nil {
		if err := m.VM.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("vm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineClusterInterface The cluster network IP address of the node to be added.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_cluster_interface
type ClusterInlineNodesInlineArrayItemInlineClusterInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline cluster interface
func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline cluster interface based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cluster_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineClusterInterface) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineClusterInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ClusterInterfacesItems0 Network interface
//
// swagger:model ClusterNodesItems0ClusterInterfacesItems0
type ClusterNodesItems0ClusterInterfacesItems0 struct {

	// links
	Links *ClusterNodesItems0ClusterInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *ClusterNodesItems0ClusterInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster nodes items0 cluster interfaces items0
func (m *ClusterNodesItems0ClusterInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 cluster interfaces items0 based on the context it is used
func (m *ClusterNodesItems0ClusterInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ClusterInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ClusterInterfacesItems0IP IP information
//
// swagger:model ClusterNodesItems0ClusterInterfacesItems0IP
type ClusterNodesItems0ClusterInterfacesItems0IP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this cluster nodes items0 cluster interfaces items0 IP
func (m *ClusterNodesItems0ClusterInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 cluster interfaces items0 IP based on the context it is used
func (m *ClusterNodesItems0ClusterInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ClusterInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ClusterInterfacesItems0Links cluster nodes items0 cluster interfaces items0 links
//
// swagger:model ClusterNodesItems0ClusterInterfacesItems0Links
type ClusterNodesItems0ClusterInterfacesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster nodes items0 cluster interfaces items0 links
func (m *ClusterNodesItems0ClusterInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 cluster interfaces items0 links based on the context it is used
func (m *ClusterNodesItems0ClusterInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ClusterInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ClusterInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ClusterInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineController Controller information
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller
type ClusterInlineNodesInlineArrayItemInlineController struct {

	// Type of the system board. This is defined by vendor.
	// Example: System Board XXVIII
	// Read Only: true
	Board *string `json:"board,omitempty"`

	// cpu
	CPU *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU `json:"cpu,omitempty"`

	// failed fan
	FailedFan *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan `json:"failed_fan,omitempty"`

	// failed power supply
	FailedPowerSupply *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply `json:"failed_power_supply,omitempty"`

	// A list of Flash-Cache devices. Only returned when requested by name.
	// Read Only: true
	FlashCache []*ClusterNodesItems0ControllerFlashCacheItems0 `json:"flash_cache"`

	// List of FRUs on the node. Only returned when requested by name.
	Frus []*ClusterNodesItems0ControllerFrusItems0 `json:"frus"`

	// Memory available on the node, in bytes.
	// Example: 1024000000
	// Read Only: true
	MemorySize *int64 `json:"memory_size,omitempty"`

	// Specifies whether the hardware is currently operating outside of its recommended temperature range. The hardware shuts down if the temperature exceeds critical thresholds.
	// Read Only: true
	// Enum: ["over","normal"]
	OverTemperature *string `json:"over_temperature,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller
func (m *ClusterInlineNodesInlineArrayItemInlineController) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPU(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedFan(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFailedPowerSupply(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlashCache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFrus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOverTemperature(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateCPU(formats strfmt.Registry) error {
	if swag.IsZero(m.CPU) { // not required
		return nil
	}

	if m.CPU != nil {
		if err := m.CPU.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateFailedFan(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedFan) { // not required
		return nil
	}

	if m.FailedFan != nil {
		if err := m.FailedFan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateFailedPowerSupply(formats strfmt.Registry) error {
	if swag.IsZero(m.FailedPowerSupply) { // not required
		return nil
	}

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateFlashCache(formats strfmt.Registry) error {
	if swag.IsZero(m.FlashCache) { // not required
		return nil
	}

	for i := 0; i < len(m.FlashCache); i++ {
		if swag.IsZero(m.FlashCache[i]) { // not required
			continue
		}

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateFrus(formats strfmt.Registry) error {
	if swag.IsZero(m.Frus) { // not required
		return nil
	}

	for i := 0; i < len(m.Frus); i++ {
		if swag.IsZero(m.Frus[i]) { // not required
			continue
		}

		if m.Frus[i] != nil {
			if err := m.Frus[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineControllerTypeOverTemperaturePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["over","normal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineControllerTypeOverTemperaturePropEnum = append(clusterInlineNodesInlineArrayItemInlineControllerTypeOverTemperaturePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_controller
	// ClusterInlineNodesInlineArrayItemInlineController
	// over_temperature
	// OverTemperature
	// over
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineControllerOverTemperatureOver captures enum value "over"
	ClusterInlineNodesInlineArrayItemInlineControllerOverTemperatureOver string = "over"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_controller
	// ClusterInlineNodesInlineArrayItemInlineController
	// over_temperature
	// OverTemperature
	// normal
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineControllerOverTemperatureNormal captures enum value "normal"
	ClusterInlineNodesInlineArrayItemInlineControllerOverTemperatureNormal string = "normal"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineController) validateOverTemperatureEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineControllerTypeOverTemperaturePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) validateOverTemperature(formats strfmt.Registry) error {
	if swag.IsZero(m.OverTemperature) { // not required
		return nil
	}

	// value enum
	if err := m.validateOverTemperatureEnum("controller"+"."+"over_temperature", "body", *m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineController) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBoard(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCPU(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedFan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFailedPowerSupply(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlashCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFrus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMemorySize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOverTemperature(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateBoard(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"board", "body", m.Board); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateCPU(ctx context.Context, formats strfmt.Registry) error {

	if m.CPU != nil {
		if err := m.CPU.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "cpu")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateFailedFan(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedFan != nil {
		if err := m.FailedFan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateFailedPowerSupply(ctx context.Context, formats strfmt.Registry) error {

	if m.FailedPowerSupply != nil {
		if err := m.FailedPowerSupply.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateFlashCache(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"flash_cache", "body", []*ClusterNodesItems0ControllerFlashCacheItems0(m.FlashCache)); err != nil {
		return err
	}

	for i := 0; i < len(m.FlashCache); i++ {

		if m.FlashCache[i] != nil {
			if err := m.FlashCache[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "flash_cache" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateFrus(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Frus); i++ {

		if m.Frus[i] != nil {
			if err := m.Frus[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("controller" + "." + "frus" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateMemorySize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"memory_size", "body", m.MemorySize); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineController) contextValidateOverTemperature(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"over_temperature", "body", m.OverTemperature); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineController) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineController) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineController
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU CPU information.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller_inline_cpu
type ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU struct {

	// Number of CPUs on the node.
	// Example: 20
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// Firmware release number. Defined by the CPU manufacturer.
	// Read Only: true
	FirmwareRelease *string `json:"firmware_release,omitempty"`

	// CPU type on the node.
	// Read Only: true
	Processor *string `json:"processor,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller inline cpu
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller inline cpu based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProcessor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) contextValidateFirmwareRelease(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"firmware_release", "body", m.FirmwareRelease); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) contextValidateProcessor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"cpu"+"."+"processor", "body", m.Processor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineControllerInlineCPU
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan cluster inline nodes inline array item inline controller inline failed fan
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller_inline_failed_fan
type ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan struct {

	// Specifies a count of the number of chassis fans that are not operating within the recommended RPM range.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller inline failed fan
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller inline failed fan based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_fan" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFan
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage cluster inline nodes inline array item inline controller inline failed fan inline message
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller_inline_failed_fan_inline_message
type ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage struct {

	// Error code describing the current condition of chassis fans.
	// Example: 111411207
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the current condition of chassis fans. It is only of use when `failed_fan.count` is not zero.
	// Example: There are no failed fans.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller inline failed fan inline message
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller inline failed fan inline message based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_fan"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedFanInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply cluster inline nodes inline array item inline controller inline failed power supply
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller_inline_failed_power_supply
type ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply struct {

	// Number of failed power supply units.
	// Example: 1
	// Read Only: true
	Count *int64 `json:"count,omitempty"`

	// message
	Message *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller inline failed power supply
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	if m.Message != nil {
		if err := m.Message.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller inline failed power supply based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) contextValidateCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"count", "body", m.Count); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if m.Message != nil {
		if err := m.Message.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("controller" + "." + "failed_power_supply" + "." + "message")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupply
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage cluster inline nodes inline array item inline controller inline failed power supply inline message
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_controller_inline_failed_power_supply_inline_message
type ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage struct {

	// Error code describing the current condition of power supply.
	// Example: 111411208
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Message describing the state of any power supplies that are currently degraded. It is only of use when `failed_power_supply.count` is not zero.
	// Example: There are no failed power supplies.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline controller inline failed power supply inline message
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline controller inline failed power supply inline message based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "controller"+"."+"failed_power_supply"+"."+"message"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineControllerInlineFailedPowerSupplyInlineMessage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ControllerFlashCacheItems0 cluster nodes items0 controller flash cache items0
//
// swagger:model ClusterNodesItems0ControllerFlashCacheItems0
type ClusterNodesItems0ControllerFlashCacheItems0 struct {

	// Size in bytes
	// Example: 1024000000000
	// Read Only: true
	Capacity *int64 `json:"capacity,omitempty"`

	// device id
	// Example: 0
	// Read Only: true
	DeviceID *int64 `json:"device_id,omitempty"`

	// firmware file
	// Example: X9170_O000Z6300NVM
	// Read Only: true
	FirmwareFile *string `json:"firmware_file,omitempty"`

	// firmware version
	// Example: NA05
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// hardware revision
	// Example: A1
	// Read Only: true
	HardwareRevision *string `json:"hardware_revision,omitempty"`

	// model
	// Example: X1970A
	// Read Only: true
	Model *string `json:"model,omitempty"`

	// part number
	// Example: 119-00207
	// Read Only: true
	PartNumber *string `json:"part_number,omitempty"`

	// serial number
	// Example: A22P5061550000187
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`

	// slot
	// Example: 6-1
	// Read Only: true
	Slot *string `json:"slot,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","erasing","erased","failed","removed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster nodes items0 controller flash cache items0
func (m *ClusterNodesItems0ControllerFlashCacheItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterNodesItems0ControllerFlashCacheItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","erasing","erased","failed","removed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0ControllerFlashCacheItems0TypeStatePropEnum = append(clusterNodesItems0ControllerFlashCacheItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0
	// ClusterNodesItems0ControllerFlashCacheItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0StateOk captures enum value "ok"
	ClusterNodesItems0ControllerFlashCacheItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0
	// ClusterNodesItems0ControllerFlashCacheItems0
	// state
	// State
	// erasing
	// END DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0StateErasing captures enum value "erasing"
	ClusterNodesItems0ControllerFlashCacheItems0StateErasing string = "erasing"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0
	// ClusterNodesItems0ControllerFlashCacheItems0
	// state
	// State
	// erased
	// END DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0StateErased captures enum value "erased"
	ClusterNodesItems0ControllerFlashCacheItems0StateErased string = "erased"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0
	// ClusterNodesItems0ControllerFlashCacheItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0StateFailed captures enum value "failed"
	ClusterNodesItems0ControllerFlashCacheItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0
	// ClusterNodesItems0ControllerFlashCacheItems0
	// state
	// State
	// removed
	// END DEBUGGING
	// ClusterNodesItems0ControllerFlashCacheItems0StateRemoved captures enum value "removed"
	ClusterNodesItems0ControllerFlashCacheItems0StateRemoved string = "removed"
)

// prop value enum
func (m *ClusterNodesItems0ControllerFlashCacheItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0ControllerFlashCacheItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 controller flash cache items0 based on the context it is used
func (m *ClusterNodesItems0ControllerFlashCacheItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapacity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeviceID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHardwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSlot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateCapacity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "capacity", "body", m.Capacity); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateDeviceID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "device_id", "body", m.DeviceID); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateFirmwareFile(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_file", "body", m.FirmwareFile); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateHardwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "hardware_revision", "body", m.HardwareRevision); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateModel(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "model", "body", m.Model); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidatePartNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "part_number", "body", m.PartNumber); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateSlot(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "slot", "body", m.Slot); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFlashCacheItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ControllerFlashCacheItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ControllerFlashCacheItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ControllerFlashCacheItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ControllerFrusItems0 cluster nodes items0 controller frus items0
//
// swagger:model ClusterNodesItems0ControllerFrusItems0
type ClusterNodesItems0ControllerFrusItems0 struct {

	// id
	// Read Only: true
	ID *string `json:"id,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","error"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["fan","psu","pcie","disk","nvs","dimm","controller"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this cluster nodes items0 controller frus items0
func (m *ClusterNodesItems0ControllerFrusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterNodesItems0ControllerFrusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0ControllerFrusItems0TypeStatePropEnum = append(clusterNodesItems0ControllerFrusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// state
	// State
	// ok
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0StateOk captures enum value "ok"
	ClusterNodesItems0ControllerFrusItems0StateOk string = "ok"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// state
	// State
	// error
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0StateError captures enum value "error"
	ClusterNodesItems0ControllerFrusItems0StateError string = "error"
)

// prop value enum
func (m *ClusterNodesItems0ControllerFrusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0ControllerFrusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0ControllerFrusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var clusterNodesItems0ControllerFrusItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fan","psu","pcie","disk","nvs","dimm","controller"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0ControllerFrusItems0TypeTypePropEnum = append(clusterNodesItems0ControllerFrusItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// fan
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypeFan captures enum value "fan"
	ClusterNodesItems0ControllerFrusItems0TypeFan string = "fan"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// psu
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypePsu captures enum value "psu"
	ClusterNodesItems0ControllerFrusItems0TypePsu string = "psu"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// pcie
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypePcie captures enum value "pcie"
	ClusterNodesItems0ControllerFrusItems0TypePcie string = "pcie"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// disk
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypeDisk captures enum value "disk"
	ClusterNodesItems0ControllerFrusItems0TypeDisk string = "disk"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// nvs
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypeNvs captures enum value "nvs"
	ClusterNodesItems0ControllerFrusItems0TypeNvs string = "nvs"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// dimm
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypeDimm captures enum value "dimm"
	ClusterNodesItems0ControllerFrusItems0TypeDimm string = "dimm"

	// BEGIN DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0
	// ClusterNodesItems0ControllerFrusItems0
	// type
	// Type
	// controller
	// END DEBUGGING
	// ClusterNodesItems0ControllerFrusItems0TypeController captures enum value "controller"
	ClusterNodesItems0ControllerFrusItems0TypeController string = "controller"
)

// prop value enum
func (m *ClusterNodesItems0ControllerFrusItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0ControllerFrusItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0ControllerFrusItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 controller frus items0 based on the context it is used
func (m *ClusterNodesItems0ControllerFrusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ControllerFrusItems0) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFrusItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0ControllerFrusItems0) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ControllerFrusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ControllerFrusItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ControllerFrusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineExternalCache Cache used for buffer management.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_external_cache
type ClusterInlineNodesInlineArrayItemInlineExternalCache struct {

	// Indicates whether the external cache is enabled.
	// Example: true
	IsEnabled *bool `json:"is_enabled,omitempty"`

	// Indicates whether HyA caching is enabled.
	// Example: true
	IsHyaEnabled *bool `json:"is_hya_enabled,omitempty"`

	// Indicates whether rewarm is enabled.
	// Example: true
	IsRewarmEnabled *bool `json:"is_rewarm_enabled,omitempty"`

	// PCS size in gigabytes.
	PcsSize *int64 `json:"pcs_size,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline external cache
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCache) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline external cache based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCache) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineExternalCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass External cache bypass management.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_external_cache_bypass
type ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass struct {

	// Indicates whether external cache bypass is enabled.
	// Example: true
	Enabled *bool `json:"enabled,omitempty"`

	// External cache bypass allowed operations percentage for large reads.
	// Example: 100
	LargeReadOpsAllowPercent *int64 `json:"large_read_ops_allow_percent,omitempty"`

	// Initiates an external cache bypass threshold reset action.
	// Example: true
	Reset *bool `json:"reset,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline external cache bypass
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cluster inline nodes inline array item inline external cache bypass based on context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineExternalCacheBypass
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHa cluster inline nodes inline array item inline ha
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha
type ClusterInlineNodesInlineArrayItemInlineHa struct {

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGiveback *bool `json:"auto_giveback,omitempty"`

	// Specifies whether giveback is automatically initiated when the node that owns the storage is ready.
	AutoGivebackOf *bool `json:"auto_giveback_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	// Read Only: true
	EnableTakeoverOf *bool `json:"enable_takeover_of,omitempty"`

	// Specifies whether or not storage failover is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// giveback
	Giveback *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback `json:"giveback,omitempty"`

	// interconnect
	Interconnect *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect `json:"interconnect,omitempty"`

	// Nodes in this node's High Availability (HA) group.
	// Read Only: true
	Partners []*ClusterNodesItems0HaPartnersItems0 `json:"partners"`

	// ports
	// Read Only: true
	Ports []*ClusterNodesItems0HaPortsItems0 `json:"ports"`

	// takeover
	Takeover *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover `json:"takeover,omitempty"`

	// takeover check
	TakeoverCheck *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck `json:"takeover_check,omitempty"`

	// Type of storage.
	// Read Only: true
	// Enum: ["shared_storage","non_shared_storage"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha
func (m *ClusterInlineNodesInlineArrayItemInlineHa) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGiveback(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInterconnect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartners(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeover(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTakeoverCheck(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateGiveback(formats strfmt.Registry) error {
	if swag.IsZero(m.Giveback) { // not required
		return nil
	}

	if m.Giveback != nil {
		if err := m.Giveback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateInterconnect(formats strfmt.Registry) error {
	if swag.IsZero(m.Interconnect) { // not required
		return nil
	}

	if m.Interconnect != nil {
		if err := m.Interconnect.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validatePartners(formats strfmt.Registry) error {
	if swag.IsZero(m.Partners) { // not required
		return nil
	}

	for i := 0; i < len(m.Partners); i++ {
		if swag.IsZero(m.Partners[i]) { // not required
			continue
		}

		if m.Partners[i] != nil {
			if err := m.Partners[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateTakeover(formats strfmt.Registry) error {
	if swag.IsZero(m.Takeover) { // not required
		return nil
	}

	if m.Takeover != nil {
		if err := m.Takeover.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateTakeoverCheck(formats strfmt.Registry) error {
	if swag.IsZero(m.TakeoverCheck) { // not required
		return nil
	}

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineHaTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shared_storage","non_shared_storage"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHaTypeTypePropEnum = append(clusterInlineNodesInlineArrayItemInlineHaTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha
	// ClusterInlineNodesInlineArrayItemInlineHa
	// type
	// Type
	// shared_storage
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaTypeSharedStorage captures enum value "shared_storage"
	ClusterInlineNodesInlineArrayItemInlineHaTypeSharedStorage string = "shared_storage"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha
	// ClusterInlineNodesInlineArrayItemInlineHa
	// type
	// Type
	// non_shared_storage
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaTypeNonSharedStorage captures enum value "non_shared_storage"
	ClusterInlineNodesInlineArrayItemInlineHaTypeNonSharedStorage string = "non_shared_storage"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHaTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("ha"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHa) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEnableTakeoverOf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGiveback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInterconnect(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartners(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeover(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverCheck(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateEnableTakeoverOf(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"enable_takeover_of", "body", m.EnableTakeoverOf); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateGiveback(ctx context.Context, formats strfmt.Registry) error {

	if m.Giveback != nil {
		if err := m.Giveback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateInterconnect(ctx context.Context, formats strfmt.Registry) error {

	if m.Interconnect != nil {
		if err := m.Interconnect.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "interconnect")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidatePartners(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"partners", "body", []*ClusterNodesItems0HaPartnersItems0(m.Partners)); err != nil {
		return err
	}

	for i := 0; i < len(m.Partners); i++ {

		if m.Partners[i] != nil {
			if err := m.Partners[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "partners" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"ports", "body", []*ClusterNodesItems0HaPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateTakeover(ctx context.Context, formats strfmt.Registry) error {

	if m.Takeover != nil {
		if err := m.Takeover.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateTakeoverCheck(ctx context.Context, formats strfmt.Registry) error {

	if m.TakeoverCheck != nil {
		if err := m.TakeoverCheck.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover_check")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHa) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHa) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHa) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHa
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback Represents the state of the node that is giving storage back to its HA partner.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback
type ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback struct {

	// failure
	Failure *ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["nothing_to_giveback","not_attempted","in_progress","failed"]
	State *string `json:"state,omitempty"`

	// Giveback status of each aggregate. This property is not supported on the ASA r2 platform.
	// Read Only: true
	Status []*ClusterNodesItems0HaGivebackStatusItems0 `json:"status"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline giveback
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nothing_to_giveback","not_attempted","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateNothingToGiveback captures enum value "nothing_to_giveback"
	ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateNotAttempted captures enum value "not_attempted"
	ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// in_progress
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateInProgress captures enum value "in_progress"
	ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback
	// state
	// State
	// failed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateFailed captures enum value "failed"
	ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackStateFailed string = "failed"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHaInlineGivebackTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"giveback"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	for i := 0; i < len(m.Status); i++ {
		if swag.IsZero(m.Status[i]) { // not required
			continue
		}

		if m.Status[i] != nil {
			if err := m.Status[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline giveback based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "giveback" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"giveback"+"."+"status", "body", []*ClusterNodesItems0HaGivebackStatusItems0(m.Status)); err != nil {
		return err
	}

	for i := 0; i < len(m.Status); i++ {

		if m.Status[i] != nil {
			if err := m.Status[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ha" + "." + "giveback" + "." + "status" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineGiveback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_giveback_inline_failure
type ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure struct {

	// Message code
	// Example: 852126
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate giveback. Run the \"storage failover show-giveback\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline giveback inline failure
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline giveback inline failure based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineGivebackInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaGivebackStatusItems0 cluster nodes items0 ha giveback status items0
//
// swagger:model ClusterNodesItems0HaGivebackStatusItems0
type ClusterNodesItems0HaGivebackStatusItems0 struct {

	// aggregate
	Aggregate *ClusterNodesItems0HaGivebackStatusItems0Aggregate `json:"aggregate,omitempty"`

	// error
	Error *ClusterNodesItems0HaGivebackStatusItems0Error `json:"error,omitempty"`

	// Giveback state of the aggregate. <br/>
	// Possible values include no aggregates to giveback(nothing_to_giveback), failed to disable background disk firmware update(BDFU) on source node(failed_bdfu_source), <br/>
	// giveback delayed as disk firmware update is in progress on source node(delayed_bdfu_source), performing veto checks(running_checks). <br/>
	//
	// Enum: ["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster nodes items0 ha giveback status items0
func (m *ClusterNodesItems0HaGivebackStatusItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(m.Aggregate) { // not required
		return nil
	}

	if m.Aggregate != nil {
		if err := m.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

var clusterNodesItems0HaGivebackStatusItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["done","failed","in_progress","not_started","nothing_to_giveback","failed_bdfu_source","failed_bdfu_dest","delayed_bdfu_source","delayed_bdfu_dest","running_checks"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0HaGivebackStatusItems0TypeStatePropEnum = append(clusterNodesItems0HaGivebackStatusItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// done
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateDone captures enum value "done"
	ClusterNodesItems0HaGivebackStatusItems0StateDone string = "done"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// failed
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateFailed captures enum value "failed"
	ClusterNodesItems0HaGivebackStatusItems0StateFailed string = "failed"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// in_progress
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateInProgress captures enum value "in_progress"
	ClusterNodesItems0HaGivebackStatusItems0StateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// not_started
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateNotStarted captures enum value "not_started"
	ClusterNodesItems0HaGivebackStatusItems0StateNotStarted string = "not_started"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// nothing_to_giveback
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateNothingToGiveback captures enum value "nothing_to_giveback"
	ClusterNodesItems0HaGivebackStatusItems0StateNothingToGiveback string = "nothing_to_giveback"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_source
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateFailedBdfuSource captures enum value "failed_bdfu_source"
	ClusterNodesItems0HaGivebackStatusItems0StateFailedBdfuSource string = "failed_bdfu_source"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// failed_bdfu_dest
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateFailedBdfuDest captures enum value "failed_bdfu_dest"
	ClusterNodesItems0HaGivebackStatusItems0StateFailedBdfuDest string = "failed_bdfu_dest"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_source
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateDelayedBdfuSource captures enum value "delayed_bdfu_source"
	ClusterNodesItems0HaGivebackStatusItems0StateDelayedBdfuSource string = "delayed_bdfu_source"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// delayed_bdfu_dest
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateDelayedBdfuDest captures enum value "delayed_bdfu_dest"
	ClusterNodesItems0HaGivebackStatusItems0StateDelayedBdfuDest string = "delayed_bdfu_dest"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0
	// ClusterNodesItems0HaGivebackStatusItems0
	// state
	// State
	// running_checks
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0StateRunningChecks captures enum value "running_checks"
	ClusterNodesItems0HaGivebackStatusItems0StateRunningChecks string = "running_checks"
)

// prop value enum
func (m *ClusterNodesItems0HaGivebackStatusItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0HaGivebackStatusItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha giveback status items0 based on the context it is used
func (m *ClusterNodesItems0HaGivebackStatusItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if m.Aggregate != nil {
		if err := m.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaGivebackStatusItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaGivebackStatusItems0Aggregate Aggregate name and UUID.
//
// swagger:model ClusterNodesItems0HaGivebackStatusItems0Aggregate
type ClusterNodesItems0HaGivebackStatusItems0Aggregate struct {

	// links
	Links *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster nodes items0 ha giveback status items0 aggregate
func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha giveback status items0 aggregate based on the context it is used
func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0Aggregate) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaGivebackStatusItems0Aggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaGivebackStatusItems0AggregateLinks cluster nodes items0 ha giveback status items0 aggregate links
//
// swagger:model ClusterNodesItems0HaGivebackStatusItems0AggregateLinks
type ClusterNodesItems0HaGivebackStatusItems0AggregateLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster nodes items0 ha giveback status items0 aggregate links
func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha giveback status items0 aggregate links based on the context it is used
func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0AggregateLinks) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaGivebackStatusItems0AggregateLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaGivebackStatusItems0Error Indicates the failed aggregate giveback code and message.
//
// swagger:model ClusterNodesItems0HaGivebackStatusItems0Error
type ClusterNodesItems0HaGivebackStatusItems0Error struct {

	// Message code.
	// Example: 852126
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Detailed message based on the state.
	// Read Only: true
	// Enum: ["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]
	Message *string `json:"message,omitempty"`
}

// Validate validates this cluster nodes items0 ha giveback status items0 error
func (m *ClusterNodesItems0HaGivebackStatusItems0Error) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMessage(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterNodesItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["shutdown","not_homes_partner","not_sfo","failed_limbo","offline_failed","migrating","veto","communication_err","online_timeout","online_failed","hdd_to_aff_dest"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum = append(clusterNodesItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// shutdown
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageShutdown captures enum value "shutdown"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageShutdown string = "shutdown"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_homes_partner
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner captures enum value "not_homes_partner"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageNotHomesPartner string = "not_homes_partner"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// not_sfo
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageNotSfo captures enum value "not_sfo"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageNotSfo string = "not_sfo"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// failed_limbo
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageFailedLimbo captures enum value "failed_limbo"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageFailedLimbo string = "failed_limbo"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// offline_failed
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOfflineFailed captures enum value "offline_failed"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOfflineFailed string = "offline_failed"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// migrating
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageMigrating captures enum value "migrating"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageMigrating string = "migrating"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// veto
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageVeto captures enum value "veto"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageVeto string = "veto"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// communication_err
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageCommunicationErr captures enum value "communication_err"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageCommunicationErr string = "communication_err"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_timeout
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout captures enum value "online_timeout"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOnlineTimeout string = "online_timeout"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// online_failed
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOnlineFailed captures enum value "online_failed"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageOnlineFailed string = "online_failed"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// ClusterNodesItems0HaGivebackStatusItems0Error
	// message
	// Message
	// hdd_to_aff_dest
	// END DEBUGGING
	// ClusterNodesItems0HaGivebackStatusItems0ErrorMessageHddToAffDest captures enum value "hdd_to_aff_dest"
	ClusterNodesItems0HaGivebackStatusItems0ErrorMessageHddToAffDest string = "hdd_to_aff_dest"
)

// prop value enum
func (m *ClusterNodesItems0HaGivebackStatusItems0Error) validateMessageEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0HaGivebackStatusItems0ErrorTypeMessagePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0Error) validateMessage(formats strfmt.Registry) error {
	if swag.IsZero(m.Message) { // not required
		return nil
	}

	// value enum
	if err := m.validateMessageEnum("error"+"."+"message", "body", *m.Message); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha giveback status items0 error based on the context it is used
func (m *ClusterNodesItems0HaGivebackStatusItems0Error) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0Error) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"code", "body", m.Code); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0HaGivebackStatusItems0Error) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "error"+"."+"message", "body", m.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0Error) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaGivebackStatusItems0Error) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaGivebackStatusItems0Error
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect cluster inline nodes inline array item inline ha inline interconnect
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_interconnect
type ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect struct {

	// HA interconnect device name.
	// Example: MVIA-RDMA
	// Read Only: true
	Adapter *string `json:"adapter,omitempty"`

	// Indicates the HA interconnect status.
	// Read Only: true
	// Enum: ["down","up"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline interconnect
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","up"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_interconnect
	// ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnectStateDown captures enum value "down"
	ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnectStateDown string = "down"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_interconnect
	// ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect
	// state
	// State
	// up
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnectStateUp captures enum value "up"
	ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnectStateUp string = "up"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHaInlineInterconnectTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"interconnect"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline interconnect based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAdapter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) contextValidateAdapter(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"adapter", "body", m.Adapter); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"interconnect"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineInterconnect
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaPartnersItems0 cluster nodes items0 ha partners items0
//
// swagger:model ClusterNodesItems0HaPartnersItems0
type ClusterNodesItems0HaPartnersItems0 struct {

	// links
	Links *ClusterNodesItems0HaPartnersItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster nodes items0 ha partners items0
func (m *ClusterNodesItems0HaPartnersItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaPartnersItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha partners items0 based on the context it is used
func (m *ClusterNodesItems0HaPartnersItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaPartnersItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaPartnersItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaPartnersItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaPartnersItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaPartnersItems0Links cluster nodes items0 ha partners items0 links
//
// swagger:model ClusterNodesItems0HaPartnersItems0Links
type ClusterNodesItems0HaPartnersItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster nodes items0 ha partners items0 links
func (m *ClusterNodesItems0HaPartnersItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaPartnersItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha partners items0 links based on the context it is used
func (m *ClusterNodesItems0HaPartnersItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaPartnersItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaPartnersItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaPartnersItems0Links) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaPartnersItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0HaPortsItems0 cluster nodes items0 ha ports items0
//
// swagger:model ClusterNodesItems0HaPortsItems0
type ClusterNodesItems0HaPortsItems0 struct {

	// HA port number
	// Example: 0
	// Read Only: true
	Number *int64 `json:"number,omitempty"`

	// HA port state:
	// * <i>down</i> - Logical HA link is down.
	// * <i>initialized</i> - Logical HA link is initialized. The physical link is up, but the subnet manager hasn't started to configure the port.
	// * <i>armed</i> - Logical HA link is armed. The physical link is up and the subnet manager started but did not yet complete configuring the port.
	// * <i>active</i> - Logical HA link is active.
	// * <i>reserved</i> - Logical HA link is active, but the physical link is down.
	//
	// Example: active
	// Read Only: true
	// Enum: ["down","initialized","armed","active","reserved"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster nodes items0 ha ports items0
func (m *ClusterNodesItems0HaPortsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterNodesItems0HaPortsItems0TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["down","initialized","armed","active","reserved"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNodesItems0HaPortsItems0TypeStatePropEnum = append(clusterNodesItems0HaPortsItems0TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaPortsItems0
	// ClusterNodesItems0HaPortsItems0
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterNodesItems0HaPortsItems0StateDown captures enum value "down"
	ClusterNodesItems0HaPortsItems0StateDown string = "down"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaPortsItems0
	// ClusterNodesItems0HaPortsItems0
	// state
	// State
	// initialized
	// END DEBUGGING
	// ClusterNodesItems0HaPortsItems0StateInitialized captures enum value "initialized"
	ClusterNodesItems0HaPortsItems0StateInitialized string = "initialized"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaPortsItems0
	// ClusterNodesItems0HaPortsItems0
	// state
	// State
	// armed
	// END DEBUGGING
	// ClusterNodesItems0HaPortsItems0StateArmed captures enum value "armed"
	ClusterNodesItems0HaPortsItems0StateArmed string = "armed"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaPortsItems0
	// ClusterNodesItems0HaPortsItems0
	// state
	// State
	// active
	// END DEBUGGING
	// ClusterNodesItems0HaPortsItems0StateActive captures enum value "active"
	ClusterNodesItems0HaPortsItems0StateActive string = "active"

	// BEGIN DEBUGGING
	// ClusterNodesItems0HaPortsItems0
	// ClusterNodesItems0HaPortsItems0
	// state
	// State
	// reserved
	// END DEBUGGING
	// ClusterNodesItems0HaPortsItems0StateReserved captures enum value "reserved"
	ClusterNodesItems0HaPortsItems0StateReserved string = "reserved"
)

// prop value enum
func (m *ClusterNodesItems0HaPortsItems0) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNodesItems0HaPortsItems0TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNodesItems0HaPortsItems0) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 ha ports items0 based on the context it is used
func (m *ClusterNodesItems0HaPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0HaPortsItems0) contextValidateNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "number", "body", m.Number); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNodesItems0HaPortsItems0) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0HaPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0HaPortsItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0HaPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover This represents the state of the node that is taking over storage from its HA partner.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
type ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover struct {

	// failure
	Failure *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure `json:"failure,omitempty"`

	// state
	// Example: failed
	// Enum: ["not_possible","not_attempted","in_takeover","in_progress","failed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline takeover
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFailure(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) validateFailure(formats strfmt.Registry) error {
	if swag.IsZero(m.Failure) { // not required
		return nil
	}

	if m.Failure != nil {
		if err := m.Failure.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_possible","not_attempted","in_takeover","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// not_possible
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateNotPossible captures enum value "not_possible"
	ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateNotPossible string = "not_possible"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// not_attempted
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateNotAttempted captures enum value "not_attempted"
	ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateNotAttempted string = "not_attempted"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// in_takeover
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateInTakeover captures enum value "in_takeover"
	ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateInTakeover string = "in_takeover"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// in_progress
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateInProgress captures enum value "in_progress"
	ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	// state
	// State
	// failed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateFailed captures enum value "failed"
	ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverStateFailed string = "failed"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHaInlineTakeoverTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("ha"+"."+"takeover"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline takeover based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFailure(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) contextValidateFailure(ctx context.Context, formats strfmt.Registry) error {

	if m.Failure != nil {
		if err := m.Failure.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ha" + "." + "takeover" + "." + "failure")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineTakeover
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck The takeover check response.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover_check
type ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck struct {

	// Reasons why the takeover is not possible.
	// Read Only: true
	Reasons []*string `json:"reasons"`

	// Indicates whether the takeover is possible.
	// Read Only: true
	TakeoverPossible *bool `json:"takeover_possible,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline takeover check
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline takeover check based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReasons(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTakeoverPossible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) contextValidateReasons(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons", "body", []*string(m.Reasons)); err != nil {
		return err
	}

	for i := 0; i < len(m.Reasons); i++ {

		if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"reasons"+"."+strconv.Itoa(i), "body", m.Reasons[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) contextValidateTakeoverPossible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "ha"+"."+"takeover_check"+"."+"takeover_possible", "body", m.TakeoverPossible); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverCheck
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure Indicates the failure code and message. This property is not supported on the ASA r2 platform.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_ha_inline_takeover_inline_failure
type ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure struct {

	// Message code
	// Example: 852130
	Code *int64 `json:"code,omitempty"`

	// Detailed message based on the state.
	// Example: Failed to initiate takeover. Run the \"storage failover show-takeover\" command for more information.
	Message *string `json:"message,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline ha inline takeover inline failure
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline ha inline takeover inline failure based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHaInlineTakeoverInlineFailure
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHwAssist The hardware assist information.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_hw_assist
type ClusterInlineNodesInlineArrayItemInlineHwAssist struct {

	// status
	Status *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus `json:"status,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline hw assist
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline hw assist based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssist) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHwAssist
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus cluster inline nodes inline array item inline hw assist inline status
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status
type ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus struct {

	// Indicates whether hardware assist is enabled on the node.
	Enabled *bool `json:"enabled,omitempty"`

	// local
	Local *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal `json:"local,omitempty"`

	// partner
	Partner *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner `json:"partner,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline hw assist inline status
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePartner(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(m.Local) { // not required
		return nil
	}

	if m.Local != nil {
		if err := m.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) validatePartner(formats strfmt.Registry) error {
	if swag.IsZero(m.Partner) { // not required
		return nil
	}

	if m.Partner != nil {
		if err := m.Partner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline hw assist inline status based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if m.Local != nil {
		if err := m.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) contextValidatePartner(ctx context.Context, formats strfmt.Registry) error {

	if m.Partner != nil {
		if err := m.Partner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("hw_assist" + "." + "status" + "." + "partner")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal cluster inline nodes inline array item inline hw assist inline status inline local
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_local
type ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline hw assist inline status inline local
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_local
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// active
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateActive captures enum value "active"
	ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateActive string = "active"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_local
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	// state
	// State
	// inactive
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateInactive captures enum value "inactive"
	ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalStateInactive string = "inactive"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocalTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"local"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster inline nodes inline array item inline hw assist inline status inline local based on context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner cluster inline nodes inline array item inline hw assist inline status inline partner
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_partner
type ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner struct {

	// The hardware assist IP address.
	IP *string `json:"ip,omitempty"`

	// The hardware assist port.
	Port *int64 `json:"port,omitempty"`

	// The hardware assist monitor status.
	// Enum: ["active","inactive"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline hw assist inline status inline partner
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["active","inactive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_partner
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// active
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateActive captures enum value "active"
	ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateActive string = "active"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_hw_assist_inline_status_inline_partner
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	// state
	// State
	// inactive
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateInactive captures enum value "inactive"
	ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerStateInactive string = "inactive"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartnerTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("hw_assist"+"."+"status"+"."+"partner"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster inline nodes inline array item inline hw assist inline status inline partner based on context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineHwAssistInlineStatusInlinePartner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineLinks cluster inline nodes inline array item inline links
//
// swagger:model cluster_inline_nodes_inline_array_item_inline__links
type ClusterInlineNodesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline links
func (m *ClusterInlineNodesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline links based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineManagementInterface The management interface of the node to be added. The subnet mask is set based on the management interface of the cluster or the management interfaces of other nodes.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_management_interface
type ClusterInlineNodesInlineArrayItemInlineManagementInterface struct {

	// ip
	IP *NodeSetupIP `json:"ip,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline management interface
func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline management interface based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("management_interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineManagementInterface) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineManagementInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ManagementInterfacesItems0 Network interface
//
// swagger:model ClusterNodesItems0ManagementInterfacesItems0
type ClusterNodesItems0ManagementInterfacesItems0 struct {

	// links
	Links *ClusterNodesItems0ManagementInterfacesItems0Links `json:"_links,omitempty"`

	// ip
	IP *ClusterNodesItems0ManagementInterfacesItems0IP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster nodes items0 management interfaces items0
func (m *ClusterNodesItems0ManagementInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(m.IP) { // not required
		return nil
	}

	if m.IP != nil {
		if err := m.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 management interfaces items0 based on the context it is used
func (m *ClusterNodesItems0ManagementInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if m.IP != nil {
		if err := m.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ManagementInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ManagementInterfacesItems0IP IP information
//
// swagger:model ClusterNodesItems0ManagementInterfacesItems0IP
type ClusterNodesItems0ManagementInterfacesItems0IP struct {

	// address
	Address *IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this cluster nodes items0 management interfaces items0 IP
func (m *ClusterNodesItems0ManagementInterfacesItems0IP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0IP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.Address) { // not required
		return nil
	}

	if m.Address != nil {
		if err := m.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 management interfaces items0 IP based on the context it is used
func (m *ClusterNodesItems0ManagementInterfacesItems0IP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0IP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.Address != nil {
		if err := m.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0IP) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0IP) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ManagementInterfacesItems0IP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0ManagementInterfacesItems0Links cluster nodes items0 management interfaces items0 links
//
// swagger:model ClusterNodesItems0ManagementInterfacesItems0Links
type ClusterNodesItems0ManagementInterfacesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster nodes items0 management interfaces items0 links
func (m *ClusterNodesItems0ManagementInterfacesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nodes items0 management interfaces items0 links based on the context it is used
func (m *ClusterNodesItems0ManagementInterfacesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNodesItems0ManagementInterfacesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0ManagementInterfacesItems0Links) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0ManagementInterfacesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineMetric CPU performance for the nodes.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_metric
type ClusterInlineNodesInlineArrayItemInlineMetric struct {

	// links
	Links *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Enum: ["PT15S","PT5M","PT30M","PT2H","P1D"]
	Duration *string `json:"duration,omitempty"`

	// Average CPU Utilization for the node
	// Example: 13
	ProcessorUtilization *int64 `json:"processor_utilization,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline metric
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT5M","PT30M","PT2H","P1D"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineMetricTypeDurationPropEnum = append(clusterInlineNodesInlineArrayItemInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricDurationPT15S captures enum value "PT15S"
	ClusterInlineNodesInlineArrayItemInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricDurationPT5M captures enum value "PT5M"
	ClusterInlineNodesInlineArrayItemInlineMetricDurationPT5M string = "PT5M"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricDurationPT30M captures enum value "PT30M"
	ClusterInlineNodesInlineArrayItemInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricDurationPT2H captures enum value "PT2H"
	ClusterInlineNodesInlineArrayItemInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricDurationP1D captures enum value "P1D"
	ClusterInlineNodesInlineArrayItemInlineMetricDurationP1D string = "P1D"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineMetricTypeStatusPropEnum = append(clusterInlineNodesInlineArrayItemInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusOk captures enum value "ok"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusError captures enum value "error"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metric
	// ClusterInlineNodesInlineArrayItemInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterInlineNodesInlineArrayItemInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline metric based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetric) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks cluster inline nodes inline array item inline metric inline links
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_metric_inline__links
type ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline metric inline links
func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline metric inline links based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineMetrocluster Metrocluster
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_metrocluster
type ClusterInlineNodesInlineArrayItemInlineMetrocluster struct {

	// Indicates whether the MetroCluster over IP platform supports custom VLAN IDs.
	// Read Only: true
	CustomVlanCapable *bool `json:"custom_vlan_capable,omitempty"`

	// MetroCluster over IP ports.
	// Read Only: true
	Ports []*ClusterNodesItems0MetroclusterPortsItems0 `json:"ports"`

	// The Metrocluster configuration type
	// Read Only: true
	// Enum: ["fc","fc_2_node","ip"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline metrocluster
func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePorts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) validatePorts(formats strfmt.Registry) error {
	if swag.IsZero(m.Ports) { // not required
		return nil
	}

	for i := 0; i < len(m.Ports); i++ {
		if swag.IsZero(m.Ports[i]) { // not required
			continue
		}

		if m.Ports[i] != nil {
			if err := m.Ports[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineMetroclusterTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","fc_2_node","ip"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineMetroclusterTypeTypePropEnum = append(clusterInlineNodesInlineArrayItemInlineMetroclusterTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metrocluster
	// ClusterInlineNodesInlineArrayItemInlineMetrocluster
	// type
	// Type
	// fc
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeFc captures enum value "fc"
	ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeFc string = "fc"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metrocluster
	// ClusterInlineNodesInlineArrayItemInlineMetrocluster
	// type
	// Type
	// fc_2_node
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeFc2Node captures enum value "fc_2_node"
	ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeFc2Node string = "fc_2_node"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_metrocluster
	// ClusterInlineNodesInlineArrayItemInlineMetrocluster
	// type
	// Type
	// ip
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeIP captures enum value "ip"
	ClusterInlineNodesInlineArrayItemInlineMetroclusterTypeIP string = "ip"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineMetroclusterTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("metrocluster"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline metrocluster based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCustomVlanCapable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePorts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) contextValidateCustomVlanCapable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"custom_vlan_capable", "body", m.CustomVlanCapable); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) contextValidatePorts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"ports", "body", []*ClusterNodesItems0MetroclusterPortsItems0(m.Ports)); err != nil {
		return err
	}

	for i := 0; i < len(m.Ports); i++ {

		if m.Ports[i] != nil {
			if err := m.Ports[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("metrocluster" + "." + "ports" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metrocluster"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineMetrocluster) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineMetrocluster
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNodesItems0MetroclusterPortsItems0 cluster nodes items0 metrocluster ports items0
//
// swagger:model ClusterNodesItems0MetroclusterPortsItems0
type ClusterNodesItems0MetroclusterPortsItems0 struct {

	// name
	// Example: e1b
	Name *string `json:"name,omitempty"`
}

// Validate validates this cluster nodes items0 metrocluster ports items0
func (m *ClusterNodesItems0MetroclusterPortsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cluster nodes items0 metrocluster ports items0 based on context it is used
func (m *ClusterNodesItems0MetroclusterPortsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNodesItems0MetroclusterPortsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNodesItems0MetroclusterPortsItems0) UnmarshalBinary(b []byte) error {
	var res ClusterNodesItems0MetroclusterPortsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineNvlog Non-volatile write log settings.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_nvlog
type ClusterInlineNodesInlineArrayItemInlineNvlog struct {

	// Indicates the current NVLog journal backing type.
	// Enum: ["ephemeral_memory","ephemeral_disk"]
	BackingType *string `json:"backing_type,omitempty"`

	// Indicates the current NVLog journal swap mode.
	// Enum: ["dynamic","manual"]
	SwapMode *string `json:"swap_mode,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline nvlog
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBackingType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSwapMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineNvlogTypeBackingTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ephemeral_memory","ephemeral_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineNvlogTypeBackingTypePropEnum = append(clusterInlineNodesInlineArrayItemInlineNvlogTypeBackingTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvlog
	// ClusterInlineNodesInlineArrayItemInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_memory
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvlogBackingTypeEphemeralMemory captures enum value "ephemeral_memory"
	ClusterInlineNodesInlineArrayItemInlineNvlogBackingTypeEphemeralMemory string = "ephemeral_memory"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvlog
	// ClusterInlineNodesInlineArrayItemInlineNvlog
	// backing_type
	// BackingType
	// ephemeral_disk
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvlogBackingTypeEphemeralDisk captures enum value "ephemeral_disk"
	ClusterInlineNodesInlineArrayItemInlineNvlogBackingTypeEphemeralDisk string = "ephemeral_disk"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) validateBackingTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineNvlogTypeBackingTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) validateBackingType(formats strfmt.Registry) error {
	if swag.IsZero(m.BackingType) { // not required
		return nil
	}

	// value enum
	if err := m.validateBackingTypeEnum("nvlog"+"."+"backing_type", "body", *m.BackingType); err != nil {
		return err
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineNvlogTypeSwapModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["dynamic","manual"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineNvlogTypeSwapModePropEnum = append(clusterInlineNodesInlineArrayItemInlineNvlogTypeSwapModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvlog
	// ClusterInlineNodesInlineArrayItemInlineNvlog
	// swap_mode
	// SwapMode
	// dynamic
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvlogSwapModeDynamic captures enum value "dynamic"
	ClusterInlineNodesInlineArrayItemInlineNvlogSwapModeDynamic string = "dynamic"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvlog
	// ClusterInlineNodesInlineArrayItemInlineNvlog
	// swap_mode
	// SwapMode
	// manual
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvlogSwapModeManual captures enum value "manual"
	ClusterInlineNodesInlineArrayItemInlineNvlogSwapModeManual string = "manual"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) validateSwapModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineNvlogTypeSwapModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) validateSwapMode(formats strfmt.Registry) error {
	if swag.IsZero(m.SwapMode) { // not required
		return nil
	}

	// value enum
	if err := m.validateSwapModeEnum("nvlog"+"."+"swap_mode", "body", *m.SwapMode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster inline nodes inline array item inline nvlog based on context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineNvlog) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineNvlog
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineNvram cluster inline nodes inline array item inline nvram
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_nvram
type ClusterInlineNodesInlineArrayItemInlineNvram struct {

	// Specifies status of the NVRAM battery. Possible values:
	// * <i>battery_ok</i>
	// * <i>battery_partially_discharged</i>
	// * <i>battery_fully_discharged</i>
	// * <i>battery_not_present</i>
	// * <i>battery_near_end_of_life</i>
	// * <i>battery_at_end_of_life</i>
	// * <i>battery_unknown</i>
	// * <i>battery_over_charged</i>
	// * <i>battery_fully_charged</i>
	//
	// Read Only: true
	// Enum: ["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]
	BatteryState *string `json:"battery_state,omitempty"`

	// Vendor specific NVRAM ID of the node.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline nvram
func (m *ClusterInlineNodesInlineArrayItemInlineNvram) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBatteryState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineNvramTypeBatteryStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["battery_ok","battery_partially_discharged","battery_fully_discharged","battery_not_present","battery_near_end_of_life","battery_at_end_of_life","battery_unknown","battery_over_charged","battery_fully_charged"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineNvramTypeBatteryStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineNvramTypeBatteryStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_ok
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryOk captures enum value "battery_ok"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryOk string = "battery_ok"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_partially_discharged
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryPartiallyDischarged captures enum value "battery_partially_discharged"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryPartiallyDischarged string = "battery_partially_discharged"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_discharged
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryFullyDischarged captures enum value "battery_fully_discharged"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryFullyDischarged string = "battery_fully_discharged"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_not_present
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryNotPresent captures enum value "battery_not_present"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryNotPresent string = "battery_not_present"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_near_end_of_life
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryNearEndOfLife captures enum value "battery_near_end_of_life"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryNearEndOfLife string = "battery_near_end_of_life"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_at_end_of_life
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryAtEndOfLife captures enum value "battery_at_end_of_life"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryAtEndOfLife string = "battery_at_end_of_life"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_unknown
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryUnknown captures enum value "battery_unknown"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryUnknown string = "battery_unknown"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_over_charged
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryOverCharged captures enum value "battery_over_charged"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryOverCharged string = "battery_over_charged"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_nvram
	// ClusterInlineNodesInlineArrayItemInlineNvram
	// battery_state
	// BatteryState
	// battery_fully_charged
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryFullyCharged captures enum value "battery_fully_charged"
	ClusterInlineNodesInlineArrayItemInlineNvramBatteryStateBatteryFullyCharged string = "battery_fully_charged"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineNvram) validateBatteryStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineNvramTypeBatteryStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineNvram) validateBatteryState(formats strfmt.Registry) error {
	if swag.IsZero(m.BatteryState) { // not required
		return nil
	}

	// value enum
	if err := m.validateBatteryStateEnum("nvram"+"."+"battery_state", "body", *m.BatteryState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline nvram based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineNvram) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBatteryState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineNvram) contextValidateBatteryState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"battery_state", "body", m.BatteryState); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineNvram) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nvram"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineNvram) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineNvram) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineNvram
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessor cluster inline nodes inline array item inline service processor
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor
type ClusterInlineNodesInlineArrayItemInlineServiceProcessor struct {

	// api service
	APIService *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService `json:"api_service,omitempty"`

	// auto config
	AutoConfig *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig `json:"auto_config,omitempty"`

	// Indicates whether the service processor can be automatically updated from ONTAP.
	AutoupdateEnabled *bool `json:"autoupdate_enabled,omitempty"`

	// backup
	Backup *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup `json:"backup,omitempty"`

	// Set to "true" to use DHCP to configure an IPv4 interface. Do not provide values for address, netmask and gateway when set to "true".
	DhcpEnabled *bool `json:"dhcp_enabled,omitempty"`

	// The version of firmware installed.
	// Read Only: true
	FirmwareVersion *string `json:"firmware_version,omitempty"`

	// ipv4 interface
	IPV4Interface *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface `json:"ipv4_interface,omitempty"`

	// ipv6 interface
	IPV6Interface *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface `json:"ipv6_interface,omitempty"`

	// Indicates whether the service processor network is configured.
	// Read Only: true
	IsIPConfigured *bool `json:"is_ip_configured,omitempty"`

	// Provides the "update status" of the last service processor update.
	// Read Only: true
	// Enum: ["failed","passed"]
	LastUpdateState *string `json:"last_update_state,omitempty"`

	// link status
	// Read Only: true
	// Enum: ["up","down","disabled","unknown"]
	LinkStatus *string `json:"link_status,omitempty"`

	// mac address
	// Read Only: true
	MacAddress *string `json:"mac_address,omitempty"`

	// primary
	Primary *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary `json:"primary,omitempty"`

	// ssh info
	SSHInfo *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo `json:"ssh_info,omitempty"`

	// state
	// Read Only: true
	// Enum: ["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]
	State *string `json:"state,omitempty"`

	// type
	// Read Only: true
	// Enum: ["sp","none","bmc"]
	Type *string `json:"type,omitempty"`

	// web service
	WebService *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService `json:"web_service,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAPIService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAutoConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBackup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6Interface(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLinkStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSSHInfo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWebService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateAPIService(formats strfmt.Registry) error {
	if swag.IsZero(m.APIService) { // not required
		return nil
	}

	if m.APIService != nil {
		if err := m.APIService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateAutoConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.AutoConfig) { // not required
		return nil
	}

	if m.AutoConfig != nil {
		if err := m.AutoConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateBackup(formats strfmt.Registry) error {
	if swag.IsZero(m.Backup) { // not required
		return nil
	}

	if m.Backup != nil {
		if err := m.Backup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateIPV4Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4Interface) { // not required
		return nil
	}

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateIPV6Interface(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6Interface) { // not required
		return nil
	}

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["failed","passed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// failed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLastUpdateStateFailed captures enum value "failed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLastUpdateStateFailed string = "failed"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// last_update_state
	// LastUpdateState
	// passed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLastUpdateStatePassed captures enum value "passed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLastUpdateStatePassed string = "passed"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateLastUpdateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLastUpdateStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateLastUpdateState(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateState) { // not required
		return nil
	}

	// value enum
	if err := m.validateLastUpdateStateEnum("service_processor"+"."+"last_update_state", "body", *m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down","disabled","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// up
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusUp captures enum value "up"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusUp string = "up"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// down
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusDown captures enum value "down"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusDown string = "down"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// disabled
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusDisabled captures enum value "disabled"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusDisabled string = "disabled"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// link_status
	// LinkStatus
	// unknown
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusUnknown captures enum value "unknown"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorLinkStatusUnknown string = "unknown"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateLinkStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeLinkStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateLinkStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.LinkStatus) { // not required
		return nil
	}

	// value enum
	if err := m.validateLinkStatusEnum("service_processor"+"."+"link_status", "body", *m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(m.Primary) { // not required
		return nil
	}

	if m.Primary != nil {
		if err := m.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateSSHInfo(formats strfmt.Registry) error {
	if swag.IsZero(m.SSHInfo) { // not required
		return nil
	}

	if m.SSHInfo != nil {
		if err := m.SSHInfo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","offline","degraded","rebooting","unknown","updating","node_offline","sp_daemon_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// online
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateOnline captures enum value "online"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateOnline string = "online"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// offline
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateOffline captures enum value "offline"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateOffline string = "offline"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// degraded
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateDegraded captures enum value "degraded"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// rebooting
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateRebooting captures enum value "rebooting"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateRebooting string = "rebooting"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// unknown
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateUnknown captures enum value "unknown"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateUnknown string = "unknown"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// updating
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateUpdating captures enum value "updating"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// node_offline
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateNodeOffline captures enum value "node_offline"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateNodeOffline string = "node_offline"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// state
	// State
	// sp_daemon_offline
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateSpDaemonOffline captures enum value "sp_daemon_offline"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorStateSpDaemonOffline string = "sp_daemon_offline"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sp","none","bmc"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeTypePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// sp
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeSp captures enum value "sp"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeSp string = "sp"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// none
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeNone captures enum value "none"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeNone string = "none"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	// type
	// Type
	// bmc
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeBmc captures enum value "bmc"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorTypeBmc string = "bmc"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("service_processor"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) validateWebService(formats strfmt.Registry) error {
	if swag.IsZero(m.WebService) { // not required
		return nil
	}

	if m.WebService != nil {
		if err := m.WebService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAPIService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAutoConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBackup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFirmwareVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV4Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6Interface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsIPConfigured(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLinkStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMacAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSSHInfo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWebService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateAPIService(ctx context.Context, formats strfmt.Registry) error {

	if m.APIService != nil {
		if err := m.APIService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "api_service")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateAutoConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.AutoConfig != nil {
		if err := m.AutoConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "auto_config")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateBackup(ctx context.Context, formats strfmt.Registry) error {

	if m.Backup != nil {
		if err := m.Backup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "backup")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateFirmwareVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"firmware_version", "body", m.FirmwareVersion); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateIPV4Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4Interface != nil {
		if err := m.IPV4Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv4_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateIPV6Interface(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6Interface != nil {
		if err := m.IPV6Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ipv6_interface")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateIsIPConfigured(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"is_ip_configured", "body", m.IsIPConfigured); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateLastUpdateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"last_update_state", "body", m.LastUpdateState); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateLinkStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"link_status", "body", m.LinkStatus); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateMacAddress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"mac_address", "body", m.MacAddress); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if m.Primary != nil {
		if err := m.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateSSHInfo(ctx context.Context, formats strfmt.Registry) error {

	if m.SSHInfo != nil {
		if err := m.SSHInfo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "ssh_info")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) contextValidateWebService(ctx context.Context, formats strfmt.Registry) error {

	if m.WebService != nil {
		if err := m.WebService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("service_processor" + "." + "web_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessor) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessor
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService Provides the properties of the service processor (SP) or baseboard management controller (BMC) API service.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_api_service
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService struct {

	// Indicates whether the SP API service of the SP or BMC is enabled or disabled. When the SP API service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts SP API service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`

	// Specifies the port number on the SP or BMC used for the SP API service. By default, port 50000 is used.
	Port *int64 `json:"port,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline api service
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline api service based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAPIService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig Provides the properties of the service processor auto configuration.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_auto_config
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig struct {

	// Indicates the service processor auto configuration IPv4 subnet name. To enable IPv4 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv4_mgmt
	IPV4Subnet *string `json:"ipv4_subnet,omitempty"`

	// Indicates the service processor auto configuration IPv6 subnet name. To enable IPv6 auto-config give the subnet name, give the value as null or an empty string "" to disable auto-config.
	// Example: ipv6_mgmt
	IPV6Subnet *string `json:"ipv6_subnet,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline auto config
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline auto config based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineAutoConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup Provides the properties of the service processor backup partition.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup struct {

	// Indicates whether the service processor is currently booted from the backup partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the backup partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the backup partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline backup
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// installed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateInstalled captures enum value "installed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// corrupt
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateCorrupt captures enum value "corrupt"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// updating
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateUpdating captures enum value "updating"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateAutoUpdating captures enum value "auto_updating"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_backup
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	// state
	// State
	// none
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateNone captures enum value "none"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupStateNone string = "none"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackupTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"backup"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline backup based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"backup"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineBackup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface Object to set up an interface along with its default router.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv4_interface
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface struct {

	// IPv4 address
	// Example: 10.10.10.7
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv4 interfaces is enabled. It expects dhcp_enabled as "true" or values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv4 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// Input as IPv4 mask (255.255.0.0). Output is always the netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline ipv4 interface
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv4_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup captures enum value "not_setup"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv4_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded captures enum value "succeeded"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv4_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress captures enum value "in_progress"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv4_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed captures enum value "failed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv4InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline ipv4 interface based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv4_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV4Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface Object to setup an interface along with its default router.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv6_interface
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface struct {

	// IPv6 address
	// Example: fd20:8b1e:b255:5011:10:141:4:97
	Address *string `json:"address,omitempty"`

	// Indicates whether the IPv6 interfaces is enabled. It expects values for address, netmask and gateway when set to "true".
	Enabled *bool `json:"enabled,omitempty"`

	// The IPv6 address of the default router.
	// Example: fd20:8b1e:b255:5011:10::1
	Gateway *string `json:"gateway,omitempty"`

	// Indicates whether IPv6 RA is enabled.
	IsIPV6RaEnabled *bool `json:"is_ipv6_ra_enabled,omitempty"`

	// Link local IP address.
	// Example: FE80::/10
	LinkLocalIP *string `json:"link_local_ip,omitempty"`

	// The IPv6 netmask/prefix length. The default value is 64 with a valid range of 1 to 127.
	// Example: 64
	Netmask *int64 `json:"netmask,omitempty"`

	// Router assigned IP address.
	// Example: 2001:0db8:85a3:0000:0000:8a2e:0370:7334
	RouterIP *string `json:"router_ip,omitempty"`

	// Indicates the setup state of the interface.
	// Read Only: true
	// Enum: ["not_setup","succeeded","in_progress","failed"]
	SetupState *string `json:"setup_state,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline ipv6 interface
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSetupState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["not_setup","succeeded","in_progress","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv6_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// not_setup
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup captures enum value "not_setup"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateNotSetup string = "not_setup"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv6_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// succeeded
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded captures enum value "succeeded"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateSucceeded string = "succeeded"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv6_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// in_progress
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress captures enum value "in_progress"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ipv6_interface
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	// setup_state
	// SetupState
	// failed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed captures enum value "failed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6InterfaceSetupStateFailed string = "failed"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) validateSetupStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIpv6InterfaceTypeSetupStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) validateSetupState(formats strfmt.Registry) error {
	if swag.IsZero(m.SetupState) { // not required
		return nil
	}

	// value enum
	if err := m.validateSetupStateEnum("service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", *m.SetupState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline ipv6 interface based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSetupState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) contextValidateSetupState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"ipv6_interface"+"."+"setup_state", "body", m.SetupState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineIPV6Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary Provides the properties of the service processor primary partition.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary struct {

	// Indicates whether the service processor is currently booted from the primary partition.
	// Read Only: true
	IsCurrent *bool `json:"is_current,omitempty"`

	// Status of the primary partition.
	// Read Only: true
	// Enum: ["installed","corrupt","updating","auto_updating","none"]
	State *string `json:"state,omitempty"`

	// Firmware version of the primary partition.
	// Example: 11.6
	// Read Only: true
	Version *string `json:"version,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline primary
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["installed","corrupt","updating","auto_updating","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum = append(clusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// installed
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateInstalled captures enum value "installed"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateInstalled string = "installed"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// corrupt
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateCorrupt captures enum value "corrupt"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateCorrupt string = "corrupt"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// updating
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateUpdating captures enum value "updating"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateUpdating string = "updating"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// auto_updating
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateAutoUpdating captures enum value "auto_updating"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateAutoUpdating string = "auto_updating"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_service_processor_inline_primary
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	// state
	// State
	// none
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateNone captures enum value "none"
	ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryStateNone string = "none"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimaryTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("service_processor"+"."+"primary"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline primary based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIsCurrent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateIsCurrent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"is_current", "body", m.IsCurrent); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "service_processor"+"."+"primary"+"."+"version", "body", m.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo Service processor SSH allowed IP address configuration applied across the cluster.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_ssh_info
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo struct {

	// Allowed IP addresses
	AllowedAddresses []*IPAddressAndNetmask `json:"allowed_addresses"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline ssh info
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllowedAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) validateAllowedAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.AllowedAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.AllowedAddresses); i++ {
		if swag.IsZero(m.AllowedAddresses[i]) { // not required
			continue
		}

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline ssh info based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllowedAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) contextValidateAllowedAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.AllowedAddresses); i++ {

		if m.AllowedAddresses[i] != nil {
			if err := m.AllowedAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("service_processor" + "." + "ssh_info" + "." + "allowed_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineSSHInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService Provides the properties of SP or BMC web service.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_service_processor_inline_web_service
type ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService struct {

	// Indicates whether the web service of the SP or BMC is enabled or disabled. When the web service is disabled, features such as network-based firmware updates and network-based down node log collection are not available, and the slower serial-interface is used for firmware updates and down node log collection.
	Enabled *bool `json:"enabled,omitempty"`

	// Restricts web service access to cluster nodes only. By default, limit_access is set to true.
	LimitAccess *bool `json:"limit_access,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline service processor inline web service
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline service processor inline web service based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineServiceProcessorInlineWebService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineSnaplock SnapLock-related properties.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_snaplock
type ClusterInlineNodesInlineArrayItemInlineSnaplock struct {

	// SnapLock compliance clock time.
	// Example: 2018-06-04 19:00:00+00:00
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline snaplock
func (m *ClusterInlineNodesInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline snaplock based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineStatistics Raw CPU performance for the nodes.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_statistics
type ClusterInlineNodesInlineArrayItemInlineStatistics struct {

	// Base counter for CPU Utilization.
	// Example: 12345123
	ProcessorUtilizationBase *int64 `json:"processor_utilization_base,omitempty"`

	// Raw CPU utilization for the node. The change in this value over time should be divided by corresponding change in processor_utilization_base, then multiplied by 100 to calculate the percentage CPU utilization for the node. For example: ((processor_utilization_raw_t2 - processor_utilization_raw_t1) / (processor_utilization_base_t2 - processor_utilization_base_t1)) * 100.
	//
	// Example: 13
	ProcessorUtilizationRaw *int64 `json:"processor_utilization_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline statistics
func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineStatisticsTypeStatusPropEnum = append(clusterInlineNodesInlineArrayItemInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusOk captures enum value "ok"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusError captures enum value "error"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_statistics
	// ClusterInlineNodesInlineArrayItemInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterInlineNodesInlineArrayItemInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster inline nodes inline array item inline statistics based on context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineSystemAggregate Aggregate
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_system_aggregate
type ClusterInlineNodesInlineArrayItemInlineSystemAggregate struct {

	// links
	Links *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline system aggregate
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline system aggregate based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregate) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineSystemAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks cluster inline nodes inline array item inline system aggregate inline links
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_system_aggregate_inline__links
type ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline system aggregate inline links
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline system aggregate inline links based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("system_aggregate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineSystemAggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineVM cluster inline nodes inline array item inline vm
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_vm
type ClusterInlineNodesInlineArrayItemInlineVM struct {

	// Cloud provider where the VM is hosted.
	// Read Only: true
	// Enum: ["GoogleCloud","AWS_S3","Azure_Cloud"]
	ProviderType *string `json:"provider_type,omitempty"`
}

// Validate validates this cluster inline nodes inline array item inline vm
func (m *ClusterInlineNodesInlineArrayItemInlineVM) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProviderType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterInlineNodesInlineArrayItemInlineVmTypeProviderTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["GoogleCloud","AWS_S3","Azure_Cloud"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineNodesInlineArrayItemInlineVmTypeProviderTypePropEnum = append(clusterInlineNodesInlineArrayItemInlineVmTypeProviderTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_vm
	// ClusterInlineNodesInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// GoogleCloud
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineVMProviderTypeGoogleCloud captures enum value "GoogleCloud"
	ClusterInlineNodesInlineArrayItemInlineVMProviderTypeGoogleCloud string = "GoogleCloud"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_vm
	// ClusterInlineNodesInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// AWS_S3
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineVMProviderTypeAWSS3 captures enum value "AWS_S3"
	ClusterInlineNodesInlineArrayItemInlineVMProviderTypeAWSS3 string = "AWS_S3"

	// BEGIN DEBUGGING
	// cluster_inline_nodes_inline_array_item_inline_vm
	// ClusterInlineNodesInlineArrayItemInlineVM
	// provider_type
	// ProviderType
	// Azure_Cloud
	// END DEBUGGING
	// ClusterInlineNodesInlineArrayItemInlineVMProviderTypeAzureCloud captures enum value "Azure_Cloud"
	ClusterInlineNodesInlineArrayItemInlineVMProviderTypeAzureCloud string = "Azure_Cloud"
)

// prop value enum
func (m *ClusterInlineNodesInlineArrayItemInlineVM) validateProviderTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineNodesInlineArrayItemInlineVmTypeProviderTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVM) validateProviderType(formats strfmt.Registry) error {
	if swag.IsZero(m.ProviderType) { // not required
		return nil
	}

	// value enum
	if err := m.validateProviderTypeEnum("vm"+"."+"provider_type", "body", *m.ProviderType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline vm based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineVM) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProviderType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVM) contextValidateProviderType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "vm"+"."+"provider_type", "body", m.ProviderType); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineVM) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineVM) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineVM
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineNodesInlineArrayItemInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
//
// swagger:model cluster_inline_nodes_inline_array_item_inline_version
type ClusterInlineNodesInlineArrayItemInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this cluster inline nodes inline array item inline version
func (m *ClusterInlineNodesInlineArrayItemInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline nodes inline array item inline version based on the context it is used
func (m *ClusterInlineNodesInlineArrayItemInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineNodesInlineArrayItemInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineNodesInlineArrayItemInlineVersion) UnmarshalBinary(b []byte) error {
	var res ClusterInlineNodesInlineArrayItemInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlinePeeringPolicy cluster inline peering policy
//
// swagger:model cluster_inline_peering_policy
type ClusterInlinePeeringPolicy struct {

	// Indicates whether authentication is required in the communication between cluster peers. If true, authentication is required to establish communication between cluster peers.
	// Read Only: true
	AuthenticationRequired *bool `json:"authentication_required,omitempty"`

	// Indicates whether encryption is required in the communication between cluster peers. If true, encryption is required to establish communication between cluster peers.
	// Read Only: true
	EncryptionRequired *bool `json:"encryption_required,omitempty"`

	// Minimum required length for a passphrase. For more information on password strength best practices, see: https://cheatsheetseries.owasp.org/cheatsheets/Authentication_Cheat_Sheet.html#implement-proper-password-strength-controls
	// Read Only: true
	// Maximum: 1500
	// Minimum: 0
	MinimumPassphraseLength *int64 `json:"minimum_passphrase_length,omitempty"`
}

// Validate validates this cluster inline peering policy
func (m *ClusterInlinePeeringPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMinimumPassphraseLength(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlinePeeringPolicy) validateMinimumPassphraseLength(formats strfmt.Registry) error {
	if swag.IsZero(m.MinimumPassphraseLength) { // not required
		return nil
	}

	if err := validate.MinimumInt("peering_policy"+"."+"minimum_passphrase_length", "body", *m.MinimumPassphraseLength, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("peering_policy"+"."+"minimum_passphrase_length", "body", *m.MinimumPassphraseLength, 1500, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline peering policy based on the context it is used
func (m *ClusterInlinePeeringPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuthenticationRequired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryptionRequired(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinimumPassphraseLength(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlinePeeringPolicy) contextValidateAuthenticationRequired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "peering_policy"+"."+"authentication_required", "body", m.AuthenticationRequired); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlinePeeringPolicy) contextValidateEncryptionRequired(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "peering_policy"+"."+"encryption_required", "body", m.EncryptionRequired); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlinePeeringPolicy) contextValidateMinimumPassphraseLength(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "peering_policy"+"."+"minimum_passphrase_length", "body", m.MinimumPassphraseLength); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlinePeeringPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlinePeeringPolicy) UnmarshalBinary(b []byte) error {
	var res ClusterInlinePeeringPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineStatistics These are raw performance numbers, such as IOPS latency and throughput. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model cluster_inline_statistics
type ClusterInlineStatistics struct {

	// iops raw
	IopsRaw *ClusterInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *ClusterInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *ClusterInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cluster inline statistics
func (m *ClusterInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var clusterInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterInlineStatisticsTypeStatusPropEnum = append(clusterInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterInlineStatisticsStatusOk captures enum value "ok"
	ClusterInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterInlineStatisticsStatusError captures enum value "error"
	ClusterInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	ClusterInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	ClusterInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	ClusterInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// ClusterInlineStatisticsStatusNotFound captures enum value "not_found"
	ClusterInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	ClusterInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cluster_inline_statistics
	// ClusterInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *ClusterInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster inline statistics based on the context it is used
func (m *ClusterInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ClusterInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model cluster_inline_statistics_inline_iops_raw
type ClusterInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline statistics inline iops raw
func (m *ClusterInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline statistics inline iops raw based on the context it is used
func (m *ClusterInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res ClusterInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model cluster_inline_statistics_inline_latency_raw
type ClusterInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline statistics inline latency raw
func (m *ClusterInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline statistics inline latency raw based on the context it is used
func (m *ClusterInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res ClusterInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model cluster_inline_statistics_inline_throughput_raw
type ClusterInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster inline statistics inline throughput raw
func (m *ClusterInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline statistics inline throughput raw based on the context it is used
func (m *ClusterInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res ClusterInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineTimezone Provides the cluster-wide time zone information that localizes time found on messages displayed on each node's:
// * console messages;
// * logging to internal ONTAP log files; and
// * localized REST API full ISO-8601 date, time, and time zone format information.
// Machine-to-machine interfaces, such as file access protocols (NFS, CIFS), block access protocols (SAN), and other protocols
// such as Manage ONTAP (ONTAPI), use second or subsecond time values that are based on world time or UTC.
//
// swagger:model cluster_inline_timezone
type ClusterInlineTimezone struct {

	// The ONTAP time zone name or identification in either IANA time zone format "Area/Location", or an ONTAP traditional time zone.
	// </br>
	// The initial first node in cluster setting for time zone is "Etc/UTC".
	// "Etc/UTC" is the IANA timezone "Area/Location" specifier for
	// Coordinated Universal Time (UTC), which is an offset of 0.
	// ### IANA time zone format
	// The IANA time zone, formatted as "Area/Location", is based on geographic areas that have had the same time zone offset for many years.
	// </br>
	// "Location" represents a compound name using additional forward slashes.
	// </br>
	// An example of the "Area/Location" time zone is "America/New_York" and represents most of the United States Eastern Time Zone.
	// Examples of "Area/Location" with "Location" as a compound name are "America/Argentina/Buenos_Aires" and "America/Indiana/Indianapolis".
	// ### ONTAP traditional time zone
	// Examples of the traditional time zones are "EST5EDT" for the United States Eastern Time Zone and "CET" for Central European Time Zone.
	//
	// Example: America/New_York
	Name *string `json:"name,omitempty"`
}

// Validate validates this cluster inline timezone
func (m *ClusterInlineTimezone) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cluster inline timezone based on context it is used
func (m *ClusterInlineTimezone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineTimezone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineTimezone) UnmarshalBinary(b []byte) error {
	var res ClusterInlineTimezone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
//
// swagger:model cluster_inline_version
type ClusterInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this cluster inline version
func (m *ClusterInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster inline version based on the context it is used
func (m *ClusterInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *ClusterInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterInlineVersion) UnmarshalBinary(b []byte) error {
	var res ClusterInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
