// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterActiveDirectory cluster active directory
//
// swagger:model cluster_active_directory
type ClusterActiveDirectory struct {

	// If set to true and a machine account exists with the same name as specified in "name" in Active Directory, it is overwritten and reused.
	// Example: false
	ForceAccountOverwrite *bool `json:"force_account_overwrite,omitempty"`

	// Fully qualified domain name.
	// Example: server1.com
	// Max Length: 254
	Fqdn *string `json:"fqdn,omitempty"`

	// Active Directory account NetBIOS name.
	// Example: account1
	// Max Length: 15
	Name *string `json:"name,omitempty"`

	// Organizational unit under which the Active Directory account is created.
	// Example: CN=Test
	OrganizationalUnit *string `json:"organizational_unit,omitempty"`

	// Administrator password required for Active Directory account creation, modification, and deletion.
	// Example: testpwd
	// Min Length: 1
	Password *string `json:"password,omitempty"`

	// security
	Security *ActiveDirectorySecurity `json:"security,omitempty"`

	// Administrator username required for Active Directory account creation, modification, and deletion.
	// Example: admin
	// Min Length: 1
	Username *string `json:"username,omitempty"`
}

// Validate validates this cluster active directory
func (m *ClusterActiveDirectory) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFqdn(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePassword(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsername(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterActiveDirectory) validateFqdn(formats strfmt.Registry) error {
	if swag.IsZero(m.Fqdn) { // not required
		return nil
	}

	if err := validate.MaxLength("fqdn", "body", *m.Fqdn, 254); err != nil {
		return err
	}

	return nil
}

func (m *ClusterActiveDirectory) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MaxLength("name", "body", *m.Name, 15); err != nil {
		return err
	}

	return nil
}

func (m *ClusterActiveDirectory) validatePassword(formats strfmt.Registry) error {
	if swag.IsZero(m.Password) { // not required
		return nil
	}

	if err := validate.MinLength("password", "body", *m.Password, 1); err != nil {
		return err
	}

	return nil
}

func (m *ClusterActiveDirectory) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.Security) { // not required
		return nil
	}

	if m.Security != nil {
		if err := m.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterActiveDirectory) validateUsername(formats strfmt.Registry) error {
	if swag.IsZero(m.Username) { // not required
		return nil
	}

	if err := validate.MinLength("username", "body", *m.Username, 1); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster active directory based on the context it is used
func (m *ClusterActiveDirectory) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterActiveDirectory) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if m.Security != nil {
		if err := m.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterActiveDirectory) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterActiveDirectory) UnmarshalBinary(b []byte) error {
	var res ClusterActiveDirectory
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
