// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterLdap cluster ldap
//
// swagger:model cluster_ldap
type ClusterLdap struct {

	// links
	Links *ClusterLdapInlineLinks `json:"_links,omitempty"`

	// Specifies the default base DN for all searches.
	BaseDn *string `json:"base_dn,omitempty"`

	// Specifies the default search scope for LDAP queries:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	BaseScope *string `json:"base_scope,omitempty"`

	// Specifies whether or not CIFS server's credentials are used to bind to the LDAP server.
	//
	BindAsCifsServer *bool `json:"bind_as_cifs_server,omitempty"`

	// Specifies the user that binds to the LDAP servers.
	BindDn *string `json:"bind_dn,omitempty"`

	// Specifies the bind password for the LDAP servers.
	BindPassword *string `json:"bind_password,omitempty"`

	// cluster ldap inline servers
	ClusterLdapInlineServers []*string `json:"servers,omitempty"`

	// Specifies the group Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for group lookups.
	GroupDn *string `json:"group_dn,omitempty"`

	// Specifies the custom filter used for group membership lookups from an LDAP server.
	//
	GroupMembershipFilter *string `json:"group_membership_filter,omitempty"`

	// Specifies the default search scope for LDAP for group lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	GroupScope *string `json:"group_scope,omitempty"`

	// Specifies whether or not netgroup by host querying is enabled.
	//
	IsNetgroupByhostEnabled *bool `json:"is_netgroup_byhost_enabled,omitempty"`

	// Specifies whether or not the SVM owns the LDAP client configuration.
	//
	// Read Only: true
	IsOwner *bool `json:"is_owner,omitempty"`

	// Specifies whether or not LDAPS is enabled.
	//
	LdapsEnabled *bool `json:"ldaps_enabled,omitempty"`

	// The minimum bind authentication level. Possible values are:
	// * anonymous - anonymous bind
	// * simple - simple bind
	// * sasl - Simple Authentication and Security Layer (SASL) bind
	//
	// Enum: ["anonymous","simple","sasl"]
	MinBindLevel *string `json:"min_bind_level,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup by host lookups.
	NetgroupByhostDn *string `json:"netgroup_byhost_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup by host lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupByhostScope *string `json:"netgroup_byhost_scope,omitempty"`

	// Specifies the netgroup Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for netgroup lookups.
	NetgroupDn *string `json:"netgroup_dn,omitempty"`

	// Specifies the default search scope for LDAP for netgroup lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	NetgroupScope *string `json:"netgroup_scope,omitempty"`

	// The port used to connect to the LDAP Servers.
	// Example: 389
	// Maximum: 65535
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`

	// Specifies the maximum time to wait for a query response from the LDAP server, in seconds.
	//
	QueryTimeout *int64 `json:"query_timeout,omitempty"`

	// The name of the schema template used by the SVM.
	// * AD-IDMU - Active Directory Identity Management for UNIX
	// * AD-SFU - Active Directory Services for UNIX
	// * MS-AD-BIS - Active Directory Identity Management for UNIX
	// * RFC-2307 - Schema based on RFC 2307
	// * Custom schema
	//
	Schema *string `json:"schema,omitempty"`

	// Specifies the level of security to be used for LDAP communications:
	// * none - no signing or sealing
	// * sign - sign LDAP traffic
	// * seal - seal and sign LDAP traffic
	//
	// Enum: ["none","sign","seal"]
	SessionSecurity *string `json:"session_security,omitempty"`

	// Indicates whether or not the validation for the specified LDAP configuration is disabled.
	//
	SkipConfigValidation *bool `json:"skip_config_validation,omitempty"`

	// status
	Status *ClusterLdapInlineStatus `json:"status,omitempty"`

	// Specifies whether or not channel binding is attempted in the case of TLS/LDAPS.
	//
	TryChannelBinding *bool `json:"try_channel_binding,omitempty"`

	// Specifies whether or not to use Start TLS over LDAP connections.
	//
	UseStartTLS *bool `json:"use_start_tls,omitempty"`

	// Specifies the user Distinguished Name (DN) that is used as the starting point in the LDAP directory tree for user lookups.
	UserDn *string `json:"user_dn,omitempty"`

	// Specifies the default search scope for LDAP for user lookups:
	// * base - search the named entry only
	// * onelevel - search all entries immediately below the DN
	// * subtree - search the named DN entry and the entire subtree below the DN
	//
	// Enum: ["base","onelevel","subtree"]
	UserScope *string `json:"user_scope,omitempty"`
}

// Validate validates this cluster ldap
func (m *ClusterLdap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBaseScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinBindLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetgroupByhostScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNetgroupScope(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSessionSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserScope(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var clusterLdapTypeBaseScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeBaseScopePropEnum = append(clusterLdapTypeBaseScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// base_scope
	// BaseScope
	// base
	// END DEBUGGING
	// ClusterLdapBaseScopeBase captures enum value "base"
	ClusterLdapBaseScopeBase string = "base"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// base_scope
	// BaseScope
	// onelevel
	// END DEBUGGING
	// ClusterLdapBaseScopeOnelevel captures enum value "onelevel"
	ClusterLdapBaseScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// base_scope
	// BaseScope
	// subtree
	// END DEBUGGING
	// ClusterLdapBaseScopeSubtree captures enum value "subtree"
	ClusterLdapBaseScopeSubtree string = "subtree"
)

// prop value enum
func (m *ClusterLdap) validateBaseScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeBaseScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateBaseScope(formats strfmt.Registry) error {
	if swag.IsZero(m.BaseScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateBaseScopeEnum("base_scope", "body", *m.BaseScope); err != nil {
		return err
	}

	return nil
}

var clusterLdapTypeGroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeGroupScopePropEnum = append(clusterLdapTypeGroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// group_scope
	// GroupScope
	// base
	// END DEBUGGING
	// ClusterLdapGroupScopeBase captures enum value "base"
	ClusterLdapGroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// group_scope
	// GroupScope
	// onelevel
	// END DEBUGGING
	// ClusterLdapGroupScopeOnelevel captures enum value "onelevel"
	ClusterLdapGroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// group_scope
	// GroupScope
	// subtree
	// END DEBUGGING
	// ClusterLdapGroupScopeSubtree captures enum value "subtree"
	ClusterLdapGroupScopeSubtree string = "subtree"
)

// prop value enum
func (m *ClusterLdap) validateGroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeGroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateGroupScope(formats strfmt.Registry) error {
	if swag.IsZero(m.GroupScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateGroupScopeEnum("group_scope", "body", *m.GroupScope); err != nil {
		return err
	}

	return nil
}

var clusterLdapTypeMinBindLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["anonymous","simple","sasl"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeMinBindLevelPropEnum = append(clusterLdapTypeMinBindLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// min_bind_level
	// MinBindLevel
	// anonymous
	// END DEBUGGING
	// ClusterLdapMinBindLevelAnonymous captures enum value "anonymous"
	ClusterLdapMinBindLevelAnonymous string = "anonymous"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// min_bind_level
	// MinBindLevel
	// simple
	// END DEBUGGING
	// ClusterLdapMinBindLevelSimple captures enum value "simple"
	ClusterLdapMinBindLevelSimple string = "simple"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// min_bind_level
	// MinBindLevel
	// sasl
	// END DEBUGGING
	// ClusterLdapMinBindLevelSasl captures enum value "sasl"
	ClusterLdapMinBindLevelSasl string = "sasl"
)

// prop value enum
func (m *ClusterLdap) validateMinBindLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeMinBindLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateMinBindLevel(formats strfmt.Registry) error {
	if swag.IsZero(m.MinBindLevel) { // not required
		return nil
	}

	// value enum
	if err := m.validateMinBindLevelEnum("min_bind_level", "body", *m.MinBindLevel); err != nil {
		return err
	}

	return nil
}

var clusterLdapTypeNetgroupByhostScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeNetgroupByhostScopePropEnum = append(clusterLdapTypeNetgroupByhostScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// base
	// END DEBUGGING
	// ClusterLdapNetgroupByhostScopeBase captures enum value "base"
	ClusterLdapNetgroupByhostScopeBase string = "base"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// onelevel
	// END DEBUGGING
	// ClusterLdapNetgroupByhostScopeOnelevel captures enum value "onelevel"
	ClusterLdapNetgroupByhostScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_byhost_scope
	// NetgroupByhostScope
	// subtree
	// END DEBUGGING
	// ClusterLdapNetgroupByhostScopeSubtree captures enum value "subtree"
	ClusterLdapNetgroupByhostScopeSubtree string = "subtree"
)

// prop value enum
func (m *ClusterLdap) validateNetgroupByhostScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeNetgroupByhostScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateNetgroupByhostScope(formats strfmt.Registry) error {
	if swag.IsZero(m.NetgroupByhostScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateNetgroupByhostScopeEnum("netgroup_byhost_scope", "body", *m.NetgroupByhostScope); err != nil {
		return err
	}

	return nil
}

var clusterLdapTypeNetgroupScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeNetgroupScopePropEnum = append(clusterLdapTypeNetgroupScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_scope
	// NetgroupScope
	// base
	// END DEBUGGING
	// ClusterLdapNetgroupScopeBase captures enum value "base"
	ClusterLdapNetgroupScopeBase string = "base"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_scope
	// NetgroupScope
	// onelevel
	// END DEBUGGING
	// ClusterLdapNetgroupScopeOnelevel captures enum value "onelevel"
	ClusterLdapNetgroupScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// netgroup_scope
	// NetgroupScope
	// subtree
	// END DEBUGGING
	// ClusterLdapNetgroupScopeSubtree captures enum value "subtree"
	ClusterLdapNetgroupScopeSubtree string = "subtree"
)

// prop value enum
func (m *ClusterLdap) validateNetgroupScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeNetgroupScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateNetgroupScope(formats strfmt.Registry) error {
	if swag.IsZero(m.NetgroupScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateNetgroupScopeEnum("netgroup_scope", "body", *m.NetgroupScope); err != nil {
		return err
	}

	return nil
}

func (m *ClusterLdap) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(m.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("port", "body", *m.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("port", "body", *m.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

var clusterLdapTypeSessionSecurityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","sign","seal"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeSessionSecurityPropEnum = append(clusterLdapTypeSessionSecurityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// session_security
	// SessionSecurity
	// none
	// END DEBUGGING
	// ClusterLdapSessionSecurityNone captures enum value "none"
	ClusterLdapSessionSecurityNone string = "none"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// session_security
	// SessionSecurity
	// sign
	// END DEBUGGING
	// ClusterLdapSessionSecuritySign captures enum value "sign"
	ClusterLdapSessionSecuritySign string = "sign"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// session_security
	// SessionSecurity
	// seal
	// END DEBUGGING
	// ClusterLdapSessionSecuritySeal captures enum value "seal"
	ClusterLdapSessionSecuritySeal string = "seal"
)

// prop value enum
func (m *ClusterLdap) validateSessionSecurityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeSessionSecurityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateSessionSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.SessionSecurity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSessionSecurityEnum("session_security", "body", *m.SessionSecurity); err != nil {
		return err
	}

	return nil
}

func (m *ClusterLdap) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

var clusterLdapTypeUserScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["base","onelevel","subtree"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapTypeUserScopePropEnum = append(clusterLdapTypeUserScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// user_scope
	// UserScope
	// base
	// END DEBUGGING
	// ClusterLdapUserScopeBase captures enum value "base"
	ClusterLdapUserScopeBase string = "base"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// user_scope
	// UserScope
	// onelevel
	// END DEBUGGING
	// ClusterLdapUserScopeOnelevel captures enum value "onelevel"
	ClusterLdapUserScopeOnelevel string = "onelevel"

	// BEGIN DEBUGGING
	// cluster_ldap
	// ClusterLdap
	// user_scope
	// UserScope
	// subtree
	// END DEBUGGING
	// ClusterLdapUserScopeSubtree captures enum value "subtree"
	ClusterLdapUserScopeSubtree string = "subtree"
)

// prop value enum
func (m *ClusterLdap) validateUserScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapTypeUserScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdap) validateUserScope(formats strfmt.Registry) error {
	if swag.IsZero(m.UserScope) { // not required
		return nil
	}

	// value enum
	if err := m.validateUserScopeEnum("user_scope", "body", *m.UserScope); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster ldap based on the context it is used
func (m *ClusterLdap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterLdap) contextValidateIsOwner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_owner", "body", m.IsOwner); err != nil {
		return err
	}

	return nil
}

func (m *ClusterLdap) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterLdap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterLdap) UnmarshalBinary(b []byte) error {
	var res ClusterLdap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterLdapInlineLinks cluster ldap inline links
//
// swagger:model cluster_ldap_inline__links
type ClusterLdapInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster ldap inline links
func (m *ClusterLdapInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdapInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster ldap inline links based on the context it is used
func (m *ClusterLdapInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdapInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterLdapInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterLdapInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterLdapInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterLdapInlineStatus cluster ldap inline status
//
// swagger:model cluster_ldap_inline_status
type ClusterLdapInlineStatus struct {

	// This field is no longer supported. Use ipv4.code or ipv6.code instead.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn message
	DnMessage []*string `json:"dn_message,omitempty"`

	// ipv4
	IPV4 *ClusterLdapInlineStatusInlineIPV4 `json:"ipv4,omitempty"`

	// This field is no longer supported. Use ipv4.state instead.
	//
	// Enum: ["up","down"]
	IPV4State *string `json:"ipv4_state,omitempty"`

	// ipv6
	IPV6 *ClusterLdapInlineStatusInlineIPV6 `json:"ipv6,omitempty"`

	// This field is no longer supported. Use ipv6.state instead.
	//
	// Enum: ["up","down"]
	IPV6State *string `json:"ipv6_state,omitempty"`

	// This field is no longer supported. Use ipv4.message or ipv6.message instead.
	//
	Message *string `json:"message,omitempty"`

	// The status of the LDAP service for the SVM. The LDAP service is up if either `ipv4_state` or `ipv6_state` is up.
	// The LDAP service is down if both `ipv4_state` and `ipv6_state` are down.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster ldap inline status
func (m *ClusterLdapInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPV4(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV4State(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPV6State(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdapInlineStatus) validateIPV4(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4) { // not required
		return nil
	}

	if m.IPV4 != nil {
		if err := m.IPV4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

var clusterLdapInlineStatusTypeIPV4StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapInlineStatusTypeIPV4StatePropEnum = append(clusterLdapInlineStatusTypeIPV4StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// ipv4_state
	// IPV4State
	// up
	// END DEBUGGING
	// ClusterLdapInlineStatusIPV4StateUp captures enum value "up"
	ClusterLdapInlineStatusIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// ipv4_state
	// IPV4State
	// down
	// END DEBUGGING
	// ClusterLdapInlineStatusIPV4StateDown captures enum value "down"
	ClusterLdapInlineStatusIPV4StateDown string = "down"
)

// prop value enum
func (m *ClusterLdapInlineStatus) validateIPV4StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapInlineStatusTypeIPV4StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdapInlineStatus) validateIPV4State(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV4State) { // not required
		return nil
	}

	// value enum
	if err := m.validateIPV4StateEnum("status"+"."+"ipv4_state", "body", *m.IPV4State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterLdapInlineStatus) validateIPV6(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6) { // not required
		return nil
	}

	if m.IPV6 != nil {
		if err := m.IPV6.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

var clusterLdapInlineStatusTypeIPV6StatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapInlineStatusTypeIPV6StatePropEnum = append(clusterLdapInlineStatusTypeIPV6StatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// ipv6_state
	// IPV6State
	// up
	// END DEBUGGING
	// ClusterLdapInlineStatusIPV6StateUp captures enum value "up"
	ClusterLdapInlineStatusIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// ipv6_state
	// IPV6State
	// down
	// END DEBUGGING
	// ClusterLdapInlineStatusIPV6StateDown captures enum value "down"
	ClusterLdapInlineStatusIPV6StateDown string = "down"
)

// prop value enum
func (m *ClusterLdapInlineStatus) validateIPV6StateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapInlineStatusTypeIPV6StatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdapInlineStatus) validateIPV6State(formats strfmt.Registry) error {
	if swag.IsZero(m.IPV6State) { // not required
		return nil
	}

	// value enum
	if err := m.validateIPV6StateEnum("status"+"."+"ipv6_state", "body", *m.IPV6State); err != nil {
		return err
	}

	return nil
}

var clusterLdapInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapInlineStatusTypeStatePropEnum = append(clusterLdapInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// state
	// State
	// up
	// END DEBUGGING
	// ClusterLdapInlineStatusStateUp captures enum value "up"
	ClusterLdapInlineStatusStateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status
	// ClusterLdapInlineStatus
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterLdapInlineStatusStateDown captures enum value "down"
	ClusterLdapInlineStatusStateDown string = "down"
)

// prop value enum
func (m *ClusterLdapInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdapInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster ldap inline status based on the context it is used
func (m *ClusterLdapInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPV4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPV6(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterLdapInlineStatus) contextValidateIPV4(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV4 != nil {
		if err := m.IPV4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv4")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterLdapInlineStatus) contextValidateIPV6(ctx context.Context, formats strfmt.Registry) error {

	if m.IPV6 != nil {
		if err := m.IPV6.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status" + "." + "ipv6")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterLdapInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterLdapInlineStatus) UnmarshalBinary(b []byte) error {
	var res ClusterLdapInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterLdapInlineStatusInlineIPV4 cluster ldap inline status inline ipv4
//
// swagger:model cluster_ldap_inline_status_inline_ipv4
type ClusterLdapInlineStatusInlineIPV4 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster ldap inline status inline ipv4
func (m *ClusterLdapInlineStatusInlineIPV4) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterLdapInlineStatusInlineIpv4TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapInlineStatusInlineIpv4TypeStatePropEnum = append(clusterLdapInlineStatusInlineIpv4TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status_inline_ipv4
	// ClusterLdapInlineStatusInlineIPV4
	// state
	// State
	// up
	// END DEBUGGING
	// ClusterLdapInlineStatusInlineIPV4StateUp captures enum value "up"
	ClusterLdapInlineStatusInlineIPV4StateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status_inline_ipv4
	// ClusterLdapInlineStatusInlineIPV4
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterLdapInlineStatusInlineIPV4StateDown captures enum value "down"
	ClusterLdapInlineStatusInlineIPV4StateDown string = "down"
)

// prop value enum
func (m *ClusterLdapInlineStatusInlineIPV4) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapInlineStatusInlineIpv4TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdapInlineStatusInlineIPV4) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"ipv4"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster ldap inline status inline ipv4 based on context it is used
func (m *ClusterLdapInlineStatusInlineIPV4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterLdapInlineStatusInlineIPV4) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterLdapInlineStatusInlineIPV4) UnmarshalBinary(b []byte) error {
	var res ClusterLdapInlineStatusInlineIPV4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterLdapInlineStatusInlineIPV6 cluster ldap inline status inline ipv6
//
// swagger:model cluster_ldap_inline_status_inline_ipv6
type ClusterLdapInlineStatusInlineIPV6 struct {

	// Code corresponding to the error message. If there is no error, it is 0 to indicate success.
	//
	// Example: 65537300
	Code *int64 `json:"code,omitempty"`

	// dn messages
	DnMessages []*string `json:"dn_messages,omitempty"`

	// Provides additional details on the error.
	//
	Message *string `json:"message,omitempty"`

	// Status of the LDAP service.
	//
	// Enum: ["up","down"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster ldap inline status inline ipv6
func (m *ClusterLdapInlineStatusInlineIPV6) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterLdapInlineStatusInlineIpv6TypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["up","down"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterLdapInlineStatusInlineIpv6TypeStatePropEnum = append(clusterLdapInlineStatusInlineIpv6TypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status_inline_ipv6
	// ClusterLdapInlineStatusInlineIPV6
	// state
	// State
	// up
	// END DEBUGGING
	// ClusterLdapInlineStatusInlineIPV6StateUp captures enum value "up"
	ClusterLdapInlineStatusInlineIPV6StateUp string = "up"

	// BEGIN DEBUGGING
	// cluster_ldap_inline_status_inline_ipv6
	// ClusterLdapInlineStatusInlineIPV6
	// state
	// State
	// down
	// END DEBUGGING
	// ClusterLdapInlineStatusInlineIPV6StateDown captures enum value "down"
	ClusterLdapInlineStatusInlineIPV6StateDown string = "down"
)

// prop value enum
func (m *ClusterLdapInlineStatusInlineIPV6) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterLdapInlineStatusInlineIpv6TypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterLdapInlineStatusInlineIPV6) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"ipv6"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this cluster ldap inline status inline ipv6 based on context it is used
func (m *ClusterLdapInlineStatusInlineIPV6) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterLdapInlineStatusInlineIPV6) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterLdapInlineStatusInlineIPV6) UnmarshalBinary(b []byte) error {
	var res ClusterLdapInlineStatusInlineIPV6
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
