// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterMetrics Performance numbers, such as IOPS latency and throughput.
//
// swagger:model cluster_metrics
type ClusterMetrics struct {

	// links
	Links *ClusterMetricsInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *ClusterMetricsInlineIops `json:"iops,omitempty"`

	// latency
	Latency *ClusterMetricsInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *ClusterMetricsInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this cluster metrics
func (m *ClusterMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var clusterMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterMetricsTypeDurationPropEnum = append(clusterMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ClusterMetricsDurationPT15S captures enum value "PT15S"
	ClusterMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ClusterMetricsDurationPT4M captures enum value "PT4M"
	ClusterMetricsDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ClusterMetricsDurationPT30M captures enum value "PT30M"
	ClusterMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ClusterMetricsDurationPT2H captures enum value "PT2H"
	ClusterMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ClusterMetricsDurationP1D captures enum value "P1D"
	ClusterMetricsDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ClusterMetricsDurationPT5M captures enum value "PT5M"
	ClusterMetricsDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ClusterMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterMetrics) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var clusterMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterMetricsTypeStatusPropEnum = append(clusterMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterMetricsStatusOk captures enum value "ok"
	ClusterMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterMetricsStatusError captures enum value "error"
	ClusterMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterMetricsStatusPartialNoData captures enum value "partial_no_data"
	ClusterMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterMetricsStatusPartialOtherError captures enum value "partial_other_error"
	ClusterMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterMetricsStatusNegativeDelta captures enum value "negative_delta"
	ClusterMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// ClusterMetricsStatusNotFound captures enum value "not_found"
	ClusterMetricsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterMetricsStatusBackfilledData captures enum value "backfilled_data"
	ClusterMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterMetricsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// cluster_metrics
	// ClusterMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterMetricsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (m *ClusterMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterMetrics) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster metrics based on the context it is used
func (m *ClusterMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterMetrics) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterMetrics) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterMetrics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterMetrics) UnmarshalBinary(b []byte) error {
	var res ClusterMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterMetricsInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model cluster_metrics_inline_iops
type ClusterMetricsInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster metrics inline iops
func (m *ClusterMetricsInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster metrics inline iops based on the context it is used
func (m *ClusterMetricsInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterMetricsInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterMetricsInlineIops) UnmarshalBinary(b []byte) error {
	var res ClusterMetricsInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterMetricsInlineLatency The round trip latency in microseconds observed at the storage object.
//
// swagger:model cluster_metrics_inline_latency
type ClusterMetricsInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster metrics inline latency
func (m *ClusterMetricsInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster metrics inline latency based on the context it is used
func (m *ClusterMetricsInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterMetricsInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterMetricsInlineLatency) UnmarshalBinary(b []byte) error {
	var res ClusterMetricsInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterMetricsInlineLinks cluster metrics inline links
//
// swagger:model cluster_metrics_inline__links
type ClusterMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster metrics inline links
func (m *ClusterMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster metrics inline links based on the context it is used
func (m *ClusterMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterMetricsInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model cluster_metrics_inline_throughput
type ClusterMetricsInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this cluster metrics inline throughput
func (m *ClusterMetricsInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster metrics inline throughput based on the context it is used
func (m *ClusterMetricsInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterMetricsInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterMetricsInlineThroughput) UnmarshalBinary(b []byte) error {
	var res ClusterMetricsInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
