// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterNdmpProperties cluster ndmp properties
//
// swagger:model cluster_ndmp_properties
type ClusterNdmpProperties struct {

	// links
	Links *ClusterNdmpPropertiesInlineLinks `json:"_links,omitempty"`

	// Indicates whether NDMP is in node-scoped or SVM-scoped mode.
	// Enum: ["svm","node"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this cluster ndmp properties
func (m *ClusterNdmpProperties) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNdmpProperties) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var clusterNdmpPropertiesTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["svm","node"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterNdmpPropertiesTypeModePropEnum = append(clusterNdmpPropertiesTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_ndmp_properties
	// ClusterNdmpProperties
	// mode
	// Mode
	// svm
	// END DEBUGGING
	// ClusterNdmpPropertiesModeSvm captures enum value "svm"
	ClusterNdmpPropertiesModeSvm string = "svm"

	// BEGIN DEBUGGING
	// cluster_ndmp_properties
	// ClusterNdmpProperties
	// mode
	// Mode
	// node
	// END DEBUGGING
	// ClusterNdmpPropertiesModeNode captures enum value "node"
	ClusterNdmpPropertiesModeNode string = "node"
)

// prop value enum
func (m *ClusterNdmpProperties) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterNdmpPropertiesTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterNdmpProperties) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(m.Mode) { // not required
		return nil
	}

	// value enum
	if err := m.validateModeEnum("mode", "body", *m.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster ndmp properties based on the context it is used
func (m *ClusterNdmpProperties) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNdmpProperties) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNdmpProperties) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNdmpProperties) UnmarshalBinary(b []byte) error {
	var res ClusterNdmpProperties
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNdmpPropertiesInlineLinks cluster ndmp properties inline links
//
// swagger:model cluster_ndmp_properties_inline__links
type ClusterNdmpPropertiesInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster ndmp properties inline links
func (m *ClusterNdmpPropertiesInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNdmpPropertiesInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster ndmp properties inline links based on the context it is used
func (m *ClusterNdmpPropertiesInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNdmpPropertiesInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNdmpPropertiesInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNdmpPropertiesInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterNdmpPropertiesInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
