// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterNisService cluster nis service
//
// swagger:model cluster_nis_service
type ClusterNisService struct {

	// links
	Links *ClusterNisServiceInlineLinks `json:"_links,omitempty"`

	// An array of objects where each object represents the NIS server and it's status for a given NIS domain. It is an advanced field.
	// Read Only: true
	ClusterNisServiceInlineBindingDetails []*ClusterNisServiceInlineBindingDetailsInlineArrayItem `json:"binding_details,omitempty"`

	// cluster nis service inline bound servers
	// Read Only: true
	ClusterNisServiceInlineBoundServers []*string `json:"bound_servers,omitempty"`

	// A list of hostnames or IP addresses of NIS servers used
	// by the NIS domain configuration.
	//
	// Max Items: 10
	ClusterNisServiceInlineServers []*string `json:"servers,omitempty"`

	// The NIS domain to which this configuration belongs.
	//
	// Max Length: 64
	// Min Length: 1
	Domain *string `json:"domain,omitempty"`
}

// Validate validates this cluster nis service
func (m *ClusterNisService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterNisServiceInlineBindingDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterNisServiceInlineBoundServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterNisServiceInlineServers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDomain(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisService) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNisService) validateClusterNisServiceInlineBindingDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterNisServiceInlineBindingDetails) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterNisServiceInlineBindingDetails); i++ {
		if swag.IsZero(m.ClusterNisServiceInlineBindingDetails[i]) { // not required
			continue
		}

		if m.ClusterNisServiceInlineBindingDetails[i] != nil {
			if err := m.ClusterNisServiceInlineBindingDetails[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterNisService) validateClusterNisServiceInlineBoundServers(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterNisServiceInlineBoundServers) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterNisServiceInlineBoundServers); i++ {
		if swag.IsZero(m.ClusterNisServiceInlineBoundServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("bound_servers"+"."+strconv.Itoa(i), "body", *m.ClusterNisServiceInlineBoundServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("bound_servers"+"."+strconv.Itoa(i), "body", *m.ClusterNisServiceInlineBoundServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (m *ClusterNisService) validateClusterNisServiceInlineServers(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterNisServiceInlineServers) { // not required
		return nil
	}

	iClusterNisServiceInlineServersSize := int64(len(m.ClusterNisServiceInlineServers))

	if err := validate.MaxItems("servers", "body", iClusterNisServiceInlineServersSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterNisServiceInlineServers); i++ {
		if swag.IsZero(m.ClusterNisServiceInlineServers[i]) { // not required
			continue
		}

		if err := validate.MinLength("servers"+"."+strconv.Itoa(i), "body", *m.ClusterNisServiceInlineServers[i], 1); err != nil {
			return err
		}

		if err := validate.MaxLength("servers"+"."+strconv.Itoa(i), "body", *m.ClusterNisServiceInlineServers[i], 255); err != nil {
			return err
		}

	}

	return nil
}

func (m *ClusterNisService) validateDomain(formats strfmt.Registry) error {
	if swag.IsZero(m.Domain) { // not required
		return nil
	}

	if err := validate.MinLength("domain", "body", *m.Domain, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("domain", "body", *m.Domain, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster nis service based on the context it is used
func (m *ClusterNisService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterNisServiceInlineBindingDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterNisServiceInlineBoundServers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisService) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterNisService) contextValidateClusterNisServiceInlineBindingDetails(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "binding_details", "body", []*ClusterNisServiceInlineBindingDetailsInlineArrayItem(m.ClusterNisServiceInlineBindingDetails)); err != nil {
		return err
	}

	for i := 0; i < len(m.ClusterNisServiceInlineBindingDetails); i++ {

		if m.ClusterNisServiceInlineBindingDetails[i] != nil {
			if err := m.ClusterNisServiceInlineBindingDetails[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("binding_details" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterNisService) contextValidateClusterNisServiceInlineBoundServers(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "bound_servers", "body", []*string(m.ClusterNisServiceInlineBoundServers)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNisService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNisService) UnmarshalBinary(b []byte) error {
	var res ClusterNisService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNisServiceInlineBindingDetailsInlineArrayItem cluster nis service inline binding details inline array item
//
// swagger:model cluster_nis_service_inline_binding_details_inline_array_item
type ClusterNisServiceInlineBindingDetailsInlineArrayItem struct {

	// Hostname/IP address of the NIS server in the domain.
	// Max Length: 255
	// Min Length: 1
	Server *string `json:"server,omitempty"`

	// status
	Status *BindingStatus `json:"status,omitempty"`
}

// Validate validates this cluster nis service inline binding details inline array item
func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateServer(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) validateServer(formats strfmt.Registry) error {
	if swag.IsZero(m.Server) { // not required
		return nil
	}

	if err := validate.MinLength("server", "body", *m.Server, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("server", "body", *m.Server, 255); err != nil {
		return err
	}

	return nil
}

func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nis service inline binding details inline array item based on the context it is used
func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNisServiceInlineBindingDetailsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ClusterNisServiceInlineBindingDetailsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterNisServiceInlineLinks cluster nis service inline links
//
// swagger:model cluster_nis_service_inline__links
type ClusterNisServiceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster nis service inline links
func (m *ClusterNisServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster nis service inline links based on the context it is used
func (m *ClusterNisServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterNisServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterNisServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterNisServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterNisServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
