// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterPeer cluster peer
//
// swagger:model cluster_peer
type ClusterPeer struct {

	// links
	Links *ClusterPeerInlineLinks `json:"_links,omitempty"`

	// authentication
	Authentication *ClusterPeerInlineAuthentication `json:"authentication,omitempty"`

	// The local SVMs allowed to peer with the peer cluster's SVMs. This list can be modified until the remote cluster accepts this cluster peering relationship.
	ClusterPeerInlineInitialAllowedSvms []*ClusterPeerInlineInitialAllowedSvmsInlineArrayItem `json:"initial_allowed_svms,omitempty"`

	// Peering applications against which allowed SVMs are configured.
	// Example: ["snapmirror","flexcache"]
	ClusterPeerInlinePeerApplications []*SvmPeerPermissionApplications `json:"peer_applications,omitempty"`

	// encryption
	Encryption *ClusterPeerInlineEncryption `json:"encryption,omitempty"`

	// A local intercluster IP address that a remote cluster can use, together with the passphrase, to create a cluster peer relationship with the local cluster.
	// Read Only: true
	IPAddress *IPAddress `json:"ip_address,omitempty"`

	// ipspace
	Ipspace *ClusterPeerInlineIpspace `json:"ipspace,omitempty"`

	// local network
	LocalNetwork *ClusterPeerInlineLocalNetwork `json:"local_network,omitempty"`

	// Optional name for the cluster peer relationship. By default, it is the name of the remote cluster, or a temporary name might be autogenerated for anonymous cluster peer offers.
	// Example: cluster2
	Name *string `json:"name,omitempty"`

	// remote
	Remote *ClusterPeerInlineRemote `json:"remote,omitempty"`

	// status
	Status *ClusterPeerInlineStatus `json:"status,omitempty"`

	// UUID of the cluster peer relationship. For anonymous cluster peer offers, the UUID will change when the remote cluster accepts the relationship.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// version
	Version *ClusterPeerInlineVersion `json:"version,omitempty"`
}

// Validate validates this cluster peer
func (m *ClusterPeer) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAuthentication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterPeerInlineInitialAllowedSvms(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClusterPeerInlinePeerApplications(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIpspace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocalNetwork(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVersion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeer) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateAuthentication(formats strfmt.Registry) error {
	if swag.IsZero(m.Authentication) { // not required
		return nil
	}

	if m.Authentication != nil {
		if err := m.Authentication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authentication")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateClusterPeerInlineInitialAllowedSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterPeerInlineInitialAllowedSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterPeerInlineInitialAllowedSvms); i++ {
		if swag.IsZero(m.ClusterPeerInlineInitialAllowedSvms[i]) { // not required
			continue
		}

		if m.ClusterPeerInlineInitialAllowedSvms[i] != nil {
			if err := m.ClusterPeerInlineInitialAllowedSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initial_allowed_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterPeer) validateClusterPeerInlinePeerApplications(formats strfmt.Registry) error {
	if swag.IsZero(m.ClusterPeerInlinePeerApplications) { // not required
		return nil
	}

	for i := 0; i < len(m.ClusterPeerInlinePeerApplications); i++ {
		if swag.IsZero(m.ClusterPeerInlinePeerApplications[i]) { // not required
			continue
		}

		if m.ClusterPeerInlinePeerApplications[i] != nil {
			if err := m.ClusterPeerInlinePeerApplications[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("peer_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterPeer) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(m.Encryption) { // not required
		return nil
	}

	if m.Encryption != nil {
		if err := m.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateIPAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAddress) { // not required
		return nil
	}

	if m.IPAddress != nil {
		if err := m.IPAddress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateIpspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Ipspace) { // not required
		return nil
	}

	if m.Ipspace != nil {
		if err := m.Ipspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateLocalNetwork(formats strfmt.Registry) error {
	if swag.IsZero(m.LocalNetwork) { // not required
		return nil
	}

	if m.LocalNetwork != nil {
		if err := m.LocalNetwork.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_network")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(m.Remote) { // not required
		return nil
	}

	if m.Remote != nil {
		if err := m.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) validateVersion(formats strfmt.Registry) error {
	if swag.IsZero(m.Version) { // not required
		return nil
	}

	if m.Version != nil {
		if err := m.Version.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer based on the context it is used
func (m *ClusterPeer) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAuthentication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterPeerInlineInitialAllowedSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClusterPeerInlinePeerApplications(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIPAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIpspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalNetwork(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeer) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateAuthentication(ctx context.Context, formats strfmt.Registry) error {

	if m.Authentication != nil {
		if err := m.Authentication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authentication")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateClusterPeerInlineInitialAllowedSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ClusterPeerInlineInitialAllowedSvms); i++ {

		if m.ClusterPeerInlineInitialAllowedSvms[i] != nil {
			if err := m.ClusterPeerInlineInitialAllowedSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initial_allowed_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterPeer) contextValidateClusterPeerInlinePeerApplications(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ClusterPeerInlinePeerApplications); i++ {

		if m.ClusterPeerInlinePeerApplications[i] != nil {
			if err := m.ClusterPeerInlinePeerApplications[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("peer_applications" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterPeer) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if m.Encryption != nil {
		if err := m.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("encryption")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateIPAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.IPAddress != nil {
		if err := m.IPAddress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateIpspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Ipspace != nil {
		if err := m.Ipspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateLocalNetwork(ctx context.Context, formats strfmt.Registry) error {

	if m.LocalNetwork != nil {
		if err := m.LocalNetwork.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("local_network")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if m.Remote != nil {
		if err := m.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remote")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeer) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeer) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if m.Version != nil {
		if err := m.Version.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("version")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeer) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeer) UnmarshalBinary(b []byte) error {
	var res ClusterPeer
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineAuthentication cluster peer inline authentication
//
// swagger:model cluster_peer_inline_authentication
type ClusterPeerInlineAuthentication struct {

	// The time when the passphrase will expire, in ISO 8601 duration format or date and time format.  The default is 1 hour.
	// Example: P1DT2H3M4S or '2017-01-25T11:20:13Z'
	ExpiryTime *string `json:"expiry_time,omitempty"`

	// Auto generate a passphrase when true.
	GeneratePassphrase *bool `json:"generate_passphrase,omitempty"`

	// in use
	// Enum: ["ok","absent","revoked"]
	InUse *string `json:"in_use,omitempty"`

	// A password to authenticate the cluster peer relationship.
	Passphrase *string `json:"passphrase,omitempty"`

	// state
	// Read Only: true
	// Enum: ["ok","absent","pending","problem"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster peer inline authentication
func (m *ClusterPeerInlineAuthentication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInUse(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineAuthenticationTypeInUsePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","absent","revoked"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineAuthenticationTypeInUsePropEnum = append(clusterPeerInlineAuthenticationTypeInUsePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// ok
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseOk captures enum value "ok"
	ClusterPeerInlineAuthenticationInUseOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// absent
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseAbsent captures enum value "absent"
	ClusterPeerInlineAuthenticationInUseAbsent string = "absent"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// in_use
	// InUse
	// revoked
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationInUseRevoked captures enum value "revoked"
	ClusterPeerInlineAuthenticationInUseRevoked string = "revoked"
)

// prop value enum
func (m *ClusterPeerInlineAuthentication) validateInUseEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineAuthenticationTypeInUsePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterPeerInlineAuthentication) validateInUse(formats strfmt.Registry) error {
	if swag.IsZero(m.InUse) { // not required
		return nil
	}

	// value enum
	if err := m.validateInUseEnum("authentication"+"."+"in_use", "body", *m.InUse); err != nil {
		return err
	}

	return nil
}

var clusterPeerInlineAuthenticationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","absent","pending","problem"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineAuthenticationTypeStatePropEnum = append(clusterPeerInlineAuthenticationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// ok
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateOk captures enum value "ok"
	ClusterPeerInlineAuthenticationStateOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// absent
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateAbsent captures enum value "absent"
	ClusterPeerInlineAuthenticationStateAbsent string = "absent"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// pending
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStatePending captures enum value "pending"
	ClusterPeerInlineAuthenticationStatePending string = "pending"

	// BEGIN DEBUGGING
	// cluster_peer_inline_authentication
	// ClusterPeerInlineAuthentication
	// state
	// State
	// problem
	// END DEBUGGING
	// ClusterPeerInlineAuthenticationStateProblem captures enum value "problem"
	ClusterPeerInlineAuthenticationStateProblem string = "problem"
)

// prop value enum
func (m *ClusterPeerInlineAuthentication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineAuthenticationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterPeerInlineAuthentication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("authentication"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline authentication based on the context it is used
func (m *ClusterPeerInlineAuthentication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineAuthentication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "authentication"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineAuthentication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineAuthentication) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineAuthentication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineEncryption cluster peer inline encryption
//
// swagger:model cluster_peer_inline_encryption
type ClusterPeerInlineEncryption struct {

	// proposed
	// Enum: ["none","tls_psk"]
	Proposed *string `json:"proposed,omitempty"`

	// state
	// Read Only: true
	// Enum: ["none","tls_psk"]
	State *string `json:"state,omitempty"`
}

// Validate validates this cluster peer inline encryption
func (m *ClusterPeerInlineEncryption) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProposed(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineEncryptionTypeProposedPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","tls_psk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineEncryptionTypeProposedPropEnum = append(clusterPeerInlineEncryptionTypeProposedPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// proposed
	// Proposed
	// none
	// END DEBUGGING
	// ClusterPeerInlineEncryptionProposedNone captures enum value "none"
	ClusterPeerInlineEncryptionProposedNone string = "none"

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// proposed
	// Proposed
	// tls_psk
	// END DEBUGGING
	// ClusterPeerInlineEncryptionProposedTLSPsk captures enum value "tls_psk"
	ClusterPeerInlineEncryptionProposedTLSPsk string = "tls_psk"
)

// prop value enum
func (m *ClusterPeerInlineEncryption) validateProposedEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineEncryptionTypeProposedPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterPeerInlineEncryption) validateProposed(formats strfmt.Registry) error {
	if swag.IsZero(m.Proposed) { // not required
		return nil
	}

	// value enum
	if err := m.validateProposedEnum("encryption"+"."+"proposed", "body", *m.Proposed); err != nil {
		return err
	}

	return nil
}

var clusterPeerInlineEncryptionTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["none","tls_psk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineEncryptionTypeStatePropEnum = append(clusterPeerInlineEncryptionTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// state
	// State
	// none
	// END DEBUGGING
	// ClusterPeerInlineEncryptionStateNone captures enum value "none"
	ClusterPeerInlineEncryptionStateNone string = "none"

	// BEGIN DEBUGGING
	// cluster_peer_inline_encryption
	// ClusterPeerInlineEncryption
	// state
	// State
	// tls_psk
	// END DEBUGGING
	// ClusterPeerInlineEncryptionStateTLSPsk captures enum value "tls_psk"
	ClusterPeerInlineEncryptionStateTLSPsk string = "tls_psk"
)

// prop value enum
func (m *ClusterPeerInlineEncryption) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineEncryptionTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterPeerInlineEncryption) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("encryption"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline encryption based on the context it is used
func (m *ClusterPeerInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineEncryption) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "encryption"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineEncryption) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineEncryption) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineInitialAllowedSvmsInlineArrayItem SVM, applies only to SVM-scoped objects.
//
// swagger:model cluster_peer_inline_initial_allowed_svms_inline_array_item
type ClusterPeerInlineInitialAllowedSvmsInlineArrayItem struct {

	// links
	Links *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster peer inline initial allowed svms inline array item
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline initial allowed svms inline array item based on the context it is used
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineInitialAllowedSvmsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks cluster peer inline initial allowed svms inline array item inline links
//
// swagger:model cluster_peer_inline_initial_allowed_svms_inline_array_item_inline__links
type ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline initial allowed svms inline array item inline links
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline initial allowed svms inline array item inline links based on the context it is used
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineInitialAllowedSvmsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineIpspace The IPspace of the local intercluster LIFs.
//
// swagger:model cluster_peer_inline_ipspace
type ClusterPeerInlineIpspace struct {

	// links
	Links *ClusterPeerInlineIpspaceInlineLinks `json:"_links,omitempty"`

	// IPspace name
	// Example: Default
	Name *string `json:"name,omitempty"`

	// IPspace UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cluster peer inline ipspace
func (m *ClusterPeerInlineIpspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineIpspace) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline ipspace based on the context it is used
func (m *ClusterPeerInlineIpspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineIpspace) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineIpspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineIpspace) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineIpspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineIpspaceInlineLinks cluster peer inline ipspace inline links
//
// swagger:model cluster_peer_inline_ipspace_inline__links
type ClusterPeerInlineIpspaceInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline ipspace inline links
func (m *ClusterPeerInlineIpspaceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineIpspaceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline ipspace inline links based on the context it is used
func (m *ClusterPeerInlineIpspaceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineIpspaceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ipspace" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineIpspaceInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineIpspaceInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineIpspaceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineLinks cluster peer inline links
//
// swagger:model cluster_peer_inline__links
type ClusterPeerInlineLinks struct {

	// interfaces
	Interfaces *Href `json:"interfaces,omitempty"`

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster peer inline links
func (m *ClusterPeerInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineLinks) validateInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.Interfaces) { // not required
		return nil
	}

	if m.Interfaces != nil {
		if err := m.Interfaces.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "interfaces")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeerInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer inline links based on the context it is used
func (m *ClusterPeerInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineLinks) contextValidateInterfaces(ctx context.Context, formats strfmt.Registry) error {

	if m.Interfaces != nil {
		if err := m.Interfaces.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "interfaces")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterPeerInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineLocalNetwork Cluster peering requires an intercluster LIF on each local node. These can be optionally created by specifying a list of IP addresses corresponding to each node.
//
// swagger:model cluster_peer_inline_local_network
type ClusterPeerInlineLocalNetwork struct {

	// Broadcast domain that is in use within the IPspace.
	// Example: bd1
	BroadcastDomain *string `json:"broadcast_domain,omitempty"`

	// The IPv4 or IPv6 address of the default router.
	// Example: 10.1.1.1
	Gateway *string `json:"gateway,omitempty"`

	// interfaces
	Interfaces []*ClusterPeerLocalNetworkInterfacesItems0 `json:"interfaces,omitempty"`

	// IPv4 mask or netmask length.
	// Example: 255.255.0.0
	Netmask *string `json:"netmask,omitempty"`
}

// Validate validates this cluster peer inline local network
func (m *ClusterPeerInlineLocalNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateInterfaces(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineLocalNetwork) validateInterfaces(formats strfmt.Registry) error {
	if swag.IsZero(m.Interfaces) { // not required
		return nil
	}

	for i := 0; i < len(m.Interfaces); i++ {
		if swag.IsZero(m.Interfaces[i]) { // not required
			continue
		}

		if m.Interfaces[i] != nil {
			if err := m.Interfaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("local_network" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster peer inline local network based on the context it is used
func (m *ClusterPeerInlineLocalNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateInterfaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineLocalNetwork) contextValidateInterfaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Interfaces); i++ {

		if m.Interfaces[i] != nil {
			if err := m.Interfaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("local_network" + "." + "interfaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineLocalNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineLocalNetwork) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineLocalNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerLocalNetworkInterfacesItems0 cluster peer local network interfaces items0
//
// swagger:model ClusterPeerLocalNetworkInterfacesItems0
type ClusterPeerLocalNetworkInterfacesItems0 struct {

	// List of local intercluster IP addresses.
	IPAddress *IPAddress `json:"ip_address,omitempty"`
}

// Validate validates this cluster peer local network interfaces items0
func (m *ClusterPeerLocalNetworkInterfacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerLocalNetworkInterfacesItems0) validateIPAddress(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAddress) { // not required
		return nil
	}

	if m.IPAddress != nil {
		if err := m.IPAddress.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster peer local network interfaces items0 based on the context it is used
func (m *ClusterPeerLocalNetworkInterfacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerLocalNetworkInterfacesItems0) contextValidateIPAddress(ctx context.Context, formats strfmt.Registry) error {

	if m.IPAddress != nil {
		if err := m.IPAddress.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ip_address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerLocalNetworkInterfacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerLocalNetworkInterfacesItems0) UnmarshalBinary(b []byte) error {
	var res ClusterPeerLocalNetworkInterfacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineRemote cluster peer inline remote
//
// swagger:model cluster_peer_inline_remote
type ClusterPeerInlineRemote struct {

	// The IPv4 addresses, IPv6 addresses, or hostnames of the peers.
	IPAddresses []*IPAddress `json:"ip_addresses,omitempty"`

	// The name of the remote cluster.
	// Example: cluster2
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The serial number of the remote cluster.
	// Example: 4048820-60-9
	// Read Only: true
	SerialNumber *string `json:"serial_number,omitempty"`
}

// Validate validates this cluster peer inline remote
func (m *ClusterPeerInlineRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIPAddresses(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineRemote) validateIPAddresses(formats strfmt.Registry) error {
	if swag.IsZero(m.IPAddresses) { // not required
		return nil
	}

	for i := 0; i < len(m.IPAddresses); i++ {
		if swag.IsZero(m.IPAddresses[i]) { // not required
			continue
		}

		if m.IPAddresses[i] != nil {
			if err := m.IPAddresses[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("remote" + "." + "ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster peer inline remote based on the context it is used
func (m *ClusterPeerInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIPAddresses(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineRemote) contextValidateIPAddresses(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.IPAddresses); i++ {

		if m.IPAddresses[i] != nil {
			if err := m.IPAddresses[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("remote" + "." + "ip_addresses" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterPeerInlineRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineRemote) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote"+"."+"serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineRemote) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineRemote) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineStatus cluster peer inline status
//
// swagger:model cluster_peer_inline_status
type ClusterPeerInlineStatus struct {

	// state
	// Example: available
	// Read Only: true
	// Enum: ["available","partial","unavailable","pending","unidentified"]
	State *string `json:"state,omitempty"`

	// The last time the state was updated.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`
}

// Validate validates this cluster peer inline status
func (m *ClusterPeerInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var clusterPeerInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","partial","unavailable","pending","unidentified"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterPeerInlineStatusTypeStatePropEnum = append(clusterPeerInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// available
	// END DEBUGGING
	// ClusterPeerInlineStatusStateAvailable captures enum value "available"
	ClusterPeerInlineStatusStateAvailable string = "available"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// partial
	// END DEBUGGING
	// ClusterPeerInlineStatusStatePartial captures enum value "partial"
	ClusterPeerInlineStatusStatePartial string = "partial"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// unavailable
	// END DEBUGGING
	// ClusterPeerInlineStatusStateUnavailable captures enum value "unavailable"
	ClusterPeerInlineStatusStateUnavailable string = "unavailable"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// pending
	// END DEBUGGING
	// ClusterPeerInlineStatusStatePending captures enum value "pending"
	ClusterPeerInlineStatusStatePending string = "pending"

	// BEGIN DEBUGGING
	// cluster_peer_inline_status
	// ClusterPeerInlineStatus
	// state
	// State
	// unidentified
	// END DEBUGGING
	// ClusterPeerInlineStatusStateUnidentified captures enum value "unidentified"
	ClusterPeerInlineStatusStateUnidentified string = "unidentified"
)

// prop value enum
func (m *ClusterPeerInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterPeerInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterPeerInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineStatus) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("status"+"."+"update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster peer inline status based on the context it is used
func (m *ClusterPeerInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineStatus) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineStatus) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status"+"."+"update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineStatus) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterPeerInlineVersion This returns the cluster version information.  When the cluster has more than one node, the cluster version is equivalent to the lowest of generation, major, and minor versions on all nodes.
//
// swagger:model cluster_peer_inline_version
type ClusterPeerInlineVersion struct {

	// The full cluster version string.
	// Example: NetApp Release 9.4.0: Sun Nov 05 18:20:57 UTC 2017
	// Read Only: true
	Full *string `json:"full,omitempty"`

	// The generation portion of the version.
	// Example: 9
	// Read Only: true
	Generation *int64 `json:"generation"`

	// The major portion of the version.
	// Example: 4
	// Read Only: true
	Major *int64 `json:"major"`

	// The minor portion of the version.
	// Example: 0
	// Read Only: true
	Minor *int64 `json:"minor"`
}

// Validate validates this cluster peer inline version
func (m *ClusterPeerInlineVersion) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster peer inline version based on the context it is used
func (m *ClusterPeerInlineVersion) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFull(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMajor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinor(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterPeerInlineVersion) contextValidateFull(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"full", "body", m.Full); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineVersion) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"generation", "body", m.Generation); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineVersion) contextValidateMajor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"major", "body", m.Major); err != nil {
		return err
	}

	return nil
}

func (m *ClusterPeerInlineVersion) contextValidateMinor(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "version"+"."+"minor", "body", m.Minor); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterPeerInlineVersion) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterPeerInlineVersion) UnmarshalBinary(b []byte) error {
	var res ClusterPeerInlineVersion
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
