// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterSpace Provides information on cluster-wide storage details across the different tiers. Storage details include storage efficiency, block storage and cloud storage information.
//
// swagger:model cluster_space
type ClusterSpace struct {

	// block storage
	BlockStorage *ClusterSpaceInlineBlockStorage `json:"block_storage,omitempty"`

	// cloud storage
	CloudStorage *ClusterSpaceInlineCloudStorage `json:"cloud_storage,omitempty"`

	// efficiency
	Efficiency *ClusterSpaceInlineEfficiency `json:"efficiency,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *ClusterSpaceInlineEfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// efficiency without snapshots flexclones
	EfficiencyWithoutSnapshotsFlexclones *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones `json:"efficiency_without_snapshots_flexclones,omitempty"`

	// metric
	Metric *ClusterSpaceInlineMetric `json:"metric,omitempty"`
}

// Validate validates this cluster space
func (m *ClusterSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCloudStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshotsFlexclones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpace) validateBlockStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockStorage) { // not required
		return nil
	}

	if m.BlockStorage != nil {
		if err := m.BlockStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) validateCloudStorage(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudStorage) { // not required
		return nil
	}

	if m.CloudStorage != nil {
		if err := m.CloudStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(m.Efficiency) { // not required
		return nil
	}

	if m.Efficiency != nil {
		if err := m.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) validateEfficiencyWithoutSnapshotsFlexclones(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshotsFlexclones) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster space based on the context it is used
func (m *ClusterSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBlockStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCloudStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpace) contextValidateBlockStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.BlockStorage != nil {
		if err := m.BlockStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("block_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) contextValidateCloudStorage(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudStorage != nil {
		if err := m.CloudStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if m.Efficiency != nil {
		if err := m.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpace) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpace) UnmarshalBinary(b []byte) error {
	var res ClusterSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineBlockStorage Configuration information for the locally attached portion of the storage across the cluster. When a cloud store is also used by the storage, this is referred to as the performance tier.
//
// swagger:model cluster_space_inline_block_storage
type ClusterSpaceInlineBlockStorage struct {

	// Available space across the cluster.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total delayed free space across the cluster.
	// Read Only: true
	DelayedFrees *int64 `json:"delayed_frees,omitempty"`

	// The cluster space full threshold percentage that triggers an EMS error.
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// Inactive data across the cluster.
	// Read Only: true
	InactiveData *int64 `json:"inactive_data,omitempty"`

	// The total space consumed by system logs and cores in the cluster.
	// Read Only: true
	LogAndRecoveryMetadata *int64 `json:"log_and_recovery_metadata,omitempty"`

	// Configuration information based on type of media. For example, SSD media type information includes the sum of all the SSD storage across the cluster.
	// Read Only: true
	Medias []*ClusterSpaceBlockStorageMediasItems0 `json:"medias,omitempty"`

	// The cluster space nearly full threshold percentage that triggers an EMS warning.
	NearlyFullThresholdPercent *int64 `json:"nearly_full_threshold_percent,omitempty"`

	// Total physical used space across the cluster.
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// The Physical space used percentage across the cluster.
	// Read Only: true
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// Total space across the cluster.
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// The total space consumed by metadata in the cluster, which includes log and recovery metadata, delayed frees along with filesystem metadata and performance metadata.
	// Read Only: true
	TotalMetadataUsed *int64 `json:"total_metadata_used,omitempty"`

	// Total unusable space across the cluster due to some aggregate being unavailable.
	// Read Only: true
	UnusableSpace *int64 `json:"unusable_space,omitempty"`

	// Used space (includes volume reserves) across the cluster.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this cluster space inline block storage
func (m *ClusterSpaceInlineBlockStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMedias(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineBlockStorage) validateMedias(formats strfmt.Registry) error {
	if swag.IsZero(m.Medias) { // not required
		return nil
	}

	for i := 0; i < len(m.Medias); i++ {
		if swag.IsZero(m.Medias[i]) { // not required
			continue
		}

		if m.Medias[i] != nil {
			if err := m.Medias[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "medias" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cluster space inline block storage based on the context it is used
func (m *ClusterSpaceInlineBlockStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDelayedFrees(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInactiveData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLogAndRecoveryMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMedias(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePhysicalUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalMetadataUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnusableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateDelayedFrees(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"delayed_frees", "body", m.DelayedFrees); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateInactiveData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"inactive_data", "body", m.InactiveData); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateLogAndRecoveryMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"log_and_recovery_metadata", "body", m.LogAndRecoveryMetadata); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateMedias(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"medias", "body", []*ClusterSpaceBlockStorageMediasItems0(m.Medias)); err != nil {
		return err
	}

	for i := 0; i < len(m.Medias); i++ {

		if m.Medias[i] != nil {
			if err := m.Medias[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("block_storage" + "." + "medias" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"physical_used", "body", m.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidatePhysicalUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"physical_used_percent", "body", m.PhysicalUsedPercent); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateTotalMetadataUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"total_metadata_used", "body", m.TotalMetadataUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateUnusableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"unusable_space", "body", m.UnusableSpace); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineBlockStorage) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "block_storage"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineBlockStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineBlockStorage) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineBlockStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceBlockStorageMediasItems0 cluster space block storage medias items0
//
// swagger:model ClusterSpaceBlockStorageMediasItems0
type ClusterSpaceBlockStorageMediasItems0 struct {

	// Available space across the cluster based on media type.
	Available *int64 `json:"available,omitempty"`

	// efficiency
	Efficiency *ClusterSpaceBlockStorageMediasItems0Efficiency `json:"efficiency,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// efficiency without snapshots flexclones
	EfficiencyWithoutSnapshotsFlexclones *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones `json:"efficiency_without_snapshots_flexclones,omitempty"`

	// Total physical used space across the cluster based on media type.
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// Total space across the cluster based on media type.
	Size *int64 `json:"size,omitempty"`

	// The type of media being used.
	// Enum: ["hdd","hybrid","lun","ssd","vmdisk"]
	Type *string `json:"type,omitempty"`

	// Used space across the cluster based on media type.
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this cluster space block storage medias items0
func (m *ClusterSpaceBlockStorageMediasItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEfficiencyWithoutSnapshotsFlexclones(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(m.Efficiency) { // not required
		return nil
	}

	if m.Efficiency != nil {
		if err := m.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) validateEfficiencyWithoutSnapshotsFlexclones(formats strfmt.Registry) error {
	if swag.IsZero(m.EfficiencyWithoutSnapshotsFlexclones) { // not required
		return nil
	}

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

var clusterSpaceBlockStorageMediasItems0TypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hdd","hybrid","lun","ssd","vmdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterSpaceBlockStorageMediasItems0TypeTypePropEnum = append(clusterSpaceBlockStorageMediasItems0TypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0
	// ClusterSpaceBlockStorageMediasItems0
	// type
	// Type
	// hdd
	// END DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0TypeHdd captures enum value "hdd"
	ClusterSpaceBlockStorageMediasItems0TypeHdd string = "hdd"

	// BEGIN DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0
	// ClusterSpaceBlockStorageMediasItems0
	// type
	// Type
	// hybrid
	// END DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0TypeHybrid captures enum value "hybrid"
	ClusterSpaceBlockStorageMediasItems0TypeHybrid string = "hybrid"

	// BEGIN DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0
	// ClusterSpaceBlockStorageMediasItems0
	// type
	// Type
	// lun
	// END DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0TypeLun captures enum value "lun"
	ClusterSpaceBlockStorageMediasItems0TypeLun string = "lun"

	// BEGIN DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0
	// ClusterSpaceBlockStorageMediasItems0
	// type
	// Type
	// ssd
	// END DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0TypeSsd captures enum value "ssd"
	ClusterSpaceBlockStorageMediasItems0TypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0
	// ClusterSpaceBlockStorageMediasItems0
	// type
	// Type
	// vmdisk
	// END DEBUGGING
	// ClusterSpaceBlockStorageMediasItems0TypeVmdisk captures enum value "vmdisk"
	ClusterSpaceBlockStorageMediasItems0TypeVmdisk string = "vmdisk"
)

// prop value enum
func (m *ClusterSpaceBlockStorageMediasItems0) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterSpaceBlockStorageMediasItems0TypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster space block storage medias items0 based on the context it is used
func (m *ClusterSpaceBlockStorageMediasItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if m.Efficiency != nil {
		if err := m.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshots != nil {
		if err := m.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0) contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if m.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := m.EfficiencyWithoutSnapshotsFlexclones.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceBlockStorageMediasItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceBlockStorageMediasItems0Efficiency Storage efficiency.
//
// swagger:model ClusterSpaceBlockStorageMediasItems0Efficiency
type ClusterSpaceBlockStorageMediasItems0Efficiency struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space block storage medias items0 efficiency
func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space block storage medias items0 efficiency based on the context it is used
func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0Efficiency) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceBlockStorageMediasItems0Efficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots.
//
// swagger:model ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots
type ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space block storage medias items0 efficiency without snapshots
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space block storage medias items0 efficiency without snapshots based on the context it is used
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones Storage efficiency that does not include the savings provided by snapshots and FlexClone volumes.
//
// swagger:model ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones
type ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space block storage medias items0 efficiency without snapshots flexclones
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space block storage medias items0 efficiency without snapshots flexclones based on the context it is used
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceBlockStorageMediasItems0EfficiencyWithoutSnapshotsFlexclones
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineCloudStorage Configuration information for the cloud storage portion of all the aggregates across the cluster. This is referred to as the capacity tier.
//
// swagger:model cluster_space_inline_cloud_storage
type ClusterSpaceInlineCloudStorage struct {

	// Total space used in cloud.
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this cluster space inline cloud storage
func (m *ClusterSpaceInlineCloudStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space inline cloud storage based on the context it is used
func (m *ClusterSpaceInlineCloudStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineCloudStorage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineCloudStorage) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineCloudStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineEfficiency Storage efficiency.
//
// swagger:model cluster_space_inline_efficiency
type ClusterSpaceInlineEfficiency struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space inline efficiency
func (m *ClusterSpaceInlineEfficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space inline efficiency based on the context it is used
func (m *ClusterSpaceInlineEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineEfficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiency) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineEfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots.
//
// swagger:model cluster_space_inline_efficiency_without_snapshots
type ClusterSpaceInlineEfficiencyWithoutSnapshots struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space inline efficiency without snapshots
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space inline efficiency without snapshots based on the context it is used
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineEfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones Storage efficiency that does not include the savings provided by snapshots and FlexClone volumes.
//
// swagger:model cluster_space_inline_efficiency_without_snapshots_flexclones
type ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this cluster space inline efficiency without snapshots flexclones
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cluster space inline efficiency without snapshots flexclones based on the context it is used
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"logical_used", "body", m.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"ratio", "body", m.Ratio); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "efficiency_without_snapshots_flexclones"+"."+"savings", "body", m.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineEfficiencyWithoutSnapshotsFlexclones
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineMetric Cluster capacity numbers, such as total size, used size, and available size.
//
// swagger:model cluster_space_inline_metric
type ClusterSpaceInlineMetric struct {

	// links
	Links *ClusterSpaceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The total size available in the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSize *int64 `json:"available_size,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance and capacity data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total size of the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	TotalSize *int64 `json:"total_size,omitempty"`

	// The total size used in the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this cluster space inline metric
func (m *ClusterSpaceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var clusterSpaceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterSpaceInlineMetricTypeDurationPropEnum = append(clusterSpaceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationPT15S captures enum value "PT15S"
	ClusterSpaceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationPT4M captures enum value "PT4M"
	ClusterSpaceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationPT30M captures enum value "PT30M"
	ClusterSpaceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationPT2H captures enum value "PT2H"
	ClusterSpaceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationP1D captures enum value "P1D"
	ClusterSpaceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ClusterSpaceInlineMetricDurationPT5M captures enum value "PT5M"
	ClusterSpaceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ClusterSpaceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterSpaceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterSpaceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var clusterSpaceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterSpaceInlineMetricTypeStatusPropEnum = append(clusterSpaceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusOk captures enum value "ok"
	ClusterSpaceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusError captures enum value "error"
	ClusterSpaceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	ClusterSpaceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterSpaceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterSpaceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	ClusterSpaceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	ClusterSpaceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	ClusterSpaceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterSpaceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_space_inline_metric
	// ClusterSpaceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterSpaceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterSpaceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ClusterSpaceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterSpaceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterSpaceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster space inline metric based on the context it is used
func (m *ClusterSpaceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateAvailableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"available_size", "body", m.AvailableSize); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateTotalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"total_size", "body", m.TotalSize); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceInlineMetric) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"used_size", "body", m.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineMetric) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceInlineMetricInlineLinks cluster space inline metric inline links
//
// swagger:model cluster_space_inline_metric_inline__links
type ClusterSpaceInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster space inline metric inline links
func (m *ClusterSpaceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster space inline metric inline links based on the context it is used
func (m *ClusterSpaceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
