// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ClusterSpaceMetrics Cluster capacity numbers, such as total size, used size, and available size.
//
// swagger:model cluster_space_metrics
type ClusterSpaceMetrics struct {

	// links
	Links *ClusterSpaceMetricsInlineLinks `json:"_links,omitempty"`

	// The total size available in the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSize *int64 `json:"available_size,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// The timestamp of the performance and capacity data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total size of the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	TotalSize *int64 `json:"total_size,omitempty"`

	// The total size used in the cluster, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSize *int64 `json:"used_size,omitempty"`
}

// Validate validates this cluster space metrics
func (m *ClusterSpaceMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var clusterSpaceMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterSpaceMetricsTypeDurationPropEnum = append(clusterSpaceMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ClusterSpaceMetricsDurationPT15S captures enum value "PT15S"
	ClusterSpaceMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ClusterSpaceMetricsDurationPT4M captures enum value "PT4M"
	ClusterSpaceMetricsDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ClusterSpaceMetricsDurationPT30M captures enum value "PT30M"
	ClusterSpaceMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ClusterSpaceMetricsDurationPT2H captures enum value "PT2H"
	ClusterSpaceMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ClusterSpaceMetricsDurationP1D captures enum value "P1D"
	ClusterSpaceMetricsDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ClusterSpaceMetricsDurationPT5M captures enum value "PT5M"
	ClusterSpaceMetricsDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ClusterSpaceMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterSpaceMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterSpaceMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

var clusterSpaceMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		clusterSpaceMetricsTypeStatusPropEnum = append(clusterSpaceMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ClusterSpaceMetricsStatusOk captures enum value "ok"
	ClusterSpaceMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// ClusterSpaceMetricsStatusError captures enum value "error"
	ClusterSpaceMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ClusterSpaceMetricsStatusPartialNoData captures enum value "partial_no_data"
	ClusterSpaceMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ClusterSpaceMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ClusterSpaceMetricsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ClusterSpaceMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	ClusterSpaceMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ClusterSpaceMetricsStatusPartialOtherError captures enum value "partial_other_error"
	ClusterSpaceMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ClusterSpaceMetricsStatusNegativeDelta captures enum value "negative_delta"
	ClusterSpaceMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ClusterSpaceMetricsStatusBackfilledData captures enum value "backfilled_data"
	ClusterSpaceMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ClusterSpaceMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ClusterSpaceMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// cluster_space_metrics
	// ClusterSpaceMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ClusterSpaceMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ClusterSpaceMetricsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ClusterSpaceMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, clusterSpaceMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ClusterSpaceMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this cluster space metrics based on the context it is used
func (m *ClusterSpaceMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailableSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateAvailableSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_size", "body", m.AvailableSize); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateTotalSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_size", "body", m.TotalSize); err != nil {
		return err
	}

	return nil
}

func (m *ClusterSpaceMetrics) contextValidateUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used_size", "body", m.UsedSize); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceMetrics) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ClusterSpaceMetricsInlineLinks cluster space metrics inline links
//
// swagger:model cluster_space_metrics_inline__links
type ClusterSpaceMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this cluster space metrics inline links
func (m *ClusterSpaceMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cluster space metrics inline links based on the context it is used
func (m *ClusterSpaceMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ClusterSpaceMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ClusterSpaceMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ClusterSpaceMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res ClusterSpaceMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
