// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConnectionStatus FlexCache Connection Status Endpoint
//
// swagger:model connection_status
type ConnectionStatus struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Connection Status between the Flexcache and Origin volumes.
	// Read Only: true
	// Enum: ["connected","disconnected","downrev","unknown"]
	ConnState *string `json:"conn_state,omitempty"`

	// Last update time of the connection status.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	LastUpdateTime *strfmt.DateTime `json:"last_update_time,omitempty"`

	// The local volume's Master Set ID.
	// Read Only: true
	LocalFgMsid *int64 `json:"local_fg_msid,omitempty"`

	// Name of the node.
	// Read Only: true
	Node *string `json:"node,omitempty"`

	// Remote cluster.
	// Read Only: true
	RemoteCluster *string `json:"remote_cluster,omitempty"`

	// Remote endpoint type.
	// Read Only: true
	// Enum: ["cache","none","origin"]
	RemoteEndpoint *string `json:"remote_endpoint,omitempty"`

	// Remote volume SVM.
	// Read Only: true
	RemoteSvm *string `json:"remote_svm,omitempty"`

	// Remote SVM UUID.
	// Read Only: true
	RemoteSvmUUID *string `json:"remote_svm_uuid,omitempty"`

	// Remote volume's Master Set ID.
	// Read Only: true
	RemoteVolConstMsid *int64 `json:"remote_vol_const_msid,omitempty"`

	// Remote Volume name.
	// Read Only: true
	RemoteVolume *string `json:"remote_volume,omitempty"`

	// Volume SVM.
	// Read Only: true
	Svm *string `json:"svm,omitempty"`

	// Local SVM UUID.
	// Read Only: true
	SvmUUID *string `json:"svm_uuid,omitempty"`

	// Local Volume name.
	// Read Only: true
	Volume *string `json:"volume,omitempty"`
}

// Validate validates this connection status
func (m *ConnectionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectionStatus) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var connectionStatusTypeConnStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["connected","disconnected","downrev","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		connectionStatusTypeConnStatePropEnum = append(connectionStatusTypeConnStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// conn_state
	// ConnState
	// connected
	// END DEBUGGING
	// ConnectionStatusConnStateConnected captures enum value "connected"
	ConnectionStatusConnStateConnected string = "connected"

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// conn_state
	// ConnState
	// disconnected
	// END DEBUGGING
	// ConnectionStatusConnStateDisconnected captures enum value "disconnected"
	ConnectionStatusConnStateDisconnected string = "disconnected"

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// conn_state
	// ConnState
	// downrev
	// END DEBUGGING
	// ConnectionStatusConnStateDownrev captures enum value "downrev"
	ConnectionStatusConnStateDownrev string = "downrev"

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// conn_state
	// ConnState
	// unknown
	// END DEBUGGING
	// ConnectionStatusConnStateUnknown captures enum value "unknown"
	ConnectionStatusConnStateUnknown string = "unknown"
)

// prop value enum
func (m *ConnectionStatus) validateConnStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, connectionStatusTypeConnStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConnectionStatus) validateConnState(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnState) { // not required
		return nil
	}

	// value enum
	if err := m.validateConnStateEnum("conn_state", "body", *m.ConnState); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) validateLastUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_update_time", "body", "date-time", m.LastUpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var connectionStatusTypeRemoteEndpointPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cache","none","origin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		connectionStatusTypeRemoteEndpointPropEnum = append(connectionStatusTypeRemoteEndpointPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// remote_endpoint
	// RemoteEndpoint
	// cache
	// END DEBUGGING
	// ConnectionStatusRemoteEndpointCache captures enum value "cache"
	ConnectionStatusRemoteEndpointCache string = "cache"

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// remote_endpoint
	// RemoteEndpoint
	// none
	// END DEBUGGING
	// ConnectionStatusRemoteEndpointNone captures enum value "none"
	ConnectionStatusRemoteEndpointNone string = "none"

	// BEGIN DEBUGGING
	// connection_status
	// ConnectionStatus
	// remote_endpoint
	// RemoteEndpoint
	// origin
	// END DEBUGGING
	// ConnectionStatusRemoteEndpointOrigin captures enum value "origin"
	ConnectionStatusRemoteEndpointOrigin string = "origin"
)

// prop value enum
func (m *ConnectionStatus) validateRemoteEndpointEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, connectionStatusTypeRemoteEndpointPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConnectionStatus) validateRemoteEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteEndpoint) { // not required
		return nil
	}

	// value enum
	if err := m.validateRemoteEndpointEnum("remote_endpoint", "body", *m.RemoteEndpoint); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this connection status based on the context it is used
func (m *ConnectionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLastUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocalFgMsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteCluster(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteSvmUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteVolConstMsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvmUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectionStatus) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConnectionStatus) contextValidateConnState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "conn_state", "body", m.ConnState); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateLastUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_update_time", "body", m.LastUpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateLocalFgMsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "local_fg_msid", "body", m.LocalFgMsid); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "node", "body", m.Node); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteCluster(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_cluster", "body", m.RemoteCluster); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_endpoint", "body", m.RemoteEndpoint); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_svm", "body", m.RemoteSvm); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteSvmUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_svm_uuid", "body", m.RemoteSvmUUID); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteVolConstMsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_vol_const_msid", "body", m.RemoteVolConstMsid); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateRemoteVolume(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "remote_volume", "body", m.RemoteVolume); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm", "body", m.Svm); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateSvmUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "svm_uuid", "body", m.SvmUUID); err != nil {
		return err
	}

	return nil
}

func (m *ConnectionStatus) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "volume", "body", m.Volume); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConnectionStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConnectionStatus) UnmarshalBinary(b []byte) error {
	var res ConnectionStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
