// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ConnectionStatusResponse connection status response
//
// swagger:model connection_status_response
type ConnectionStatusResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// connection status response inline records
	ConnectionStatusResponseInlineRecords []*ConnectionStatus `json:"records,omitempty"`

	// Number of Records
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this connection status response
func (m *ConnectionStatusResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConnectionStatusResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectionStatusResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConnectionStatusResponse) validateConnectionStatusResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.ConnectionStatusResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.ConnectionStatusResponseInlineRecords); i++ {
		if swag.IsZero(m.ConnectionStatusResponseInlineRecords[i]) { // not required
			continue
		}

		if m.ConnectionStatusResponseInlineRecords[i] != nil {
			if err := m.ConnectionStatusResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this connection status response based on the context it is used
func (m *ConnectionStatusResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConnectionStatusResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConnectionStatusResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConnectionStatusResponse) contextValidateConnectionStatusResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConnectionStatusResponseInlineRecords); i++ {

		if m.ConnectionStatusResponseInlineRecords[i] != nil {
			if err := m.ConnectionStatusResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConnectionStatusResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConnectionStatusResponse) UnmarshalBinary(b []byte) error {
	var res ConnectionStatusResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
