// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroup consistency group
//
// swagger:model consistency_group
type ConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// application
	Application *ConsistencyGroupInlineApplication `json:"application,omitempty"`

	// clone
	Clone *ConsistencyGroupInlineClone `json:"clone,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	ConsistencyGroupInlineTags []*string `json:"_tags,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A consistency group can only be associated with one direct parent consistency group.
	//
	// Max Items: 5
	// Min Items: 0
	// Unique: true
	ConsistencyGroupInlineConsistencyGroups []*ConsistencyGroupInlineConsistencyGroupsInlineArrayItem `json:"consistency_groups,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	ConsistencyGroupInlineLuns []*ConsistencyGroupInlineLunsInlineArrayItem `json:"luns,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	ConsistencyGroupInlineNamespaces []*ConsistencyGroupInlineNamespacesInlineArrayItem `json:"namespaces,omitempty"`

	// Indicates the SnapMirror relationship of this consistency group.
	//
	// Read Only: true
	ConsistencyGroupInlineReplicationRelationships []*ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem `json:"replication_relationships,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	ConsistencyGroupInlineVolumes []*ConsistencyGroupInlineVolumesInlineArrayItem `json:"volumes,omitempty"`

	// map to
	MapTo *ConsistencyGroupInlineMapTo `json:"map_to,omitempty"`

	// metric
	Metric *ConsistencyGroupInlineMetric `json:"metric,omitempty"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupInlineQos `json:"qos,omitempty"`

	// Indicates whether or not replication has been enabled on this consistency group.
	//
	// Read Only: true
	Replicated *bool `json:"replicated,omitempty"`

	// Since support for this field is to be removed in the next release, use replication_relationships.is_source instead.
	//
	// Read Only: true
	ReplicationSource *bool `json:"replication_source,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupInlineRestoreTo `json:"restore_to,omitempty"`

	// snaplock
	Snaplock *ConsistencyGroupInlineSnaplock `json:"snaplock,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupInlineSpace `json:"space,omitempty"`

	// statistics
	Statistics *ConsistencyGroupInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *ConsistencyGroupInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupInlineTiering `json:"tiering,omitempty"`

	// unmap from
	UnmapFrom *ConsistencyGroupInlineUnmapFrom `json:"unmap_from,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Type of objects in the consistency group.
	// Example: luns
	// Enum: ["luns","namespaces","mixed"]
	VdiskType *string `json:"vdisk_type,omitempty"`
}

// Validate validates this consistency group
func (m *ConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineConsistencyGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineReplicationRelationships(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupInlineVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMapTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnmapFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVdiskType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineTags) { // not required
		return nil
	}

	iConsistencyGroupInlineTagsSize := int64(len(m.ConsistencyGroupInlineTags))

	if err := validate.MaxItems("_tags", "body", iConsistencyGroupInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineConsistencyGroups(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineConsistencyGroups) { // not required
		return nil
	}

	iConsistencyGroupInlineConsistencyGroupsSize := int64(len(m.ConsistencyGroupInlineConsistencyGroups))

	if err := validate.MinItems("consistency_groups", "body", iConsistencyGroupInlineConsistencyGroupsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("consistency_groups", "body", iConsistencyGroupInlineConsistencyGroupsSize, 5); err != nil {
		return err
	}

	if err := validate.UniqueItems("consistency_groups", "body", m.ConsistencyGroupInlineConsistencyGroups); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupInlineConsistencyGroups); i++ {
		if swag.IsZero(m.ConsistencyGroupInlineConsistencyGroups[i]) { // not required
			continue
		}

		if m.ConsistencyGroupInlineConsistencyGroups[i] != nil {
			if err := m.ConsistencyGroupInlineConsistencyGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineLuns(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineLuns) { // not required
		return nil
	}

	iConsistencyGroupInlineLunsSize := int64(len(m.ConsistencyGroupInlineLuns))

	if err := validate.MinItems("luns", "body", iConsistencyGroupInlineLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", m.ConsistencyGroupInlineLuns); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupInlineLuns); i++ {
		if swag.IsZero(m.ConsistencyGroupInlineLuns[i]) { // not required
			continue
		}

		if m.ConsistencyGroupInlineLuns[i] != nil {
			if err := m.ConsistencyGroupInlineLuns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineNamespaces) { // not required
		return nil
	}

	iConsistencyGroupInlineNamespacesSize := int64(len(m.ConsistencyGroupInlineNamespaces))

	if err := validate.MinItems("namespaces", "body", iConsistencyGroupInlineNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", m.ConsistencyGroupInlineNamespaces); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupInlineNamespaces); i++ {
		if swag.IsZero(m.ConsistencyGroupInlineNamespaces[i]) { // not required
			continue
		}

		if m.ConsistencyGroupInlineNamespaces[i] != nil {
			if err := m.ConsistencyGroupInlineNamespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineReplicationRelationships(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineReplicationRelationships) { // not required
		return nil
	}

	for i := 0; i < len(m.ConsistencyGroupInlineReplicationRelationships); i++ {
		if swag.IsZero(m.ConsistencyGroupInlineReplicationRelationships[i]) { // not required
			continue
		}

		if m.ConsistencyGroupInlineReplicationRelationships[i] != nil {
			if err := m.ConsistencyGroupInlineReplicationRelationships[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) validateConsistencyGroupInlineVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupInlineVolumes) { // not required
		return nil
	}

	iConsistencyGroupInlineVolumesSize := int64(len(m.ConsistencyGroupInlineVolumes))

	if err := validate.MinItems("volumes", "body", iConsistencyGroupInlineVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iConsistencyGroupInlineVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", m.ConsistencyGroupInlineVolumes); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupInlineVolumes); i++ {
		if swag.IsZero(m.ConsistencyGroupInlineVolumes[i]) { // not required
			continue
		}

		if m.ConsistencyGroupInlineVolumes[i] != nil {
			if err := m.ConsistencyGroupInlineVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) validateMapTo(formats strfmt.Registry) error {
	if swag.IsZero(m.MapTo) { // not required
		return nil
	}

	if m.MapTo != nil {
		if err := m.MapTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("map_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(m.Metric) { // not required
		return nil
	}

	if m.Metric != nil {
		if err := m.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentConsistencyGroup) { // not required
		return nil
	}

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(m.RestoreTo) { // not required
		return nil
	}

	if m.RestoreTo != nil {
		if err := m.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(m.Statistics) { // not required
		return nil
	}

	if m.Statistics != nil {
		if err := m.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) validateUnmapFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.UnmapFrom) { // not required
		return nil
	}

	if m.UnmapFrom != nil {
		if err := m.UnmapFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unmap_from")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupTypeVdiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["luns","namespaces","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupTypeVdiskTypePropEnum = append(consistencyGroupTypeVdiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group
	// ConsistencyGroup
	// vdisk_type
	// VdiskType
	// luns
	// END DEBUGGING
	// ConsistencyGroupVdiskTypeLuns captures enum value "luns"
	ConsistencyGroupVdiskTypeLuns string = "luns"

	// BEGIN DEBUGGING
	// consistency_group
	// ConsistencyGroup
	// vdisk_type
	// VdiskType
	// namespaces
	// END DEBUGGING
	// ConsistencyGroupVdiskTypeNamespaces captures enum value "namespaces"
	ConsistencyGroupVdiskTypeNamespaces string = "namespaces"

	// BEGIN DEBUGGING
	// consistency_group
	// ConsistencyGroup
	// vdisk_type
	// VdiskType
	// mixed
	// END DEBUGGING
	// ConsistencyGroupVdiskTypeMixed captures enum value "mixed"
	ConsistencyGroupVdiskTypeMixed string = "mixed"
)

// prop value enum
func (m *ConsistencyGroup) validateVdiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupTypeVdiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroup) validateVdiskType(formats strfmt.Registry) error {
	if swag.IsZero(m.VdiskType) { // not required
		return nil
	}

	// value enum
	if err := m.validateVdiskTypeEnum("vdisk_type", "body", *m.VdiskType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group based on the context it is used
func (m *ConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupInlineConsistencyGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupInlineLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupInlineNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupInlineReplicationRelationships(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupInlineVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMapTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReplicated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateReplicationSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnmapFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateConsistencyGroupInlineConsistencyGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupInlineConsistencyGroups); i++ {

		if m.ConsistencyGroupInlineConsistencyGroups[i] != nil {
			if err := m.ConsistencyGroupInlineConsistencyGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("consistency_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) contextValidateConsistencyGroupInlineLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupInlineLuns); i++ {

		if m.ConsistencyGroupInlineLuns[i] != nil {
			if err := m.ConsistencyGroupInlineLuns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) contextValidateConsistencyGroupInlineNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupInlineNamespaces); i++ {

		if m.ConsistencyGroupInlineNamespaces[i] != nil {
			if err := m.ConsistencyGroupInlineNamespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) contextValidateConsistencyGroupInlineReplicationRelationships(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication_relationships", "body", []*ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem(m.ConsistencyGroupInlineReplicationRelationships)); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupInlineReplicationRelationships); i++ {

		if m.ConsistencyGroupInlineReplicationRelationships[i] != nil {
			if err := m.ConsistencyGroupInlineReplicationRelationships[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("replication_relationships" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) contextValidateConsistencyGroupInlineVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupInlineVolumes); i++ {

		if m.ConsistencyGroupInlineVolumes[i] != nil {
			if err := m.ConsistencyGroupInlineVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroup) contextValidateMapTo(ctx context.Context, formats strfmt.Registry) error {

	if m.MapTo != nil {
		if err := m.MapTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("map_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if m.Metric != nil {
		if err := m.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateReplicated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replicated", "body", m.Replicated); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateReplicationSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "replication_source", "body", m.ReplicationSource); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if m.RestoreTo != nil {
		if err := m.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if m.Statistics != nil {
		if err := m.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateUnmapFrom(ctx context.Context, formats strfmt.Registry) error {

	if m.UnmapFrom != nil {
		if err := m.UnmapFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("unmap_from")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineApplication consistency group inline application
//
// swagger:model consistency_group_inline_application
type ConsistencyGroupInlineApplication struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group inline application
func (m *ConsistencyGroupInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineApplicationTypeComponentTypePropEnum = append(consistencyGroupInlineApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupInlineApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupInlineApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupInlineApplicationComponentTypeOther string = "other"
)

// prop value enum
func (m *ConsistencyGroupInlineApplication) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineApplication) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(m.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := m.validateComponentTypeEnum("application"+"."+"component_type", "body", *m.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupInlineApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineApplicationTypeTypePropEnum = append(consistencyGroupInlineApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupInlineApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeOther captures enum value "other"
	ConsistencyGroupInlineApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupInlineApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupInlineApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupInlineApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupInlineApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupInlineApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupInlineApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupInlineApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupInlineApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupInlineApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// consistency_group_inline_application
	// ConsistencyGroupInlineApplication
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupInlineApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupInlineApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (m *ConsistencyGroupInlineApplication) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineApplication) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("application"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline application based on context it is used
func (m *ConsistencyGroupInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineApplication) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineClone Creates a clone of an existing consistency group from the current contents or an existing snapshot.
//
// swagger:model consistency_group_inline_clone
type ConsistencyGroupInlineClone struct {

	// guarantee
	Guarantee *ConsistencyGroupInlineCloneInlineGuarantee `json:"guarantee,omitempty"`

	// Specifies if the consistency group contains any unsplit FlexClone storage units.
	// Read Only: true
	HasUnsplitFlexclones *bool `json:"has_unsplit_flexclones,omitempty"`

	// Specifies if this consistency group is a FlexClone of a consistency group.
	// Read Only: true
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupInlineCloneInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// parent snapshot
	ParentSnapshot *ConsistencyGroupInlineCloneInlineParentSnapshot `json:"parent_snapshot,omitempty"`

	// parent svm
	ParentSvm *ConsistencyGroupInlineCloneInlineParentSvm `json:"parent_svm,omitempty"`

	// Specifies the SnapLock type for the clone consistency group.
	// Enum: ["compliance","enterprise","non_snaplock"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// Percentage of FlexClone blocks split from its parent consistency group.
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required to split the FlexClone consistency group.
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// Splits volumes after cloning. Defaults to false during POST. Only accepts true during a PATCH.
	SplitInitiated *bool `json:"split_initiated,omitempty"`

	// storage unit
	StorageUnit *ConsistencyGroupInlineCloneInlineStorageUnit `json:"storage_unit,omitempty"`

	// A list of unsplit FlexClone storage units in the consistency group.
	// Read Only: true
	UnsplitFlexclones []*string `json:"unsplit_flexclones,omitempty"`

	// volume
	Volume *ConsistencyGroupInlineCloneInlineVolume `json:"volume,omitempty"`
}

// Validate validates this consistency group inline clone
func (m *ConsistencyGroupInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineClone) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentConsistencyGroup) { // not required
		return nil
	}

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) validateParentSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSnapshot) { // not required
		return nil
	}

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) validateParentSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSvm) { // not required
		return nil
	}

	if m.ParentSvm != nil {
		if err := m.ParentSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineCloneTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineCloneTypeSnaplockTypePropEnum = append(consistencyGroupInlineCloneTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_clone
	// ConsistencyGroupInlineClone
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// ConsistencyGroupInlineCloneSnaplockTypeCompliance captures enum value "compliance"
	ConsistencyGroupInlineCloneSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// consistency_group_inline_clone
	// ConsistencyGroupInlineClone
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// ConsistencyGroupInlineCloneSnaplockTypeEnterprise captures enum value "enterprise"
	ConsistencyGroupInlineCloneSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// consistency_group_inline_clone
	// ConsistencyGroupInlineClone
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// ConsistencyGroupInlineCloneSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ConsistencyGroupInlineCloneSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ConsistencyGroupInlineClone) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineCloneTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineClone) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnaplockTypeEnum("clone"+"."+"snaplock_type", "body", *m.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone based on the context it is used
func (m *ConsistencyGroupInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsFlexclone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateHasUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"has_unsplit_flexclones", "body", m.HasUnsplitFlexclones); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateIsFlexclone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"is_flexclone", "body", m.IsFlexclone); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateParentSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateParentSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSvm != nil {
		if err := m.ParentSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_complete_percent", "body", m.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"split_estimate", "body", m.SplitEstimate); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "clone"+"."+"unsplit_flexclones", "body", []*string(m.UnsplitFlexclones)); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineClone) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineClone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineGuarantee consistency group inline clone inline guarantee
//
// swagger:model consistency_group_inline_clone_inline_guarantee
type ConsistencyGroupInlineCloneInlineGuarantee struct {

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group inline clone inline guarantee
func (m *ConsistencyGroupInlineCloneInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineCloneInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineCloneInlineGuaranteeTypeTypePropEnum = append(consistencyGroupInlineCloneInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_clone_inline_guarantee
	// ConsistencyGroupInlineCloneInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// ConsistencyGroupInlineCloneInlineGuaranteeTypeVolume captures enum value "volume"
	ConsistencyGroupInlineCloneInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// consistency_group_inline_clone_inline_guarantee
	// ConsistencyGroupInlineCloneInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// ConsistencyGroupInlineCloneInlineGuaranteeTypeNone captures enum value "none"
	ConsistencyGroupInlineCloneInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (m *ConsistencyGroupInlineCloneInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineCloneInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("clone"+"."+"guarantee"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline clone inline guarantee based on context it is used
func (m *ConsistencyGroupInlineCloneInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineParentConsistencyGroup Consistency group that is to be cloned.
//
// swagger:model consistency_group_inline_clone_inline_parent_consistency_group
type ConsistencyGroupInlineCloneInlineParentConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	Name *string `json:"name,omitempty"`

	// The name of the parent consistency group used when cloning a child consistency group.
	ParentName *string `json:"parent_name,omitempty"`

	// The unique identifier of the parent consistency group used when cloning a child consistency group.
	ParentUUID *string `json:"parent_uuid,omitempty"`

	// The unique identifier of the consistency group.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline clone inline parent consistency group
func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone inline parent consistency group based on the context it is used
func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineParentSnapshot Consistency group that is to be cloned.
//
// swagger:model consistency_group_inline_clone_inline_parent_snapshot
type ConsistencyGroupInlineCloneInlineParentSnapshot struct {

	// links
	Links *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks `json:"_links,omitempty"`

	// name
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline clone inline parent snapshot
func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone inline parent snapshot based on the context it is used
func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineParentSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks consistency group inline clone inline parent snapshot inline links
//
// swagger:model consistency_group_inline_clone_inline_parent_snapshot_inline__links
type ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group inline clone inline parent snapshot inline links
func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone inline parent snapshot inline links based on the context it is used
func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineParentSnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineParentSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model consistency_group_inline_clone_inline_parent_svm
type ConsistencyGroupInlineCloneInlineParentSvm struct {

	// links
	Links *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline clone inline parent svm
func (m *ConsistencyGroupInlineCloneInlineParentSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone inline parent svm based on the context it is used
func (m *ConsistencyGroupInlineCloneInlineParentSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineParentSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineParentSvmInlineLinks consistency group inline clone inline parent svm inline links
//
// swagger:model consistency_group_inline_clone_inline_parent_svm_inline__links
type ConsistencyGroupInlineCloneInlineParentSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group inline clone inline parent svm inline links
func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline clone inline parent svm inline links based on the context it is used
func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineParentSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineParentSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineStorageUnit Storage unit name suffix/prefix for the cloned blocks. This is applied to all the vdisks, i.e. LUNs or NVMe namespaces within the consistency group.
//
// swagger:model consistency_group_inline_clone_inline_storage_unit
type ConsistencyGroupInlineCloneInlineStorageUnit struct {

	// Storage unit name prefix for cloned volume blocks.
	Prefix *string `json:"prefix,omitempty"`

	// Storage unit name suffix for cloned volume blocks.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group inline clone inline storage unit
func (m *ConsistencyGroupInlineCloneInlineStorageUnit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline clone inline storage unit based on context it is used
func (m *ConsistencyGroupInlineCloneInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineCloneInlineVolume Volume name suffix/prefix for the cloned volumes.
//
// swagger:model consistency_group_inline_clone_inline_volume
type ConsistencyGroupInlineCloneInlineVolume struct {

	// Volume name prefix for cloned volumes.
	Prefix *string `json:"prefix,omitempty"`

	// Volume name suffix for cloned volumes.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group inline clone inline volume
func (m *ConsistencyGroupInlineCloneInlineVolume) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline clone inline volume based on context it is used
func (m *ConsistencyGroupInlineCloneInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineCloneInlineVolume) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineCloneInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItem consistency group inline consistency groups inline array item
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItem struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	Tags []*string `json:"_tags"`

	// application
	Application *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication `json:"application,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Luns []*ConsistencyGroupConsistencyGroupsItems0LunsItems0 `json:"luns"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	Namespaces []*ConsistencyGroupConsistencyGroupsItems0NamespacesItems0 `json:"namespaces"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo `json:"restore_to,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// svm
	Svm *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	Volumes []*ConsistencyGroupConsistencyGroupsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this consistency group inline consistency groups inline array item
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(m.Tags) { // not required
		return nil
	}

	iTagsSize := int64(len(m.Tags))

	if err := validate.MaxItems("_tags", "body", iTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateLuns(formats strfmt.Registry) error {
	if swag.IsZero(m.Luns) { // not required
		return nil
	}

	iLunsSize := int64(len(m.Luns))

	if err := validate.MinItems("luns", "body", iLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", m.Luns); err != nil {
		return err
	}

	for i := 0; i < len(m.Luns); i++ {
		if swag.IsZero(m.Luns[i]) { // not required
			continue
		}

		if m.Luns[i] != nil {
			if err := m.Luns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(m.Namespaces) { // not required
		return nil
	}

	iNamespacesSize := int64(len(m.Namespaces))

	if err := validate.MinItems("namespaces", "body", iNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", m.Namespaces); err != nil {
		return err
	}

	for i := 0; i < len(m.Namespaces); i++ {
		if swag.IsZero(m.Namespaces[i]) { // not required
			continue
		}

		if m.Namespaces[i] != nil {
			if err := m.Namespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentConsistencyGroup) { // not required
		return nil
	}

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(m.RestoreTo) { // not required
		return nil
	}

	if m.RestoreTo != nil {
		if err := m.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(m.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", m.Volumes); err != nil {
		return err
	}

	for i := 0; i < len(m.Volumes); i++ {
		if swag.IsZero(m.Volumes[i]) { // not required
			continue
		}

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Luns); i++ {

		if m.Luns[i] != nil {
			if err := m.Luns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Namespaces); i++ {

		if m.Namespaces[i] != nil {
			if err := m.Namespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if m.RestoreTo != nil {
		if err := m.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Volumes); i++ {

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication consistency group inline consistency groups inline array item inline application
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_application
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline application
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeComponentTypePropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationComponentTypeOther string = "other"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(m.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := m.validateComponentTypeEnum("application"+"."+"component_type", "body", *m.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeTypePropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeOther captures enum value "other"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_application
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("application"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline consistency groups inline array item inline application based on context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0 A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0
type ConsistencyGroupConsistencyGroupsItems0LunsItems0 struct {

	// clone
	Clone *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.LunMaps); i++ {
		if swag.IsZero(m.LunMaps[i]) { // not required
			continue
		}

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum = append(consistencyGroupConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeHpux captures enum value "hpux"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeNetware captures enum value "netware"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeSolaris captures enum value "solaris"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeXen captures enum value "xen"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0OsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0LunsItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LunMaps); i++ {

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone
type ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone struct {

	// source
	Source *ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource `json:"source,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 clone
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 clone based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0Clone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource
type ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 clone source
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group consistency groups items0 luns items0 clone source based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0CloneSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0
type ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 lun maps items0
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 lun maps items0 based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
type ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 lun maps items0 igroup
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(m.Igroups); i++ {
		if swag.IsZero(m.Igroups[i]) { // not required
			continue
		}

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(m.Initiators); i++ {
		if swag.IsZero(m.Initiators[i]) { // not required
			continue
		}

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("igroup"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("igroup"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 lun maps items0 igroup based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Igroups); i++ {

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Initiators); i++ {

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group consistency groups items0 luns items0 lun maps items0 igroup igroups items0
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
type ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 lun maps items0 igroup igroups items0
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
type ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 lun maps items0 igroup initiators items0
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group consistency groups items0 luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions Options that are applied to the operation.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions
type ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 provisioning options
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group consistency groups items0 luns items0 provisioning options based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos consistency group consistency groups items0 luns items0 qos
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos
type ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos struct {

	// policy
	Policy *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 qos
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 qos based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy The QoS policy
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy
type ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 qos policy
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 qos policy based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", m.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", m.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", m.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", m.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0Space The storage space related properties of the LUN.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0Space
type ConsistencyGroupConsistencyGroupsItems0LunsItems0Space struct {

	// guarantee
	Guarantee *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 space
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 space based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee Properties that request and report the space guarantee for the LUN.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee
type ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group consistency groups items0 luns items0 space guarantee
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group consistency groups items0 luns items0 space guarantee based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0LunsItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0 An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0 struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum = append(consistencyGroupConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeAix captures enum value "aix"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeLinux captures enum value "linux"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeVmware captures enum value "vmware"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeWindows captures enum value "windows"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0OsTypeWindows string = "windows"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0NamespacesItems0TypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 namespaces items0 based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions Options that are applied to the operation.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0 provisioning options
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group consistency groups items0 namespaces items0 provisioning options based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space The storage space related properties of the NVMe namespace.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0 space
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum = append(consistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockSizeEnum("space"+"."+"block_size", "body", *m.BlockSize); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 namespaces items0 space based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0 space guarantee
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group consistency groups items0 namespaces items0 space guarantee based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SpaceGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status Status information about the NVMe namespace.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0 status
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum = append(consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline captures enum value "online"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum = append(consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateOffline captures enum value "offline"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateOnline captures enum value "online"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupConsistencyGroupsItems0NamespacesItems0StatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0NamespacesItems0StatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group consistency groups items0 namespaces items0 status based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0Status
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap
type ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group consistency groups items0 namespaces items0 subsystem map
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 namespaces items0 subsystem map based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0NamespacesItems0SubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup The parent consistency group.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_parent_consistency_group
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline parent consistency group
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline parent consistency group based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags"`
}

// Validate validates this consistency group inline consistency groups inline array item inline provisioning options
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(m.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(m.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline provisioning options based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options_inline_storage_service
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline provisioning options inline storage service
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline consistency groups inline array item inline provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos consistency group inline consistency groups inline array item inline qos
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_qos
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos struct {

	// policy
	Policy *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline qos
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline qos based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_qos_inline_policy
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline qos inline policy
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline qos inline policy based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo Use to restore a consistency group to a previous snapshot
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_restore_to
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline restore to
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline restore to based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot A consistency group's snapshot
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_restore_to_inline_snapshot
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline restore to inline snapshot
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline consistency groups inline array item inline restore to inline snapshot based on context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineRestoreToInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace Space information for the consistency group.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_space
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline space
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline consistency groups inline array item inline space based on context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_svm
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm struct {

	// links
	Links *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline svm
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline svm based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks consistency group inline consistency groups inline array item inline svm inline links
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_svm_inline__links
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline svm inline links
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline svm inline links based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering The tiering placement and policy definitions for volumes in this consistency group.
//
// swagger:model consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
type ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group inline consistency groups inline array item inline tiering
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypeControlPropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypePolicyPropEnum = append(consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_inline_consistency_groups_inline_array_item_inline_tiering
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline consistency groups inline array item inline tiering based on the context it is used
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineConsistencyGroupsInlineArrayItemInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0 consistency group consistency groups items0 tiering object stores items0
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0
type ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group consistency groups items0 tiering object stores items0
func (m *ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group consistency groups items0 tiering object stores items0 based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0 consistency group consistency groups items0 volumes items0
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0 struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas The CIFS share policy and/or export policies for this volume.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 nas
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(consistencyGroupConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 nas based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs consistency group consistency groups items0 volumes items0 nas cifs
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 nas cifs
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 nas cifs based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 nas export policy
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 nas export policy based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent consistency group consistency groups items0 volumes items0 nas junction parent
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 nas junction parent
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 nas junction parent based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions Options that are applied to the operation.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 provisioning options
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum = append(consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 provisioning options based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 provisioning options storage service
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum = append(consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue captures enum value "value"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group consistency groups items0 volumes items0 provisioning options storage service based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0ProvisioningOptionsStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos The QoS policy for this volume.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos struct {

	// policy
	Policy *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 qos
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 qos based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy The QoS policy
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 qos policy
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 qos policy based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space consistency group consistency groups items0 volumes items0 space
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 space
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 space based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering The tiering placement and policy definitions for this volume.
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 tiering
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum = append(consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum = append(consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupConsistencyGroupsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group consistency groups items0 volumes items0 tiering based on the context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 consistency group consistency groups items0 volumes items0 tiering object stores items0
//
// swagger:model ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
type ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group consistency groups items0 volumes items0 tiering object stores items0
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group consistency groups items0 volumes items0 tiering object stores items0 based on context it is used
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupConsistencyGroupsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItem A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model consistency_group_inline_luns_inline_array_item
type ConsistencyGroupInlineLunsInlineArrayItem struct {

	// clone
	Clone *ConsistencyGroupInlineLunsInlineArrayItemInlineClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupLunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupInlineLunsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline luns inline array item
func (m *ConsistencyGroupInlineLunsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.LunMaps); i++ {
		if swag.IsZero(m.LunMaps[i]) { // not required
			continue
		}

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupInlineLunsInlineArrayItemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineLunsInlineArrayItemTypeOsTypePropEnum = append(consistencyGroupInlineLunsInlineArrayItemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeAix captures enum value "aix"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeHpux captures enum value "hpux"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeLinux captures enum value "linux"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeNetware captures enum value "netware"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeVmware captures enum value "vmware"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindows captures enum value "windows"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item
	// ConsistencyGroupInlineLunsInlineArrayItem
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemOsTypeXen captures enum value "xen"
	ConsistencyGroupInlineLunsInlineArrayItemOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineLunsInlineArrayItemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline luns inline array item based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LunMaps); i++ {

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineClone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_clone
type ConsistencyGroupInlineLunsInlineArrayItemInlineClone struct {

	// source
	Source *ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource `json:"source,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline clone
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline luns inline array item inline clone based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineClone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_clone_inline_source
type ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline clone inline source
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline luns inline array item inline clone inline source based on context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupLunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
// swagger:model ConsistencyGroupLunsItems0LunMapsItems0
type ConsistencyGroupLunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupLunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group luns items0 lun maps items0
func (m *ConsistencyGroupLunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group luns items0 lun maps items0 based on the context it is used
func (m *ConsistencyGroupLunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupLunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupLunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
// swagger:model ConsistencyGroupLunsItems0LunMapsItems0Igroup
type ConsistencyGroupLunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group luns items0 lun maps items0 igroup
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(m.Igroups); i++ {
		if swag.IsZero(m.Igroups[i]) { // not required
			continue
		}

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(m.Initiators); i++ {
		if swag.IsZero(m.Initiators[i]) { // not required
			continue
		}

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("igroup"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupLunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("igroup"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group luns items0 lun maps items0 igroup based on the context it is used
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Igroups); i++ {

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Initiators); i++ {

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupLunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group luns items0 lun maps items0 igroup igroups items0
//
// swagger:model ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0
type ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group luns items0 lun maps items0 igroup igroups items0
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupLunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
//
// swagger:model ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0
type ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group luns items0 lun maps items0 igroup initiators items0
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupLunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_provisioning_options
type ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline provisioning options
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_luns_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline luns inline array item inline provisioning options based on context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineQos consistency group inline luns inline array item inline qos
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_qos
type ConsistencyGroupInlineLunsInlineArrayItemInlineQos struct {

	// policy
	Policy *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline qos
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline luns inline array item inline qos based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_qos_inline_policy
type ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline qos inline policy
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline luns inline array item inline qos inline policy based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", m.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", m.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", m.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", m.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineSpace The storage space related properties of the LUN.
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_space
type ConsistencyGroupInlineLunsInlineArrayItemInlineSpace struct {

	// guarantee
	Guarantee *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline space
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline luns inline array item inline space based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the LUN.
//
// swagger:model consistency_group_inline_luns_inline_array_item_inline_space_inline_guarantee
type ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group inline luns inline array item inline space inline guarantee
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline luns inline array item inline space inline guarantee based on the context it is used
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineLunsInlineArrayItemInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMapTo Specifies the igroup or subsystem to map the LUNs or namespaces within the consistency group. This parameter can only be used if all the storage objects within the consistency groups are either LUNs or namespaces.
//
// swagger:model consistency_group_inline_map_to
type ConsistencyGroupInlineMapTo struct {

	// Name of the igroup or subsystem.
	// Example: igroup1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group inline map to
func (m *ConsistencyGroupInlineMapTo) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline map to based on context it is used
func (m *ConsistencyGroupInlineMapTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMapTo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMapTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMapTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMetric Performance and capacity numbers, such as, IOPS, latency, throughput, used space, and available space.
//
// swagger:model consistency_group_inline_metric
type ConsistencyGroupInlineMetric struct {

	// links
	Links *ConsistencyGroupInlineMetricInlineLinks `json:"_links,omitempty"`

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *ConsistencyGroupInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *ConsistencyGroupInlineMetricInlineLatency `json:"latency,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *ConsistencyGroupInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance and capacity data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total space used in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group inline metric
func (m *ConsistencyGroupInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineMetricTypeDurationPropEnum = append(consistencyGroupInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationPT15S captures enum value "PT15S"
	ConsistencyGroupInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationPT4M captures enum value "PT4M"
	ConsistencyGroupInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationPT30M captures enum value "PT30M"
	ConsistencyGroupInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationPT2H captures enum value "PT2H"
	ConsistencyGroupInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationP1D captures enum value "P1D"
	ConsistencyGroupInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ConsistencyGroupInlineMetricDurationPT5M captures enum value "PT5M"
	ConsistencyGroupInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ConsistencyGroupInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("metric"+"."+"duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineMetricTypeStatusPropEnum = append(consistencyGroupInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusOk captures enum value "ok"
	ConsistencyGroupInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusError captures enum value "error"
	ConsistencyGroupInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupInlineMetricStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_inline_metric
	// ConsistencyGroupInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ConsistencyGroupInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("metric"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("metric"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline metric based on the context it is used
func (m *ConsistencyGroupInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"available_space", "body", m.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineMetric) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "metric"+"."+"used_space", "body", m.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetric) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetric) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMetricInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model consistency_group_inline_metric_inline_iops
type ConsistencyGroupInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline metric inline iops
func (m *ConsistencyGroupInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline metric inline iops based on the context it is used
func (m *ConsistencyGroupInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMetricInlineLatency The round trip latency observed at the storage object, in microseconds.
//
// swagger:model consistency_group_inline_metric_inline_latency
type ConsistencyGroupInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline metric inline latency
func (m *ConsistencyGroupInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline metric inline latency based on the context it is used
func (m *ConsistencyGroupInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMetricInlineLinks consistency group inline metric inline links
//
// swagger:model consistency_group_inline_metric_inline__links
type ConsistencyGroupInlineMetricInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group inline metric inline links
func (m *ConsistencyGroupInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline metric inline links based on the context it is used
func (m *ConsistencyGroupInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model consistency_group_inline_metric_inline_throughput
type ConsistencyGroupInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline metric inline throughput
func (m *ConsistencyGroupInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline metric inline throughput based on the context it is used
func (m *ConsistencyGroupInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItem An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model consistency_group_inline_namespaces_inline_array_item
type ConsistencyGroupInlineNamespacesInlineArrayItem struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item
func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupInlineNamespacesInlineArrayItemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineNamespacesInlineArrayItemTypeOsTypePropEnum = append(consistencyGroupInlineNamespacesInlineArrayItemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item
	// ConsistencyGroupInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeAix captures enum value "aix"
	ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item
	// ConsistencyGroupInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeLinux captures enum value "linux"
	ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item
	// ConsistencyGroupInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeVmware captures enum value "vmware"
	ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item
	// ConsistencyGroupInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeWindows captures enum value "windows"
	ConsistencyGroupInlineNamespacesInlineArrayItemOsTypeWindows string = "windows"
)

// prop value enum
func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineNamespacesInlineArrayItemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline namespaces inline array item based on the context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_inline_namespaces_inline_array_item_inline_provisioning_options
type ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item inline provisioning options
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline namespaces inline array item inline provisioning options based on context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace The storage space related properties of the NVMe namespace.
//
// swagger:model consistency_group_inline_namespaces_inline_array_item_inline_space
type ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item inline space
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum = append(consistencyGroupInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockSizeEnum("space"+"."+"block_size", "body", *m.BlockSize); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline namespaces inline array item inline space based on the context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
// swagger:model consistency_group_inline_namespaces_inline_array_item_inline_space_inline_guarantee
type ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item inline space inline guarantee
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline namespaces inline array item inline space inline guarantee based on the context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus Status information about the NVMe namespace.
//
// swagger:model consistency_group_inline_namespaces_inline_array_item_inline_status
type ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item inline status
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum = append(consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateOnline captures enum value "online"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum = append(consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateOffline captures enum value "offline"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateOnline captures enum value "online"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// consistency_group_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline namespaces inline array item inline status based on context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItemInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
// swagger:model consistency_group_inline_namespaces_inline_array_item_inline_subsystem_map
type ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group inline namespaces inline array item inline subsystem map
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline namespaces inline array item inline subsystem map based on the context it is used
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineNamespacesInlineArrayItemInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineParentConsistencyGroup The parent consistency group.
//
// swagger:model consistency_group_inline_parent_consistency_group
type ConsistencyGroupInlineParentConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline parent consistency group
func (m *ConsistencyGroupInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline parent consistency group based on the context it is used
func (m *ConsistencyGroupInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_inline_provisioning_options
type ConsistencyGroupInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags,omitempty"`
}

// Validate validates this consistency group inline provisioning options
func (m *ConsistencyGroupInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options
	// ConsistencyGroupInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options
	// ConsistencyGroupInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options
	// ConsistencyGroupInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options
	// ConsistencyGroupInlineProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupInlineProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options
	// ConsistencyGroupInlineProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupInlineProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (m *ConsistencyGroupInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(m.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(m.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline provisioning options based on the context it is used
func (m *ConsistencyGroupInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_inline_provisioning_options_inline_storage_service
type ConsistencyGroupInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group inline provisioning options inline storage service
func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineQos consistency group inline qos
//
// swagger:model consistency_group_inline_qos
type ConsistencyGroupInlineQos struct {

	// policy
	Policy *ConsistencyGroupInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group inline qos
func (m *ConsistencyGroupInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline qos based on the context it is used
func (m *ConsistencyGroupInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_inline_qos_inline_policy
type ConsistencyGroupInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline qos inline policy
func (m *ConsistencyGroupInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline qos inline policy based on the context it is used
func (m *ConsistencyGroupInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem consistency group inline replication relationships inline array item
//
// swagger:model consistency_group_inline_replication_relationships_inline_array_item
type ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Indicates whether or not this consistency group is protected by SVM DR.
	//
	// Read Only: true
	IsProtectedBySvmDr *bool `json:"is_protected_by_svm_dr,omitempty"`

	// Indicates whether or not this consistency group is the source for replication.
	//
	// Read Only: true
	IsSource *bool `json:"is_source,omitempty"`

	// The unique identifier of the SnapMirror relationship.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline replication relationships inline array item
func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline replication relationships inline array item based on the context it is used
func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsProtectedBySvmDr(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) contextValidateIsProtectedBySvmDr(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_protected_by_svm_dr", "body", m.IsProtectedBySvmDr); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) contextValidateIsSource(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_source", "body", m.IsSource); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineReplicationRelationshipsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineRestoreTo Use to restore a consistency group to a previous snapshot
//
// swagger:model consistency_group_inline_restore_to
type ConsistencyGroupInlineRestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupInlineRestoreToInlineSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group inline restore to
func (m *ConsistencyGroupInlineRestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineRestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline restore to based on the context it is used
func (m *ConsistencyGroupInlineRestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineRestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineRestoreTo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineRestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineRestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineRestoreToInlineSnapshot A consistency group's snapshot
//
// swagger:model consistency_group_inline_restore_to_inline_snapshot
type ConsistencyGroupInlineRestoreToInlineSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline restore to inline snapshot
func (m *ConsistencyGroupInlineRestoreToInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline restore to inline snapshot based on context it is used
func (m *ConsistencyGroupInlineRestoreToInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineRestoreToInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineRestoreToInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineRestoreToInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineSnaplock consistency group inline snaplock
//
// swagger:model consistency_group_inline_snaplock
type ConsistencyGroupInlineSnaplock struct {

	// The compliance clock time used to manage the SnapLock objects in the consistency group.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ComplianceClockTime *strfmt.DateTime `json:"compliance_clock_time,omitempty"`

	// Expiry time of the consistency group. For consistency group with an infinite SnapLock expiry time, "9999-12-31T23:59:59" is used to denote the time.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	ExpiryTime *strfmt.DateTime `json:"expiry_time,omitempty"`

	// retention
	Retention *ConsistencyGroupInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the consistency group. <br>compliance &dash; A SnapLock Compliance (SLC) consistency group provides the highest level of WORM protection and an administrator cannot destroy an SLC consistency group if it contains unexpired WORM objects. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise (SLE) consistency group.<br> non_snaplock &dash; Indicates the consistency group is non-snaplock.
	// Example: enterprise
	// Read Only: true
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group inline snaplock
func (m *ConsistencyGroupInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComplianceClockTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSnaplock) validateComplianceClockTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ComplianceClockTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"compliance_clock_time", "body", "date-time", m.ComplianceClockTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineSnaplock) validateExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("snaplock"+"."+"expiry_time", "body", "date-time", m.ExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineSnaplockTypeTypePropEnum = append(consistencyGroupInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_snaplock
	// ConsistencyGroupInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// ConsistencyGroupInlineSnaplockTypeCompliance captures enum value "compliance"
	ConsistencyGroupInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// consistency_group_inline_snaplock
	// ConsistencyGroupInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// ConsistencyGroupInlineSnaplockTypeEnterprise captures enum value "enterprise"
	ConsistencyGroupInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// consistency_group_inline_snaplock
	// ConsistencyGroupInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// ConsistencyGroupInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ConsistencyGroupInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ConsistencyGroupInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("snaplock"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline snaplock based on the context it is used
func (m *ConsistencyGroupInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateComplianceClockTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSnaplock) contextValidateComplianceClockTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"compliance_clock_time", "body", m.ComplianceClockTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineSnaplock) contextValidateExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"expiry_time", "body", m.ExpiryTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineSnaplock) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snaplock"+"."+"type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineSnaplockInlineRetention The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
//
// swagger:model consistency_group_inline_snaplock_inline_retention
type ConsistencyGroupInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to objects within a consistency group while committing them to the WORM state without an associated retention period.
	// Example: P6M
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for objects committed to the WORM state on the consistency group.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for objects within a consistency group committed to the WORM state on the consistency group.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this consistency group inline snaplock inline retention
func (m *ConsistencyGroupInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline snaplock inline retention based on context it is used
func (m *ConsistencyGroupInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineSpace Space information for the consistency group.
//
// swagger:model consistency_group_inline_space
type ConsistencyGroupInlineSpace struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group inline space
func (m *ConsistencyGroupInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline space based on context it is used
func (m *ConsistencyGroupInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineStatistics These are raw performance and space numbers, such as, IOPS, latency, throughput, used space, and available space. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model consistency_group_inline_statistics
type ConsistencyGroupInlineStatistics struct {

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// iops raw
	IopsRaw *ConsistencyGroupInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *ConsistencyGroupInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *ConsistencyGroupInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total used space in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group inline statistics
func (m *ConsistencyGroupInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineStatisticsTypeStatusPropEnum = append(consistencyGroupInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusOk captures enum value "ok"
	ConsistencyGroupInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusError captures enum value "error"
	ConsistencyGroupInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_inline_statistics
	// ConsistencyGroupInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ConsistencyGroupInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("statistics"+"."+"status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("statistics"+"."+"timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline statistics based on the context it is used
func (m *ConsistencyGroupInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"available_space", "body", m.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineStatistics) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics"+"."+"used_space", "body", m.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model consistency_group_inline_statistics_inline_iops_raw
type ConsistencyGroupInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline statistics inline iops raw
func (m *ConsistencyGroupInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline statistics inline iops raw based on the context it is used
func (m *ConsistencyGroupInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineStatisticsInlineLatencyRaw The raw latency observed at the storage object, in microseconds. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model consistency_group_inline_statistics_inline_latency_raw
type ConsistencyGroupInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline statistics inline latency raw
func (m *ConsistencyGroupInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline statistics inline latency raw based on the context it is used
func (m *ConsistencyGroupInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model consistency_group_inline_statistics_inline_throughput_raw
type ConsistencyGroupInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group inline statistics inline throughput raw
func (m *ConsistencyGroupInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline statistics inline throughput raw based on the context it is used
func (m *ConsistencyGroupInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineSvm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
// swagger:model consistency_group_inline_svm
type ConsistencyGroupInlineSvm struct {

	// links
	Links *ConsistencyGroupInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline svm
func (m *ConsistencyGroupInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline svm based on the context it is used
func (m *ConsistencyGroupInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineSvmInlineLinks consistency group inline svm inline links
//
// swagger:model consistency_group_inline_svm_inline__links
type ConsistencyGroupInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group inline svm inline links
func (m *ConsistencyGroupInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline svm inline links based on the context it is used
func (m *ConsistencyGroupInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineTiering The tiering placement and policy definitions for volumes in this consistency group.
//
// swagger:model consistency_group_inline_tiering
type ConsistencyGroupInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group inline tiering
func (m *ConsistencyGroupInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineTieringTypeControlPropEnum = append(consistencyGroupInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineTieringTypePolicyPropEnum = append(consistencyGroupInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_inline_tiering
	// ConsistencyGroupInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline tiering based on the context it is used
func (m *ConsistencyGroupInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupTieringObjectStoresItems0 consistency group tiering object stores items0
//
// swagger:model ConsistencyGroupTieringObjectStoresItems0
type ConsistencyGroupTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group tiering object stores items0
func (m *ConsistencyGroupTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group tiering object stores items0 based on context it is used
func (m *ConsistencyGroupTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineUnmapFrom Specify the igroup or subsystem within the consistency group from which the LUNs or namespaces will be unmapped. This parameter can only be used if all the storage objects within the consistency groups are either LUNs or namespaces.
//
// swagger:model consistency_group_inline_unmap_from
type ConsistencyGroupInlineUnmapFrom struct {

	// Name of the igroup or subsystem.
	// Example: subsystem1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group inline unmap from
func (m *ConsistencyGroupInlineUnmapFrom) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group inline unmap from based on context it is used
func (m *ConsistencyGroupInlineUnmapFrom) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineUnmapFrom) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineUnmapFrom) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineUnmapFrom
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItem consistency group inline volumes inline array item
//
// swagger:model consistency_group_inline_volumes_inline_array_item
type ConsistencyGroupInlineVolumesInlineArrayItem struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item
func (m *ConsistencyGroupInlineVolumesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineNas The CIFS share policy and/or export policies for this volume.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_nas
type ConsistencyGroupInlineVolumesInlineArrayItemInlineNas struct {

	// cifs
	Cifs *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline nas
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum = append(consistencyGroupInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline nas based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs consistency group inline volumes inline array item inline nas inline cifs
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_nas_inline_cifs
type ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group inline volumes inline array item inline nas inline cifs
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline nas inline cifs based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_nas_inline_export_policy
type ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules"`
}

// Validate validates this consistency group inline volumes inline array item inline nas inline export policy
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline nas inline export policy based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent consistency group inline volumes inline array item inline nas inline junction parent
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_nas_inline_junction_parent
type ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline nas inline junction parent
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline nas inline junction parent based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_provisioning_options
type ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline provisioning options
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline provisioning options based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
type ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline provisioning options inline storage service
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group inline volumes inline array item inline provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineQos The QoS policy for this volume.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_qos
type ConsistencyGroupInlineVolumesInlineArrayItemInlineQos struct {

	// policy
	Policy *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline qos
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline qos based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_qos_inline_policy
type ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline qos inline policy
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline qos inline policy based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace consistency group inline volumes inline array item inline space
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_space
type ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline space
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline space based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering The tiering placement and policy definitions for this volume.
//
// swagger:model consistency_group_inline_volumes_inline_array_item_inline_tiering
type ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupVolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group inline volumes inline array item inline tiering
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum = append(consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum = append(consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group inline volumes inline array item inline tiering based on the context it is used
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupInlineVolumesInlineArrayItemInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupVolumesItems0TieringObjectStoresItems0 consistency group volumes items0 tiering object stores items0
//
// swagger:model ConsistencyGroupVolumesItems0TieringObjectStoresItems0
type ConsistencyGroupVolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group volumes items0 tiering object stores items0
func (m *ConsistencyGroupVolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group volumes items0 tiering object stores items0 based on context it is used
func (m *ConsistencyGroupVolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupVolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupVolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupVolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
