// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupChild consistency group child
//
// swagger:model consistency_group_child
type ConsistencyGroupChild struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// application
	Application *ConsistencyGroupChildInlineApplication `json:"application,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	ConsistencyGroupChildInlineTags []*string `json:"_tags,omitempty"`

	// The LUNs array can be used to create or modify LUNs in a consistency group on a new or existing volume that is a member of the consistency group. LUNs are considered members of a consistency group if they are located on a volume that is a member of the consistency group.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	ConsistencyGroupChildInlineLuns []*ConsistencyGroupChildInlineLunsInlineArrayItem `json:"luns,omitempty"`

	// An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the SVM using the NVMe over Fabrics protocol.
	// In ONTAP, an NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. NVMe namespaces support being cloned. An NVMe namespace cannot be renamed, resized, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace. See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
	// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.
	// <personalities supports=unified>The maximum number of items for this array is 16.</personalities>
	// <personalities supports=asar2>The maximum number of items for this array is 256.</personalities>
	//
	// Min Items: 0
	// Unique: true
	ConsistencyGroupChildInlineNamespaces []*ConsistencyGroupChildInlineNamespacesInlineArrayItem `json:"namespaces,omitempty"`

	// A consistency group is a mutually exclusive aggregation of volumes or other consistency groups. A volume can only be associated with one direct parent consistency group.<br/>
	// <personalities supports=unified>The volumes array can be used to create new volumes in the consistency group, add existing volumes to the consistency group, or modify existing volumes that are already members of the consistency group.<br/></personalities>
	// The total number of volumes across all child consistency groups contained in a consistency group is constrained by the same limit.
	//
	// Max Items: 80
	// Min Items: 0
	// Unique: true
	ConsistencyGroupChildInlineVolumes []*ConsistencyGroupChildInlineVolumesInlineArrayItem `json:"volumes,omitempty"`

	// Name of the consistency group. The consistency group name must be unique within an SVM.<br/>
	// <personalities supports=unified>If not provided and the consistency group contains only one volume, the name will be generated based on the volume name. If the consistency group contains more than one volume, the name is required.</personalities>
	//
	Name *string `json:"name,omitempty"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupChildInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupChildInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupChildInlineQos `json:"qos,omitempty"`

	// restore to
	RestoreTo *ConsistencyGroupChildInlineRestoreTo `json:"restore_to,omitempty"`

	// The snapshot policy of the consistency group.<br/>
	// This is the dedicated consistency group snapshot policy, not an aggregation of the volume granular snapshot policy.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupChildInlineSpace `json:"space,omitempty"`

	// svm
	Svm *ConsistencyGroupChildInlineSvm `json:"svm,omitempty"`

	// tiering
	Tiering *ConsistencyGroupChildInlineTiering `json:"tiering,omitempty"`

	// The unique identifier of the consistency group. The UUID is generated by ONTAP when the consistency group is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child
func (m *ConsistencyGroupChild) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupChildInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupChildInlineLuns(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupChildInlineNamespaces(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupChildInlineVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRestoreTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChild) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateConsistencyGroupChildInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupChildInlineTags) { // not required
		return nil
	}

	iConsistencyGroupChildInlineTagsSize := int64(len(m.ConsistencyGroupChildInlineTags))

	if err := validate.MaxItems("_tags", "body", iConsistencyGroupChildInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChild) validateConsistencyGroupChildInlineLuns(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupChildInlineLuns) { // not required
		return nil
	}

	iConsistencyGroupChildInlineLunsSize := int64(len(m.ConsistencyGroupChildInlineLuns))

	if err := validate.MinItems("luns", "body", iConsistencyGroupChildInlineLunsSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("luns", "body", m.ConsistencyGroupChildInlineLuns); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupChildInlineLuns); i++ {
		if swag.IsZero(m.ConsistencyGroupChildInlineLuns[i]) { // not required
			continue
		}

		if m.ConsistencyGroupChildInlineLuns[i] != nil {
			if err := m.ConsistencyGroupChildInlineLuns[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) validateConsistencyGroupChildInlineNamespaces(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupChildInlineNamespaces) { // not required
		return nil
	}

	iConsistencyGroupChildInlineNamespacesSize := int64(len(m.ConsistencyGroupChildInlineNamespaces))

	if err := validate.MinItems("namespaces", "body", iConsistencyGroupChildInlineNamespacesSize, 0); err != nil {
		return err
	}

	if err := validate.UniqueItems("namespaces", "body", m.ConsistencyGroupChildInlineNamespaces); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupChildInlineNamespaces); i++ {
		if swag.IsZero(m.ConsistencyGroupChildInlineNamespaces[i]) { // not required
			continue
		}

		if m.ConsistencyGroupChildInlineNamespaces[i] != nil {
			if err := m.ConsistencyGroupChildInlineNamespaces[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) validateConsistencyGroupChildInlineVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupChildInlineVolumes) { // not required
		return nil
	}

	iConsistencyGroupChildInlineVolumesSize := int64(len(m.ConsistencyGroupChildInlineVolumes))

	if err := validate.MinItems("volumes", "body", iConsistencyGroupChildInlineVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iConsistencyGroupChildInlineVolumesSize, 80); err != nil {
		return err
	}

	if err := validate.UniqueItems("volumes", "body", m.ConsistencyGroupChildInlineVolumes); err != nil {
		return err
	}

	for i := 0; i < len(m.ConsistencyGroupChildInlineVolumes); i++ {
		if swag.IsZero(m.ConsistencyGroupChildInlineVolumes[i]) { // not required
			continue
		}

		if m.ConsistencyGroupChildInlineVolumes[i] != nil {
			if err := m.ConsistencyGroupChildInlineVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentConsistencyGroup) { // not required
		return nil
	}

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateRestoreTo(formats strfmt.Registry) error {
	if swag.IsZero(m.RestoreTo) { // not required
		return nil
	}

	if m.RestoreTo != nil {
		if err := m.RestoreTo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child based on the context it is used
func (m *ConsistencyGroupChild) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupChildInlineLuns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupChildInlineNamespaces(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupChildInlineVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRestoreTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChild) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateConsistencyGroupChildInlineLuns(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupChildInlineLuns); i++ {

		if m.ConsistencyGroupChildInlineLuns[i] != nil {
			if err := m.ConsistencyGroupChildInlineLuns[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("luns" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateConsistencyGroupChildInlineNamespaces(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupChildInlineNamespaces); i++ {

		if m.ConsistencyGroupChildInlineNamespaces[i] != nil {
			if err := m.ConsistencyGroupChildInlineNamespaces[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("namespaces" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateConsistencyGroupChildInlineVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupChildInlineVolumes); i++ {

		if m.ConsistencyGroupChildInlineVolumes[i] != nil {
			if err := m.ConsistencyGroupChildInlineVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateRestoreTo(ctx context.Context, formats strfmt.Registry) error {

	if m.RestoreTo != nil {
		if err := m.RestoreTo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChild) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChild) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChild) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChild
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineApplication consistency group child inline application
//
// swagger:model consistency_group_child_inline_application
type ConsistencyGroupChildInlineApplication struct {

	// Nested consistency group tag.
	// Enum: ["data","logs","other"]
	ComponentType *string `json:"component_type,omitempty"`

	// Top level consistency group tag.
	// Enum: ["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group child inline application
func (m *ConsistencyGroupChildInlineApplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComponentType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineApplicationTypeComponentTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","logs","other"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineApplicationTypeComponentTypePropEnum = append(consistencyGroupChildInlineApplicationTypeComponentTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// component_type
	// ComponentType
	// data
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationComponentTypeData captures enum value "data"
	ConsistencyGroupChildInlineApplicationComponentTypeData string = "data"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// component_type
	// ComponentType
	// logs
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationComponentTypeLogs captures enum value "logs"
	ConsistencyGroupChildInlineApplicationComponentTypeLogs string = "logs"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// component_type
	// ComponentType
	// other
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationComponentTypeOther captures enum value "other"
	ConsistencyGroupChildInlineApplicationComponentTypeOther string = "other"
)

// prop value enum
func (m *ConsistencyGroupChildInlineApplication) validateComponentTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineApplicationTypeComponentTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineApplication) validateComponentType(formats strfmt.Registry) error {
	if swag.IsZero(m.ComponentType) { // not required
		return nil
	}

	// value enum
	if err := m.validateComponentTypeEnum("application"+"."+"component_type", "body", *m.ComponentType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupChildInlineApplicationTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["oracle","other","exchange","sql_server","sap_hana","vmware","mongodb","db2","mysql","sap_maxdb","postgresql","sap_ase_sybase"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineApplicationTypeTypePropEnum = append(consistencyGroupChildInlineApplicationTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// oracle
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeOracle captures enum value "oracle"
	ConsistencyGroupChildInlineApplicationTypeOracle string = "oracle"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// other
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeOther captures enum value "other"
	ConsistencyGroupChildInlineApplicationTypeOther string = "other"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// exchange
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeExchange captures enum value "exchange"
	ConsistencyGroupChildInlineApplicationTypeExchange string = "exchange"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// sql_server
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeSQLServer captures enum value "sql_server"
	ConsistencyGroupChildInlineApplicationTypeSQLServer string = "sql_server"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// sap_hana
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeSapHana captures enum value "sap_hana"
	ConsistencyGroupChildInlineApplicationTypeSapHana string = "sap_hana"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// vmware
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeVmware captures enum value "vmware"
	ConsistencyGroupChildInlineApplicationTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// mongodb
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeMongodb captures enum value "mongodb"
	ConsistencyGroupChildInlineApplicationTypeMongodb string = "mongodb"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// db2
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeDb2 captures enum value "db2"
	ConsistencyGroupChildInlineApplicationTypeDb2 string = "db2"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// mysql
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeMysql captures enum value "mysql"
	ConsistencyGroupChildInlineApplicationTypeMysql string = "mysql"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// sap_maxdb
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeSapMaxdb captures enum value "sap_maxdb"
	ConsistencyGroupChildInlineApplicationTypeSapMaxdb string = "sap_maxdb"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// postgresql
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypePostgresql captures enum value "postgresql"
	ConsistencyGroupChildInlineApplicationTypePostgresql string = "postgresql"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_application
	// ConsistencyGroupChildInlineApplication
	// type
	// Type
	// sap_ase_sybase
	// END DEBUGGING
	// ConsistencyGroupChildInlineApplicationTypeSapAseSybase captures enum value "sap_ase_sybase"
	ConsistencyGroupChildInlineApplicationTypeSapAseSybase string = "sap_ase_sybase"
)

// prop value enum
func (m *ConsistencyGroupChildInlineApplication) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineApplicationTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineApplication) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("application"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline application based on context it is used
func (m *ConsistencyGroupChildInlineApplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineApplication) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineApplication) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineApplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItem A LUN is the logical representation of storage in a storage area network (SAN).<br/>
// A LUN must be mapped to an initiator group to grant access to the initiator group's initiators (client hosts). Initiators can then access the LUN and perform I/O over a Fibre Channel (FC) fabric using the FC Protocol or a TCP/IP network using iSCSI.<br/>
// See the LUN object model to learn more about each of the properties supported by the LUN REST API.<br/>
// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<lun>" where the qtree name is optional.<br/>
// A LUN can be created to a specified size using thin or thick provisioning. A LUN can then be renamed, resized, cloned, moved to a different volume and copied. LUNs support the assignment of a QoS policy for performance management or a QoS policy can be assigned to a volume containing one or more LUNs.</personalities>
// <personalities supports=asar2>LUN names are simple names that share a namespace with NVMe namespaces within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// A LUN can be created to a specified size. A LUN can then be renamed, resized, or cloned. LUNs support the assignment of a QoS policy for performance management.<br/>
// **Note**: LUN related REST API examples use the Unified ONTAP form for LUN names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model consistency_group_child_inline_luns_inline_array_item
type ConsistencyGroupChildInlineLunsInlineArrayItem struct {

	// clone
	Clone *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone `json:"clone,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the LUN was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the LUN. LUNs can be disabled to prevent access to the LUN. Certain error conditions also cause the LUN to become disabled. If the LUN is disabled, you can consult the `state` property to determine if the LUN is administratively disabled (_offline_) or has become disabled as a result of an error. A LUN in an error condition can be brought online by setting the `enabled` property to _true_ or brought administratively offline by setting the `enabled` property to _false_. Upon creation, a LUN is enabled by default. Valid in PATCH.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// An array of LUN maps.<br/>
	// A LUN map is an association between a LUN and an initiator group. When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
	//
	LunMaps []*ConsistencyGroupChildLunsItems0LunMapsItems0 `json:"lun_maps"`

	// The fully qualified path name of the LUN composed of the "/vol" prefix, the volume name, the qtree name (optional), and the base name of the LUN. Valid in POST and PATCH.
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The operating system type of the LUN.<br/>
	// Required in POST when creating a LUN that is not a clone of another. Disallowed in POST when creating a LUN clone.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos `json:"qos,omitempty"`

	// The LUN serial number. The serial number is generated by ONTAP when the LUN is created.
	//
	// Read Only: true
	// Max Length: 12
	// Min Length: 12
	SerialNumber *string `json:"serial_number,omitempty"`

	// space
	Space *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace `json:"space,omitempty"`

	// The unique identifier of the LUN. The UUID is generated by ONTAP when the LUN is created.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item
func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateClone(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSerialNumber(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateClone(formats strfmt.Registry) error {
	if swag.IsZero(m.Clone) { // not required
		return nil
	}

	if m.Clone != nil {
		if err := m.Clone.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(m.LunMaps) { // not required
		return nil
	}

	for i := 0; i < len(m.LunMaps); i++ {
		if swag.IsZero(m.LunMaps[i]) { // not required
			continue
		}

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupChildInlineLunsInlineArrayItemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","solaris_efi","vmware","windows","windows_2008","windows_gpt","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineLunsInlineArrayItemTypeOsTypePropEnum = append(consistencyGroupChildInlineLunsInlineArrayItemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeAix captures enum value "aix"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeHpux captures enum value "hpux"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeLinux captures enum value "linux"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeNetware captures enum value "netware"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// solaris_efi
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeSolarisEfi captures enum value "solaris_efi"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeSolarisEfi string = "solaris_efi"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeVmware captures enum value "vmware"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindows captures enum value "windows"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows_2008
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindows2008 captures enum value "windows_2008"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindows2008 string = "windows_2008"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// windows_gpt
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindowsGpt captures enum value "windows_gpt"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeWindowsGpt string = "windows_gpt"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item
	// ConsistencyGroupChildInlineLunsInlineArrayItem
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeXen captures enum value "xen"
	ConsistencyGroupChildInlineLunsInlineArrayItemOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineLunsInlineArrayItemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateSerialNumber(formats strfmt.Registry) error {
	if swag.IsZero(m.SerialNumber) { // not required
		return nil
	}

	if err := validate.MinLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	if err := validate.MaxLength("serial_number", "body", *m.SerialNumber, 12); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateClone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSerialNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateClone(ctx context.Context, formats strfmt.Registry) error {

	if m.Clone != nil {
		if err := m.Clone.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateLunMaps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LunMaps); i++ {

		if m.LunMaps[i] != nil {
			if err := m.LunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateSerialNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "serial_number", "body", m.SerialNumber); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone <personalities supports=unified>This sub-object is used in POST to create a new LUN as a clone of an existing LUN, or PATCH to overwrite an existing LUN as a clone of another. Setting a property in this sub-object indicates that a LUN clone is desired. Consider the following other properties when cloning a LUN: `auto_delete`, `qos_policy`, `space.guarantee.requested` and `space.scsi_thin_provisioning_support_enabled`.<br/>
// When used in a PATCH, the patched LUN's data is over-written as a clone of the source and the following properties are preserved from the patched LUN unless otherwise specified as part of the PATCH: `class`, `auto_delete`, `lun_maps`, `serial_number`, `status.state`, and `uuid`.<br/>
// Persistent reservations for the patched LUN are also preserved.</personalities>
// <personalities supports=asar2>This endpoint does not support clones. No properties in this sub-object can be set for POST or PATCH and none will be returned by GET.<br/>
// Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_clone
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone struct {

	// source
	Source *ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource `json:"source,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline clone
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSource(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) validateSource(formats strfmt.Registry) error {
	if swag.IsZero(m.Source) { // not required
		return nil
	}

	if m.Source != nil {
		if err := m.Source.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item inline clone based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) contextValidateSource(ctx context.Context, formats strfmt.Registry) error {

	if m.Source != nil {
		if err := m.Source.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("clone" + "." + "source")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource The source LUN for a LUN clone operation. This can be specified using property `clone.source.uuid` or `clone.source.name`. If both properties are supplied, they must refer to the same LUN.<br/>
// Valid in POST to create a new LUN as a clone of the source.<br/>
// Valid in PATCH to overwrite an existing LUN's data as a clone of another.
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_clone_inline_source
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource struct {

	// The name of the clone source LUN.
	// <personalities supports=unified>A LUN is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// LUN names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: /vol/volume1/lun1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the clone source LUN.
	// <personalities supports=unified>Valid in POST and PATCH.</personalities>
	// <personalities supports=asar2>This property is not supported. Cloning is supported through the /api/storage/storage-units endpoint. See the [`POST /api/storage/storage-units`](#/SAN/storage_unit_create) to learn more about cloning LUNs.</personalities>
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline clone inline source
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group child inline luns inline array item inline clone inline source based on context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineCloneInlineSource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildLunsItems0LunMapsItems0 A LUN map is an association between a LUN and an initiator group.<br/>
// When a LUN is mapped to an initiator group, the initiator group's initiators are granted access to the LUN. The relationship between a LUN and an initiator group is many LUNs to many initiator groups.
//
// swagger:model ConsistencyGroupChildLunsItems0LunMapsItems0
type ConsistencyGroupChildLunsItems0LunMapsItems0 struct {

	// igroup
	Igroup *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup `json:"igroup,omitempty"`

	// The logical unit number assigned to the LUN when mapped to the specified initiator group. The number is used to identify the LUN to initiators in the initiator group when communicating through the Fibre Channel Protocol or iSCSI. Optional in POST; if no value is provided, ONTAP assigns the lowest available value. This property is not supported when the _provisioning_options.count_ property is 2 or more.
	//
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`
}

// Validate validates this consistency group child luns items0 lun maps items0
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroup) { // not required
		return nil
	}

	if m.Igroup != nil {
		if err := m.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child luns items0 lun maps items0 based on the context it is used
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if m.Igroup != nil {
		if err := m.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildLunsItems0LunMapsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
// swagger:model ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
type ConsistencyGroupChildLunsItems0LunMapsItems0Igroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	Igroups []*ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0 `json:"igroups"`

	// The initiators that are members of the group.
	//
	Initiators []*ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0 `json:"initiators"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child luns items0 lun maps items0 igroup
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.Igroups) { // not required
		return nil
	}

	for i := 0; i < len(m.Igroups); i++ {
		if swag.IsZero(m.Igroups[i]) { // not required
			continue
		}

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.Initiators) { // not required
		return nil
	}

	for i := 0; i < len(m.Initiators); i++ {
		if swag.IsZero(m.Initiators[i]) { // not required
			continue
		}

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum = append(consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("igroup"+"."+"os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum = append(consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupChildLunsItems0LunMapsItems0IgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildLunsItems0LunMapsItems0IgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("igroup"+"."+"protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child luns items0 lun maps items0 igroup based on the context it is used
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) contextValidateIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Igroups); i++ {

		if m.Igroups[i] != nil {
			if err := m.Igroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) contextValidateInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Initiators); i++ {

		if m.Initiators[i] != nil {
			if err := m.Initiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroup" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "igroup"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0Igroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildLunsItems0LunMapsItems0Igroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0 consistency group child luns items0 lun maps items0 igroup igroups items0
//
// swagger:model ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0
type ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0 struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child luns items0 lun maps items0 igroup igroups items0
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child luns items0 lun maps items0 igroup igroups items0 based on the context it is used
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildLunsItems0LunMapsItems0IgroupIgroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0 The initiators that are members of the initiator group.
//
// swagger:model ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0
type ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0 struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group child luns items0 lun maps items0 igroup initiators items0
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child luns items0 lun maps items0 igroup initiators items0 based on context it is used
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildLunsItems0LunMapsItems0IgroupInitiatorsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_provisioning_options
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline provisioning options
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_luns_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline luns inline array item inline provisioning options based on context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos consistency group child inline luns inline array item inline qos
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_qos
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos struct {

	// policy
	Policy *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline qos
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item inline qos based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_qos_inline_policy
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Read Only: true
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Read Only: true
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline qos inline policy
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_iops", "body", *m.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"max_throughput_mbps", "body", *m.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_iops", "body", *m.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(m.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("qos"+"."+"policy"+"."+"min_throughput_mbps", "body", *m.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item inline qos inline policy based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMaxThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinThroughputMbps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMaxThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_iops", "body", m.MaxThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMaxThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"max_throughput_mbps", "body", m.MaxThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMinThroughputIops(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_iops", "body", m.MinThroughputIops); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateMinThroughputMbps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"min_throughput_mbps", "body", m.MinThroughputMbps); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "qos"+"."+"policy"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace The storage space related properties of the LUN.
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_space
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace struct {

	// guarantee
	Guarantee *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the LUN. The LUN size can be increased but not reduced using the REST interface.
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The actual minimum and maximum sizes vary depending on the ONTAP version, ONTAP platform, and the available space in the containing volume and aggregate.
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the LUN.<br/>
	// This value is the total space consumed in the volume by the LUN, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways SAN filesystems and applications utilize blocks within a LUN, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the LUN blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline space
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item inline space based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the LUN.
//
// swagger:model consistency_group_child_inline_luns_inline_array_item_inline_space_inline_guarantee
type ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the LUN. If _true_, a space reservation is requested for the LUN; if _false_, the LUN is thin provisioned. Guaranteeing a space reservation request for a LUN requires that the volume in which the LUN resides is also space reserved and that the fractional reserve for the volume is 100%. Valid in POST and PATCH.
	// <personalities supports=asar2>All LUNs are provisioned without a space reservation.</personalities>
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the LUN is space guaranteed.<br/>
	// If _true_, a space guarantee is requested and the containing volume and aggregate support the request. If _false_, a space guarantee is not requested or a space guarantee is requested and either the containing volume or aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group child inline luns inline array item inline space inline guarantee
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group child inline luns inline array item inline space inline guarantee based on the context it is used
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineLunsInlineArrayItemInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItem An NVMe namespace is a collection of addressable logical blocks presented to hosts connected to the storage virtual machine using the NVMe over Fabrics protocol.<br/>
// An NVMe namespace must be mapped to an NVMe subsystem to grant access to the subsystem's hosts. Hosts can then access the NVMe namespace and perform I/O using the NVMe over Fabrics protocol.<br/>
// See the NVMe namespace object model to learn more about each of the properties supported by the NVMe namespace REST API.<br/>
// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
// An NVMe namespace is created to a specified size using thin or thick provisioning as determined by the volume on which it is created. An NVMe namespace can then be resized or cloned. An NVMe namespace cannot be renamed, or moved to a different volume. NVMe namespaces do not support the assignment of a QoS policy for performance management, but a QoS policy can be assigned to the volume containing the namespace.</personalities>
// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
// An NVMe namespace can be created to a specified size. An NVMe namespace can then be renamed, resized, or cloned. NVMe namespaces support the assignment of a QoS policy for performance management.<br/>
// **Note**: NVMe namespace related REST API examples use the Unified ONTAP form for NVMe namespace names. On ASA r2, the ASA r2 format must be used.</personalities>
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item
type ConsistencyGroupChildInlineNamespacesInlineArrayItem struct {

	// <personalities supports=unified>This property marks the NVMe namespace for auto deletion when the volume containing the namespace runs out of space. This is most commonly set on namespace clones.<br/>
	// When set to _true_, the NVMe namespace becomes eligible for automatic deletion when the volume runs out of space. Auto deletion only occurs when the volume containing the namespace is also configured for auto deletion and free space in the volume decreases below a particular threshold.<br/>
	// This property is optional in POST and PATCH. The default value for a new NVMe namespace is _false_.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.</personalities>
	// <personalities supports=asar2>This property is not supported. It cannot be set in POST or PATCH and will not be returned by GET.</personalities>
	//
	AutoDelete *bool `json:"auto_delete,omitempty"`

	// A configurable comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The time the NVMe namespace was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The enabled state of the NVMe namespace. Certain error conditions cause the namespace to become disabled. If the namespace is disabled, check the `status.state` property to determine what error disabled the namespace. An NVMe namespace is enabled automatically when it is created.
	//
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// The name of the NVMe namespace.
	// <personalities supports=unified>An NVMe namespace is located within a volume. Optionally, it can be located within a qtree in a volume.<br/>
	// NVMe namespace names are paths of the form "/vol/\<volume>[/\<qtree>]/\<namespace>" where the qtree name is optional.<br/>
	// Renaming an NVMe namespace is not supported. Valid in POST.</personalities>
	// <personalities supports=asar2>NVMe namespace names are simple names that share a namespace with LUNs within the same SVM. The name must begin with a letter or "\_" and contain only "\_" and alphanumeric characters. In specific cases, an optional snapshot-name can be used of the form "\<name>[@\<snapshot-name>]". The snapshot name must not begin or end with whitespace.<br/>
	// Renaming an NVMe namespace is supported. Valid in POST and PATCH.</personalities>
	//
	// Example: /vol/volume1/qtree1/namespace1
	Name *string `json:"name,omitempty"`

	// The operating system type of the NVMe namespace.<br/>
	// Required in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//
	// Enum: ["aix","linux","vmware","windows"]
	OsType *string `json:"os_type,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// space
	Space *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace `json:"space,omitempty"`

	// status
	Status *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus `json:"status,omitempty"`

	// subsystem map
	SubsystemMap *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap `json:"subsystem_map,omitempty"`

	// The unique identifier of the NVMe namespace.
	//
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystemMap(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var consistencyGroupChildInlineNamespacesInlineArrayItemTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","linux","vmware","windows"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineNamespacesInlineArrayItemTypeOsTypePropEnum = append(consistencyGroupChildInlineNamespacesInlineArrayItemTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item
	// ConsistencyGroupChildInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeAix captures enum value "aix"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item
	// ConsistencyGroupChildInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeLinux captures enum value "linux"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item
	// ConsistencyGroupChildInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeVmware captures enum value "vmware"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item
	// ConsistencyGroupChildInlineNamespacesInlineArrayItem
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeWindows captures enum value "windows"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemOsTypeWindows string = "windows"
)

// prop value enum
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineNamespacesInlineArrayItemTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) validateSubsystemMap(formats strfmt.Registry) error {
	if swag.IsZero(m.SubsystemMap) { // not required
		return nil
	}

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline namespaces inline array item based on the context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystemMap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "enabled", "body", m.Enabled); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateSubsystemMap(ctx context.Context, formats strfmt.Registry) error {

	if m.SubsystemMap != nil {
		if err := m.SubsystemMap.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item_inline_provisioning_options
type ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item inline provisioning options
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"
)

// prop value enum
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline namespaces inline array item inline provisioning options based on context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace The storage space related properties of the NVMe namespace.
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item_inline_space
type ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace struct {

	// The size of blocks in the namespace, in bytes.<br/>
	// Valid in POST when creating an NVMe namespace that is not a clone of another. Disallowed in POST when creating a namespace clone.
	//  Valid in POST.
	//
	// Enum: [512,4096]
	BlockSize *int64 `json:"block_size,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee `json:"guarantee,omitempty"`

	// The total provisioned size of the NVMe namespace. Valid in POST and PATCH. The NVMe namespace size can be increased but not reduced using the REST interface.<br/>
	// The maximum and minimum sizes listed here are the absolute maximum and absolute minimum sizes, in bytes. The maximum size is variable with respect to large NVMe namespace support in ONTAP. If large namespaces are supported, the maximum size is 128 TB (140737488355328 bytes) and if not supported, the maximum size is just under 16 TB (17557557870592 bytes). The minimum size supported is always 4096 bytes.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Example: 1073741824
	// Maximum: 1.40737488355328e+14
	// Minimum: 4096
	Size *int64 `json:"size,omitempty"`

	// snapshot
	Snapshot *VdiskSpaceSnapshot `json:"snapshot,omitempty"`

	// The amount of space consumed by the main data stream of the NVMe namespace.<br/>
	// This value is the total space consumed in the volume by the NVMe namespace, including filesystem overhead, but excluding prefix and suffix streams. Due to internal filesystem overhead and the many ways NVMe filesystems and applications utilize blocks within a namespace, this value does not necessarily reflect actual consumption/availability from the perspective of the filesystem or application. Without specific knowledge of how the namespace blocks are utilized outside of ONTAP, this property should not be used as an indicator for an out-of-space condition.<br/>
	// For more information, see _Size properties_ in the _docs_ section of the ONTAP REST API documentation.
	//
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item inline space
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum []interface{}

func init() {
	var res []int64
	if err := json.Unmarshal([]byte(`[512,4096]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum = append(consistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum, v)
	}
}

// prop value enum
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) validateBlockSizeEnum(path, location string, value int64) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(m.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := m.validateBlockSizeEnum("space"+"."+"block_size", "body", *m.BlockSize); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(m.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("space"+"."+"size", "body", *m.Size, 4096, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space"+"."+"size", "body", *m.Size, 1.40737488355328e+14, false); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline namespaces inline array item inline space based on the context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee Properties that request and report the space guarantee for the NVMe namespace.
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item_inline_space_inline_guarantee
type ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee struct {

	// The requested space reservation policy for the NVMe namespace. If _true_, a space reservation is requested for the namespace; if _false_, the namespace is thin provisioned. Guaranteeing a space reservation request for a namespace requires that the volume in which the namespace resides also be space reserved and that the fractional reserve for the volume be 100%.<br/>
	// The space reservation policy for an NVMe namespace is determined by ONTAP.
	//
	Requested *bool `json:"requested,omitempty"`

	// Reports if the NVMe namespace is space guaranteed.<br/>
	// This property is _true_ if a space guarantee is requested and the containing volume and aggregate support the request. This property is _false_ if a space guarantee is not requested or if a space guarantee is requested and either the containing volume and aggregate do not support the request.
	//
	// Read Only: true
	Reserved *bool `json:"reserved,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item inline space inline guarantee
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group child inline namespaces inline array item inline space inline guarantee based on the context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateReserved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) contextValidateReserved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"guarantee"+"."+"reserved", "body", m.Reserved); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSpaceInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus Status information about the NVMe namespace.
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item_inline_status
type ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus struct {

	// The state of the volume and aggregate that contain the NVMe namespace. Namespaces are only available when their containers are available.
	//
	// Enum: ["online","aggregate_offline","volume_offline"]
	ContainerState *string `json:"container_state,omitempty"`

	// Reports if the NVMe namespace is mapped to an NVMe subsystem.<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for either a collection GET or an instance GET unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	Mapped *bool `json:"mapped,omitempty"`

	// Reports if the NVMe namespace allows only read access.
	//
	ReadOnly *bool `json:"read_only,omitempty"`

	// The state of the NVMe namespace. Normal states for a namespace are _online_ and _offline_. Other states indicate errors.
	//
	// Example: online
	// Enum: ["nvfail","offline","online","space_error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item inline status
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","aggregate_offline","volume_offline"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum = append(consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// online
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateOnline captures enum value "online"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateOnline string = "online"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// aggregate_offline
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateAggregateOffline captures enum value "aggregate_offline"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateAggregateOffline string = "aggregate_offline"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// container_state
	// ContainerState
	// volume_offline
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateVolumeOffline captures enum value "volume_offline"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusContainerStateVolumeOffline string = "volume_offline"
)

// prop value enum
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) validateContainerStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeContainerStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) validateContainerState(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerState) { // not required
		return nil
	}

	// value enum
	if err := m.validateContainerStateEnum("status"+"."+"container_state", "body", *m.ContainerState); err != nil {
		return err
	}

	return nil
}

var consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nvfail","offline","online","space_error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum = append(consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// nvfail
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateNvfail captures enum value "nvfail"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateNvfail string = "nvfail"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// offline
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateOffline captures enum value "offline"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateOffline string = "offline"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// online
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateOnline captures enum value "online"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateOnline string = "online"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_namespaces_inline_array_item_inline_status
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	// state
	// State
	// space_error
	// END DEBUGGING
	// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateSpaceError captures enum value "space_error"
	ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusStateSpaceError string = "space_error"
)

// prop value enum
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineNamespacesInlineArrayItemInlineStatusTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("status"+"."+"state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline namespaces inline array item inline status based on context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap The NVMe subsystem with which the NVMe namespace is associated. A namespace can be mapped to zero (0) or one (1) subsystems.<br/>
// There is an added computational cost to retrieving property values for `subsystem_map`.
// They are not populated for either a collection GET or an instance GET unless explicitly requested using the `fields` query parameter.
//
// swagger:model consistency_group_child_inline_namespaces_inline_array_item_inline_subsystem_map
type ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The Asymmetric Namespace Access Group ID (ANAGRPID) of the NVMe namespace.<br/>
	// The format for an ANAGRPID is 8 hexadecimal digits (zero-filled) followed by a lower case "h".<br/>
	// There is an added computational cost to retrieving this property's value. It is not populated for a GET request unless it is explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Example: 00103050h
	// Read Only: true
	Anagrpid *string `json:"anagrpid,omitempty"`

	// The NVMe namespace identifier. This is an identifier used by an NVMe controller to provide access to the NVMe namespace.<br/>
	// The format for an NVMe namespace identifier is 8 hexadecimal digits (zero-filled) followed by a lower case "h".
	//
	// Example: 00000001h
	// Read Only: true
	Nsid *string `json:"nsid,omitempty"`

	// The NVMe subsystem to which the NVMe namespace is mapped.
	//
	Subsystem *ConsistencyGroupNvmeSubsystem `json:"subsystem,omitempty"`
}

// Validate validates this consistency group child inline namespaces inline array item inline subsystem map
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubsystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) validateSubsystem(formats strfmt.Registry) error {
	if swag.IsZero(m.Subsystem) { // not required
		return nil
	}

	if m.Subsystem != nil {
		if err := m.Subsystem.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline namespaces inline array item inline subsystem map based on the context it is used
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAnagrpid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNsid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubsystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateAnagrpid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"anagrpid", "body", m.Anagrpid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateNsid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "subsystem_map"+"."+"nsid", "body", m.Nsid); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) contextValidateSubsystem(ctx context.Context, formats strfmt.Registry) error {

	if m.Subsystem != nil {
		if err := m.Subsystem.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("subsystem_map" + "." + "subsystem")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineNamespacesInlineArrayItemInlineSubsystemMap
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineParentConsistencyGroup The parent consistency group.
//
// swagger:model consistency_group_child_inline_parent_consistency_group
type ConsistencyGroupChildInlineParentConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	// Example: my_consistency_group
	Name *string `json:"name,omitempty"`

	// The unique identifier of the consistency group.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline parent consistency group
func (m *ConsistencyGroupChildInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline parent consistency group based on the context it is used
func (m *ConsistencyGroupChildInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_child_inline_provisioning_options
type ConsistencyGroupChildInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	VerifyTags []*string `json:"verify_tags,omitempty"`
}

// Validate validates this consistency group child inline provisioning options
func (m *ConsistencyGroupChildInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupChildInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options
	// ConsistencyGroupChildInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupChildInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options
	// ConsistencyGroupChildInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupChildInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options
	// ConsistencyGroupChildInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupChildInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options
	// ConsistencyGroupChildInlineProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupChildInlineProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options
	// ConsistencyGroupChildInlineProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupChildInlineProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (m *ConsistencyGroupChildInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineProvisioningOptions) validateVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(m.VerifyTags) { // not required
		return nil
	}

	iVerifyTagsSize := int64(len(m.VerifyTags))

	if err := validate.MaxItems("provisioning_options"+"."+"verify_tags", "body", iVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child inline provisioning options based on the context it is used
func (m *ConsistencyGroupChildInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_child_inline_provisioning_options_inline_storage_service
type ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group child inline provisioning options inline storage service
func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupChildInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupChildInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineQos consistency group child inline qos
//
// swagger:model consistency_group_child_inline_qos
type ConsistencyGroupChildInlineQos struct {

	// policy
	Policy *ConsistencyGroupChildInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group child inline qos
func (m *ConsistencyGroupChildInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline qos based on the context it is used
func (m *ConsistencyGroupChildInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_child_inline_qos_inline_policy
type ConsistencyGroupChildInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline qos inline policy
func (m *ConsistencyGroupChildInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline qos inline policy based on the context it is used
func (m *ConsistencyGroupChildInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineRestoreTo Use to restore a consistency group to a previous snapshot
//
// swagger:model consistency_group_child_inline_restore_to
type ConsistencyGroupChildInlineRestoreTo struct {

	// snapshot
	Snapshot *ConsistencyGroupChildInlineRestoreToInlineSnapshot `json:"snapshot,omitempty"`
}

// Validate validates this consistency group child inline restore to
func (m *ConsistencyGroupChildInlineRestoreTo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineRestoreTo) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.Snapshot) { // not required
		return nil
	}

	if m.Snapshot != nil {
		if err := m.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline restore to based on the context it is used
func (m *ConsistencyGroupChildInlineRestoreTo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineRestoreTo) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.Snapshot != nil {
		if err := m.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("restore_to" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineRestoreTo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineRestoreTo) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineRestoreTo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineRestoreToInlineSnapshot A consistency group's snapshot
//
// swagger:model consistency_group_child_inline_restore_to_inline_snapshot
type ConsistencyGroupChildInlineRestoreToInlineSnapshot struct {

	// The name of the consistency group's snapshot to restore to.
	Name *string `json:"name,omitempty"`

	// The UUID of the consistency group's snapshot to restore to.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline restore to inline snapshot
func (m *ConsistencyGroupChildInlineRestoreToInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group child inline restore to inline snapshot based on context it is used
func (m *ConsistencyGroupChildInlineRestoreToInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineRestoreToInlineSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineRestoreToInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineRestoreToInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineSpace Space information for the consistency group.
//
// swagger:model consistency_group_child_inline_space
type ConsistencyGroupChildInlineSpace struct {

	// The amount of space available in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Available *int64 `json:"available,omitempty"`

	// The total provisioned size of the consistency group, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`

	// The amount of space consumed in the consistency group, in bytes.<br/>
	//
	// Example: 5737418
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group child inline space
func (m *ConsistencyGroupChildInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group child inline space based on context it is used
func (m *ConsistencyGroupChildInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineSvm The Storage Virtual Machine (SVM) in which the consistency group is located.
//
// swagger:model consistency_group_child_inline_svm
type ConsistencyGroupChildInlineSvm struct {

	// links
	Links *ConsistencyGroupChildInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline svm
func (m *ConsistencyGroupChildInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline svm based on the context it is used
func (m *ConsistencyGroupChildInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineSvmInlineLinks consistency group child inline svm inline links
//
// swagger:model consistency_group_child_inline_svm_inline__links
type ConsistencyGroupChildInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group child inline svm inline links
func (m *ConsistencyGroupChildInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline svm inline links based on the context it is used
func (m *ConsistencyGroupChildInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineTiering The tiering placement and policy definitions for volumes in this consistency group.
//
// swagger:model consistency_group_child_inline_tiering
type ConsistencyGroupChildInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupChildTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group child inline tiering
func (m *ConsistencyGroupChildInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineTieringTypeControlPropEnum = append(consistencyGroupChildInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupChildInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupChildInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupChildInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupChildInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupChildInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupChildInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineTieringTypePolicyPropEnum = append(consistencyGroupChildInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupChildInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupChildInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupChildInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupChildInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_tiering
	// ConsistencyGroupChildInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupChildInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupChildInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupChildInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child inline tiering based on the context it is used
func (m *ConsistencyGroupChildInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildTieringObjectStoresItems0 consistency group child tiering object stores items0
//
// swagger:model ConsistencyGroupChildTieringObjectStoresItems0
type ConsistencyGroupChildTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group child tiering object stores items0
func (m *ConsistencyGroupChildTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group child tiering object stores items0 based on context it is used
func (m *ConsistencyGroupChildTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItem consistency group child inline volumes inline array item
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item
type ConsistencyGroupChildInlineVolumesInlineArrayItem struct {

	// A comment for the volume. Valid in POST or PATCH.
	// Max Length: 1023
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas `json:"nas,omitempty"`

	// provisioning options
	ProvisioningOptions *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// qos
	Qos *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos `json:"qos,omitempty"`

	// The snapshot policy for this volume.
	//
	SnapshotPolicy *SnapshotPolicyReference `json:"snapshot_policy,omitempty"`

	// space
	Space *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace `json:"space,omitempty"`

	// tiering
	Tiering *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 1023); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas The CIFS share policy and/or export policies for this volume.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_nas
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas struct {

	// cifs
	Cifs *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline nas
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupChildInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum = append(consistencyGroupChildInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed captures enum value "mixed"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs captures enum value "ntfs"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified captures enum value "unified"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_nas
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix captures enum value "unix"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline nas based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs consistency group child inline volumes inline array item inline nas inline cifs
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_nas_inline_cifs
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this consistency group child inline volumes inline array item inline nas inline cifs
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline nas inline cifs based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_nas_inline_export_policy
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules"`
}

// Validate validates this consistency group child inline volumes inline array item inline nas inline export policy
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline nas inline export policy based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent consistency group child inline volumes inline array item inline nas inline junction parent
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_nas_inline_junction_parent
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline nas inline junction parent
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline nas inline junction parent based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline provisioning options
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum = append(consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("provisioning_options"+"."+"action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline provisioning options based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options" + "." + "storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline provisioning options inline storage service
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_provisioning_options_inline_storage_service
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("provisioning_options"+"."+"storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group child inline volumes inline array item inline provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos The QoS policy for this volume.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_qos
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos struct {

	// policy
	Policy *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline qos
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline qos based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_qos_inline_policy
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline qos inline policy
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline qos inline policy based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace consistency group child inline volumes inline array item inline space
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_space
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace struct {

	// The available space, in bytes.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Total provisioned size, in bytes.
	Size *int64 `json:"size,omitempty"`

	// The virtual space used (includes volume reserves) before storage efficiency, in bytes.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline space
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline space based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", m.Available); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", m.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering The tiering placement and policy definitions for this volume.
//
// swagger:model consistency_group_child_inline_volumes_inline_array_item_inline_tiering
type ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this consistency group child inline volumes inline array item inline tiering
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum = append(consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlAllowed captures enum value "allowed"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlBestEffort captures enum value "best_effort"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlDisallowed captures enum value "disallowed"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlRequired captures enum value "required"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum = append(consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyAll captures enum value "all"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyAuto captures enum value "auto"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyBackup captures enum value "backup"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyNone captures enum value "none"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// consistency_group_child_inline_volumes_inline_array_item_inline_tiering
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupChildInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group child inline volumes inline array item inline tiering based on the context it is used
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildInlineVolumesInlineArrayItemInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0 consistency group child volumes items0 tiering object stores items0
//
// swagger:model ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0
type ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group child volumes items0 tiering object stores items0
func (m *ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group child volumes items0 tiering object stores items0 based on context it is used
func (m *ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupChildVolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
