// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupClone consistency group clone
//
// swagger:model consistency_group_clone
type ConsistencyGroupClone struct {

	// A list of unsplit FlexClone storage units in the consistency group.
	// Read Only: true
	ConsistencyGroupCloneInlineUnsplitFlexclones []*string `json:"unsplit_flexclones,omitempty"`

	// guarantee
	Guarantee *ConsistencyGroupCloneInlineGuarantee `json:"guarantee,omitempty"`

	// Specifies if the consistency group contains any unsplit FlexClone storage units.
	// Read Only: true
	HasUnsplitFlexclones *bool `json:"has_unsplit_flexclones,omitempty"`

	// Specifies if this consistency group is a FlexClone of a consistency group.
	// Read Only: true
	IsFlexclone *bool `json:"is_flexclone,omitempty"`

	// parent consistency group
	ParentConsistencyGroup *ConsistencyGroupCloneInlineParentConsistencyGroup `json:"parent_consistency_group,omitempty"`

	// parent snapshot
	ParentSnapshot *ConsistencyGroupCloneInlineParentSnapshot `json:"parent_snapshot,omitempty"`

	// parent svm
	ParentSvm *ConsistencyGroupCloneInlineParentSvm `json:"parent_svm,omitempty"`

	// Specifies the SnapLock type for the clone consistency group.
	// Enum: ["compliance","enterprise","non_snaplock"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// Percentage of FlexClone blocks split from its parent consistency group.
	// Read Only: true
	SplitCompletePercent *int64 `json:"split_complete_percent,omitempty"`

	// Space required to split the FlexClone consistency group.
	// Read Only: true
	SplitEstimate *int64 `json:"split_estimate,omitempty"`

	// Splits volumes after cloning. Defaults to false during POST. Only accepts true during a PATCH.
	SplitInitiated *bool `json:"split_initiated,omitempty"`

	// storage unit
	StorageUnit *ConsistencyGroupCloneInlineStorageUnit `json:"storage_unit,omitempty"`

	// volume
	Volume *ConsistencyGroupCloneInlineVolume `json:"volume,omitempty"`
}

// Validate validates this consistency group clone
func (m *ConsistencyGroupClone) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentConsistencyGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParentSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageUnit(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupClone) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(m.Guarantee) { // not required
		return nil
	}

	if m.Guarantee != nil {
		if err := m.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) validateParentConsistencyGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentConsistencyGroup) { // not required
		return nil
	}

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) validateParentSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSnapshot) { // not required
		return nil
	}

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) validateParentSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.ParentSvm) { // not required
		return nil
	}

	if m.ParentSvm != nil {
		if err := m.ParentSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupCloneTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupCloneTypeSnaplockTypePropEnum = append(consistencyGroupCloneTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_clone
	// ConsistencyGroupClone
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// ConsistencyGroupCloneSnaplockTypeCompliance captures enum value "compliance"
	ConsistencyGroupCloneSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// consistency_group_clone
	// ConsistencyGroupClone
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// ConsistencyGroupCloneSnaplockTypeEnterprise captures enum value "enterprise"
	ConsistencyGroupCloneSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// consistency_group_clone
	// ConsistencyGroupClone
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// ConsistencyGroupCloneSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ConsistencyGroupCloneSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ConsistencyGroupClone) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupCloneTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupClone) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(m.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := m.validateSnaplockTypeEnum("snaplock_type", "body", *m.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) validateStorageUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageUnit) { // not required
		return nil
	}

	if m.StorageUnit != nil {
		if err := m.StorageUnit.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(m.Volume) { // not required
		return nil
	}

	if m.Volume != nil {
		if err := m.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone based on the context it is used
func (m *ConsistencyGroupClone) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConsistencyGroupCloneInlineUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasUnsplitFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsFlexclone(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentConsistencyGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParentSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitCompletePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplitEstimate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageUnit(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupClone) contextValidateConsistencyGroupCloneInlineUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "unsplit_flexclones", "body", []*string(m.ConsistencyGroupCloneInlineUnsplitFlexclones)); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if m.Guarantee != nil {
		if err := m.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guarantee")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateHasUnsplitFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "has_unsplit_flexclones", "body", m.HasUnsplitFlexclones); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateIsFlexclone(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_flexclone", "body", m.IsFlexclone); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateParentConsistencyGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentConsistencyGroup != nil {
		if err := m.ParentConsistencyGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateParentSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSnapshot != nil {
		if err := m.ParentSnapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateParentSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.ParentSvm != nil {
		if err := m.ParentSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateSplitCompletePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "split_complete_percent", "body", m.SplitCompletePercent); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateSplitEstimate(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "split_estimate", "body", m.SplitEstimate); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateStorageUnit(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageUnit != nil {
		if err := m.StorageUnit.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_unit")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupClone) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if m.Volume != nil {
		if err := m.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupClone) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupClone) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupClone
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineGuarantee consistency group clone inline guarantee
//
// swagger:model consistency_group_clone_inline_guarantee
type ConsistencyGroupCloneInlineGuarantee struct {

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this consistency group clone inline guarantee
func (m *ConsistencyGroupCloneInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupCloneInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupCloneInlineGuaranteeTypeTypePropEnum = append(consistencyGroupCloneInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_clone_inline_guarantee
	// ConsistencyGroupCloneInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// ConsistencyGroupCloneInlineGuaranteeTypeVolume captures enum value "volume"
	ConsistencyGroupCloneInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// consistency_group_clone_inline_guarantee
	// ConsistencyGroupCloneInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// ConsistencyGroupCloneInlineGuaranteeTypeNone captures enum value "none"
	ConsistencyGroupCloneInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (m *ConsistencyGroupCloneInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupCloneInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("guarantee"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group clone inline guarantee based on context it is used
func (m *ConsistencyGroupCloneInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineGuarantee) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineParentConsistencyGroup Consistency group that is to be cloned.
//
// swagger:model consistency_group_clone_inline_parent_consistency_group
type ConsistencyGroupCloneInlineParentConsistencyGroup struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the consistency group.
	Name *string `json:"name,omitempty"`

	// The name of the parent consistency group used when cloning a child consistency group.
	ParentName *string `json:"parent_name,omitempty"`

	// The unique identifier of the parent consistency group used when cloning a child consistency group.
	ParentUUID *string `json:"parent_uuid,omitempty"`

	// The unique identifier of the consistency group.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group clone inline parent consistency group
func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone inline parent consistency group based on the context it is used
func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_consistency_group" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentConsistencyGroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineParentConsistencyGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineParentSnapshot Consistency group that is to be cloned.
//
// swagger:model consistency_group_clone_inline_parent_snapshot
type ConsistencyGroupCloneInlineParentSnapshot struct {

	// links
	Links *ConsistencyGroupCloneInlineParentSnapshotInlineLinks `json:"_links,omitempty"`

	// name
	// Example: this_snapshot
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group clone inline parent snapshot
func (m *ConsistencyGroupCloneInlineParentSnapshot) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSnapshot) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone inline parent snapshot based on the context it is used
func (m *ConsistencyGroupCloneInlineParentSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSnapshot) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSnapshot) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSnapshot) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineParentSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineParentSnapshotInlineLinks consistency group clone inline parent snapshot inline links
//
// swagger:model consistency_group_clone_inline_parent_snapshot_inline__links
type ConsistencyGroupCloneInlineParentSnapshotInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group clone inline parent snapshot inline links
func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone inline parent snapshot inline links based on the context it is used
func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_snapshot" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSnapshotInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineParentSnapshotInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineParentSvm SVM, applies only to SVM-scoped objects.
//
// swagger:model consistency_group_clone_inline_parent_svm
type ConsistencyGroupCloneInlineParentSvm struct {

	// links
	Links *ConsistencyGroupCloneInlineParentSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group clone inline parent svm
func (m *ConsistencyGroupCloneInlineParentSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone inline parent svm based on the context it is used
func (m *ConsistencyGroupCloneInlineParentSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSvm) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineParentSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineParentSvmInlineLinks consistency group clone inline parent svm inline links
//
// swagger:model consistency_group_clone_inline_parent_svm_inline__links
type ConsistencyGroupCloneInlineParentSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group clone inline parent svm inline links
func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group clone inline parent svm inline links based on the context it is used
func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parent_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineParentSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineParentSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineStorageUnit Storage unit name suffix/prefix for the cloned blocks. This is applied to all the vdisks, i.e. LUNs or NVMe namespaces within the consistency group.
//
// swagger:model consistency_group_clone_inline_storage_unit
type ConsistencyGroupCloneInlineStorageUnit struct {

	// Storage unit name prefix for cloned volume blocks.
	Prefix *string `json:"prefix,omitempty"`

	// Storage unit name suffix for cloned volume blocks.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group clone inline storage unit
func (m *ConsistencyGroupCloneInlineStorageUnit) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group clone inline storage unit based on context it is used
func (m *ConsistencyGroupCloneInlineStorageUnit) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineStorageUnit) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineStorageUnit) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineStorageUnit
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupCloneInlineVolume Volume name suffix/prefix for the cloned volumes.
//
// swagger:model consistency_group_clone_inline_volume
type ConsistencyGroupCloneInlineVolume struct {

	// Volume name prefix for cloned volumes.
	Prefix *string `json:"prefix,omitempty"`

	// Volume name suffix for cloned volumes.
	Suffix *string `json:"suffix,omitempty"`
}

// Validate validates this consistency group clone inline volume
func (m *ConsistencyGroupCloneInlineVolume) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this consistency group clone inline volume based on context it is used
func (m *ConsistencyGroupCloneInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupCloneInlineVolume) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupCloneInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
