// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupIgroup An initiator group (igroup) is a collection of Fibre Channel (FC) world wide port names (WWPNs), and/or iSCSI Qualified Names (IQNs), and/or iSCSI EUIs (Extended Unique Identifiers) that identify host endpoints.<br/>
// Initiator groups are used to control which hosts can access specific LUNs. To grant access to a LUN from one or more hosts, create an initiator group containing the host initiator names, then create a LUN map that associates the initiator group with the LUN.<br/>
// An initiator group may contain either initiators or other initiator groups, but not both simultaneously. When a parent initiator group is mapped, it inherits all of the initiators of any initiator groups nested below it. If any nested initiator group is modified to contain different initiators, the parent initiator groups inherit the change. A parent can have many nested initiator groups and an initiator group can be nested under multiple parents. Initiators can only be added or removed from the initiator group that directly contains them. The maximum supported depth of nesting is three layers.<br/>
// Best practice when using nested initiator groups is to match host hierarchies. A single initiator group should correspond to a single host. If a LUN needs to be mapped to multiple hosts, the initiator groups representing those hosts should be aggregated into a parent initiator group and the LUN should be mapped to that initiator group. For multi-ported hosts, initiators have a comment property where the port corresponding to the initiator can be documented.<br/>
// An initiator can appear in multiple initiator groups. An initiator group can be mapped to multiple LUNs. A specific initiator can be mapped to a specific LUN only once. With the introduction of nestable initiator groups, best practice is to use the hierarchy such that an initiator is only a direct member of a single initiator group, and that initiator group can then be referenced by other initiator groups.<br/>
// All initiators or nested initiator groups in an initiator group must be from the same operating system. The initiator group's operating system is specified when the initiator group is created.<br/>
// When an initiator group is created, the `protocol` property is used to restrict member initiators to Fibre Channel (_fcp_), iSCSI (_iscsi_), or both (_mixed_). Initiator groups within a nested hierarchy may not have conflicting protocols.<br/>
// Zero or more initiators or nested initiator groups can be supplied when the initiator group is created. After creation, initiators can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/initiators` endpoint. Initiator groups containing other initiator groups report the aggregated list of initiators from all nested initiator groups, but modifications of the initiator list must be performed on the initiator group that directly contains the initiators. See [`POST /protocols/san/igroups/{igroup.uuid}/initiators`](#/SAN/igroup_initiator_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}`](#/SAN/igroup_initiator_delete) for more details.<br/>
//
// swagger:model consistency_group_igroup
type ConsistencyGroupIgroup struct {

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	ConsistencyGroupIgroupInlineIgroups []*ConsistencyGroupIgroupInlineIgroupsInlineArrayItem `json:"igroups,omitempty"`

	// The initiators that are members of the group.
	//
	ConsistencyGroupIgroupInlineInitiators []*ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem `json:"initiators,omitempty"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group igroup
func (m *ConsistencyGroupIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupIgroupInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupIgroupInlineInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupIgroup) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupIgroup) validateConsistencyGroupIgroupInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupIgroupInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(m.ConsistencyGroupIgroupInlineIgroups); i++ {
		if swag.IsZero(m.ConsistencyGroupIgroupInlineIgroups[i]) { // not required
			continue
		}

		if m.ConsistencyGroupIgroupInlineIgroups[i] != nil {
			if err := m.ConsistencyGroupIgroupInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupIgroup) validateConsistencyGroupIgroupInlineInitiators(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupIgroupInlineInitiators) { // not required
		return nil
	}

	for i := 0; i < len(m.ConsistencyGroupIgroupInlineInitiators); i++ {
		if swag.IsZero(m.ConsistencyGroupIgroupInlineInitiators[i]) { // not required
			continue
		}

		if m.ConsistencyGroupIgroupInlineInitiators[i] != nil {
			if err := m.ConsistencyGroupIgroupInlineInitiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

var consistencyGroupIgroupTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupIgroupTypeOsTypePropEnum = append(consistencyGroupIgroupTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeAix captures enum value "aix"
	ConsistencyGroupIgroupOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeHpux captures enum value "hpux"
	ConsistencyGroupIgroupOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeHyperv captures enum value "hyper_v"
	ConsistencyGroupIgroupOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeLinux captures enum value "linux"
	ConsistencyGroupIgroupOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeNetware captures enum value "netware"
	ConsistencyGroupIgroupOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeOpenvms captures enum value "openvms"
	ConsistencyGroupIgroupOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeSolaris captures enum value "solaris"
	ConsistencyGroupIgroupOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeVmware captures enum value "vmware"
	ConsistencyGroupIgroupOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeWindows captures enum value "windows"
	ConsistencyGroupIgroupOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// ConsistencyGroupIgroupOsTypeXen captures enum value "xen"
	ConsistencyGroupIgroupOsTypeXen string = "xen"
)

// prop value enum
func (m *ConsistencyGroupIgroup) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupIgroupTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupIgroup) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(m.OsType) { // not required
		return nil
	}

	// value enum
	if err := m.validateOsTypeEnum("os_type", "body", *m.OsType); err != nil {
		return err
	}

	return nil
}

var consistencyGroupIgroupTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupIgroupTypeProtocolPropEnum = append(consistencyGroupIgroupTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// ConsistencyGroupIgroupProtocolFcp captures enum value "fcp"
	ConsistencyGroupIgroupProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// ConsistencyGroupIgroupProtocolIscsi captures enum value "iscsi"
	ConsistencyGroupIgroupProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// consistency_group_igroup
	// ConsistencyGroupIgroup
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// ConsistencyGroupIgroupProtocolMixed captures enum value "mixed"
	ConsistencyGroupIgroupProtocolMixed string = "mixed"
)

// prop value enum
func (m *ConsistencyGroupIgroup) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupIgroupTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupIgroup) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(m.Protocol) { // not required
		return nil
	}

	// value enum
	if err := m.validateProtocolEnum("protocol", "body", *m.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group igroup based on the context it is used
func (m *ConsistencyGroupIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConsistencyGroupIgroupInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistencyGroupIgroupInlineInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupIgroup) contextValidateConsistencyGroupIgroupInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupIgroupInlineIgroups); i++ {

		if m.ConsistencyGroupIgroupInlineIgroups[i] != nil {
			if err := m.ConsistencyGroupIgroupInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupIgroup) contextValidateConsistencyGroupIgroupInlineInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupIgroupInlineInitiators); i++ {

		if m.ConsistencyGroupIgroupInlineInitiators[i] != nil {
			if err := m.ConsistencyGroupIgroupInlineInitiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ConsistencyGroupIgroup) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupIgroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupIgroup) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupIgroupInlineIgroupsInlineArrayItem consistency group igroup inline igroups inline array item
//
// swagger:model consistency_group_igroup_inline_igroups_inline_array_item
type ConsistencyGroupIgroupInlineIgroupsInlineArrayItem struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group igroup inline igroups inline array item
func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group igroup inline igroups inline array item based on the context it is used
func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupIgroupInlineIgroupsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupIgroupInlineIgroupsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem The initiators that are members of the initiator group.
//
// swagger:model consistency_group_igroup_inline_initiators_inline_array_item
type ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem struct {

	// A comment available for use by the administrator.
	//
	// Example: my comment
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Name of initiator that is a member of the initiator group.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group igroup inline initiators inline array item
func (m *ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(m.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *m.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *m.Comment, 254); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group igroup inline initiators inline array item based on context it is used
func (m *ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupIgroupInlineInitiatorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
