// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupMetrics Performance and capacity numbers, such as, IOPS, latency, throughput, used space, and available space.
//
// swagger:model consistency_group_metrics
type ConsistencyGroupMetrics struct {

	// links
	Links *ConsistencyGroupMetricsInlineLinks `json:"_links,omitempty"`

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *ConsistencyGroupMetricsInlineIops `json:"iops,omitempty"`

	// latency
	Latency *ConsistencyGroupMetricsInlineLatency `json:"latency,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *ConsistencyGroupMetricsInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance and capacity data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total space used in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group metrics
func (m *ConsistencyGroupMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupMetrics) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupMetricsTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupMetricsTypeDurationPropEnum = append(consistencyGroupMetricsTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationPT15S captures enum value "PT15S"
	ConsistencyGroupMetricsDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationPT4M captures enum value "PT4M"
	ConsistencyGroupMetricsDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationPT30M captures enum value "PT30M"
	ConsistencyGroupMetricsDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationPT2H captures enum value "PT2H"
	ConsistencyGroupMetricsDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationP1D captures enum value "P1D"
	ConsistencyGroupMetricsDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// ConsistencyGroupMetricsDurationPT5M captures enum value "PT5M"
	ConsistencyGroupMetricsDurationPT5M string = "PT5M"
)

// prop value enum
func (m *ConsistencyGroupMetrics) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupMetricsTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupMetrics) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(m.Duration) { // not required
		return nil
	}

	// value enum
	if err := m.validateDurationEnum("duration", "body", *m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(m.Iops) { // not required
		return nil
	}

	if m.Iops != nil {
		if err := m.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(m.Latency) { // not required
		return nil
	}

	if m.Latency != nil {
		if err := m.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupMetricsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupMetricsTypeStatusPropEnum = append(consistencyGroupMetricsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusOk captures enum value "ok"
	ConsistencyGroupMetricsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusError captures enum value "error"
	ConsistencyGroupMetricsStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupMetricsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupMetricsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupMetricsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupMetricsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupMetricsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupMetricsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupMetricsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_metrics
	// ConsistencyGroupMetrics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupMetricsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupMetricsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ConsistencyGroupMetrics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupMetricsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupMetrics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(m.Throughput) { // not required
		return nil
	}

	if m.Throughput != nil {
		if err := m.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group metrics based on the context it is used
func (m *ConsistencyGroupMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_space", "body", m.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "duration", "body", m.Duration); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if m.Iops != nil {
		if err := m.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if m.Latency != nil {
		if err := m.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if m.Throughput != nil {
		if err := m.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupMetrics) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used_space", "body", m.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupMetrics) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupMetricsInlineIops The rate of I/O operations observed at the storage object.
//
// swagger:model consistency_group_metrics_inline_iops
type ConsistencyGroupMetricsInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group metrics inline iops
func (m *ConsistencyGroupMetricsInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group metrics inline iops based on the context it is used
func (m *ConsistencyGroupMetricsInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineIops) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineIops) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupMetricsInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupMetricsInlineLatency The round trip latency observed at the storage object, in microseconds.
//
// swagger:model consistency_group_metrics_inline_latency
type ConsistencyGroupMetricsInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group metrics inline latency
func (m *ConsistencyGroupMetricsInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group metrics inline latency based on the context it is used
func (m *ConsistencyGroupMetricsInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineLatency) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineLatency) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupMetricsInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupMetricsInlineLinks consistency group metrics inline links
//
// swagger:model consistency_group_metrics_inline__links
type ConsistencyGroupMetricsInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group metrics inline links
func (m *ConsistencyGroupMetricsInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupMetricsInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group metrics inline links based on the context it is used
func (m *ConsistencyGroupMetricsInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupMetricsInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupMetricsInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupMetricsInlineThroughput The rate of throughput bytes per second observed at the storage object.
//
// swagger:model consistency_group_metrics_inline_throughput
type ConsistencyGroupMetricsInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group metrics inline throughput
func (m *ConsistencyGroupMetricsInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group metrics inline throughput based on the context it is used
func (m *ConsistencyGroupMetricsInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineThroughput) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupMetricsInlineThroughput) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupMetricsInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
