// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ConsistencyGroupNvmeHostProximity Properties that define the SVMs to which the host is proximal. This information is used to properly report active optimized and active non-optimized network paths using an NVMe controller. If no configuration has been specified for the host, the sub-object is not present in GET requests.<br/>
// These properties apply to all instances of the host in the NVMe subsystem in the SVM and its peers.
//
// swagger:model consistency_group_nvme_host_proximity
type ConsistencyGroupNvmeHostProximity struct {

	// An array of remote peer SVMs to which the host is proximal.
	//
	ConsistencyGroupNvmeHostProximityInlinePeerSvms []*ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem `json:"peer_svms,omitempty"`

	// A boolean that indicates if the host is proximal to the SVM for which it is configured.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`
}

// Validate validates this consistency group nvme host proximity
func (m *ConsistencyGroupNvmeHostProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConsistencyGroupNvmeHostProximityInlinePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximity) validateConsistencyGroupNvmeHostProximityInlinePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupNvmeHostProximityInlinePeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(m.ConsistencyGroupNvmeHostProximityInlinePeerSvms); i++ {
		if swag.IsZero(m.ConsistencyGroupNvmeHostProximityInlinePeerSvms[i]) { // not required
			continue
		}

		if m.ConsistencyGroupNvmeHostProximityInlinePeerSvms[i] != nil {
			if err := m.ConsistencyGroupNvmeHostProximityInlinePeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this consistency group nvme host proximity based on the context it is used
func (m *ConsistencyGroupNvmeHostProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConsistencyGroupNvmeHostProximityInlinePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximity) contextValidateConsistencyGroupNvmeHostProximityInlinePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ConsistencyGroupNvmeHostProximityInlinePeerSvms); i++ {

		if m.ConsistencyGroupNvmeHostProximityInlinePeerSvms[i] != nil {
			if err := m.ConsistencyGroupNvmeHostProximityInlinePeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximity) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupNvmeHostProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem A reference to an SVM peer relationship.
//
// swagger:model consistency_group_nvme_host_proximity_inline_peer_svms_inline_array_item
type ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem struct {

	// links
	Links *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this consistency group nvme host proximity inline peer svms inline array item
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group nvme host proximity inline peer svms inline array item based on the context it is used
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks consistency group nvme host proximity inline peer svms inline array item inline links
//
// swagger:model consistency_group_nvme_host_proximity_inline_peer_svms_inline_array_item_inline__links
type ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this consistency group nvme host proximity inline peer svms inline array item inline links
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group nvme host proximity inline peer svms inline array item inline links based on the context it is used
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupNvmeHostProximityInlinePeerSvmsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
