// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_provisioning_options
type ConsistencyGroupProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","promote","demote"]
	Action *string `json:"action,omitempty"`

	// Resource tags to confirm before an update.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	ConsistencyGroupProvisioningOptionsInlineVerifyTags []*string `json:"verify_tags,omitempty"`

	// New name for consistency group. Required to resolve naming collisions.
	//
	Name *string `json:"name,omitempty"`

	// Enable snapshot autodelete on a storage unit.
	SnapshotAutodeleteEnabled interface{} `json:"snapshot_autodelete_enabled,omitempty"`

	// The space that has been set aside as a reserve for storage unit snapshot usage, in percent.
	SnapshotReservePercent interface{} `json:"snapshot_reserve_percent,omitempty"`

	// storage service
	StorageService *ConsistencyGroupProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group provisioning options
func (m *ConsistencyGroupProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistencyGroupProvisioningOptionsInlineVerifyTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","promote","demote"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupProvisioningOptionsTypeActionPropEnum = append(consistencyGroupProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options
	// ConsistencyGroupProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options
	// ConsistencyGroupProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options
	// ConsistencyGroupProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options
	// ConsistencyGroupProvisioningOptions
	// action
	// Action
	// promote
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsActionPromote captures enum value "promote"
	ConsistencyGroupProvisioningOptionsActionPromote string = "promote"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options
	// ConsistencyGroupProvisioningOptions
	// action
	// Action
	// demote
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsActionDemote captures enum value "demote"
	ConsistencyGroupProvisioningOptionsActionDemote string = "demote"
)

// prop value enum
func (m *ConsistencyGroupProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupProvisioningOptions) validateConsistencyGroupProvisioningOptionsInlineVerifyTags(formats strfmt.Registry) error {
	if swag.IsZero(m.ConsistencyGroupProvisioningOptionsInlineVerifyTags) { // not required
		return nil
	}

	iConsistencyGroupProvisioningOptionsInlineVerifyTagsSize := int64(len(m.ConsistencyGroupProvisioningOptionsInlineVerifyTags))

	if err := validate.MaxItems("verify_tags", "body", iConsistencyGroupProvisioningOptionsInlineVerifyTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group provisioning options based on the context it is used
func (m *ConsistencyGroupProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_provisioning_options_inline_storage_service
type ConsistencyGroupProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group provisioning options inline storage service
func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options_inline_storage_service
	// ConsistencyGroupProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options_inline_storage_service
	// ConsistencyGroupProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_provisioning_options_inline_storage_service
	// ConsistencyGroupProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
