// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupStatistics These are raw performance and space numbers, such as, IOPS, latency, throughput, used space, and available space. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
//
// swagger:model consistency_group_statistics
type ConsistencyGroupStatistics struct {

	// The total space available in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	AvailableSpace *int64 `json:"available_space,omitempty"`

	// iops raw
	IopsRaw *ConsistencyGroupStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *ConsistencyGroupStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// The total size of the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *ConsistencyGroupStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// The total used space in the consistency group, in bytes.
	// Example: 4096
	// Read Only: true
	UsedSpace *int64 `json:"used_space,omitempty"`
}

// Validate validates this consistency group statistics
func (m *ConsistencyGroupStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.IopsRaw) { // not required
		return nil
	}

	if m.IopsRaw != nil {
		if err := m.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.LatencyRaw) { // not required
		return nil
	}

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

var consistencyGroupStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_uuid","partial_no_response","partial_other_error","negative_delta","backfilled_data","inconsistent_delta_time","inconsistent_old_data"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupStatisticsTypeStatusPropEnum = append(consistencyGroupStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusOk captures enum value "ok"
	ConsistencyGroupStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusError captures enum value "error"
	ConsistencyGroupStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusPartialNoData captures enum value "partial_no_data"
	ConsistencyGroupStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	ConsistencyGroupStatisticsStatusPartialNoUUID string = "partial_no_uuid"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	ConsistencyGroupStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	ConsistencyGroupStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusNegativeDelta captures enum value "negative_delta"
	ConsistencyGroupStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusBackfilledData captures enum value "backfilled_data"
	ConsistencyGroupStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	ConsistencyGroupStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// consistency_group_statistics
	// ConsistencyGroupStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// ConsistencyGroupStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	ConsistencyGroupStatisticsStatusInconsistentOldData string = "inconsistent_old_data"
)

// prop value enum
func (m *ConsistencyGroupStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	// value enum
	if err := m.validateStatusEnum("status", "body", *m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(m.ThroughputRaw) { // not required
		return nil
	}

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this consistency group statistics based on the context it is used
func (m *ConsistencyGroupStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAvailableSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateAvailableSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "available_space", "body", m.AvailableSpace); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.IopsRaw != nil {
		if err := m.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.LatencyRaw != nil {
		if err := m.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "status", "body", m.Status); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if m.ThroughputRaw != nil {
		if err := m.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupStatistics) contextValidateUsedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "used_space", "body", m.UsedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupStatistics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupStatistics) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
//
// swagger:model consistency_group_statistics_inline_iops_raw
type ConsistencyGroupStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group statistics inline iops raw
func (m *ConsistencyGroupStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group statistics inline iops raw based on the context it is used
func (m *ConsistencyGroupStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupStatisticsInlineLatencyRaw The raw latency observed at the storage object, in microseconds. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
//
// swagger:model consistency_group_statistics_inline_latency_raw
type ConsistencyGroupStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group statistics inline latency raw
func (m *ConsistencyGroupStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group statistics inline latency raw based on the context it is used
func (m *ConsistencyGroupStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
//
// swagger:model consistency_group_statistics_inline_throughput_raw
type ConsistencyGroupStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this consistency group statistics inline throughput raw
func (m *ConsistencyGroupStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this consistency group statistics inline throughput raw based on the context it is used
func (m *ConsistencyGroupStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
