// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ConsistencyGroupVolumeProvisioningOptions Options that are applied to the operation.
//
// swagger:model consistency_group_volume_provisioning_options
type ConsistencyGroupVolumeProvisioningOptions struct {

	// Operation to perform
	// Enum: ["create","add","remove","reassign"]
	Action *string `json:"action,omitempty"`

	// Number of elements to perform the operation on.
	Count *int64 `json:"count,omitempty"`

	// storage service
	StorageService *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService `json:"storage_service,omitempty"`
}

// Validate validates this consistency group volume provisioning options
func (m *ConsistencyGroupVolumeProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAction(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupVolumeProvisioningOptionsTypeActionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["create","add","remove","reassign"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupVolumeProvisioningOptionsTypeActionPropEnum = append(consistencyGroupVolumeProvisioningOptionsTypeActionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options
	// ConsistencyGroupVolumeProvisioningOptions
	// action
	// Action
	// create
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsActionCreate captures enum value "create"
	ConsistencyGroupVolumeProvisioningOptionsActionCreate string = "create"

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options
	// ConsistencyGroupVolumeProvisioningOptions
	// action
	// Action
	// add
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsActionAdd captures enum value "add"
	ConsistencyGroupVolumeProvisioningOptionsActionAdd string = "add"

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options
	// ConsistencyGroupVolumeProvisioningOptions
	// action
	// Action
	// remove
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsActionRemove captures enum value "remove"
	ConsistencyGroupVolumeProvisioningOptionsActionRemove string = "remove"

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options
	// ConsistencyGroupVolumeProvisioningOptions
	// action
	// Action
	// reassign
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsActionReassign captures enum value "reassign"
	ConsistencyGroupVolumeProvisioningOptionsActionReassign string = "reassign"
)

// prop value enum
func (m *ConsistencyGroupVolumeProvisioningOptions) validateActionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupVolumeProvisioningOptionsTypeActionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupVolumeProvisioningOptions) validateAction(formats strfmt.Registry) error {
	if swag.IsZero(m.Action) { // not required
		return nil
	}

	// value enum
	if err := m.validateActionEnum("action", "body", *m.Action); err != nil {
		return err
	}

	return nil
}

func (m *ConsistencyGroupVolumeProvisioningOptions) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this consistency group volume provisioning options based on the context it is used
func (m *ConsistencyGroupVolumeProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ConsistencyGroupVolumeProvisioningOptions) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupVolumeProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupVolumeProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupVolumeProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ConsistencyGroupVolumeProvisioningOptionsInlineStorageService Determines the placement of any storage object created during this operation.
//
// swagger:model consistency_group_volume_provisioning_options_inline_storage_service
type ConsistencyGroupVolumeProvisioningOptionsInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this consistency group volume provisioning options inline storage service
func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var consistencyGroupVolumeProvisioningOptionsInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		consistencyGroupVolumeProvisioningOptionsInlineStorageServiceTypeNamePropEnum = append(consistencyGroupVolumeProvisioningOptionsInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options_inline_storage_service
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNameExtreme captures enum value "extreme"
	ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options_inline_storage_service
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNamePerformance captures enum value "performance"
	ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// consistency_group_volume_provisioning_options_inline_storage_service
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNameValue captures enum value "value"
	ConsistencyGroupVolumeProvisioningOptionsInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, consistencyGroupVolumeProvisioningOptionsInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this consistency group volume provisioning options inline storage service based on context it is used
func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ConsistencyGroupVolumeProvisioningOptionsInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ConsistencyGroupVolumeProvisioningOptionsInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
