// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Container container
//
// swagger:model container
type Container struct {

	// A list of NAS volumes to provision.<br/>
	//
	// Max Items: 0
	// Min Items: 0
	ContainerInlineVolumes []*ContainerInlineVolumesInlineArrayItem `json:"volumes,omitempty"`

	// provisioning options
	ProvisioningOptions *ContainerInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// svm
	Svm *ContainerInlineSvm `json:"svm,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this container
func (m *Container) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerInlineVolumes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Container) validateContainerInlineVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerInlineVolumes) { // not required
		return nil
	}

	iContainerInlineVolumesSize := int64(len(m.ContainerInlineVolumes))

	if err := validate.MinItems("volumes", "body", iContainerInlineVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iContainerInlineVolumesSize, 0); err != nil {
		return err
	}

	for i := 0; i < len(m.ContainerInlineVolumes); i++ {
		if swag.IsZero(m.ContainerInlineVolumes[i]) { // not required
			continue
		}

		if m.ContainerInlineVolumes[i] != nil {
			if err := m.ContainerInlineVolumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Container) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *Container) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container based on the context it is used
func (m *Container) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainerInlineVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Container) contextValidateContainerInlineVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ContainerInlineVolumes); i++ {

		if m.ContainerInlineVolumes[i] != nil {
			if err := m.ContainerInlineVolumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Container) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *Container) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Container) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Container) UnmarshalBinary(b []byte) error {
	var res Container
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model container_inline_provisioning_options
type ContainerInlineProvisioningOptions struct {

	// A list of aggregates to exclude when determining the placement of the volume.
	//
	// Max Items: 256
	// Min Items: 0
	ExcludeAggregates []*ContainerProvisioningOptionsExcludeAggregatesItems0 `json:"exclude_aggregates,omitempty"`
}

// Validate validates this container inline provisioning options
func (m *ContainerInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineProvisioningOptions) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 256); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container inline provisioning options based on the context it is used
func (m *ContainerInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineProvisioningOptions) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ContainerInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerProvisioningOptionsExcludeAggregatesItems0 container provisioning options exclude aggregates items0
//
// swagger:model ContainerProvisioningOptionsExcludeAggregatesItems0
type ContainerProvisioningOptionsExcludeAggregatesItems0 struct {

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this container provisioning options exclude aggregates items0
func (m *ContainerProvisioningOptionsExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container provisioning options exclude aggregates items0 based on context it is used
func (m *ContainerProvisioningOptionsExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerProvisioningOptionsExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerProvisioningOptionsExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res ContainerProvisioningOptionsExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineSvm The SVM in which the container is located.
//
// swagger:model container_inline_svm
type ContainerInlineSvm struct {

	// links
	Links *ContainerInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container inline svm
func (m *ContainerInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline svm based on the context it is used
func (m *ContainerInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineSvm) UnmarshalBinary(b []byte) error {
	var res ContainerInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineSvmInlineLinks container inline svm inline links
//
// swagger:model container_inline_svm_inline__links
type ContainerInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container inline svm inline links
func (m *ContainerInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline svm inline links based on the context it is used
func (m *ContainerInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ContainerInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItem container inline volumes inline array item
//
// swagger:model container_inline_volumes_inline_array_item
type ContainerInlineVolumesInlineArrayItem struct {

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 256
	// Min Items: 0
	ExcludeAggregates []*ContainerVolumesItems0ExcludeAggregatesItems0 `json:"exclude_aggregates"`

	// flexcache
	Flexcache *ContainerInlineVolumesInlineArrayItemInlineFlexcache `json:"flexcache,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ContainerInlineVolumesInlineArrayItemInlineNas `json:"nas,omitempty"`

	// qos
	Qos *ContainerInlineVolumesInlineArrayItemInlineQos `json:"qos,omitempty"`

	// s3 bucket
	S3Bucket *ContainerInlineVolumesInlineArrayItemInlineS3Bucket `json:"s3_bucket,omitempty"`

	// Denotes a Flexgroup.
	// Enum: [false,true]
	ScaleOut *bool `json:"scale_out,omitempty"`

	// snaplock
	Snaplock *ContainerInlineVolumesInlineArrayItemInlineSnaplock `json:"snaplock,omitempty"`

	// Specifies whether or not snapshot copy locking is enabled on the volume.
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// space
	Space *ContainerInlineVolumesInlineArrayItemInlineSpace `json:"space,omitempty"`

	// storage service
	StorageService *ContainerInlineVolumesInlineArrayItemInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *ContainerInlineVolumesInlineArrayItemInlineTiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this container inline volumes inline array item
func (m *ContainerInlineVolumesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3Bucket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScaleOut(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("exclude_aggregates", "body", iExcludeAggregatesSize, 256); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateS3Bucket(formats strfmt.Registry) error {
	if swag.IsZero(m.S3Bucket) { // not required
		return nil
	}

	if m.S3Bucket != nil {
		if err := m.S3Bucket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

var containerInlineVolumesInlineArrayItemTypeScaleOutPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemTypeScaleOutPropEnum = append(containerInlineVolumesInlineArrayItemTypeScaleOutPropEnum, v)
	}
}

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItem) validateScaleOutEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemTypeScaleOutPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateScaleOut(formats strfmt.Registry) error {
	if swag.IsZero(m.ScaleOut) { // not required
		return nil
	}

	// value enum
	if err := m.validateScaleOutEnum("scale_out", "body", *m.ScaleOut); err != nil {
		return err
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3Bucket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateS3Bucket(ctx context.Context, formats strfmt.Registry) error {

	if m.S3Bucket != nil {
		if err := m.S3Bucket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItem) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumesItems0ExcludeAggregatesItems0 Aggregate
//
// swagger:model ContainerVolumesItems0ExcludeAggregatesItems0
type ContainerVolumesItems0ExcludeAggregatesItems0 struct {

	// links
	Links *ContainerVolumesItems0ExcludeAggregatesItems0Links `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container volumes items0 exclude aggregates items0
func (m *ContainerVolumesItems0ExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0ExcludeAggregatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volumes items0 exclude aggregates items0 based on the context it is used
func (m *ContainerVolumesItems0ExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0ExcludeAggregatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumesItems0ExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumesItems0ExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res ContainerVolumesItems0ExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumesItems0ExcludeAggregatesItems0Links container volumes items0 exclude aggregates items0 links
//
// swagger:model ContainerVolumesItems0ExcludeAggregatesItems0Links
type ContainerVolumesItems0ExcludeAggregatesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container volumes items0 exclude aggregates items0 links
func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volumes items0 exclude aggregates items0 links based on the context it is used
func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumesItems0ExcludeAggregatesItems0Links) UnmarshalBinary(b []byte) error {
	var res ContainerVolumesItems0ExcludeAggregatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineFlexcache The FlexCache origin volume.
//
// swagger:model container_inline_volumes_inline_array_item_inline_flexcache
type ContainerInlineVolumesInlineArrayItemInlineFlexcache struct {

	// If set to true, a DR cache is created.
	DrCache *bool `json:"dr_cache,omitempty"`

	// origins
	Origins []*ContainerVolumeFlexcacheRelationship `json:"origins"`

	// writeback
	Writeback *ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback `json:"writeback,omitempty"`
}

// Validate validates this container inline volumes inline array item inline flexcache
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWriteback(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) validateOrigins(formats strfmt.Registry) error {
	if swag.IsZero(m.Origins) { // not required
		return nil
	}

	for i := 0; i < len(m.Origins); i++ {
		if swag.IsZero(m.Origins[i]) { // not required
			continue
		}

		if m.Origins[i] != nil {
			if err := m.Origins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) validateWriteback(formats strfmt.Registry) error {
	if swag.IsZero(m.Writeback) { // not required
		return nil
	}

	if m.Writeback != nil {
		if err := m.Writeback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline flexcache based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) contextValidateOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Origins); i++ {

		if m.Origins[i] != nil {
			if err := m.Origins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) contextValidateWriteback(ctx context.Context, formats strfmt.Registry) error {

	if m.Writeback != nil {
		if err := m.Writeback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback container inline volumes inline array item inline flexcache inline writeback
//
// swagger:model container_inline_volumes_inline_array_item_inline_flexcache_inline_writeback
type ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback struct {

	// Indicates whether or not writeback is enabled for the FlexCache volume. Writeback is a storage method where data is first written to the FlexCache volume and then written to the origin of a FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this container inline volumes inline array item inline flexcache inline writeback
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container inline volumes inline array item inline flexcache inline writeback based on context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineFlexcacheInlineWriteback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineNas The CIFS share policy and export policies for this volume.
//
// swagger:model container_inline_volumes_inline_array_item_inline_nas
type ContainerInlineVolumesInlineArrayItemInlineNas struct {

	// cifs
	Cifs *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this container inline volumes inline array item inline nas
func (m *ContainerInlineVolumesInlineArrayItemInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var containerInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum = append(containerInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_nas
	// ContainerInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed captures enum value "mixed"
	ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_nas
	// ContainerInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs captures enum value "ntfs"
	ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_nas
	// ContainerInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified captures enum value "unified"
	ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_nas
	// ContainerInlineVolumesInlineArrayItemInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix captures enum value "unix"
	ContainerInlineVolumesInlineArrayItemInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItemInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline nas based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNas) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs container inline volumes inline array item inline nas inline cifs
//
// swagger:model container_inline_volumes_inline_array_item_inline_nas_inline_cifs
type ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this container inline volumes inline array item inline nas inline cifs
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline nas inline cifs based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineNasInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model container_inline_volumes_inline_array_item_inline_nas_inline_export_policy
type ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules"`
}

// Validate validates this container inline volumes inline array item inline nas inline export policy
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline nas inline export policy based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent container inline volumes inline array item inline nas inline junction parent
//
// swagger:model container_inline_volumes_inline_array_item_inline_nas_inline_junction_parent
type ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container inline volumes inline array item inline nas inline junction parent
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline nas inline junction parent based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineQos container inline volumes inline array item inline qos
//
// swagger:model container_inline_volumes_inline_array_item_inline_qos
type ContainerInlineVolumesInlineArrayItemInlineQos struct {

	// policy
	Policy *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this container inline volumes inline array item inline qos
func (m *ContainerInlineVolumesInlineArrayItemInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline qos based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineQos) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy The QoS policy
//
// swagger:model container_inline_volumes_inline_array_item_inline_qos_inline_policy
type ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container inline volumes inline array item inline qos inline policy
func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline qos inline policy based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineS3Bucket The S3 bucket
//
// swagger:model container_inline_volumes_inline_array_item_inline_s3_bucket
type ContainerInlineVolumesInlineArrayItemInlineS3Bucket struct {

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path that corresponds with the NAS bucket.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this container inline volumes inline array item inline s3 bucket
func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("s3_bucket"+"."+"name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("s3_bucket"+"."+"name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline s3 bucket based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineS3Bucket) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineS3Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies are evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
//
// swagger:model container_inline_volumes_inline_array_item_inline_s3_bucket_inline_policy
type ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy struct {

	// Specifies the bucket access policy statement.
	// Max Items: 10
	// Min Items: 0
	Statements []*ContainerVolumesItems0S3BucketPolicyStatementsItems0 `json:"statements"`
}

// Validate validates this container inline volumes inline array item inline s3 bucket inline policy
func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	iStatementsSize := int64(len(m.Statements))

	if err := validate.MinItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline s3 bucket inline policy based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {
			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineS3BucketInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumesItems0S3BucketPolicyStatementsItems0 Specifies information about a single access permission.
//
// swagger:model ContainerVolumesItems0S3BucketPolicyStatementsItems0
type ContainerVolumesItems0S3BucketPolicyStatementsItems0 struct {

	// actions
	// Example: ["GetObject","PutObject","DeleteObject","ListBucket"]
	Actions []*string `json:"actions"`

	// Specifies bucket policy conditions.
	Conditions []*S3BucketPolicyCondition `json:"conditions"`

	// Specifies whether access is allowed or denied when a user requests the specific action. If access (to allow) is not granted explicitly to a resource, access is implicitly denied. Access can also be denied explicitly to a resource, in order to make sure that a user cannot access it, even if a different policy grants access.
	// Example: allow
	// Enum: ["allow","deny"]
	Effect *string `json:"effect,omitempty"`

	// principals
	// Example: ["user1","group/grp1","nasgroup/group1"]
	Principals []*string `json:"principals"`

	// resources
	// Example: ["bucket1","bucket1/*"]
	Resources []*string `json:"resources"`

	// Specifies the statement identifier used to differentiate between statements. The SID length can range from 1 to 256 characters.
	// Example: Full_Access_To_User1!
	// Max Length: 256
	// Min Length: 0
	Sid *string `json:"sid,omitempty"`
}

// Validate validates this container volumes items0 s3 bucket policy statements items0
func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEffect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSid(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) validateConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.Conditions) { // not required
		return nil
	}

	for i := 0; i < len(m.Conditions); i++ {
		if swag.IsZero(m.Conditions[i]) { // not required
			continue
		}

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerVolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allow","deny"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum = append(containerVolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0
	// effect
	// Effect
	// allow
	// END DEBUGGING
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0EffectAllow captures enum value "allow"
	ContainerVolumesItems0S3BucketPolicyStatementsItems0EffectAllow string = "allow"

	// BEGIN DEBUGGING
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0
	// effect
	// Effect
	// deny
	// END DEBUGGING
	// ContainerVolumesItems0S3BucketPolicyStatementsItems0EffectDeny captures enum value "deny"
	ContainerVolumesItems0S3BucketPolicyStatementsItems0EffectDeny string = "deny"
)

// prop value enum
func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) validateEffectEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) validateEffect(formats strfmt.Registry) error {
	if swag.IsZero(m.Effect) { // not required
		return nil
	}

	// value enum
	if err := m.validateEffectEnum("effect", "body", *m.Effect); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) validateSid(formats strfmt.Registry) error {
	if swag.IsZero(m.Sid) { // not required
		return nil
	}

	if err := validate.MinLength("sid", "body", *m.Sid, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("sid", "body", *m.Sid, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container volumes items0 s3 bucket policy statements items0 based on the context it is used
func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) contextValidateConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Conditions); i++ {

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumesItems0S3BucketPolicyStatementsItems0) UnmarshalBinary(b []byte) error {
	var res ContainerVolumesItems0S3BucketPolicyStatementsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineSnaplock container inline volumes inline array item inline snaplock
//
// swagger:model container_inline_volumes_inline_array_item_inline_snaplock
type ContainerInlineVolumesInlineArrayItemInlineSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// retention
	Retention *ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this container inline volumes inline array item inline snaplock
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var containerInlineVolumesInlineArrayItemInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemInlineSnaplockTypeTypePropEnum = append(containerInlineVolumesInlineArrayItemInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_snaplock
	// ContainerInlineVolumesInlineArrayItemInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeCompliance captures enum value "compliance"
	ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_snaplock
	// ContainerInlineVolumesInlineArrayItemInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeEnterprise captures enum value "enterprise"
	ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_snaplock
	// ContainerInlineVolumesInlineArrayItemInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ContainerInlineVolumesInlineArrayItemInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("snaplock"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline snaplock based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention container inline volumes inline array item inline snaplock inline retention
//
// swagger:model container_inline_volumes_inline_array_item_inline_snaplock_inline_retention
type ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this container inline volumes inline array item inline snaplock inline retention
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container inline volumes inline array item inline snaplock inline retention based on context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy This is a reference to the snapshot policy.
//
// swagger:model container_inline_volumes_inline_array_item_inline_snapshot_policy
type ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy struct {

	// links
	Links *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container inline volumes inline array item inline snapshot policy
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline snapshot policy based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks container inline volumes inline array item inline snapshot policy inline links
//
// swagger:model container_inline_volumes_inline_array_item_inline_snapshot_policy_inline__links
type ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container inline volumes inline array item inline snapshot policy inline links
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline snapshot policy inline links based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineSpace container inline volumes inline array item inline space
//
// swagger:model container_inline_volumes_inline_array_item_inline_space
type ContainerInlineVolumesInlineArrayItemInlineSpace struct {

	// The total provisioned size of the container, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`
}

// Validate validates this container inline volumes inline array item inline space
func (m *ContainerInlineVolumesInlineArrayItemInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container inline volumes inline array item inline space based on context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineSpace) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineStorageService Determines the placement of the volume that is to be provisioned.
//
// swagger:model container_inline_volumes_inline_array_item_inline_storage_service
type ContainerInlineVolumesInlineArrayItemInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this container inline volumes inline array item inline storage service
func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerInlineVolumesInlineArrayItemInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemInlineStorageServiceTypeNamePropEnum = append(containerInlineVolumesInlineArrayItemInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_storage_service
	// ContainerInlineVolumesInlineArrayItemInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineStorageServiceNameExtreme captures enum value "extreme"
	ContainerInlineVolumesInlineArrayItemInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_storage_service
	// ContainerInlineVolumesInlineArrayItemInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineStorageServiceNamePerformance captures enum value "performance"
	ContainerInlineVolumesInlineArrayItemInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_storage_service
	// ContainerInlineVolumesInlineArrayItemInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineStorageServiceNameValue captures enum value "value"
	ContainerInlineVolumesInlineArrayItemInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this container inline volumes inline array item inline storage service based on context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerInlineVolumesInlineArrayItemInlineTiering container inline volumes inline array item inline tiering
//
// swagger:model container_inline_volumes_inline_array_item_inline_tiering
type ContainerInlineVolumesInlineArrayItemInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ContainerVolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this container inline volumes inline array item inline tiering
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum = append(containerInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringControlAllowed captures enum value "allowed"
	ContainerInlineVolumesInlineArrayItemInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringControlBestEffort captures enum value "best_effort"
	ContainerInlineVolumesInlineArrayItemInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringControlDisallowed captures enum value "disallowed"
	ContainerInlineVolumesInlineArrayItemInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringControlRequired captures enum value "required"
	ContainerInlineVolumesInlineArrayItemInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum = append(containerInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringPolicyAll captures enum value "all"
	ContainerInlineVolumesInlineArrayItemInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringPolicyAuto captures enum value "auto"
	ContainerInlineVolumesInlineArrayItemInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringPolicyBackup captures enum value "backup"
	ContainerInlineVolumesInlineArrayItemInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringPolicyNone captures enum value "none"
	ContainerInlineVolumesInlineArrayItemInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// container_inline_volumes_inline_array_item_inline_tiering
	// ContainerInlineVolumesInlineArrayItemInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ContainerInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ContainerInlineVolumesInlineArrayItemInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerInlineVolumesInlineArrayItemInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container inline volumes inline array item inline tiering based on the context it is used
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerInlineVolumesInlineArrayItemInlineTiering) UnmarshalBinary(b []byte) error {
	var res ContainerInlineVolumesInlineArrayItemInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumesItems0TieringObjectStoresItems0 container volumes items0 tiering object stores items0
//
// swagger:model ContainerVolumesItems0TieringObjectStoresItems0
type ContainerVolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this container volumes items0 tiering object stores items0
func (m *ContainerVolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container volumes items0 tiering object stores items0 based on context it is used
func (m *ContainerVolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ContainerVolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
