// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ContainerResponse container response
//
// swagger:model container_response
type ContainerResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// container response inline records
	ContainerResponseInlineRecords []*ContainerResponseInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// Number of records.
	// Example: 1
	NumRecords *int64 `json:"num_records,omitempty"`
}

// Validate validates this container response
func (m *ContainerResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateContainerResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponse) validateContainerResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.ContainerResponseInlineRecords); i++ {
		if swag.IsZero(m.ContainerResponseInlineRecords[i]) { // not required
			continue
		}

		if m.ContainerResponseInlineRecords[i] != nil {
			if err := m.ContainerResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response based on the context it is used
func (m *ContainerResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContainerResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponse) contextValidateContainerResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ContainerResponseInlineRecords); i++ {

		if m.ContainerResponseInlineRecords[i] != nil {
			if err := m.ContainerResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponse) UnmarshalBinary(b []byte) error {
	var res ContainerResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseInlineRecordsInlineArrayItem container response inline records inline array item
//
// swagger:model container_response_inline_records_inline_array_item
type ContainerResponseInlineRecordsInlineArrayItem struct {

	// provisioning options
	ProvisioningOptions *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions `json:"provisioning_options,omitempty"`

	// svm
	Svm *ContainerResponseInlineRecordsInlineArrayItemInlineSvm `json:"svm,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`

	// A list of NAS volumes to provision.<br/>
	//
	// Max Items: 0
	// Min Items: 0
	Volumes []*ContainerResponseRecordsItems0VolumesItems0 `json:"volumes"`
}

// Validate validates this container response inline records inline array item
func (m *ContainerResponseInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateProvisioningOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) validateProvisioningOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.ProvisioningOptions) { // not required
		return nil
	}

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(m.Svm) { // not required
		return nil
	}

	if m.Svm != nil {
		if err := m.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) validateVolumes(formats strfmt.Registry) error {
	if swag.IsZero(m.Volumes) { // not required
		return nil
	}

	iVolumesSize := int64(len(m.Volumes))

	if err := validate.MinItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("volumes", "body", iVolumesSize, 0); err != nil {
		return err
	}

	for i := 0; i < len(m.Volumes); i++ {
		if swag.IsZero(m.Volumes[i]) { // not required
			continue
		}

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response inline records inline array item based on the context it is used
func (m *ContainerResponseInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateProvisioningOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) contextValidateProvisioningOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.ProvisioningOptions != nil {
		if err := m.ProvisioningOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("provisioning_options")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if m.Svm != nil {
		if err := m.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItem) contextValidateVolumes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Volumes); i++ {

		if m.Volumes[i] != nil {
			if err := m.Volumes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("volumes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ContainerResponseInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions Options that are applied to the operation.
//
// swagger:model container_response_inline_records_inline_array_item_inline_provisioning_options
type ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions struct {

	// A list of aggregates to exclude when determining the placement of the volume.
	//
	// Max Items: 256
	// Min Items: 0
	ExcludeAggregates []*ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0 `json:"exclude_aggregates"`
}

// Validate validates this container response inline records inline array item inline provisioning options
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("provisioning_options"+"."+"exclude_aggregates", "body", iExcludeAggregatesSize, 256); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response inline records inline array item inline provisioning options based on the context it is used
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("provisioning_options" + "." + "exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions) UnmarshalBinary(b []byte) error {
	var res ContainerResponseInlineRecordsInlineArrayItemInlineProvisioningOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0 container response records items0 provisioning options exclude aggregates items0
//
// swagger:model ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0
type ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0 struct {

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this container response records items0 provisioning options exclude aggregates items0
func (m *ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container response records items0 provisioning options exclude aggregates items0 based on context it is used
func (m *ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0ProvisioningOptionsExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseInlineRecordsInlineArrayItemInlineSvm The SVM in which the container is located.
//
// swagger:model container_response_inline_records_inline_array_item_inline_svm
type ContainerResponseInlineRecordsInlineArrayItemInlineSvm struct {

	// links
	Links *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container response inline records inline array item inline svm
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response inline records inline array item inline svm based on the context it is used
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvm) UnmarshalBinary(b []byte) error {
	var res ContainerResponseInlineRecordsInlineArrayItemInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks container response inline records inline array item inline svm inline links
//
// swagger:model container_response_inline_records_inline_array_item_inline_svm_inline__links
type ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container response inline records inline array item inline svm inline links
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response inline records inline array item inline svm inline links based on the context it is used
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res ContainerResponseInlineRecordsInlineArrayItemInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0 container response records items0 volumes items0
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0
type ContainerResponseRecordsItems0VolumesItems0 struct {

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 256
	// Min Items: 0
	ExcludeAggregates []*ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0 `json:"exclude_aggregates"`

	// flexcache
	Flexcache *ContainerResponseRecordsItems0VolumesItems0Flexcache `json:"flexcache,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ContainerResponseRecordsItems0VolumesItems0Nas `json:"nas,omitempty"`

	// qos
	Qos *ContainerResponseRecordsItems0VolumesItems0Qos `json:"qos,omitempty"`

	// s3 bucket
	S3Bucket *ContainerResponseRecordsItems0VolumesItems0S3Bucket `json:"s3_bucket,omitempty"`

	// Denotes a Flexgroup.
	// Enum: [false,true]
	ScaleOut *bool `json:"scale_out,omitempty"`

	// snaplock
	Snaplock *ContainerResponseRecordsItems0VolumesItems0Snaplock `json:"snaplock,omitempty"`

	// Specifies whether or not snapshot copy locking is enabled on the volume.
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy `json:"snapshot_policy,omitempty"`

	// space
	Space *ContainerResponseRecordsItems0VolumesItems0Space `json:"space,omitempty"`

	// storage service
	StorageService *ContainerResponseRecordsItems0VolumesItems0StorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *ContainerResponseRecordsItems0VolumesItems0Tiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this container response records items0 volumes items0
func (m *ContainerResponseRecordsItems0VolumesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3Bucket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScaleOut(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ExcludeAggregates) { // not required
		return nil
	}

	iExcludeAggregatesSize := int64(len(m.ExcludeAggregates))

	if err := validate.MinItems("exclude_aggregates", "body", iExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("exclude_aggregates", "body", iExcludeAggregatesSize, 256); err != nil {
		return err
	}

	for i := 0; i < len(m.ExcludeAggregates); i++ {
		if swag.IsZero(m.ExcludeAggregates[i]) { // not required
			continue
		}

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateS3Bucket(formats strfmt.Registry) error {
	if swag.IsZero(m.S3Bucket) { // not required
		return nil
	}

	if m.S3Bucket != nil {
		if err := m.S3Bucket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

var containerResponseRecordsItems0VolumesItems0TypeScaleOutPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0TypeScaleOutPropEnum = append(containerResponseRecordsItems0VolumesItems0TypeScaleOutPropEnum, v)
	}
}

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0) validateScaleOutEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0TypeScaleOutPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateScaleOut(formats strfmt.Registry) error {
	if swag.IsZero(m.ScaleOut) { // not required
		return nil
	}

	// value enum
	if err := m.validateScaleOutEnum("scale_out", "body", *m.ScaleOut); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3Bucket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExcludeAggregates); i++ {

		if m.ExcludeAggregates[i] != nil {
			if err := m.ExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateS3Bucket(ctx context.Context, formats strfmt.Registry) error {

	if m.S3Bucket != nil {
		if err := m.S3Bucket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0 Aggregate
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0
type ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0 struct {

	// links
	Links *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container response records items0 volumes items0 exclude aggregates items0
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 exclude aggregates items0 based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links container response records items0 volumes items0 exclude aggregates items0 links
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links
type ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container response records items0 volumes items0 exclude aggregates items0 links
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 exclude aggregates items0 links based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0ExcludeAggregatesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Flexcache The FlexCache origin volume.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Flexcache
type ContainerResponseRecordsItems0VolumesItems0Flexcache struct {

	// If set to true, a DR cache is created.
	DrCache *bool `json:"dr_cache,omitempty"`

	// origins
	Origins []*ContainerVolumeFlexcacheRelationship `json:"origins"`

	// writeback
	Writeback *ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback `json:"writeback,omitempty"`
}

// Validate validates this container response records items0 volumes items0 flexcache
func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWriteback(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) validateOrigins(formats strfmt.Registry) error {
	if swag.IsZero(m.Origins) { // not required
		return nil
	}

	for i := 0; i < len(m.Origins); i++ {
		if swag.IsZero(m.Origins[i]) { // not required
			continue
		}

		if m.Origins[i] != nil {
			if err := m.Origins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) validateWriteback(formats strfmt.Registry) error {
	if swag.IsZero(m.Writeback) { // not required
		return nil
	}

	if m.Writeback != nil {
		if err := m.Writeback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 flexcache based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) contextValidateOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Origins); i++ {

		if m.Origins[i] != nil {
			if err := m.Origins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) contextValidateWriteback(ctx context.Context, formats strfmt.Registry) error {

	if m.Writeback != nil {
		if err := m.Writeback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Flexcache) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Flexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback container response records items0 volumes items0 flexcache writeback
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback
type ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback struct {

	// Indicates whether or not writeback is enabled for the FlexCache volume. Writeback is a storage method where data is first written to the FlexCache volume and then written to the origin of a FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this container response records items0 volumes items0 flexcache writeback
func (m *ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container response records items0 volumes items0 flexcache writeback based on context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0FlexcacheWriteback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Nas The CIFS share policy and export policies for this volume.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Nas
type ContainerResponseRecordsItems0VolumesItems0Nas struct {

	// cifs
	Cifs *ContainerResponseRecordsItems0VolumesItems0NasCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this container response records items0 volumes items0 nas
func (m *ContainerResponseRecordsItems0VolumesItems0Nas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var containerResponseRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum = append(containerResponseRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleMixed captures enum value "mixed"
	ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleNtfs captures enum value "ntfs"
	ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleUnified captures enum value "unified"
	ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// ContainerResponseRecordsItems0VolumesItems0Nas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleUnix captures enum value "unix"
	ContainerResponseRecordsItems0VolumesItems0NasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0Nas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0NasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 nas based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Nas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Nas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Nas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Nas) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Nas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0NasCifs container response records items0 volumes items0 nas cifs
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0NasCifs
type ContainerResponseRecordsItems0VolumesItems0NasCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares"`
}

// Validate validates this container response records items0 volumes items0 nas cifs
func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 nas cifs based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasCifs) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0NasCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0NasExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0NasExportPolicy
type ContainerResponseRecordsItems0VolumesItems0NasExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules"`
}

// Validate validates this container response records items0 volumes items0 nas export policy
func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 nas export policy based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasExportPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0NasExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0NasJunctionParent container response records items0 volumes items0 nas junction parent
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0NasJunctionParent
type ContainerResponseRecordsItems0VolumesItems0NasJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container response records items0 volumes items0 nas junction parent
func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 nas junction parent based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0NasJunctionParent) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0NasJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Qos container response records items0 volumes items0 qos
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Qos
type ContainerResponseRecordsItems0VolumesItems0Qos struct {

	// policy
	Policy *ContainerResponseRecordsItems0VolumesItems0QosPolicy `json:"policy,omitempty"`
}

// Validate validates this container response records items0 volumes items0 qos
func (m *ContainerResponseRecordsItems0VolumesItems0Qos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Qos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 qos based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Qos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Qos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Qos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Qos) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Qos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0QosPolicy The QoS policy
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0QosPolicy
type ContainerResponseRecordsItems0VolumesItems0QosPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container response records items0 volumes items0 qos policy
func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 qos policy based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0QosPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0QosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0S3Bucket The S3 bucket
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0S3Bucket
type ContainerResponseRecordsItems0VolumesItems0S3Bucket struct {

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path that corresponds with the NAS bucket.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy `json:"policy,omitempty"`
}

// Validate validates this container response records items0 volumes items0 s3 bucket
func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("s3_bucket"+"."+"name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("s3_bucket"+"."+"name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 s3 bucket based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3Bucket) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0S3Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies are evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy
type ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy struct {

	// Specifies the bucket access policy statement.
	// Max Items: 10
	// Min Items: 0
	Statements []*ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0 `json:"statements"`
}

// Validate validates this container response records items0 volumes items0 s3 bucket policy
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	iStatementsSize := int64(len(m.Statements))

	if err := validate.MinItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 s3 bucket policy based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {
			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0S3BucketPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0 Specifies information about a single access permission.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
type ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0 struct {

	// actions
	// Example: ["GetObject","PutObject","DeleteObject","ListBucket"]
	Actions []*string `json:"actions"`

	// Specifies bucket policy conditions.
	Conditions []*S3BucketPolicyCondition `json:"conditions"`

	// Specifies whether access is allowed or denied when a user requests the specific action. If access (to allow) is not granted explicitly to a resource, access is implicitly denied. Access can also be denied explicitly to a resource, in order to make sure that a user cannot access it, even if a different policy grants access.
	// Example: allow
	// Enum: ["allow","deny"]
	Effect *string `json:"effect,omitempty"`

	// principals
	// Example: ["user1","group/grp1","nasgroup/group1"]
	Principals []*string `json:"principals"`

	// resources
	// Example: ["bucket1","bucket1/*"]
	Resources []*string `json:"resources"`

	// Specifies the statement identifier used to differentiate between statements. The SID length can range from 1 to 256 characters.
	// Example: Full_Access_To_User1!
	// Max Length: 256
	// Min Length: 0
	Sid *string `json:"sid,omitempty"`
}

// Validate validates this container response records items0 volumes items0 s3 bucket policy statements items0
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEffect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSid(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) validateConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.Conditions) { // not required
		return nil
	}

	for i := 0; i < len(m.Conditions); i++ {
		if swag.IsZero(m.Conditions[i]) { // not required
			continue
		}

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allow","deny"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum = append(containerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
	// effect
	// Effect
	// allow
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0EffectAllow captures enum value "allow"
	ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0EffectAllow string = "allow"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
	// effect
	// Effect
	// deny
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0EffectDeny captures enum value "deny"
	ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0EffectDeny string = "deny"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) validateEffectEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0TypeEffectPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) validateEffect(formats strfmt.Registry) error {
	if swag.IsZero(m.Effect) { // not required
		return nil
	}

	// value enum
	if err := m.validateEffectEnum("effect", "body", *m.Effect); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) validateSid(formats strfmt.Registry) error {
	if swag.IsZero(m.Sid) { // not required
		return nil
	}

	if err := validate.MinLength("sid", "body", *m.Sid, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("sid", "body", *m.Sid, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 s3 bucket policy statements items0 based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) contextValidateConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Conditions); i++ {

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0S3BucketPolicyStatementsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Snaplock container response records items0 volumes items0 snaplock
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Snaplock
type ContainerResponseRecordsItems0VolumesItems0Snaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// retention
	Retention *ContainerResponseRecordsItems0VolumesItems0SnaplockRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this container response records items0 volumes items0 snaplock
func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var containerResponseRecordsItems0VolumesItems0SnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0SnaplockTypeTypePropEnum = append(containerResponseRecordsItems0VolumesItems0SnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0SnaplockTypeCompliance captures enum value "compliance"
	ContainerResponseRecordsItems0VolumesItems0SnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0SnaplockTypeEnterprise captures enum value "enterprise"
	ContainerResponseRecordsItems0VolumesItems0SnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// ContainerResponseRecordsItems0VolumesItems0Snaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0SnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ContainerResponseRecordsItems0VolumesItems0SnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0SnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("snaplock"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 snaplock based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Snaplock) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Snaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0SnaplockRetention container response records items0 volumes items0 snaplock retention
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0SnaplockRetention
type ContainerResponseRecordsItems0VolumesItems0SnaplockRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this container response records items0 volumes items0 snaplock retention
func (m *ContainerResponseRecordsItems0VolumesItems0SnaplockRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container response records items0 volumes items0 snaplock retention based on context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0SnaplockRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnaplockRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnaplockRetention) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0SnaplockRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy This is a reference to the snapshot policy.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy
type ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy struct {

	// links
	Links *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container response records items0 volumes items0 snapshot policy
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 snapshot policy based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0SnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks container response records items0 volumes items0 snapshot policy links
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks
type ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container response records items0 volumes items0 snapshot policy links
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 snapshot policy links based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0SnapshotPolicyLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Space container response records items0 volumes items0 space
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Space
type ContainerResponseRecordsItems0VolumesItems0Space struct {

	// The total provisioned size of the container, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`
}

// Validate validates this container response records items0 volumes items0 space
func (m *ContainerResponseRecordsItems0VolumesItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container response records items0 volumes items0 space based on context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Space) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Space) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0StorageService Determines the placement of the volume that is to be provisioned.
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0StorageService
type ContainerResponseRecordsItems0VolumesItems0StorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this container response records items0 volumes items0 storage service
func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerResponseRecordsItems0VolumesItems0StorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0StorageServiceTypeNamePropEnum = append(containerResponseRecordsItems0VolumesItems0StorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageServiceNameExtreme captures enum value "extreme"
	ContainerResponseRecordsItems0VolumesItems0StorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageServiceNamePerformance captures enum value "performance"
	ContainerResponseRecordsItems0VolumesItems0StorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// ContainerResponseRecordsItems0VolumesItems0StorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0StorageServiceNameValue captures enum value "value"
	ContainerResponseRecordsItems0VolumesItems0StorageServiceNameValue string = "value"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0StorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this container response records items0 volumes items0 storage service based on context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0StorageService) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0StorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0Tiering container response records items0 volumes items0 tiering
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0Tiering
type ContainerResponseRecordsItems0VolumesItems0Tiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0 `json:"object_stores"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this container response records items0 volumes items0 tiering
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerResponseRecordsItems0VolumesItems0TieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0TieringTypeControlPropEnum = append(containerResponseRecordsItems0VolumesItems0TieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringControlAllowed captures enum value "allowed"
	ContainerResponseRecordsItems0VolumesItems0TieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringControlBestEffort captures enum value "best_effort"
	ContainerResponseRecordsItems0VolumesItems0TieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringControlDisallowed captures enum value "disallowed"
	ContainerResponseRecordsItems0VolumesItems0TieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringControlRequired captures enum value "required"
	ContainerResponseRecordsItems0VolumesItems0TieringControlRequired string = "required"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0TieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerResponseRecordsItems0VolumesItems0TieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerResponseRecordsItems0VolumesItems0TieringTypePolicyPropEnum = append(containerResponseRecordsItems0VolumesItems0TieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringPolicyAll captures enum value "all"
	ContainerResponseRecordsItems0VolumesItems0TieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringPolicyAuto captures enum value "auto"
	ContainerResponseRecordsItems0VolumesItems0TieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringPolicyBackup captures enum value "backup"
	ContainerResponseRecordsItems0VolumesItems0TieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringPolicyNone captures enum value "none"
	ContainerResponseRecordsItems0VolumesItems0TieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// ContainerResponseRecordsItems0VolumesItems0Tiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ContainerResponseRecordsItems0VolumesItems0TieringPolicySnapshotOnly captures enum value "snapshot_only"
	ContainerResponseRecordsItems0VolumesItems0TieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerResponseRecordsItems0VolumesItems0TieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container response records items0 volumes items0 tiering based on the context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0Tiering) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0Tiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0 container response records items0 volumes items0 tiering object stores items0
//
// swagger:model ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0
type ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this container response records items0 volumes items0 tiering object stores items0
func (m *ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container response records items0 volumes items0 tiering object stores items0 based on context it is used
func (m *ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ContainerResponseRecordsItems0VolumesItems0TieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
