// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ContainerVolume container volume
//
// swagger:model container_volume
type ContainerVolume struct {

	// A list of aggregates to exclude when determining the placement of the volume. <br/>
	//
	// Max Items: 256
	// Min Items: 0
	ContainerVolumeInlineExcludeAggregates []*ContainerVolumeInlineExcludeAggregatesInlineArrayItem `json:"exclude_aggregates,omitempty"`

	// flexcache
	Flexcache *ContainerVolumeInlineFlexcache `json:"flexcache,omitempty"`

	// Volume name. The name of volume must start with an alphabetic character (a to z or A to Z) or an underscore (_). The name must be 197 or fewer characters in length for FlexGroup volumes, and 203 or fewer characters in length for all other types of volumes. Volume names must be unique within an SVM. Required on POST.
	// Example: vol_cs_dept
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nas
	Nas *ContainerVolumeInlineNas `json:"nas,omitempty"`

	// qos
	Qos *ContainerVolumeInlineQos `json:"qos,omitempty"`

	// s3 bucket
	S3Bucket *ContainerVolumeInlineS3Bucket `json:"s3_bucket,omitempty"`

	// Denotes a Flexgroup.
	// Enum: [false,true]
	ScaleOut *bool `json:"scale_out,omitempty"`

	// snaplock
	Snaplock *ContainerVolumeInlineSnaplock `json:"snaplock,omitempty"`

	// Specifies whether or not snapshot copy locking is enabled on the volume.
	SnapshotLockingEnabled *bool `json:"snapshot_locking_enabled,omitempty"`

	// snapshot policy
	SnapshotPolicy *ContainerVolumeInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// space
	Space *ContainerVolumeInlineSpace `json:"space,omitempty"`

	// storage service
	StorageService *ContainerVolumeInlineStorageService `json:"storage_service,omitempty"`

	// tiering
	Tiering *ContainerVolumeInlineTiering `json:"tiering,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning the volume. Only mirrored aggregates are used if this parameter is set to _true_ and only unmirrored aggregates are used if this parameter is set to _false_. The default value is _true_ for a MetroCluster configuration and is _false_ for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`
}

// Validate validates this container volume
func (m *ContainerVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContainerVolumeInlineExcludeAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFlexcache(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateQos(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateS3Bucket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateScaleOut(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnaplock(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTiering(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolume) validateContainerVolumeInlineExcludeAggregates(formats strfmt.Registry) error {
	if swag.IsZero(m.ContainerVolumeInlineExcludeAggregates) { // not required
		return nil
	}

	iContainerVolumeInlineExcludeAggregatesSize := int64(len(m.ContainerVolumeInlineExcludeAggregates))

	if err := validate.MinItems("exclude_aggregates", "body", iContainerVolumeInlineExcludeAggregatesSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("exclude_aggregates", "body", iContainerVolumeInlineExcludeAggregatesSize, 256); err != nil {
		return err
	}

	for i := 0; i < len(m.ContainerVolumeInlineExcludeAggregates); i++ {
		if swag.IsZero(m.ContainerVolumeInlineExcludeAggregates[i]) { // not required
			continue
		}

		if m.ContainerVolumeInlineExcludeAggregates[i] != nil {
			if err := m.ContainerVolumeInlineExcludeAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerVolume) validateFlexcache(formats strfmt.Registry) error {
	if swag.IsZero(m.Flexcache) { // not required
		return nil
	}

	if m.Flexcache != nil {
		if err := m.Flexcache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *m.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *m.Name, 203); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolume) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(m.Nas) { // not required
		return nil
	}

	if m.Nas != nil {
		if err := m.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateQos(formats strfmt.Registry) error {
	if swag.IsZero(m.Qos) { // not required
		return nil
	}

	if m.Qos != nil {
		if err := m.Qos.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateS3Bucket(formats strfmt.Registry) error {
	if swag.IsZero(m.S3Bucket) { // not required
		return nil
	}

	if m.S3Bucket != nil {
		if err := m.S3Bucket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

var containerVolumeTypeScaleOutPropEnum []interface{}

func init() {
	var res []bool
	if err := json.Unmarshal([]byte(`[false,true]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeTypeScaleOutPropEnum = append(containerVolumeTypeScaleOutPropEnum, v)
	}
}

// prop value enum
func (m *ContainerVolume) validateScaleOutEnum(path, location string, value bool) error {
	if err := validate.EnumCase(path, location, value, containerVolumeTypeScaleOutPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolume) validateScaleOut(formats strfmt.Registry) error {
	if swag.IsZero(m.ScaleOut) { // not required
		return nil
	}

	// value enum
	if err := m.validateScaleOutEnum("scale_out", "body", *m.ScaleOut); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolume) validateSnaplock(formats strfmt.Registry) error {
	if swag.IsZero(m.Snaplock) { // not required
		return nil
	}

	if m.Snaplock != nil {
		if err := m.Snaplock.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.SnapshotPolicy) { // not required
		return nil
	}

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(m.Space) { // not required
		return nil
	}

	if m.Space != nil {
		if err := m.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(m.StorageService) { // not required
		return nil
	}

	if m.StorageService != nil {
		if err := m.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) validateTiering(formats strfmt.Registry) error {
	if swag.IsZero(m.Tiering) { // not required
		return nil
	}

	if m.Tiering != nil {
		if err := m.Tiering.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume based on the context it is used
func (m *ContainerVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContainerVolumeInlineExcludeAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFlexcache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateQos(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateS3Bucket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnaplock(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTiering(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolume) contextValidateContainerVolumeInlineExcludeAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ContainerVolumeInlineExcludeAggregates); i++ {

		if m.ContainerVolumeInlineExcludeAggregates[i] != nil {
			if err := m.ContainerVolumeInlineExcludeAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("exclude_aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerVolume) contextValidateFlexcache(ctx context.Context, formats strfmt.Registry) error {

	if m.Flexcache != nil {
		if err := m.Flexcache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if m.Nas != nil {
		if err := m.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateQos(ctx context.Context, formats strfmt.Registry) error {

	if m.Qos != nil {
		if err := m.Qos.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateS3Bucket(ctx context.Context, formats strfmt.Registry) error {

	if m.S3Bucket != nil {
		if err := m.S3Bucket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateSnaplock(ctx context.Context, formats strfmt.Registry) error {

	if m.Snaplock != nil {
		if err := m.Snaplock.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.SnapshotPolicy != nil {
		if err := m.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if m.Space != nil {
		if err := m.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if m.StorageService != nil {
		if err := m.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolume) contextValidateTiering(ctx context.Context, formats strfmt.Registry) error {

	if m.Tiering != nil {
		if err := m.Tiering.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tiering")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolume) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolume) UnmarshalBinary(b []byte) error {
	var res ContainerVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineExcludeAggregatesInlineArrayItem Aggregate
//
// swagger:model container_volume_inline_exclude_aggregates_inline_array_item
type ContainerVolumeInlineExcludeAggregatesInlineArrayItem struct {

	// links
	Links *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container volume inline exclude aggregates inline array item
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline exclude aggregates inline array item based on the context it is used
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineExcludeAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks container volume inline exclude aggregates inline array item inline links
//
// swagger:model container_volume_inline_exclude_aggregates_inline_array_item_inline__links
type ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container volume inline exclude aggregates inline array item inline links
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline exclude aggregates inline array item inline links based on the context it is used
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineExcludeAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineFlexcache The FlexCache origin volume.
//
// swagger:model container_volume_inline_flexcache
type ContainerVolumeInlineFlexcache struct {

	// If set to true, a DR cache is created.
	DrCache *bool `json:"dr_cache,omitempty"`

	// origins
	Origins []*ContainerVolumeFlexcacheRelationship `json:"origins,omitempty"`

	// writeback
	Writeback *ContainerVolumeInlineFlexcacheInlineWriteback `json:"writeback,omitempty"`
}

// Validate validates this container volume inline flexcache
func (m *ContainerVolumeInlineFlexcache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWriteback(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineFlexcache) validateOrigins(formats strfmt.Registry) error {
	if swag.IsZero(m.Origins) { // not required
		return nil
	}

	for i := 0; i < len(m.Origins); i++ {
		if swag.IsZero(m.Origins[i]) { // not required
			continue
		}

		if m.Origins[i] != nil {
			if err := m.Origins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerVolumeInlineFlexcache) validateWriteback(formats strfmt.Registry) error {
	if swag.IsZero(m.Writeback) { // not required
		return nil
	}

	if m.Writeback != nil {
		if err := m.Writeback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline flexcache based on the context it is used
func (m *ContainerVolumeInlineFlexcache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWriteback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineFlexcache) contextValidateOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Origins); i++ {

		if m.Origins[i] != nil {
			if err := m.Origins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("flexcache" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ContainerVolumeInlineFlexcache) contextValidateWriteback(ctx context.Context, formats strfmt.Registry) error {

	if m.Writeback != nil {
		if err := m.Writeback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("flexcache" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineFlexcache) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineFlexcache) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineFlexcache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineFlexcacheInlineWriteback container volume inline flexcache inline writeback
//
// swagger:model container_volume_inline_flexcache_inline_writeback
type ContainerVolumeInlineFlexcacheInlineWriteback struct {

	// Indicates whether or not writeback is enabled for the FlexCache volume. Writeback is a storage method where data is first written to the FlexCache volume and then written to the origin of a FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this container volume inline flexcache inline writeback
func (m *ContainerVolumeInlineFlexcacheInlineWriteback) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container volume inline flexcache inline writeback based on context it is used
func (m *ContainerVolumeInlineFlexcacheInlineWriteback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineFlexcacheInlineWriteback) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineFlexcacheInlineWriteback) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineFlexcacheInlineWriteback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineNas The CIFS share policy and export policies for this volume.
//
// swagger:model container_volume_inline_nas
type ContainerVolumeInlineNas struct {

	// cifs
	Cifs *ContainerVolumeInlineNasInlineCifs `json:"cifs,omitempty"`

	// export policy
	ExportPolicy *ContainerVolumeInlineNasInlineExportPolicy `json:"export_policy,omitempty"`

	// The UNIX group ID of the volume. Valid in POST or PATCH.
	Gid *int64 `json:"gid,omitempty"`

	// junction parent
	JunctionParent *ContainerVolumeInlineNasInlineJunctionParent `json:"junction_parent,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the volume is mounted. The path is case insensitive and must be unique within an SVM's namespace. Path must begin with '/' and must not end with '/'. Only one volume can be mounted at any given junction path. An empty path in POST creates an unmounted volume. An empty path in PATCH deactivates and unmounts the volume. Taking a volume offline or restricted state removes its junction path. This attribute is reported in GET only when the volume is mounted.
	// Example: /user/my_volume
	Path *string `json:"path,omitempty"`

	// Security style associated with the volume. Valid in POST or PATCH.<br>mixed &dash; Mixed-style security<br>ntfs &dash; NTFS/WIndows-style security<br>unified &dash; Unified-style security, unified UNIX, NFS and CIFS permissions<br>unix &dash; UNIX-style security.
	// Enum: ["mixed","ntfs","unified","unix"]
	SecurityStyle *string `json:"security_style,omitempty"`

	// The UNIX user ID of the volume. Valid in POST or PATCH.
	UID *int64 `json:"uid,omitempty"`

	// UNIX permissions to be viewed as an octal number, consisting of 4 digits derived by adding up bits 4 (read), 2 (write), and 1 (execute). First digit selects the set user ID (4), set group ID (2), and sticky (1) attributes. Second digit selects permission for the owner of the file. Third selects permissions for other users in the same group while the fourth selects permissions for other users not in the group. Valid in POST or PATCH. For security style "mixed" or "unix", the default setting is 0755 in octal (493 in decimal) and for security style "ntfs", the default setting is 0000. In cases where only owner, group, and other permissions are given (as in 755, representing the second, third and fourth digit), the first digit is assumed to be zero.
	// Example: 493
	UnixPermissions *int64 `json:"unix_permissions,omitempty"`
}

// Validate validates this container volume inline nas
func (m *ContainerVolumeInlineNas) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExportPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJunctionParent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityStyle(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNas) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(m.Cifs) { // not required
		return nil
	}

	if m.Cifs != nil {
		if err := m.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNas) validateExportPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.ExportPolicy) { // not required
		return nil
	}

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNas) validateJunctionParent(formats strfmt.Registry) error {
	if swag.IsZero(m.JunctionParent) { // not required
		return nil
	}

	if m.JunctionParent != nil {
		if err := m.JunctionParent.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

var containerVolumeInlineNasTypeSecurityStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["mixed","ntfs","unified","unix"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeInlineNasTypeSecurityStylePropEnum = append(containerVolumeInlineNasTypeSecurityStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_volume_inline_nas
	// ContainerVolumeInlineNas
	// security_style
	// SecurityStyle
	// mixed
	// END DEBUGGING
	// ContainerVolumeInlineNasSecurityStyleMixed captures enum value "mixed"
	ContainerVolumeInlineNasSecurityStyleMixed string = "mixed"

	// BEGIN DEBUGGING
	// container_volume_inline_nas
	// ContainerVolumeInlineNas
	// security_style
	// SecurityStyle
	// ntfs
	// END DEBUGGING
	// ContainerVolumeInlineNasSecurityStyleNtfs captures enum value "ntfs"
	ContainerVolumeInlineNasSecurityStyleNtfs string = "ntfs"

	// BEGIN DEBUGGING
	// container_volume_inline_nas
	// ContainerVolumeInlineNas
	// security_style
	// SecurityStyle
	// unified
	// END DEBUGGING
	// ContainerVolumeInlineNasSecurityStyleUnified captures enum value "unified"
	ContainerVolumeInlineNasSecurityStyleUnified string = "unified"

	// BEGIN DEBUGGING
	// container_volume_inline_nas
	// ContainerVolumeInlineNas
	// security_style
	// SecurityStyle
	// unix
	// END DEBUGGING
	// ContainerVolumeInlineNasSecurityStyleUnix captures enum value "unix"
	ContainerVolumeInlineNasSecurityStyleUnix string = "unix"
)

// prop value enum
func (m *ContainerVolumeInlineNas) validateSecurityStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeInlineNasTypeSecurityStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeInlineNas) validateSecurityStyle(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityStyle) { // not required
		return nil
	}

	// value enum
	if err := m.validateSecurityStyleEnum("nas"+"."+"security_style", "body", *m.SecurityStyle); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container volume inline nas based on the context it is used
func (m *ContainerVolumeInlineNas) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExportPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJunctionParent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNas) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if m.Cifs != nil {
		if err := m.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNas) contextValidateExportPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.ExportPolicy != nil {
		if err := m.ExportPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNas) contextValidateJunctionParent(ctx context.Context, formats strfmt.Registry) error {

	if m.JunctionParent != nil {
		if err := m.JunctionParent.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineNas) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineNas) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineNas
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineNasInlineCifs container volume inline nas inline cifs
//
// swagger:model container_volume_inline_nas_inline_cifs
type ContainerVolumeInlineNasInlineCifs struct {

	// shares
	Shares []*ConsistencyGroupCifsShare `json:"shares,omitempty"`
}

// Validate validates this container volume inline nas inline cifs
func (m *ContainerVolumeInlineNasInlineCifs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateShares(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineCifs) validateShares(formats strfmt.Registry) error {
	if swag.IsZero(m.Shares) { // not required
		return nil
	}

	for i := 0; i < len(m.Shares); i++ {
		if swag.IsZero(m.Shares[i]) { // not required
			continue
		}

		if m.Shares[i] != nil {
			if err := m.Shares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container volume inline nas inline cifs based on the context it is used
func (m *ContainerVolumeInlineNasInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateShares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineCifs) contextValidateShares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Shares); i++ {

		if m.Shares[i] != nil {
			if err := m.Shares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "cifs" + "." + "shares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineCifs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineCifs) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineNasInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineNasInlineExportPolicy The policy associated with volumes to export them for protocol access.
//
// swagger:model container_volume_inline_nas_inline_export_policy
type ContainerVolumeInlineNasInlineExportPolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// Identifier for the export policy.
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Name of the export policy.
	Name *string `json:"name,omitempty"`

	// The set of rules that govern the export policy.
	Rules []*ExportRules `json:"rules,omitempty"`
}

// Validate validates this container volume inline nas inline export policy
func (m *ContainerVolumeInlineNasInlineExportPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineExportPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNasInlineExportPolicy) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(m.Rules) { // not required
		return nil
	}

	for i := 0; i < len(m.Rules); i++ {
		if swag.IsZero(m.Rules[i]) { // not required
			continue
		}

		if m.Rules[i] != nil {
			if err := m.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container volume inline nas inline export policy based on the context it is used
func (m *ContainerVolumeInlineNasInlineExportPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineExportPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "export_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerVolumeInlineNasInlineExportPolicy) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "nas"+"."+"export_policy"+"."+"id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolumeInlineNasInlineExportPolicy) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Rules); i++ {

		if m.Rules[i] != nil {
			if err := m.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nas" + "." + "export_policy" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineExportPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineExportPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineNasInlineExportPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineNasInlineJunctionParent container volume inline nas inline junction parent
//
// swagger:model container_volume_inline_nas_inline_junction_parent
type ContainerVolumeInlineNasInlineJunctionParent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The name of the parent volume that contains the junction inode of this volume. The junction parent volume must belong to the same SVM that owns this volume.
	// Example: vs1_root
	Name *string `json:"name,omitempty"`

	// Unique identifier for the parent volume.
	// Example: 75c9cfb0-3eb4-11eb-9fb4-005056bb088a
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container volume inline nas inline junction parent
func (m *ContainerVolumeInlineNasInlineJunctionParent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineJunctionParent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline nas inline junction parent based on the context it is used
func (m *ContainerVolumeInlineNasInlineJunctionParent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineNasInlineJunctionParent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("nas" + "." + "junction_parent" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineJunctionParent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineNasInlineJunctionParent) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineNasInlineJunctionParent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineQos container volume inline qos
//
// swagger:model container_volume_inline_qos
type ContainerVolumeInlineQos struct {

	// policy
	Policy *ContainerVolumeInlineQosInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this container volume inline qos
func (m *ContainerVolumeInlineQos) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineQos) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline qos based on the context it is used
func (m *ContainerVolumeInlineQos) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineQos) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineQos) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineQos) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineQos
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineQosInlinePolicy The QoS policy
//
// swagger:model container_volume_inline_qos_inline_policy
type ContainerVolumeInlineQosInlinePolicy struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container volume inline qos inline policy
func (m *ContainerVolumeInlineQosInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineQosInlinePolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline qos inline policy based on the context it is used
func (m *ContainerVolumeInlineQosInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineQosInlinePolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("qos" + "." + "policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineQosInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineQosInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineQosInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineS3Bucket The S3 bucket
//
// swagger:model container_volume_inline_s3_bucket
type ContainerVolumeInlineS3Bucket struct {

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path that corresponds with the NAS bucket.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *ContainerVolumeInlineS3BucketInlinePolicy `json:"policy,omitempty"`
}

// Validate validates this container volume inline s3 bucket
func (m *ContainerVolumeInlineS3Bucket) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineS3Bucket) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	if err := validate.MinLength("s3_bucket"+"."+"name", "body", *m.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("s3_bucket"+"."+"name", "body", *m.Name, 63); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolumeInlineS3Bucket) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	if m.Policy != nil {
		if err := m.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline s3 bucket based on the context it is used
func (m *ContainerVolumeInlineS3Bucket) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineS3Bucket) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.Policy != nil {
		if err := m.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("s3_bucket" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineS3Bucket) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineS3Bucket) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineS3Bucket
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineS3BucketInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies are evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
//
// swagger:model container_volume_inline_s3_bucket_inline_policy
type ContainerVolumeInlineS3BucketInlinePolicy struct {

	// Specifies the bucket access policy statement.
	// Max Items: 10
	// Min Items: 0
	Statements []*ContainerVolumeS3BucketPolicyStatementsItems0 `json:"statements,omitempty"`
}

// Validate validates this container volume inline s3 bucket inline policy
func (m *ContainerVolumeInlineS3BucketInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineS3BucketInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(m.Statements) { // not required
		return nil
	}

	iStatementsSize := int64(len(m.Statements))

	if err := validate.MinItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("s3_bucket"+"."+"policy"+"."+"statements", "body", iStatementsSize, 10); err != nil {
		return err
	}

	for i := 0; i < len(m.Statements); i++ {
		if swag.IsZero(m.Statements[i]) { // not required
			continue
		}

		if m.Statements[i] != nil {
			if err := m.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this container volume inline s3 bucket inline policy based on the context it is used
func (m *ContainerVolumeInlineS3BucketInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineS3BucketInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Statements); i++ {

		if m.Statements[i] != nil {
			if err := m.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("s3_bucket" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineS3BucketInlinePolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineS3BucketInlinePolicy) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineS3BucketInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeS3BucketPolicyStatementsItems0 Specifies information about a single access permission.
//
// swagger:model ContainerVolumeS3BucketPolicyStatementsItems0
type ContainerVolumeS3BucketPolicyStatementsItems0 struct {

	// actions
	// Example: ["GetObject","PutObject","DeleteObject","ListBucket"]
	Actions []*string `json:"actions"`

	// Specifies bucket policy conditions.
	Conditions []*S3BucketPolicyCondition `json:"conditions"`

	// Specifies whether access is allowed or denied when a user requests the specific action. If access (to allow) is not granted explicitly to a resource, access is implicitly denied. Access can also be denied explicitly to a resource, in order to make sure that a user cannot access it, even if a different policy grants access.
	// Example: allow
	// Enum: ["allow","deny"]
	Effect *string `json:"effect,omitempty"`

	// principals
	// Example: ["user1","group/grp1","nasgroup/group1"]
	Principals []*string `json:"principals"`

	// resources
	// Example: ["bucket1","bucket1/*"]
	Resources []*string `json:"resources"`

	// Specifies the statement identifier used to differentiate between statements. The SID length can range from 1 to 256 characters.
	// Example: Full_Access_To_User1!
	// Max Length: 256
	// Min Length: 0
	Sid *string `json:"sid,omitempty"`
}

// Validate validates this container volume s3 bucket policy statements items0
func (m *ContainerVolumeS3BucketPolicyStatementsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConditions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateEffect(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSid(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeS3BucketPolicyStatementsItems0) validateConditions(formats strfmt.Registry) error {
	if swag.IsZero(m.Conditions) { // not required
		return nil
	}

	for i := 0; i < len(m.Conditions); i++ {
		if swag.IsZero(m.Conditions[i]) { // not required
			continue
		}

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerVolumeS3BucketPolicyStatementsItems0TypeEffectPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allow","deny"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeS3BucketPolicyStatementsItems0TypeEffectPropEnum = append(containerVolumeS3BucketPolicyStatementsItems0TypeEffectPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ContainerVolumeS3BucketPolicyStatementsItems0
	// ContainerVolumeS3BucketPolicyStatementsItems0
	// effect
	// Effect
	// allow
	// END DEBUGGING
	// ContainerVolumeS3BucketPolicyStatementsItems0EffectAllow captures enum value "allow"
	ContainerVolumeS3BucketPolicyStatementsItems0EffectAllow string = "allow"

	// BEGIN DEBUGGING
	// ContainerVolumeS3BucketPolicyStatementsItems0
	// ContainerVolumeS3BucketPolicyStatementsItems0
	// effect
	// Effect
	// deny
	// END DEBUGGING
	// ContainerVolumeS3BucketPolicyStatementsItems0EffectDeny captures enum value "deny"
	ContainerVolumeS3BucketPolicyStatementsItems0EffectDeny string = "deny"
)

// prop value enum
func (m *ContainerVolumeS3BucketPolicyStatementsItems0) validateEffectEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeS3BucketPolicyStatementsItems0TypeEffectPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeS3BucketPolicyStatementsItems0) validateEffect(formats strfmt.Registry) error {
	if swag.IsZero(m.Effect) { // not required
		return nil
	}

	// value enum
	if err := m.validateEffectEnum("effect", "body", *m.Effect); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolumeS3BucketPolicyStatementsItems0) validateSid(formats strfmt.Registry) error {
	if swag.IsZero(m.Sid) { // not required
		return nil
	}

	if err := validate.MinLength("sid", "body", *m.Sid, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("sid", "body", *m.Sid, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container volume s3 bucket policy statements items0 based on the context it is used
func (m *ContainerVolumeS3BucketPolicyStatementsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConditions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeS3BucketPolicyStatementsItems0) contextValidateConditions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Conditions); i++ {

		if m.Conditions[i] != nil {
			if err := m.Conditions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("conditions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeS3BucketPolicyStatementsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeS3BucketPolicyStatementsItems0) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeS3BucketPolicyStatementsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineSnaplock container volume inline snaplock
//
// swagger:model container_volume_inline_snaplock
type ContainerVolumeInlineSnaplock struct {

	// Specifies if the volume append mode is enabled or disabled. When it is enabled, all the files created with write permissions on the volume are, by default, WORM appendable files. The user can append the data to a WORM appendable file but cannot modify the existing contents of the file nor delete the file until it expires.
	// Example: false
	AppendModeEnabled *bool `json:"append_mode_enabled,omitempty"`

	// Specifies the autocommit period for SnapLock volume. All files which are not modified for a period greater than the autocommit period of the volume are committed to the WORM state. The autocommit period value represents a duration and must be specified in the ISO-8601 duration format. The autocommit period can be in years, months, days, hours, and minutes. A period specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The period string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the autocommit field also accepts the string "none".
	// Example: P30M
	AutocommitPeriod *string `json:"autocommit_period,omitempty"`

	// retention
	Retention *ContainerVolumeInlineSnaplockInlineRetention `json:"retention,omitempty"`

	// The SnapLock type of the volume. <br>compliance &dash; A SnapLock Compliance(SLC) volume provides the highest level of WORM protection and an administrator cannot destroy a SLC volume if it contains unexpired WORM files. <br> enterprise &dash; An administrator can delete a SnapLock Enterprise(SLE) volume.<br> non_snaplock &dash; Indicates the volume is non-snaplock.
	// Example: enterprise
	// Enum: ["compliance","enterprise","non_snaplock"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this container volume inline snaplock
func (m *ContainerVolumeInlineSnaplock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnaplock) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(m.Retention) { // not required
		return nil
	}

	if m.Retention != nil {
		if err := m.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var containerVolumeInlineSnaplockTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["compliance","enterprise","non_snaplock"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeInlineSnaplockTypeTypePropEnum = append(containerVolumeInlineSnaplockTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_volume_inline_snaplock
	// ContainerVolumeInlineSnaplock
	// type
	// Type
	// compliance
	// END DEBUGGING
	// ContainerVolumeInlineSnaplockTypeCompliance captures enum value "compliance"
	ContainerVolumeInlineSnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// container_volume_inline_snaplock
	// ContainerVolumeInlineSnaplock
	// type
	// Type
	// enterprise
	// END DEBUGGING
	// ContainerVolumeInlineSnaplockTypeEnterprise captures enum value "enterprise"
	ContainerVolumeInlineSnaplockTypeEnterprise string = "enterprise"

	// BEGIN DEBUGGING
	// container_volume_inline_snaplock
	// ContainerVolumeInlineSnaplock
	// type
	// Type
	// non_snaplock
	// END DEBUGGING
	// ContainerVolumeInlineSnaplockTypeNonSnaplock captures enum value "non_snaplock"
	ContainerVolumeInlineSnaplockTypeNonSnaplock string = "non_snaplock"
)

// prop value enum
func (m *ContainerVolumeInlineSnaplock) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeInlineSnaplockTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeInlineSnaplock) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("snaplock"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container volume inline snaplock based on the context it is used
func (m *ContainerVolumeInlineSnaplock) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnaplock) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if m.Retention != nil {
		if err := m.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snaplock" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineSnaplock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineSnaplock) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineSnaplock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineSnaplockInlineRetention container volume inline snaplock inline retention
//
// swagger:model container_volume_inline_snaplock_inline_retention
type ContainerVolumeInlineSnaplockInlineRetention struct {

	// Specifies the default retention period that is applied to files while committing them to the WORM state without an associated retention period. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period and the string "unspecified" to set an unspecified retention period.
	// Example: P30Y
	Default *string `json:"default,omitempty"`

	// Specifies the maximum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, months, and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Maximum *string `json:"maximum,omitempty"`

	// Specifies the minimum allowed retention period for files committed to the WORM state on the volume. The retention value represents a duration and must be specified in the ISO-8601 duration format. The retention period can be in years, months, days, hours, and minutes. A duration specified for years, month,s and days is represented in the ISO-8601 format as "P<num>Y", "P<num>M", "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. A duration in hours and minutes is represented by "PT<num>H" and "PT<num>M" respectively. The retention string must contain only a single time element that is, either years, months, days, hours, or minutes. A duration which combines different periods is not supported, for example "P1Y10M" is not supported. Apart from the duration specified in the ISO-8601 format, the duration field also accepts the string "infinite" to set an infinite retention period.
	// Example: P30Y
	Minimum *string `json:"minimum,omitempty"`
}

// Validate validates this container volume inline snaplock inline retention
func (m *ContainerVolumeInlineSnaplockInlineRetention) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container volume inline snaplock inline retention based on context it is used
func (m *ContainerVolumeInlineSnaplockInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineSnaplockInlineRetention) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineSnaplockInlineRetention) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineSnaplockInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineSnapshotPolicy This is a reference to the snapshot policy.
//
// swagger:model container_volume_inline_snapshot_policy
type ContainerVolumeInlineSnapshotPolicy struct {

	// links
	Links *ContainerVolumeInlineSnapshotPolicyInlineLinks `json:"_links,omitempty"`

	// name
	// Example: default
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this container volume inline snapshot policy
func (m *ContainerVolumeInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnapshotPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline snapshot policy based on the context it is used
func (m *ContainerVolumeInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnapshotPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineSnapshotPolicyInlineLinks container volume inline snapshot policy inline links
//
// swagger:model container_volume_inline_snapshot_policy_inline__links
type ContainerVolumeInlineSnapshotPolicyInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this container volume inline snapshot policy inline links
func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container volume inline snapshot policy inline links based on the context it is used
func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineSnapshotPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineSnapshotPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineSpace container volume inline space
//
// swagger:model container_volume_inline_space
type ContainerVolumeInlineSpace struct {

	// The total provisioned size of the container, in bytes.<br/>
	//
	// Example: 1073741824
	Size *int64 `json:"size,omitempty"`
}

// Validate validates this container volume inline space
func (m *ContainerVolumeInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container volume inline space based on context it is used
func (m *ContainerVolumeInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineSpace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineSpace) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineStorageService Determines the placement of the volume that is to be provisioned.
//
// swagger:model container_volume_inline_storage_service
type ContainerVolumeInlineStorageService struct {

	// Storage service name. If not specified, the default value is the most performant for the platform.
	//
	// Enum: ["extreme","performance","value"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this container volume inline storage service
func (m *ContainerVolumeInlineStorageService) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerVolumeInlineStorageServiceTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["extreme","performance","value"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeInlineStorageServiceTypeNamePropEnum = append(containerVolumeInlineStorageServiceTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_volume_inline_storage_service
	// ContainerVolumeInlineStorageService
	// name
	// Name
	// extreme
	// END DEBUGGING
	// ContainerVolumeInlineStorageServiceNameExtreme captures enum value "extreme"
	ContainerVolumeInlineStorageServiceNameExtreme string = "extreme"

	// BEGIN DEBUGGING
	// container_volume_inline_storage_service
	// ContainerVolumeInlineStorageService
	// name
	// Name
	// performance
	// END DEBUGGING
	// ContainerVolumeInlineStorageServiceNamePerformance captures enum value "performance"
	ContainerVolumeInlineStorageServiceNamePerformance string = "performance"

	// BEGIN DEBUGGING
	// container_volume_inline_storage_service
	// ContainerVolumeInlineStorageService
	// name
	// Name
	// value
	// END DEBUGGING
	// ContainerVolumeInlineStorageServiceNameValue captures enum value "value"
	ContainerVolumeInlineStorageServiceNameValue string = "value"
)

// prop value enum
func (m *ContainerVolumeInlineStorageService) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeInlineStorageServiceTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeInlineStorageService) validateName(formats strfmt.Registry) error {
	if swag.IsZero(m.Name) { // not required
		return nil
	}

	// value enum
	if err := m.validateNameEnum("storage_service"+"."+"name", "body", *m.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this container volume inline storage service based on context it is used
func (m *ContainerVolumeInlineStorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineStorageService) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineStorageService) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineStorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeInlineTiering container volume inline tiering
//
// swagger:model container_volume_inline_tiering
type ContainerVolumeInlineTiering struct {

	// Storage tiering placement rules for the object.
	// Enum: ["allowed","best_effort","disallowed","required"]
	Control *string `json:"control,omitempty"`

	// Object stores to use. Used for placement.
	//
	// Max Items: 2
	// Min Items: 0
	ObjectStores []*ContainerVolumeTieringObjectStoresItems0 `json:"object_stores,omitempty"`

	// Policy that determines whether the user data blocks of a volume in a FabricPool will be tiered to the cloud store when they become cold.
	// <br>FabricPool combines flash (performance tier) with a cloud store into a single aggregate. Temperature of a volume block increases if it is accessed frequently and decreases when it is not. Valid in POST or PATCH.<br/>all &dash; Allows tiering of both snapshots and active file system user data to the cloud store as soon as possible by ignoring the temperature on the volume blocks.<br/>auto &dash; Allows tiering of both snapshot and active file system user data to the cloud store<br/>none &dash; Volume blocks are not be tiered to the cloud store.<br/>snapshot_only &dash; Allows tiering of only the volume snapshots not associated with the active file system.
	// <br>The default tiering policy is "snapshot-only" for a FlexVol volume and "none" for a FlexGroup volume. The default minimum cooling period for the "snapshot-only" tiering policy is 2 days and for the "auto" tiering policy it is 31 days.
	//
	// Enum: ["all","auto","backup","none","snapshot_only"]
	Policy *string `json:"policy,omitempty"`
}

// Validate validates this container volume inline tiering
func (m *ContainerVolumeInlineTiering) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateObjectStores(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var containerVolumeInlineTieringTypeControlPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["allowed","best_effort","disallowed","required"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeInlineTieringTypeControlPropEnum = append(containerVolumeInlineTieringTypeControlPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// control
	// Control
	// allowed
	// END DEBUGGING
	// ContainerVolumeInlineTieringControlAllowed captures enum value "allowed"
	ContainerVolumeInlineTieringControlAllowed string = "allowed"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// control
	// Control
	// best_effort
	// END DEBUGGING
	// ContainerVolumeInlineTieringControlBestEffort captures enum value "best_effort"
	ContainerVolumeInlineTieringControlBestEffort string = "best_effort"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// control
	// Control
	// disallowed
	// END DEBUGGING
	// ContainerVolumeInlineTieringControlDisallowed captures enum value "disallowed"
	ContainerVolumeInlineTieringControlDisallowed string = "disallowed"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// control
	// Control
	// required
	// END DEBUGGING
	// ContainerVolumeInlineTieringControlRequired captures enum value "required"
	ContainerVolumeInlineTieringControlRequired string = "required"
)

// prop value enum
func (m *ContainerVolumeInlineTiering) validateControlEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeInlineTieringTypeControlPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeInlineTiering) validateControl(formats strfmt.Registry) error {
	if swag.IsZero(m.Control) { // not required
		return nil
	}

	// value enum
	if err := m.validateControlEnum("tiering"+"."+"control", "body", *m.Control); err != nil {
		return err
	}

	return nil
}

func (m *ContainerVolumeInlineTiering) validateObjectStores(formats strfmt.Registry) error {
	if swag.IsZero(m.ObjectStores) { // not required
		return nil
	}

	iObjectStoresSize := int64(len(m.ObjectStores))

	if err := validate.MinItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 0); err != nil {
		return err
	}

	if err := validate.MaxItems("tiering"+"."+"object_stores", "body", iObjectStoresSize, 2); err != nil {
		return err
	}

	for i := 0; i < len(m.ObjectStores); i++ {
		if swag.IsZero(m.ObjectStores[i]) { // not required
			continue
		}

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var containerVolumeInlineTieringTypePolicyPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","auto","backup","none","snapshot_only"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		containerVolumeInlineTieringTypePolicyPropEnum = append(containerVolumeInlineTieringTypePolicyPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// policy
	// Policy
	// all
	// END DEBUGGING
	// ContainerVolumeInlineTieringPolicyAll captures enum value "all"
	ContainerVolumeInlineTieringPolicyAll string = "all"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// policy
	// Policy
	// auto
	// END DEBUGGING
	// ContainerVolumeInlineTieringPolicyAuto captures enum value "auto"
	ContainerVolumeInlineTieringPolicyAuto string = "auto"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// policy
	// Policy
	// backup
	// END DEBUGGING
	// ContainerVolumeInlineTieringPolicyBackup captures enum value "backup"
	ContainerVolumeInlineTieringPolicyBackup string = "backup"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// policy
	// Policy
	// none
	// END DEBUGGING
	// ContainerVolumeInlineTieringPolicyNone captures enum value "none"
	ContainerVolumeInlineTieringPolicyNone string = "none"

	// BEGIN DEBUGGING
	// container_volume_inline_tiering
	// ContainerVolumeInlineTiering
	// policy
	// Policy
	// snapshot_only
	// END DEBUGGING
	// ContainerVolumeInlineTieringPolicySnapshotOnly captures enum value "snapshot_only"
	ContainerVolumeInlineTieringPolicySnapshotOnly string = "snapshot_only"
)

// prop value enum
func (m *ContainerVolumeInlineTiering) validatePolicyEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, containerVolumeInlineTieringTypePolicyPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *ContainerVolumeInlineTiering) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.Policy) { // not required
		return nil
	}

	// value enum
	if err := m.validatePolicyEnum("tiering"+"."+"policy", "body", *m.Policy); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this container volume inline tiering based on the context it is used
func (m *ContainerVolumeInlineTiering) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateObjectStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerVolumeInlineTiering) contextValidateObjectStores(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ObjectStores); i++ {

		if m.ObjectStores[i] != nil {
			if err := m.ObjectStores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tiering" + "." + "object_stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeInlineTiering) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeInlineTiering) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeInlineTiering
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// ContainerVolumeTieringObjectStoresItems0 container volume tiering object stores items0
//
// swagger:model ContainerVolumeTieringObjectStoresItems0
type ContainerVolumeTieringObjectStoresItems0 struct {

	// The name of the object store to use. Used for placement.
	Name *string `json:"name,omitempty"`
}

// Validate validates this container volume tiering object stores items0
func (m *ContainerVolumeTieringObjectStoresItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container volume tiering object stores items0 based on context it is used
func (m *ContainerVolumeTieringObjectStoresItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *ContainerVolumeTieringObjectStoresItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerVolumeTieringObjectStoresItems0) UnmarshalBinary(b []byte) error {
	var res ContainerVolumeTieringObjectStoresItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
