// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Coredump coredump
//
// swagger:model coredump
type Coredump struct {

	// links
	Links *CoredumpInlineLinks `json:"_links,omitempty"`

	// Specifies whether or not the core is a partial core.  Applicable only to kernel core dump type.
	// Read Only: true
	IsPartial *bool `json:"is_partial,omitempty"`

	// Specifies whether or not the core file is saved.
	// Read Only: true
	IsSaved *bool `json:"is_saved,omitempty"`

	// MD5 checksum of the compressed data of core.  Applicable only to kernel core dump type.
	// Example: 5118488cc5065e33a16986001b1ffa48
	// Read Only: true
	Md5DataChecksum *string `json:"md5_data_checksum,omitempty"`

	// Core name
	// Example: core.4136886413.2021-03-01.22_09_11.nz
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *CoredumpInlineNode `json:"node,omitempty"`

	// Time of panic that generated the core.
	// Example: 2021-03-01 18:09:11-04:00
	// Read Only: true
	// Format: date-time
	PanicTime *strfmt.DateTime `json:"panic_time,omitempty"`

	// Size of core, in bytes.  Applicable only to kernel core dump type.
	// Example: 1161629804
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Core type, kernel or application
	// Example: kernel
	// Read Only: true
	// Enum: ["kernel","application","ancillary_kernel_segment"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this coredump
func (m *Coredump) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePanicTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Coredump) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Coredump) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(m.Node) { // not required
		return nil
	}

	if m.Node != nil {
		if err := m.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Coredump) validatePanicTime(formats strfmt.Registry) error {
	if swag.IsZero(m.PanicTime) { // not required
		return nil
	}

	if err := validate.FormatOf("panic_time", "body", "date-time", m.PanicTime.String(), formats); err != nil {
		return err
	}

	return nil
}

var coredumpTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["kernel","application","ancillary_kernel_segment"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		coredumpTypeTypePropEnum = append(coredumpTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// coredump
	// Coredump
	// type
	// Type
	// kernel
	// END DEBUGGING
	// CoredumpTypeKernel captures enum value "kernel"
	CoredumpTypeKernel string = "kernel"

	// BEGIN DEBUGGING
	// coredump
	// Coredump
	// type
	// Type
	// application
	// END DEBUGGING
	// CoredumpTypeApplication captures enum value "application"
	CoredumpTypeApplication string = "application"

	// BEGIN DEBUGGING
	// coredump
	// Coredump
	// type
	// Type
	// ancillary_kernel_segment
	// END DEBUGGING
	// CoredumpTypeAncillaryKernelSegment captures enum value "ancillary_kernel_segment"
	CoredumpTypeAncillaryKernelSegment string = "ancillary_kernel_segment"
)

// prop value enum
func (m *Coredump) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, coredumpTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *Coredump) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this coredump based on the context it is used
func (m *Coredump) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsPartial(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIsSaved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMd5DataChecksum(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePanicTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Coredump) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *Coredump) contextValidateIsPartial(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_partial", "body", m.IsPartial); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateIsSaved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "is_saved", "body", m.IsSaved); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateMd5DataChecksum(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "md5_data_checksum", "body", m.Md5DataChecksum); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if m.Node != nil {
		if err := m.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

func (m *Coredump) contextValidatePanicTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "panic_time", "body", m.PanicTime); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *Coredump) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Coredump) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Coredump) UnmarshalBinary(b []byte) error {
	var res Coredump
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CoredumpInlineLinks coredump inline links
//
// swagger:model coredump_inline__links
type CoredumpInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this coredump inline links
func (m *CoredumpInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this coredump inline links based on the context it is used
func (m *CoredumpInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CoredumpInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CoredumpInlineLinks) UnmarshalBinary(b []byte) error {
	var res CoredumpInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CoredumpInlineNode coredump inline node
//
// swagger:model coredump_inline_node
type CoredumpInlineNode struct {

	// links
	Links *CoredumpInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this coredump inline node
func (m *CoredumpInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this coredump inline node based on the context it is used
func (m *CoredumpInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CoredumpInlineNode) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CoredumpInlineNode) UnmarshalBinary(b []byte) error {
	var res CoredumpInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CoredumpInlineNodeInlineLinks coredump inline node inline links
//
// swagger:model coredump_inline_node_inline__links
type CoredumpInlineNodeInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this coredump inline node inline links
func (m *CoredumpInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this coredump inline node inline links based on the context it is used
func (m *CoredumpInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CoredumpInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CoredumpInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CoredumpInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res CoredumpInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
