// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CounterSchema Schema definition of a single counter or property.
//
// swagger:model counter_schema
type CounterSchema struct {

	// denominator
	Denominator *CounterDenominator `json:"denominator,omitempty"`

	// Counter or property description.
	Description *string `json:"description,omitempty"`

	// Counter or property name.
	Name *string `json:"name,omitempty"`

	// Type of counter or property. Properties will always set this field to 'string'.
	//
	// Enum: ["average","rate","raw","delta","percent","string"]
	Type *string `json:"type,omitempty"`

	// Counter unit.
	// Enum: ["per_sec","b_per_sec","kb_per_sec","mb_per_sec","percent","millisec","microsec","nanosec","sec","none"]
	Unit *string `json:"unit,omitempty"`
}

// Validate validates this counter schema
func (m *CounterSchema) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDenominator(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUnit(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterSchema) validateDenominator(formats strfmt.Registry) error {
	if swag.IsZero(m.Denominator) { // not required
		return nil
	}

	if m.Denominator != nil {
		if err := m.Denominator.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("denominator")
			}
			return err
		}
	}

	return nil
}

var counterSchemaTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["average","rate","raw","delta","percent","string"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		counterSchemaTypeTypePropEnum = append(counterSchemaTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// average
	// END DEBUGGING
	// CounterSchemaTypeAverage captures enum value "average"
	CounterSchemaTypeAverage string = "average"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// rate
	// END DEBUGGING
	// CounterSchemaTypeRate captures enum value "rate"
	CounterSchemaTypeRate string = "rate"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// raw
	// END DEBUGGING
	// CounterSchemaTypeRaw captures enum value "raw"
	CounterSchemaTypeRaw string = "raw"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// delta
	// END DEBUGGING
	// CounterSchemaTypeDelta captures enum value "delta"
	CounterSchemaTypeDelta string = "delta"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// percent
	// END DEBUGGING
	// CounterSchemaTypePercent captures enum value "percent"
	CounterSchemaTypePercent string = "percent"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// type
	// Type
	// string
	// END DEBUGGING
	// CounterSchemaTypeString captures enum value "string"
	CounterSchemaTypeString string = "string"
)

// prop value enum
func (m *CounterSchema) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, counterSchemaTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CounterSchema) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

var counterSchemaTypeUnitPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["per_sec","b_per_sec","kb_per_sec","mb_per_sec","percent","millisec","microsec","nanosec","sec","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		counterSchemaTypeUnitPropEnum = append(counterSchemaTypeUnitPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// per_sec
	// END DEBUGGING
	// CounterSchemaUnitPerSec captures enum value "per_sec"
	CounterSchemaUnitPerSec string = "per_sec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// b_per_sec
	// END DEBUGGING
	// CounterSchemaUnitBPerSec captures enum value "b_per_sec"
	CounterSchemaUnitBPerSec string = "b_per_sec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// kb_per_sec
	// END DEBUGGING
	// CounterSchemaUnitKbPerSec captures enum value "kb_per_sec"
	CounterSchemaUnitKbPerSec string = "kb_per_sec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// mb_per_sec
	// END DEBUGGING
	// CounterSchemaUnitMbPerSec captures enum value "mb_per_sec"
	CounterSchemaUnitMbPerSec string = "mb_per_sec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// percent
	// END DEBUGGING
	// CounterSchemaUnitPercent captures enum value "percent"
	CounterSchemaUnitPercent string = "percent"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// millisec
	// END DEBUGGING
	// CounterSchemaUnitMillisec captures enum value "millisec"
	CounterSchemaUnitMillisec string = "millisec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// microsec
	// END DEBUGGING
	// CounterSchemaUnitMicrosec captures enum value "microsec"
	CounterSchemaUnitMicrosec string = "microsec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// nanosec
	// END DEBUGGING
	// CounterSchemaUnitNanosec captures enum value "nanosec"
	CounterSchemaUnitNanosec string = "nanosec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// sec
	// END DEBUGGING
	// CounterSchemaUnitSec captures enum value "sec"
	CounterSchemaUnitSec string = "sec"

	// BEGIN DEBUGGING
	// counter_schema
	// CounterSchema
	// unit
	// Unit
	// none
	// END DEBUGGING
	// CounterSchemaUnitNone captures enum value "none"
	CounterSchemaUnitNone string = "none"
)

// prop value enum
func (m *CounterSchema) validateUnitEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, counterSchemaTypeUnitPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CounterSchema) validateUnit(formats strfmt.Registry) error {
	if swag.IsZero(m.Unit) { // not required
		return nil
	}

	// value enum
	if err := m.validateUnitEnum("unit", "body", *m.Unit); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this counter schema based on the context it is used
func (m *CounterSchema) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDenominator(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterSchema) contextValidateDenominator(ctx context.Context, formats strfmt.Registry) error {

	if m.Denominator != nil {
		if err := m.Denominator.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("denominator")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CounterSchema) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CounterSchema) UnmarshalBinary(b []byte) error {
	var res CounterSchema
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
