// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// CounterTable Information for a single counter table.
//
// swagger:model counter_table
type CounterTable struct {

	// links
	Links *CounterTableInlineLinks `json:"_links,omitempty"`

	// Array of counter schema definitions.
	CounterTableInlineCounterSchemas []*CounterSchema `json:"counter_schemas,omitempty"`

	// Description of the table.
	Description *string `json:"description,omitempty"`

	// Table name.
	Name *string `json:"name,omitempty"`
}

// Validate validates this counter table
func (m *CounterTable) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCounterTableInlineCounterSchemas(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterTable) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CounterTable) validateCounterTableInlineCounterSchemas(formats strfmt.Registry) error {
	if swag.IsZero(m.CounterTableInlineCounterSchemas) { // not required
		return nil
	}

	for i := 0; i < len(m.CounterTableInlineCounterSchemas); i++ {
		if swag.IsZero(m.CounterTableInlineCounterSchemas[i]) { // not required
			continue
		}

		if m.CounterTableInlineCounterSchemas[i] != nil {
			if err := m.CounterTableInlineCounterSchemas[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counter_schemas" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this counter table based on the context it is used
func (m *CounterTable) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCounterTableInlineCounterSchemas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterTable) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *CounterTable) contextValidateCounterTableInlineCounterSchemas(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CounterTableInlineCounterSchemas); i++ {

		if m.CounterTableInlineCounterSchemas[i] != nil {
			if err := m.CounterTableInlineCounterSchemas[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counter_schemas" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *CounterTable) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CounterTable) UnmarshalBinary(b []byte) error {
	var res CounterTable
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// CounterTableInlineLinks counter table inline links
//
// swagger:model counter_table_inline__links
type CounterTableInlineLinks struct {

	// self
	Self *Href `json:"self,omitempty"`
}

// Validate validates this counter table inline links
func (m *CounterTableInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterTableInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(m.Self) { // not required
		return nil
	}

	if m.Self != nil {
		if err := m.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this counter table inline links based on the context it is used
func (m *CounterTableInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *CounterTableInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if m.Self != nil {
		if err := m.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *CounterTableInlineLinks) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CounterTableInlineLinks) UnmarshalBinary(b []byte) error {
	var res CounterTableInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
