// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataCollectionMetrics The aggregated metrics of all data collections.
//
// swagger:model data_collection_metrics
type DataCollectionMetrics struct {

	// The number of data collections per state.
	DataCollectionMetricsInlineCountsByState []*DataCollectionMetricsInlineCountsByStateInlineArrayItem `json:"counts_by_state,omitempty"`

	// The percentage of the total cluster size occupied by the data collections.
	// Example: 25
	// Maximum: 100
	// Minimum: 0
	SpacePercent *int64 `json:"space_percent,omitempty"`

	// The total number of data collections.
	// Example: 100
	TotalCount *int64 `json:"total_count,omitempty"`

	// The total size of all data collections, in bytes.
	// Example: 121314
	TotalSize *int64 `json:"total_size,omitempty"`
}

// Validate validates this data collection metrics
func (m *DataCollectionMetrics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataCollectionMetricsInlineCountsByState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSpacePercent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataCollectionMetrics) validateDataCollectionMetricsInlineCountsByState(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollectionMetricsInlineCountsByState) { // not required
		return nil
	}

	for i := 0; i < len(m.DataCollectionMetricsInlineCountsByState); i++ {
		if swag.IsZero(m.DataCollectionMetricsInlineCountsByState[i]) { // not required
			continue
		}

		if m.DataCollectionMetricsInlineCountsByState[i] != nil {
			if err := m.DataCollectionMetricsInlineCountsByState[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counts_by_state" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataCollectionMetrics) validateSpacePercent(formats strfmt.Registry) error {
	if swag.IsZero(m.SpacePercent) { // not required
		return nil
	}

	if err := validate.MinimumInt("space_percent", "body", *m.SpacePercent, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("space_percent", "body", *m.SpacePercent, 100, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data collection metrics based on the context it is used
func (m *DataCollectionMetrics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDataCollectionMetricsInlineCountsByState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataCollectionMetrics) contextValidateDataCollectionMetricsInlineCountsByState(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataCollectionMetricsInlineCountsByState); i++ {

		if m.DataCollectionMetricsInlineCountsByState[i] != nil {
			if err := m.DataCollectionMetricsInlineCountsByState[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("counts_by_state" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataCollectionMetrics) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataCollectionMetrics) UnmarshalBinary(b []byte) error {
	var res DataCollectionMetrics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataCollectionMetricsInlineCountsByStateInlineArrayItem data collection metrics inline counts by state inline array item
//
// swagger:model data_collection_metrics_inline_counts_by_state_inline_array_item
type DataCollectionMetricsInlineCountsByStateInlineArrayItem struct {

	// The number of data collections in the given state.
	// Example: 50
	Count *int64 `json:"count,omitempty"`

	// State of the data collection:
	// * <i>draft</i> - The data collection is in draft.
	// * <i>processing</i> - The data collection is being processed.
	// * <i>published</i> - The data collection is published.
	// * <i>failed</i> - The data collection has a failure.
	// * <i>outdated</i> - The data collection is outdated.
	// * <i>deleted</i> - The data collection has been marked for deletion.
	//
	// Example: published
	// Enum: ["draft","processing","published","failed","outdated","deleted"]
	State *string `json:"state,omitempty"`
}

// Validate validates this data collection metrics inline counts by state inline array item
func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataCollectionMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["draft","processing","published","failed","outdated","deleted"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataCollectionMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum = append(dataCollectionMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// draft
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStateDraft captures enum value "draft"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStateDraft string = "draft"

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// processing
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStateProcessing captures enum value "processing"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStateProcessing string = "processing"

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// published
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStatePublished captures enum value "published"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStatePublished string = "published"

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// failed
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStateFailed captures enum value "failed"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStateFailed string = "failed"

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// outdated
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStateOutdated captures enum value "outdated"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStateOutdated string = "outdated"

	// BEGIN DEBUGGING
	// data_collection_metrics_inline_counts_by_state_inline_array_item
	// DataCollectionMetricsInlineCountsByStateInlineArrayItem
	// state
	// State
	// deleted
	// END DEBUGGING
	// DataCollectionMetricsInlineCountsByStateInlineArrayItemStateDeleted captures enum value "deleted"
	DataCollectionMetricsInlineCountsByStateInlineArrayItemStateDeleted string = "deleted"
)

// prop value enum
func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataCollectionMetricsInlineCountsByStateInlineArrayItemTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data collection metrics inline counts by state inline array item based on context it is used
func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataCollectionMetricsInlineCountsByStateInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataCollectionMetricsInlineCountsByStateInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
