// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// DataEngine data engine
//
// swagger:model data_engine
type DataEngine struct {

	// data collection metrics
	DataCollectionMetrics *DataCollectionMetrics `json:"data_collection_metrics,omitempty"`

	// Top CPU consuming operations.
	TopCPUOperations DataEngineOperationsArrayInline `json:"top_cpu_operations,omitempty"`

	// Top GPU consuming operations.
	TopGpuOperations DataEngineOperationsArrayInline `json:"top_gpu_operations,omitempty"`

	// workspace metrics
	WorkspaceMetrics *WorkspaceMetrics `json:"workspace_metrics,omitempty"`
}

// Validate validates this data engine
func (m *DataEngine) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataCollectionMetrics(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopCPUOperations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTopGpuOperations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspaceMetrics(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngine) validateDataCollectionMetrics(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollectionMetrics) { // not required
		return nil
	}

	if m.DataCollectionMetrics != nil {
		if err := m.DataCollectionMetrics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection_metrics")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngine) validateTopCPUOperations(formats strfmt.Registry) error {
	if swag.IsZero(m.TopCPUOperations) { // not required
		return nil
	}

	if err := m.TopCPUOperations.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_cpu_operations")
		}
		return err
	}

	return nil
}

func (m *DataEngine) validateTopGpuOperations(formats strfmt.Registry) error {
	if swag.IsZero(m.TopGpuOperations) { // not required
		return nil
	}

	if err := m.TopGpuOperations.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_gpu_operations")
		}
		return err
	}

	return nil
}

func (m *DataEngine) validateWorkspaceMetrics(formats strfmt.Registry) error {
	if swag.IsZero(m.WorkspaceMetrics) { // not required
		return nil
	}

	if m.WorkspaceMetrics != nil {
		if err := m.WorkspaceMetrics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace_metrics")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine based on the context it is used
func (m *DataEngine) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDataCollectionMetrics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopCPUOperations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTopGpuOperations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspaceMetrics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngine) contextValidateDataCollectionMetrics(ctx context.Context, formats strfmt.Registry) error {

	if m.DataCollectionMetrics != nil {
		if err := m.DataCollectionMetrics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection_metrics")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngine) contextValidateTopCPUOperations(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TopCPUOperations.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_cpu_operations")
		}
		return err
	}

	return nil
}

func (m *DataEngine) contextValidateTopGpuOperations(ctx context.Context, formats strfmt.Registry) error {

	if err := m.TopGpuOperations.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("top_gpu_operations")
		}
		return err
	}

	return nil
}

func (m *DataEngine) contextValidateWorkspaceMetrics(ctx context.Context, formats strfmt.Registry) error {

	if m.WorkspaceMetrics != nil {
		if err := m.WorkspaceMetrics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace_metrics")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngine) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngine) UnmarshalBinary(b []byte) error {
	var res DataEngine
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
