// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineACL Defines the structure of the data engine Access Control List (ACL).
//
// swagger:model data_engine_acl
type DataEngineACL struct {

	// user or group
	UserOrGroup *DataEngineACLInlineUserOrGroup `json:"user_or_group,omitempty"`

	// Workspace containing the ACL.
	// Read Only: true
	Workspace *WorkspaceReference `json:"workspace,omitempty"`
}

// Validate validates this data engine acl
func (m *DataEngineACL) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUserOrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACL) validateUserOrGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.UserOrGroup) { // not required
		return nil
	}

	if m.UserOrGroup != nil {
		if err := m.UserOrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user_or_group")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineACL) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine acl based on the context it is used
func (m *DataEngineACL) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUserOrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACL) contextValidateUserOrGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.UserOrGroup != nil {
		if err := m.UserOrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user_or_group")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineACL) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineACL) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineACL) UnmarshalBinary(b []byte) error {
	var res DataEngineACL
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineACLInlineUserOrGroup User or group information.
//
// swagger:model data_engine_acl_inline_user_or_group
type DataEngineACLInlineUserOrGroup struct {

	// The time when the user or group is granted access to the workspace.
	// Example: 2025-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	AllocationTime *strfmt.DateTime `json:"allocation_time,omitempty"`

	// Name of the user or group.
	// Example: user1
	Name *string `json:"name,omitempty"`
}

// Validate validates this data engine acl inline user or group
func (m *DataEngineACLInlineUserOrGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllocationTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACLInlineUserOrGroup) validateAllocationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AllocationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("user_or_group"+"."+"allocation_time", "body", "date-time", m.AllocationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine acl inline user or group based on the context it is used
func (m *DataEngineACLInlineUserOrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllocationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACLInlineUserOrGroup) contextValidateAllocationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_or_group"+"."+"allocation_time", "body", m.AllocationTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineACLInlineUserOrGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineACLInlineUserOrGroup) UnmarshalBinary(b []byte) error {
	var res DataEngineACLInlineUserOrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
