// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineACLResponse Defines the structure of the response for data engine workspace ACL requests.
//
// swagger:model data_engine_acl_response
type DataEngineACLResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// data engine acl response inline records
	DataEngineACLResponseInlineRecords []*DataEngineACL `json:"records,omitempty"`

	// The number of records returned in the response.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of ACL records available.
	// Example: 100
	// Read Only: true
	TotalRecords *int64 `json:"total_records,omitempty"`
}

// Validate validates this data engine acl response
func (m *DataEngineACLResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineACLResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACLResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineACLResponse) validateDataEngineACLResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineACLResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineACLResponseInlineRecords); i++ {
		if swag.IsZero(m.DataEngineACLResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DataEngineACLResponseInlineRecords[i] != nil {
			if err := m.DataEngineACLResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine acl response based on the context it is used
func (m *DataEngineACLResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineACLResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineACLResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineACLResponse) contextValidateDataEngineACLResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineACLResponseInlineRecords); i++ {

		if m.DataEngineACLResponseInlineRecords[i] != nil {
			if err := m.DataEngineACLResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineACLResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineACLResponse) contextValidateTotalRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_records", "body", m.TotalRecords); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineACLResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineACLResponse) UnmarshalBinary(b []byte) error {
	var res DataEngineACLResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
