// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineDatacollectionACL Defines the structure of the data engine Access Control List (ACL) for data collections.
//
// swagger:model data_engine_datacollection_acl
type DataEngineDatacollectionACL struct {

	// Data collection containing the ACL.
	// Read Only: true
	DataCollection *DatacollectionReference `json:"data_collection,omitempty"`

	// user or group
	UserOrGroup *DataEngineDatacollectionACLInlineUserOrGroup `json:"user_or_group,omitempty"`

	// Workspace containing the ACL.
	// Read Only: true
	Workspace *WorkspaceReference `json:"workspace,omitempty"`
}

// Validate validates this data engine datacollection acl
func (m *DataEngineDatacollectionACL) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDataCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserOrGroup(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineDatacollectionACL) validateDataCollection(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollection) { // not required
		return nil
	}

	if m.DataCollection != nil {
		if err := m.DataCollection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineDatacollectionACL) validateUserOrGroup(formats strfmt.Registry) error {
	if swag.IsZero(m.UserOrGroup) { // not required
		return nil
	}

	if m.UserOrGroup != nil {
		if err := m.UserOrGroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user_or_group")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineDatacollectionACL) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine datacollection acl based on the context it is used
func (m *DataEngineDatacollectionACL) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDataCollection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserOrGroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineDatacollectionACL) contextValidateDataCollection(ctx context.Context, formats strfmt.Registry) error {

	if m.DataCollection != nil {
		if err := m.DataCollection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineDatacollectionACL) contextValidateUserOrGroup(ctx context.Context, formats strfmt.Registry) error {

	if m.UserOrGroup != nil {
		if err := m.UserOrGroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("user_or_group")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineDatacollectionACL) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineDatacollectionACL) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineDatacollectionACL) UnmarshalBinary(b []byte) error {
	var res DataEngineDatacollectionACL
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineDatacollectionACLInlineUserOrGroup User or group information.
//
// swagger:model data_engine_datacollection_acl_inline_user_or_group
type DataEngineDatacollectionACLInlineUserOrGroup struct {

	// The time when the user or group is granted access to the data collection.
	// Example: 2025-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	AllocationTime *strfmt.DateTime `json:"allocation_time,omitempty"`

	// Name of the user or group.
	// Example: user1
	Name *string `json:"name,omitempty"`
}

// Validate validates this data engine datacollection acl inline user or group
func (m *DataEngineDatacollectionACLInlineUserOrGroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAllocationTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineDatacollectionACLInlineUserOrGroup) validateAllocationTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AllocationTime) { // not required
		return nil
	}

	if err := validate.FormatOf("user_or_group"+"."+"allocation_time", "body", "date-time", m.AllocationTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine datacollection acl inline user or group based on the context it is used
func (m *DataEngineDatacollectionACLInlineUserOrGroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAllocationTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineDatacollectionACLInlineUserOrGroup) contextValidateAllocationTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "user_or_group"+"."+"allocation_time", "body", m.AllocationTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineDatacollectionACLInlineUserOrGroup) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineDatacollectionACLInlineUserOrGroup) UnmarshalBinary(b []byte) error {
	var res DataEngineDatacollectionACLInlineUserOrGroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
