// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineEntity Entity attributes.
//
// swagger:model data_engine_entity
type DataEngineEntity struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The last access time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	AccessTime *strfmt.DateTime `json:"access_time,omitempty"`

	// attributes
	Attributes *DataEngineEntityInlineAttributes `json:"attributes,omitempty"`

	// Indicates if the entity can be previewed.
	// Example: true
	// Read Only: true
	CanPreview *bool `json:"can_preview,omitempty"`

	// The hash of the entity content.
	// Read Only: true
	ContentHash *string `json:"content_hash,omitempty"`

	// The create time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// data engine entity inline errors
	// Read Only: true
	DataEngineEntityInlineErrors []*DataEngineEntityInlineErrorsInlineArrayItem `json:"errors,omitempty"`

	// datasource
	// Read Only: true
	Datasource *DataSourceVersion `json:"datasource,omitempty"`

	// The extension of the entity.
	// Read Only: true
	Extension *string `json:"extension,omitempty"`

	// The format of the entity (e.g. pdf document, jpeg image, mp4 video, zip).
	// Example: pdf
	// Read Only: true
	Format *string `json:"format,omitempty"`

	// Indicates if the entity has PII.
	// Example: false
	// Read Only: true
	HasPii *bool `json:"has_pii,omitempty"`

	// The name of the entity.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// permissions
	Permissions *DataEngineEntityInlinePermissions `json:"permissions,omitempty"`

	// The size of the entity in bytes.
	// Example: 100
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Type of the entity:
	// * <i>file</i> - The entity is a file.
	// * <i>object</i> - The entity is an object.
	//
	// Read Only: true
	// Enum: ["file","object"]
	Type *string `json:"type,omitempty"`

	// The last update time of the entity.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// The URI of the entity.
	// Read Only: true
	URI *string `json:"uri,omitempty"`

	// Unique identifier for the entity.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	// Read Only: true
	Workspace *EntityWorkspaceVersion `json:"workspace,omitempty"`
}

// Validate validates this data engine entity
func (m *DataEngineEntity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAccessTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineEntityInlineErrors(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatasource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePermissions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntity) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) validateAccessTime(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessTime) { // not required
		return nil
	}

	if err := validate.FormatOf("access_time", "body", "date-time", m.AccessTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) validateAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.Attributes) { // not required
		return nil
	}

	if m.Attributes != nil {
		if err := m.Attributes.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) validateDataEngineEntityInlineErrors(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineEntityInlineErrors) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineEntityInlineErrors); i++ {
		if swag.IsZero(m.DataEngineEntityInlineErrors[i]) { // not required
			continue
		}

		if m.DataEngineEntityInlineErrors[i] != nil {
			if err := m.DataEngineEntityInlineErrors[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntity) validateDatasource(formats strfmt.Registry) error {
	if swag.IsZero(m.Datasource) { // not required
		return nil
	}

	if m.Datasource != nil {
		if err := m.Datasource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) validatePermissions(formats strfmt.Registry) error {
	if swag.IsZero(m.Permissions) { // not required
		return nil
	}

	if m.Permissions != nil {
		if err := m.Permissions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

var dataEngineEntityTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["file","object"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEntityTypeTypePropEnum = append(dataEngineEntityTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_entity
	// DataEngineEntity
	// type
	// Type
	// file
	// END DEBUGGING
	// DataEngineEntityTypeFile captures enum value "file"
	DataEngineEntityTypeFile string = "file"

	// BEGIN DEBUGGING
	// data_engine_entity
	// DataEngineEntity
	// type
	// Type
	// object
	// END DEBUGGING
	// DataEngineEntityTypeObject captures enum value "object"
	DataEngineEntityTypeObject string = "object"
)

// prop value enum
func (m *DataEngineEntity) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEntityTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEntity) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine entity based on the context it is used
func (m *DataEngineEntity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAccessTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCanPreview(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateContentHash(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineEntityInlineErrors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatasource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtension(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFormat(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHasPii(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePermissions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateURI(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntity) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) contextValidateAccessTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "access_time", "body", m.AccessTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateAttributes(ctx context.Context, formats strfmt.Registry) error {

	if m.Attributes != nil {
		if err := m.Attributes.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("attributes")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) contextValidateCanPreview(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "can_preview", "body", m.CanPreview); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateContentHash(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "content_hash", "body", m.ContentHash); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateDataEngineEntityInlineErrors(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "errors", "body", []*DataEngineEntityInlineErrorsInlineArrayItem(m.DataEngineEntityInlineErrors)); err != nil {
		return err
	}

	for i := 0; i < len(m.DataEngineEntityInlineErrors); i++ {

		if m.DataEngineEntityInlineErrors[i] != nil {
			if err := m.DataEngineEntityInlineErrors[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("errors" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntity) contextValidateDatasource(ctx context.Context, formats strfmt.Registry) error {

	if m.Datasource != nil {
		if err := m.Datasource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datasource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) contextValidateExtension(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "extension", "body", m.Extension); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateFormat(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "format", "body", m.Format); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateHasPii(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "has_pii", "body", m.HasPii); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidatePermissions(ctx context.Context, formats strfmt.Registry) error {

	if m.Permissions != nil {
		if err := m.Permissions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("permissions")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEntity) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateURI(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uri", "body", m.URI); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEntity) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntity) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntity) UnmarshalBinary(b []byte) error {
	var res DataEngineEntity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityInlineAttributes data engine entity inline attributes
//
// swagger:model data_engine_entity_inline_attributes
type DataEngineEntityInlineAttributes struct {

	// content
	Content []*DataEngineEntityAttributesContentItems0 `json:"content,omitempty"`

	// custom
	Custom []*DataEngineEntityAttributesCustomItems0 `json:"custom,omitempty"`

	// extended
	Extended []*DataEngineEntityAttributesExtendedItems0 `json:"extended,omitempty"`

	// system
	System []*DataEngineEntityAttributesSystemItems0 `json:"system,omitempty"`
}

// Validate validates this data engine entity inline attributes
func (m *DataEngineEntityInlineAttributes) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContent(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCustom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExtended(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSystem(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntityInlineAttributes) validateContent(formats strfmt.Registry) error {
	if swag.IsZero(m.Content) { // not required
		return nil
	}

	for i := 0; i < len(m.Content); i++ {
		if swag.IsZero(m.Content[i]) { // not required
			continue
		}

		if m.Content[i] != nil {
			if err := m.Content[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) validateCustom(formats strfmt.Registry) error {
	if swag.IsZero(m.Custom) { // not required
		return nil
	}

	for i := 0; i < len(m.Custom); i++ {
		if swag.IsZero(m.Custom[i]) { // not required
			continue
		}

		if m.Custom[i] != nil {
			if err := m.Custom[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) validateExtended(formats strfmt.Registry) error {
	if swag.IsZero(m.Extended) { // not required
		return nil
	}

	for i := 0; i < len(m.Extended); i++ {
		if swag.IsZero(m.Extended[i]) { // not required
			continue
		}

		if m.Extended[i] != nil {
			if err := m.Extended[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) validateSystem(formats strfmt.Registry) error {
	if swag.IsZero(m.System) { // not required
		return nil
	}

	for i := 0; i < len(m.System); i++ {
		if swag.IsZero(m.System[i]) { // not required
			continue
		}

		if m.System[i] != nil {
			if err := m.System[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine entity inline attributes based on the context it is used
func (m *DataEngineEntityInlineAttributes) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateContent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCustom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExtended(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSystem(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntityInlineAttributes) contextValidateContent(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Content); i++ {

		if m.Content[i] != nil {
			if err := m.Content[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "content" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) contextValidateCustom(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Custom); i++ {

		if m.Custom[i] != nil {
			if err := m.Custom[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "custom" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) contextValidateExtended(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Extended); i++ {

		if m.Extended[i] != nil {
			if err := m.Extended[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "extended" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEntityInlineAttributes) contextValidateSystem(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.System); i++ {

		if m.System[i] != nil {
			if err := m.System[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + "system" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityInlineAttributes) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityInlineAttributes) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityInlineAttributes
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityAttributesContentItems0 data engine entity attributes content items0
//
// swagger:model DataEngineEntityAttributesContentItems0
type DataEngineEntityAttributesContentItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine entity attributes content items0
func (m *DataEngineEntityAttributesContentItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine entity attributes content items0 based on context it is used
func (m *DataEngineEntityAttributesContentItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityAttributesContentItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityAttributesContentItems0) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityAttributesContentItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityAttributesCustomItems0 data engine entity attributes custom items0
//
// swagger:model DataEngineEntityAttributesCustomItems0
type DataEngineEntityAttributesCustomItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine entity attributes custom items0
func (m *DataEngineEntityAttributesCustomItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine entity attributes custom items0 based on context it is used
func (m *DataEngineEntityAttributesCustomItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityAttributesCustomItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityAttributesCustomItems0) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityAttributesCustomItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityAttributesExtendedItems0 data engine entity attributes extended items0
//
// swagger:model DataEngineEntityAttributesExtendedItems0
type DataEngineEntityAttributesExtendedItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine entity attributes extended items0
func (m *DataEngineEntityAttributesExtendedItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine entity attributes extended items0 based on context it is used
func (m *DataEngineEntityAttributesExtendedItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityAttributesExtendedItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityAttributesExtendedItems0) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityAttributesExtendedItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityAttributesSystemItems0 data engine entity attributes system items0
//
// swagger:model DataEngineEntityAttributesSystemItems0
type DataEngineEntityAttributesSystemItems0 struct {

	// key
	Key *string `json:"key,omitempty"`

	// value
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine entity attributes system items0
func (m *DataEngineEntityAttributesSystemItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this data engine entity attributes system items0 based on context it is used
func (m *DataEngineEntityAttributesSystemItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityAttributesSystemItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityAttributesSystemItems0) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityAttributesSystemItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityInlineErrorsInlineArrayItem data engine entity inline errors inline array item
//
// swagger:model data_engine_entity_inline_errors_inline_array_item
type DataEngineEntityInlineErrorsInlineArrayItem struct {

	// error
	Error *DcnCommonError `json:"error,omitempty"`
}

// Validate validates this data engine entity inline errors inline array item
func (m *DataEngineEntityInlineErrorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateError(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntityInlineErrorsInlineArrayItem) validateError(formats strfmt.Registry) error {
	if swag.IsZero(m.Error) { // not required
		return nil
	}

	if m.Error != nil {
		if err := m.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine entity inline errors inline array item based on the context it is used
func (m *DataEngineEntityInlineErrorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEntityInlineErrorsInlineArrayItem) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if m.Error != nil {
		if err := m.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("error")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityInlineErrorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityInlineErrorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityInlineErrorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEntityInlinePermissions The permissions of the entity.
//
// swagger:model data_engine_entity_inline_permissions
type DataEngineEntityInlinePermissions struct {

	// key
	// Example: owner
	Key *string `json:"key,omitempty"`

	// value
	// Example: rwx
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine entity inline permissions
func (m *DataEngineEntityInlinePermissions) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this data engine entity inline permissions based on the context it is used
func (m *DataEngineEntityInlinePermissions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEntityInlinePermissions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEntityInlinePermissions) UnmarshalBinary(b []byte) error {
	var res DataEngineEntityInlinePermissions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
