// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineEvent Data engine event information
//
// swagger:model data_engine_event
type DataEngineEvent struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The time when the event was created.
	// Example: 2023-10-01 12:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// The list of attributes associated with the event.
	DataEngineEventInlineAttributes []*DataEngineEventInlineAttributesInlineArrayItem `json:"attributes,omitempty"`

	// The list of users, groups, or roles that can see the event.
	// Read Only: true
	DataEngineEventInlineVisibleTo []*DataEngineEventInlineVisibleToInlineArrayItem `json:"visible_to,omitempty"`

	// The description of the event.
	// Example: Example Event
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// job
	Job *DataEngineEventJob `json:"job,omitempty"`

	// owner
	Owner *DataEngineEventInlineOwner `json:"owner,omitempty"`

	// resource
	Resource *DataEngineEventInlineResource `json:"resource,omitempty"`

	// The severity level of the event.
	// Example: error
	// Read Only: true
	// Enum: ["info","warning","error","critical"]
	Severity *string `json:"severity,omitempty"`

	// The unique identifier of the event.
	// Example: 123e4567-e89b-12d3-a456-426614173000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine event
func (m *DataEngineEvent) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineEventInlineAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineEventInlineVisibleTo(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOwner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSeverity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEvent) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEvent) validateDataEngineEventInlineAttributes(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineEventInlineAttributes) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineEventInlineAttributes); i++ {
		if swag.IsZero(m.DataEngineEventInlineAttributes[i]) { // not required
			continue
		}

		if m.DataEngineEventInlineAttributes[i] != nil {
			if err := m.DataEngineEventInlineAttributes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEvent) validateDataEngineEventInlineVisibleTo(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineEventInlineVisibleTo) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineEventInlineVisibleTo); i++ {
		if swag.IsZero(m.DataEngineEventInlineVisibleTo[i]) { // not required
			continue
		}

		if m.DataEngineEventInlineVisibleTo[i] != nil {
			if err := m.DataEngineEventInlineVisibleTo[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("visible_to" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEvent) validateJob(formats strfmt.Registry) error {
	if swag.IsZero(m.Job) { // not required
		return nil
	}

	if m.Job != nil {
		if err := m.Job.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) validateOwner(formats strfmt.Registry) error {
	if swag.IsZero(m.Owner) { // not required
		return nil
	}

	if m.Owner != nil {
		if err := m.Owner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

var dataEngineEventTypeSeverityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["info","warning","error","critical"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEventTypeSeverityPropEnum = append(dataEngineEventTypeSeverityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_event
	// DataEngineEvent
	// severity
	// Severity
	// info
	// END DEBUGGING
	// DataEngineEventSeverityInfo captures enum value "info"
	DataEngineEventSeverityInfo string = "info"

	// BEGIN DEBUGGING
	// data_engine_event
	// DataEngineEvent
	// severity
	// Severity
	// warning
	// END DEBUGGING
	// DataEngineEventSeverityWarning captures enum value "warning"
	DataEngineEventSeverityWarning string = "warning"

	// BEGIN DEBUGGING
	// data_engine_event
	// DataEngineEvent
	// severity
	// Severity
	// error
	// END DEBUGGING
	// DataEngineEventSeverityError captures enum value "error"
	DataEngineEventSeverityError string = "error"

	// BEGIN DEBUGGING
	// data_engine_event
	// DataEngineEvent
	// severity
	// Severity
	// critical
	// END DEBUGGING
	// DataEngineEventSeverityCritical captures enum value "critical"
	DataEngineEventSeverityCritical string = "critical"
)

// prop value enum
func (m *DataEngineEvent) validateSeverityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEventTypeSeverityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEvent) validateSeverity(formats strfmt.Registry) error {
	if swag.IsZero(m.Severity) { // not required
		return nil
	}

	// value enum
	if err := m.validateSeverityEnum("severity", "body", *m.Severity); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEvent) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine event based on the context it is used
func (m *DataEngineEvent) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineEventInlineAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineEventInlineVisibleTo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOwner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSeverity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEvent) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEvent) contextValidateDataEngineEventInlineAttributes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineEventInlineAttributes); i++ {

		if m.DataEngineEventInlineAttributes[i] != nil {
			if err := m.DataEngineEventInlineAttributes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("attributes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEvent) contextValidateDataEngineEventInlineVisibleTo(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "visible_to", "body", []*DataEngineEventInlineVisibleToInlineArrayItem(m.DataEngineEventInlineVisibleTo)); err != nil {
		return err
	}

	for i := 0; i < len(m.DataEngineEventInlineVisibleTo); i++ {

		if m.DataEngineEventInlineVisibleTo[i] != nil {
			if err := m.DataEngineEventInlineVisibleTo[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("visible_to" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEvent) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description", "body", m.Description); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEvent) contextValidateJob(ctx context.Context, formats strfmt.Registry) error {

	if m.Job != nil {
		if err := m.Job.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) contextValidateOwner(ctx context.Context, formats strfmt.Registry) error {

	if m.Owner != nil {
		if err := m.Owner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("owner")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {
		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEvent) contextValidateSeverity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "severity", "body", m.Severity); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEvent) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEvent) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEvent) UnmarshalBinary(b []byte) error {
	var res DataEngineEvent
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEventInlineAttributesInlineArrayItem data engine event inline attributes inline array item
//
// swagger:model data_engine_event_inline_attributes_inline_array_item
type DataEngineEventInlineAttributesInlineArrayItem struct {

	// The key of the attribute.
	// Example: attribute_key_1
	Key *string `json:"key,omitempty"`

	// The value of the attribute.
	// Example: attribute_value_1
	Value *string `json:"value,omitempty"`
}

// Validate validates this data engine event inline attributes inline array item
func (m *DataEngineEventInlineAttributesInlineArrayItem) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this data engine event inline attributes inline array item based on the context it is used
func (m *DataEngineEventInlineAttributesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventInlineAttributesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventInlineAttributesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineEventInlineAttributesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEventInlineOwner The user or group whose action triggered the event.
//
// swagger:model data_engine_event_inline_owner
type DataEngineEventInlineOwner struct {

	// The name of the user or group.
	// Example: noah
	Name *string `json:"name,omitempty"`
}

// Validate validates this data engine event inline owner
func (m *DataEngineEventInlineOwner) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this data engine event inline owner based on the context it is used
func (m *DataEngineEventInlineOwner) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventInlineOwner) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventInlineOwner) UnmarshalBinary(b []byte) error {
	var res DataEngineEventInlineOwner
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEventInlineResource The resource associated with the event.
//
// swagger:model data_engine_event_inline_resource
type DataEngineEventInlineResource struct {

	// The name of the resource.
	// Example: Workspace 1
	Name *string `json:"name,omitempty"`

	// The type of the data engine resource.
	// Example: workspace
	// Enum: ["workspace","data_source","data_collection","policy","custom"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the resource.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine event inline resource
func (m *DataEngineEventInlineResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineEventInlineResourceTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace","data_source","data_collection","policy","custom"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEventInlineResourceTypeTypePropEnum = append(dataEngineEventInlineResourceTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_event_inline_resource
	// DataEngineEventInlineResource
	// type
	// Type
	// workspace
	// END DEBUGGING
	// DataEngineEventInlineResourceTypeWorkspace captures enum value "workspace"
	DataEngineEventInlineResourceTypeWorkspace string = "workspace"

	// BEGIN DEBUGGING
	// data_engine_event_inline_resource
	// DataEngineEventInlineResource
	// type
	// Type
	// data_source
	// END DEBUGGING
	// DataEngineEventInlineResourceTypeDataSource captures enum value "data_source"
	DataEngineEventInlineResourceTypeDataSource string = "data_source"

	// BEGIN DEBUGGING
	// data_engine_event_inline_resource
	// DataEngineEventInlineResource
	// type
	// Type
	// data_collection
	// END DEBUGGING
	// DataEngineEventInlineResourceTypeDataCollection captures enum value "data_collection"
	DataEngineEventInlineResourceTypeDataCollection string = "data_collection"

	// BEGIN DEBUGGING
	// data_engine_event_inline_resource
	// DataEngineEventInlineResource
	// type
	// Type
	// policy
	// END DEBUGGING
	// DataEngineEventInlineResourceTypePolicy captures enum value "policy"
	DataEngineEventInlineResourceTypePolicy string = "policy"

	// BEGIN DEBUGGING
	// data_engine_event_inline_resource
	// DataEngineEventInlineResource
	// type
	// Type
	// custom
	// END DEBUGGING
	// DataEngineEventInlineResourceTypeCustom captures enum value "custom"
	DataEngineEventInlineResourceTypeCustom string = "custom"
)

// prop value enum
func (m *DataEngineEventInlineResource) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEventInlineResourceTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEventInlineResource) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("resource"+"."+"type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventInlineResource) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("resource"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine event inline resource based on the context it is used
func (m *DataEngineEventInlineResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventInlineResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventInlineResource) UnmarshalBinary(b []byte) error {
	var res DataEngineEventInlineResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineEventInlineVisibleToInlineArrayItem data engine event inline visible to inline array item
//
// swagger:model data_engine_event_inline_visible_to_inline_array_item
type DataEngineEventInlineVisibleToInlineArrayItem struct {

	// The name of the user, group, or role.
	// Example: admin
	Name *string `json:"name,omitempty"`

	// Specifies the visibility of the event to a user, group or role.
	// Example: role
	// Enum: ["role","user","group"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this data engine event inline visible to inline array item
func (m *DataEngineEventInlineVisibleToInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineEventInlineVisibleToInlineArrayItemTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["role","user","group"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEventInlineVisibleToInlineArrayItemTypeTypePropEnum = append(dataEngineEventInlineVisibleToInlineArrayItemTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_event_inline_visible_to_inline_array_item
	// DataEngineEventInlineVisibleToInlineArrayItem
	// type
	// Type
	// role
	// END DEBUGGING
	// DataEngineEventInlineVisibleToInlineArrayItemTypeRole captures enum value "role"
	DataEngineEventInlineVisibleToInlineArrayItemTypeRole string = "role"

	// BEGIN DEBUGGING
	// data_engine_event_inline_visible_to_inline_array_item
	// DataEngineEventInlineVisibleToInlineArrayItem
	// type
	// Type
	// user
	// END DEBUGGING
	// DataEngineEventInlineVisibleToInlineArrayItemTypeUser captures enum value "user"
	DataEngineEventInlineVisibleToInlineArrayItemTypeUser string = "user"

	// BEGIN DEBUGGING
	// data_engine_event_inline_visible_to_inline_array_item
	// DataEngineEventInlineVisibleToInlineArrayItem
	// type
	// Type
	// group
	// END DEBUGGING
	// DataEngineEventInlineVisibleToInlineArrayItemTypeGroup captures enum value "group"
	DataEngineEventInlineVisibleToInlineArrayItemTypeGroup string = "group"
)

// prop value enum
func (m *DataEngineEventInlineVisibleToInlineArrayItem) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEventInlineVisibleToInlineArrayItemTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEventInlineVisibleToInlineArrayItem) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine event inline visible to inline array item based on context it is used
func (m *DataEngineEventInlineVisibleToInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventInlineVisibleToInlineArrayItem) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventInlineVisibleToInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res DataEngineEventInlineVisibleToInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
