// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineEventJob The job associated with the event.
//
// swagger:model data_engine_event_job
type DataEngineEventJob struct {

	// The name of the job.
	// Example: workspace create
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The state of the data engine job:
	// * <i>queued</i> - The job is queued for execution.
	// * <i>running</i> - The job is currently in execution.
	// * <i>success</i> - The job has been completed successfully.
	// * <i>failure</i> - The job has failed.
	//
	// Example: success
	// Read Only: true
	// Enum: ["queued","running","success","failure"]
	State *string `json:"state,omitempty"`

	// The type of the job.
	// Example: workspace_create
	// Read Only: true
	// Enum: ["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]
	Type *string `json:"type,omitempty"`

	// The unique identifier of the job.
	// Example: 123e4567-e89b-12d3-a456-426614174000
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine event job
func (m *DataEngineEventJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineEventJobTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["queued","running","success","failure"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEventJobTypeStatePropEnum = append(dataEngineEventJobTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// state
	// State
	// queued
	// END DEBUGGING
	// DataEngineEventJobStateQueued captures enum value "queued"
	DataEngineEventJobStateQueued string = "queued"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// state
	// State
	// running
	// END DEBUGGING
	// DataEngineEventJobStateRunning captures enum value "running"
	DataEngineEventJobStateRunning string = "running"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// state
	// State
	// success
	// END DEBUGGING
	// DataEngineEventJobStateSuccess captures enum value "success"
	DataEngineEventJobStateSuccess string = "success"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// state
	// State
	// failure
	// END DEBUGGING
	// DataEngineEventJobStateFailure captures enum value "failure"
	DataEngineEventJobStateFailure string = "failure"
)

// prop value enum
func (m *DataEngineEventJob) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEventJobTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEventJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineEventJobTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["workspace_create","workspace_update","workspace_delete","workspace_refresh","workspace_restore","workspace_content_processing","workspace_versioning","data_collection_create","data_collection_update","data_collection_delete","data_collection_refresh","data_collection_restore","data_collection_content_processing","data_collection_versioning","data_source_create","data_source_update","data_source_delete","data_source_refresh","policy_enforcement","cleanup","entity_preview","entity_cache_cleanup"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineEventJobTypeTypePropEnum = append(dataEngineEventJobTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_create
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceCreate captures enum value "workspace_create"
	DataEngineEventJobTypeWorkspaceCreate string = "workspace_create"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_update
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceUpdate captures enum value "workspace_update"
	DataEngineEventJobTypeWorkspaceUpdate string = "workspace_update"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_delete
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceDelete captures enum value "workspace_delete"
	DataEngineEventJobTypeWorkspaceDelete string = "workspace_delete"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_refresh
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceRefresh captures enum value "workspace_refresh"
	DataEngineEventJobTypeWorkspaceRefresh string = "workspace_refresh"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_restore
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceRestore captures enum value "workspace_restore"
	DataEngineEventJobTypeWorkspaceRestore string = "workspace_restore"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_content_processing
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceContentProcessing captures enum value "workspace_content_processing"
	DataEngineEventJobTypeWorkspaceContentProcessing string = "workspace_content_processing"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// workspace_versioning
	// END DEBUGGING
	// DataEngineEventJobTypeWorkspaceVersioning captures enum value "workspace_versioning"
	DataEngineEventJobTypeWorkspaceVersioning string = "workspace_versioning"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_create
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionCreate captures enum value "data_collection_create"
	DataEngineEventJobTypeDataCollectionCreate string = "data_collection_create"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_update
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionUpdate captures enum value "data_collection_update"
	DataEngineEventJobTypeDataCollectionUpdate string = "data_collection_update"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_delete
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionDelete captures enum value "data_collection_delete"
	DataEngineEventJobTypeDataCollectionDelete string = "data_collection_delete"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_refresh
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionRefresh captures enum value "data_collection_refresh"
	DataEngineEventJobTypeDataCollectionRefresh string = "data_collection_refresh"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_restore
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionRestore captures enum value "data_collection_restore"
	DataEngineEventJobTypeDataCollectionRestore string = "data_collection_restore"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_content_processing
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionContentProcessing captures enum value "data_collection_content_processing"
	DataEngineEventJobTypeDataCollectionContentProcessing string = "data_collection_content_processing"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_collection_versioning
	// END DEBUGGING
	// DataEngineEventJobTypeDataCollectionVersioning captures enum value "data_collection_versioning"
	DataEngineEventJobTypeDataCollectionVersioning string = "data_collection_versioning"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_source_create
	// END DEBUGGING
	// DataEngineEventJobTypeDataSourceCreate captures enum value "data_source_create"
	DataEngineEventJobTypeDataSourceCreate string = "data_source_create"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_source_update
	// END DEBUGGING
	// DataEngineEventJobTypeDataSourceUpdate captures enum value "data_source_update"
	DataEngineEventJobTypeDataSourceUpdate string = "data_source_update"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_source_delete
	// END DEBUGGING
	// DataEngineEventJobTypeDataSourceDelete captures enum value "data_source_delete"
	DataEngineEventJobTypeDataSourceDelete string = "data_source_delete"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// data_source_refresh
	// END DEBUGGING
	// DataEngineEventJobTypeDataSourceRefresh captures enum value "data_source_refresh"
	DataEngineEventJobTypeDataSourceRefresh string = "data_source_refresh"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// policy_enforcement
	// END DEBUGGING
	// DataEngineEventJobTypePolicyEnforcement captures enum value "policy_enforcement"
	DataEngineEventJobTypePolicyEnforcement string = "policy_enforcement"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// cleanup
	// END DEBUGGING
	// DataEngineEventJobTypeCleanup captures enum value "cleanup"
	DataEngineEventJobTypeCleanup string = "cleanup"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// entity_preview
	// END DEBUGGING
	// DataEngineEventJobTypeEntityPreview captures enum value "entity_preview"
	DataEngineEventJobTypeEntityPreview string = "entity_preview"

	// BEGIN DEBUGGING
	// data_engine_event_job
	// DataEngineEventJob
	// type
	// Type
	// entity_cache_cleanup
	// END DEBUGGING
	// DataEngineEventJobTypeEntityCacheCleanup captures enum value "entity_cache_cleanup"
	DataEngineEventJobTypeEntityCacheCleanup string = "entity_cache_cleanup"
)

// prop value enum
func (m *DataEngineEventJob) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineEventJobTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineEventJob) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine event job based on the context it is used
func (m *DataEngineEventJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEventJob) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventJob) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "type", "body", m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventJob) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventJob) UnmarshalBinary(b []byte) error {
	var res DataEngineEventJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
