// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineEventResponse data engine event response
//
// swagger:model data_engine_event_response
type DataEngineEventResponse struct {

	// links
	Links *CollectionLinks `json:"_links,omitempty"`

	// data engine event response inline records
	DataEngineEventResponseInlineRecords []*DataEngineEvent `json:"records,omitempty"`

	// The number of records returned.
	// Example: 10
	// Read Only: true
	NumRecords *int64 `json:"num_records,omitempty"`

	// The total number of events.
	// Example: 100
	// Read Only: true
	TotalCount *int64 `json:"total_count,omitempty"`
}

// Validate validates this data engine event response
func (m *DataEngineEventResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineEventResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEventResponse) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEventResponse) validateDataEngineEventResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineEventResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineEventResponseInlineRecords); i++ {
		if swag.IsZero(m.DataEngineEventResponseInlineRecords[i]) { // not required
			continue
		}

		if m.DataEngineEventResponseInlineRecords[i] != nil {
			if err := m.DataEngineEventResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this data engine event response based on the context it is used
func (m *DataEngineEventResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineEventResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNumRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineEventResponse) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineEventResponse) contextValidateDataEngineEventResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineEventResponseInlineRecords); i++ {

		if m.DataEngineEventResponseInlineRecords[i] != nil {
			if err := m.DataEngineEventResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineEventResponse) contextValidateNumRecords(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "num_records", "body", m.NumRecords); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineEventResponse) contextValidateTotalCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_count", "body", m.TotalCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineEventResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineEventResponse) UnmarshalBinary(b []byte) error {
	var res DataEngineEventResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
