// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernanceAuditCount Governance audit count information.
//
// swagger:model data_engine_governance_audit_count
type DataEngineGovernanceAuditCount struct {

	// Total count of anonymized files.
	// Example: 1024
	// Read Only: true
	AnonymizedCount *int64 `json:"anonymized_count,omitempty"`

	// Total count of excluded files.
	// Example: 1024
	// Read Only: true
	ExcludedCount *int64 `json:"excluded_count,omitempty"`

	// guardrail policy
	GuardrailPolicy *GuardrailPolicy `json:"guardrail_policy,omitempty"`

	// Total count of files impacted by the guardrail.
	// Example: 1024
	// Read Only: true
	TotalCount *int64 `json:"total_count,omitempty"`

	// workspace
	Workspace *DataEngineGovernanceAuditCountInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this data engine governance audit count
func (m *DataEngineGovernanceAuditCount) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuardrailPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditCount) validateGuardrailPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.GuardrailPolicy) { // not required
		return nil
	}

	if m.GuardrailPolicy != nil {
		if err := m.GuardrailPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guardrail_policy")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditCount) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine governance audit count based on the context it is used
func (m *DataEngineGovernanceAuditCount) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAnonymizedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateExcludedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuardrailPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTotalCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditCount) contextValidateAnonymizedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "anonymized_count", "body", m.AnonymizedCount); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditCount) contextValidateExcludedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "excluded_count", "body", m.ExcludedCount); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditCount) contextValidateGuardrailPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.GuardrailPolicy != nil {
		if err := m.GuardrailPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guardrail_policy")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditCount) contextValidateTotalCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "total_count", "body", m.TotalCount); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditCount) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditCount) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditCount) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditCount
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceAuditCountInlineWorkspace data engine governance audit count inline workspace
//
// swagger:model data_engine_governance_audit_count_inline_workspace
type DataEngineGovernanceAuditCountInlineWorkspace struct {

	// UUID of the workspace.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance audit count inline workspace
func (m *DataEngineGovernanceAuditCountInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditCountInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance audit count inline workspace based on the context it is used
func (m *DataEngineGovernanceAuditCountInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditCountInlineWorkspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditCountInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditCountInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditCountInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
