// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernanceAuditImpactedFiles Governance audit information.
//
// swagger:model data_engine_governance_audit_impacted_files
type DataEngineGovernanceAuditImpactedFiles struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// List of actions taken on the file.
	Actions []*string `json:"actions,omitempty"`

	// data collection
	DataCollection *DataEngineGovernanceAuditImpactedFilesInlineDataCollection `json:"data_collection,omitempty"`

	// List of conditions that were met during the governance audit.
	DataEngineGovernanceAuditImpactedFilesInlineConditionsMet []*string `json:"conditions_met,omitempty"`

	// file
	File *DataEngineGovernanceAuditImpactedFilesInlineFile `json:"file,omitempty"`

	// guardrail policy
	GuardrailPolicy *GuardrailPolicy `json:"guardrail_policy,omitempty"`

	// Timestamp of the governance audit event.
	// Example: 2023-10-01 12:00:00+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`

	// UUID of the audit.
	// Example: 4bc7a442-86d1-11e0-ae1c-123478563499
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	Workspace *DataEngineGovernanceAuditImpactedFilesInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this data engine governance audit impacted files
func (m *DataEngineGovernanceAuditImpactedFiles) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataCollection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGuardrailPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

var dataEngineGovernanceAuditImpactedFilesActionsItemsEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["excluded","anonymized","exclude_from_pre_existing"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernanceAuditImpactedFilesActionsItemsEnum = append(dataEngineGovernanceAuditImpactedFilesActionsItemsEnum, v)
	}
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateActionsItemsEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernanceAuditImpactedFilesActionsItemsEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateActions(formats strfmt.Registry) error {
	if swag.IsZero(m.Actions) { // not required
		return nil
	}

	for i := 0; i < len(m.Actions); i++ {
		if swag.IsZero(m.Actions[i]) { // not required
			continue
		}

		// value enum
		if err := m.validateActionsItemsEnum("actions"+"."+strconv.Itoa(i), "body", *m.Actions[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateDataCollection(formats strfmt.Registry) error {
	if swag.IsZero(m.DataCollection) { // not required
		return nil
	}

	if m.DataCollection != nil {
		if err := m.DataCollection.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateGuardrailPolicy(formats strfmt.Registry) error {
	if swag.IsZero(m.GuardrailPolicy) { // not required
		return nil
	}

	if m.GuardrailPolicy != nil {
		if err := m.GuardrailPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guardrail_policy")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(m.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("timestamp", "body", "date-time", m.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine governance audit impacted files based on the context it is used
func (m *DataEngineGovernanceAuditImpactedFiles) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateActions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataCollection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernanceAuditImpactedFilesInlineConditionsMet(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGuardrailPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateActions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Actions); i++ {

		if err := validate.ReadOnly(ctx, "actions"+"."+strconv.Itoa(i), "body", m.Actions[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateDataCollection(ctx context.Context, formats strfmt.Registry) error {

	if m.DataCollection != nil {
		if err := m.DataCollection.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("data_collection")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateDataEngineGovernanceAuditImpactedFilesInlineConditionsMet(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernanceAuditImpactedFilesInlineConditionsMet); i++ {

		if err := validate.ReadOnly(ctx, "conditions_met"+"."+strconv.Itoa(i), "body", m.DataEngineGovernanceAuditImpactedFilesInlineConditionsMet[i]); err != nil {
			return err
		}

	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateGuardrailPolicy(ctx context.Context, formats strfmt.Registry) error {

	if m.GuardrailPolicy != nil {
		if err := m.GuardrailPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("guardrail_policy")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "timestamp", "body", m.Timestamp); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFiles) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFiles) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFiles) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditImpactedFiles
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceAuditImpactedFilesInlineDataCollection data engine governance audit impacted files inline data collection
//
// swagger:model data_engine_governance_audit_impacted_files_inline_data_collection
type DataEngineGovernanceAuditImpactedFilesInlineDataCollection struct {

	// UUID of the data collection associated with the file.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance audit impacted files inline data collection
func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("data_collection"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance audit impacted files inline data collection based on the context it is used
func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "data_collection"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineDataCollection) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditImpactedFilesInlineDataCollection
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceAuditImpactedFilesInlineFile data engine governance audit impacted files inline file
//
// swagger:model data_engine_governance_audit_impacted_files_inline_file
type DataEngineGovernanceAuditImpactedFilesInlineFile struct {

	// Name of the file.
	// Example: example_file.txt
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// Size of the file in bytes.
	// Example: 1024
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// UUID of the file.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance audit impacted files inline file
func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("file"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance audit impacted files inline file based on the context it is used
func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file"+"."+"name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file"+"."+"size", "body", m.Size); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "file"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineFile) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditImpactedFilesInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceAuditImpactedFilesInlineWorkspace data engine governance audit impacted files inline workspace
//
// swagger:model data_engine_governance_audit_impacted_files_inline_workspace
type DataEngineGovernanceAuditImpactedFilesInlineWorkspace struct {

	// UUID of the workspace.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance audit impacted files inline workspace
func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance audit impacted files inline workspace based on the context it is used
func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "workspace"+"."+"uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceAuditImpactedFilesInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceAuditImpactedFilesInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
