// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernanceFilePreviewFileContentRequest Request body for retrieving anonymized file content.
//
// swagger:model data_engine_governance_file_preview_file_content_request
type DataEngineGovernanceFilePreviewFileContentRequest struct {

	// file
	File *DataEngineGovernanceFilePreviewFileContentRequestInlineFile `json:"file,omitempty"`

	// workspace
	Workspace *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this data engine governance file preview file content request
func (m *DataEngineGovernanceFilePreviewFileContentRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequest) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequest) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine governance file preview file content request based on the context it is used
func (m *DataEngineGovernanceFilePreviewFileContentRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequest) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequest) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequest) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewFileContentRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceFilePreviewFileContentRequestInlineFile data engine governance file preview file content request inline file
//
// swagger:model data_engine_governance_file_preview_file_content_request_inline_file
type DataEngineGovernanceFilePreviewFileContentRequestInlineFile struct {

	// Format of the file.
	// Example: txt
	// Enum: ["pdf","docx","txt","csv","json","map","js","doc","xlsx","css","xls"]
	Format *string `json:"format,omitempty"`

	// Path to the downloaded file. This is present when the job is completed.
	// Example: /downloaded_folder/file1.pdf
	Path *string `json:"path,omitempty"`

	// UUID of the entity.
	// Example: 12c9e267-23be-22e9-81d5-00xx986138f7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance file preview file content request inline file
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernanceFilePreviewFileContentRequestInlineFileTypeFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pdf","docx","txt","csv","json","map","js","doc","xlsx","css","xls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernanceFilePreviewFileContentRequestInlineFileTypeFormatPropEnum = append(dataEngineGovernanceFilePreviewFileContentRequestInlineFileTypeFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// pdf
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatPdf captures enum value "pdf"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatPdf string = "pdf"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// docx
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatDocx captures enum value "docx"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatDocx string = "docx"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// txt
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatTxt captures enum value "txt"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatTxt string = "txt"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// csv
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatCsv captures enum value "csv"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatCsv string = "csv"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// json
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatJSON captures enum value "json"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatJSON string = "json"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// map
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatMap captures enum value "map"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatMap string = "map"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// js
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatJs captures enum value "js"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatJs string = "js"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// doc
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatDoc captures enum value "doc"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatDoc string = "doc"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// xlsx
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatXlsx captures enum value "xlsx"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatXlsx string = "xlsx"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// css
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatCSS captures enum value "css"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatCSS string = "css"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_file_content_request_inline_file
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	// format
	// Format
	// xls
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatXls captures enum value "xls"
	DataEngineGovernanceFilePreviewFileContentRequestInlineFileFormatXls string = "xls"
)

// prop value enum
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) validateFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernanceFilePreviewFileContentRequestInlineFileTypeFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	// value enum
	if err := m.validateFormatEnum("file"+"."+"format", "body", *m.Format); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("file"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance file preview file content request inline file based on context it is used
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineFile) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewFileContentRequestInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace data engine governance file preview file content request inline workspace
//
// swagger:model data_engine_governance_file_preview_file_content_request_inline_workspace
type DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace struct {

	// UUID of the workspace.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance file preview file content request inline workspace
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance file preview file content request inline workspace based on context it is used
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewFileContentRequestInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
