// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernanceFilePreviewJob File preview job.
//
// swagger:model data_engine_governance_file_preview_job
type DataEngineGovernanceFilePreviewJob struct {

	// file
	File *DataEngineGovernanceFilePreviewJobInlineFile `json:"file,omitempty"`

	// Status of the job. Possible values are:
	// * <i>new</i>: Job is newly created.
	// * <i>queued</i>: Job is queued for processing.
	// * <i>in_progress</i>: Job is currently being processed.
	// * <i>completed</i>: Job completed successfully.
	// * <i>warning</i>: Job completed with warnings.
	// * <i>failed</i>: Job failed.
	// * <i>timed_out</i>: Job timed out.
	// * <i>canceling</i>: Job is being canceled.
	// * <i>canceled</i>: Job was canceled.
	//
	// Example: in_progress
	// Read Only: true
	// Enum: ["new","queued","in_progress","completed","warning","failed","timed_out","canceling","canceled"]
	State *string `json:"state,omitempty"`

	// Unique identifier of the file preview job.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// workspace
	Workspace *DataEngineGovernanceFilePreviewJobInlineWorkspace `json:"workspace,omitempty"`
}

// Validate validates this data engine governance file preview job
func (m *DataEngineGovernanceFilePreviewJob) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFile(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) validateFile(formats strfmt.Registry) error {
	if swag.IsZero(m.File) { // not required
		return nil
	}

	if m.File != nil {
		if err := m.File.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

var dataEngineGovernanceFilePreviewJobTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["new","queued","in_progress","completed","warning","failed","timed_out","canceling","canceled"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernanceFilePreviewJobTypeStatePropEnum = append(dataEngineGovernanceFilePreviewJobTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// new
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateNew captures enum value "new"
	DataEngineGovernanceFilePreviewJobStateNew string = "new"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// queued
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateQueued captures enum value "queued"
	DataEngineGovernanceFilePreviewJobStateQueued string = "queued"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// in_progress
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateInProgress captures enum value "in_progress"
	DataEngineGovernanceFilePreviewJobStateInProgress string = "in_progress"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// completed
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateCompleted captures enum value "completed"
	DataEngineGovernanceFilePreviewJobStateCompleted string = "completed"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// warning
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateWarning captures enum value "warning"
	DataEngineGovernanceFilePreviewJobStateWarning string = "warning"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// failed
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateFailed captures enum value "failed"
	DataEngineGovernanceFilePreviewJobStateFailed string = "failed"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// timed_out
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateTimedOut captures enum value "timed_out"
	DataEngineGovernanceFilePreviewJobStateTimedOut string = "timed_out"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// canceling
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateCanceling captures enum value "canceling"
	DataEngineGovernanceFilePreviewJobStateCanceling string = "canceling"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job
	// DataEngineGovernanceFilePreviewJob
	// state
	// State
	// canceled
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobStateCanceled captures enum value "canceled"
	DataEngineGovernanceFilePreviewJobStateCanceled string = "canceled"
)

// prop value enum
func (m *DataEngineGovernanceFilePreviewJob) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernanceFilePreviewJobTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this data engine governance file preview job based on the context it is used
func (m *DataEngineGovernanceFilePreviewJob) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateFile(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) contextValidateFile(ctx context.Context, formats strfmt.Registry) error {

	if m.File != nil {
		if err := m.File.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("file")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "state", "body", m.State); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewJob) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJob) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJob) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewJob
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceFilePreviewJobInlineFile data engine governance file preview job inline file
//
// swagger:model data_engine_governance_file_preview_job_inline_file
type DataEngineGovernanceFilePreviewJobInlineFile struct {

	// Format of the file.
	// Example: txt
	// Enum: ["pdf","docx","txt","csv","json","map","js","doc","xlsx","css","xls"]
	Format *string `json:"format,omitempty"`

	// Path to the downloaded file. This is present when the job is completed.
	// Example: /downloaded_folder/file1.pdf
	Path *string `json:"path,omitempty"`

	// UUID of the entity.
	// Example: 12c9e267-23be-22e9-81d5-00xx986138f7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance file preview job inline file
func (m *DataEngineGovernanceFilePreviewJobInlineFile) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateFormat(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var dataEngineGovernanceFilePreviewJobInlineFileTypeFormatPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["pdf","docx","txt","csv","json","map","js","doc","xlsx","css","xls"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernanceFilePreviewJobInlineFileTypeFormatPropEnum = append(dataEngineGovernanceFilePreviewJobInlineFileTypeFormatPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// pdf
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatPdf captures enum value "pdf"
	DataEngineGovernanceFilePreviewJobInlineFileFormatPdf string = "pdf"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// docx
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatDocx captures enum value "docx"
	DataEngineGovernanceFilePreviewJobInlineFileFormatDocx string = "docx"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// txt
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatTxt captures enum value "txt"
	DataEngineGovernanceFilePreviewJobInlineFileFormatTxt string = "txt"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// csv
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatCsv captures enum value "csv"
	DataEngineGovernanceFilePreviewJobInlineFileFormatCsv string = "csv"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// json
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatJSON captures enum value "json"
	DataEngineGovernanceFilePreviewJobInlineFileFormatJSON string = "json"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// map
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatMap captures enum value "map"
	DataEngineGovernanceFilePreviewJobInlineFileFormatMap string = "map"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// js
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatJs captures enum value "js"
	DataEngineGovernanceFilePreviewJobInlineFileFormatJs string = "js"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// doc
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatDoc captures enum value "doc"
	DataEngineGovernanceFilePreviewJobInlineFileFormatDoc string = "doc"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// xlsx
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatXlsx captures enum value "xlsx"
	DataEngineGovernanceFilePreviewJobInlineFileFormatXlsx string = "xlsx"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// css
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatCSS captures enum value "css"
	DataEngineGovernanceFilePreviewJobInlineFileFormatCSS string = "css"

	// BEGIN DEBUGGING
	// data_engine_governance_file_preview_job_inline_file
	// DataEngineGovernanceFilePreviewJobInlineFile
	// format
	// Format
	// xls
	// END DEBUGGING
	// DataEngineGovernanceFilePreviewJobInlineFileFormatXls captures enum value "xls"
	DataEngineGovernanceFilePreviewJobInlineFileFormatXls string = "xls"
)

// prop value enum
func (m *DataEngineGovernanceFilePreviewJobInlineFile) validateFormatEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernanceFilePreviewJobInlineFileTypeFormatPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewJobInlineFile) validateFormat(formats strfmt.Registry) error {
	if swag.IsZero(m.Format) { // not required
		return nil
	}

	// value enum
	if err := m.validateFormatEnum("file"+"."+"format", "body", *m.Format); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernanceFilePreviewJobInlineFile) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("file"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance file preview job inline file based on context it is used
func (m *DataEngineGovernanceFilePreviewJobInlineFile) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJobInlineFile) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJobInlineFile) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewJobInlineFile
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// DataEngineGovernanceFilePreviewJobInlineWorkspace data engine governance file preview job inline workspace
//
// swagger:model data_engine_governance_file_preview_job_inline_workspace
type DataEngineGovernanceFilePreviewJobInlineWorkspace struct {

	// UUID of the workspace.
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance file preview job inline workspace
func (m *DataEngineGovernanceFilePreviewJobInlineWorkspace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernanceFilePreviewJobInlineWorkspace) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("workspace"+"."+"uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this data engine governance file preview job inline workspace based on context it is used
func (m *DataEngineGovernanceFilePreviewJobInlineWorkspace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJobInlineWorkspace) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernanceFilePreviewJobInlineWorkspace) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernanceFilePreviewJobInlineWorkspace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
