// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// DataEngineGovernancePoliciesClassificationCategory Defines the structure of a classification category.
//
// swagger:model data_engine_governance_policies_classification_category
type DataEngineGovernancePoliciesClassificationCategory struct {

	// links
	Links *SelfLink `json:"_links,omitempty"`

	// The timestamp indicating when the category was created.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	CreateTime *strfmt.DateTime `json:"create_time,omitempty"`

	// Indicates if the classification category is custom or predefined.
	// Example: false
	Custom *bool `json:"custom,omitempty"`

	// data engine governance policies classification category inline classifiers
	DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers []*DataEngineGovernancePoliciesClassifier `json:"classifiers,omitempty"`

	// Description of the classification category.
	// Example: General privacy classification category
	Description *string `json:"description,omitempty"`

	// Name of the classification category.
	// Example: General privacy
	Name *string `json:"name,omitempty"`

	// State of the classification category. Possible values are:
	// * <i>enabled</i>: Classification category is enabled.
	// * <i>disabled</i>: Classification category is disabled.
	// * <i>simulate</i>: Classification category is in simulation mode.
	//
	// Example: enabled
	// Enum: ["enabled","disabled","simulate"]
	State *string `json:"state,omitempty"`

	// Tag associated with the classification category.
	// Example: CAT_GP00000
	Tag *string `json:"tag,omitempty"`

	// Specifies the type of classification category. Possible values are:
	// * <i>data</i>: Classification category for data entities.
	// * <i>document</i>: Classification category for document entities.
	//
	// Example: data
	// Enum: ["data","document"]
	Type *string `json:"type,omitempty"`

	// The timestamp indicating when the category was last updated.
	// Example: 2018-06-04 19:00:00+00:00
	// Read Only: true
	// Format: date-time
	UpdateTime *strfmt.DateTime `json:"update_time,omitempty"`

	// Unique identifier of the classification category.
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this data engine governance policies classification category
func (m *DataEngineGovernancePoliciesClassificationCategory) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdateTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(m.Links) { // not required
		return nil
	}

	if m.Links != nil {
		if err := m.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateCreateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.CreateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("create_time", "body", "date-time", m.CreateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(formats strfmt.Registry) error {
	if swag.IsZero(m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers) { // not required
		return nil
	}

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers); i++ {
		if swag.IsZero(m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i]) { // not required
			continue
		}

		if m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classifiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var dataEngineGovernancePoliciesClassificationCategoryTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["enabled","disabled","simulate"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationCategoryTypeStatePropEnum = append(dataEngineGovernancePoliciesClassificationCategoryTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_category
	// DataEngineGovernancePoliciesClassificationCategory
	// state
	// State
	// enabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryStateEnabled captures enum value "enabled"
	DataEngineGovernancePoliciesClassificationCategoryStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_category
	// DataEngineGovernancePoliciesClassificationCategory
	// state
	// State
	// disabled
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryStateDisabled captures enum value "disabled"
	DataEngineGovernancePoliciesClassificationCategoryStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_category
	// DataEngineGovernancePoliciesClassificationCategory
	// state
	// State
	// simulate
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryStateSimulate captures enum value "simulate"
	DataEngineGovernancePoliciesClassificationCategoryStateSimulate string = "simulate"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassificationCategory) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationCategoryTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	// value enum
	if err := m.validateStateEnum("state", "body", *m.State); err != nil {
		return err
	}

	return nil
}

var dataEngineGovernancePoliciesClassificationCategoryTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["data","document"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		dataEngineGovernancePoliciesClassificationCategoryTypeTypePropEnum = append(dataEngineGovernancePoliciesClassificationCategoryTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_category
	// DataEngineGovernancePoliciesClassificationCategory
	// type
	// Type
	// data
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryTypeData captures enum value "data"
	DataEngineGovernancePoliciesClassificationCategoryTypeData string = "data"

	// BEGIN DEBUGGING
	// data_engine_governance_policies_classification_category
	// DataEngineGovernancePoliciesClassificationCategory
	// type
	// Type
	// document
	// END DEBUGGING
	// DataEngineGovernancePoliciesClassificationCategoryTypeDocument captures enum value "document"
	DataEngineGovernancePoliciesClassificationCategoryTypeDocument string = "document"
)

// prop value enum
func (m *DataEngineGovernancePoliciesClassificationCategory) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, dataEngineGovernancePoliciesClassificationCategoryTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	// value enum
	if err := m.validateTypeEnum("type", "body", *m.Type); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateUpdateTime(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdateTime) { // not required
		return nil
	}

	if err := validate.FormatOf("update_time", "body", "date-time", m.UpdateTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(m.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", m.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this data engine governance policies classification category based on the context it is used
func (m *DataEngineGovernancePoliciesClassificationCategory) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if m.Links != nil {
		if err := m.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "create_time", "body", m.CreateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) contextValidateDataEngineGovernancePoliciesClassificationCategoryInlineClassifiers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers); i++ {

		if m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i] != nil {
			if err := m.DataEngineGovernancePoliciesClassificationCategoryInlineClassifiers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("classifiers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) contextValidateUpdateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "update_time", "body", m.UpdateTime); err != nil {
		return err
	}

	return nil
}

func (m *DataEngineGovernancePoliciesClassificationCategory) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", m.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationCategory) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *DataEngineGovernancePoliciesClassificationCategory) UnmarshalBinary(b []byte) error {
	var res DataEngineGovernancePoliciesClassificationCategory
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
